-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.7.14-log - MySQL Community Server (GPL)
-- Server OS:                    Win64
-- HeidiSQL Verzija:             9.3.0.4984
-- --------------------------------------------------------

-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.7.20-log - MySQL Community Server (GPL)
-- Server OS:                    Win64
-- HeidiSQL Verzija:             9.3.0.4984
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for masterdb
CREATE DATABASE IF NOT EXISTS `masterdb` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `masterdb`;

-- Dumping structure for procedure masterdb.donos
DELIMITER //
CREATE DEFINER=`root`@`localhost` PROCEDURE `donos`(
	IN `i_date` DATETIME,
	IN `i_department_id` INT
)
    READS SQL DATA
BEGIN 
	DECLARE last_pocetno_stanje DATETIME DEFAULT poslednji_popis_department_pre_datuma_v5(i_department_id, i_date);
	DECLARE end_of_workday DATETIME DEFAULT workday_end_v4(i_department_id, i_date);
	DECLARE datum TIMESTAMP DEFAULT workday_start_v5(i_department_id, i_date);
	DECLARE donos_zaduzenja DECIMAL(15,2) DEFAULT 0;
	DECLARE donos_razduzenja DECIMAL(15,2) DEFAULT 0;
	DECLARE donos_nivelacija DECIMAL(15,2) DEFAULT 0;
	DECLARE donos_sum DECIMAL(15,2) DEFAULT 0;
	DECLARE donos_pocetno_stanje INTEGER;
	DECLARE daily_report INTEGER DEFAULT (SELECT COUNT(*) FROM dailyturnover dt WHERE dt.DailyTurnoverWorkDayID IN (SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = i_date));
	SELECT d.DocumentTypeID FROM document d
	WHERE d.DocumentTypeID = 11
	AND DATE(d.Date) = i_date
	INTO donos_pocetno_stanje;
	CASE 
      WHEN donos_pocetno_stanje = 11 THEN 
			SELECT COALESCE(SUM(dd.Quantity * (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= datum ORDER BY pld.ProductID DESC LIMIT 1)),0) AS Zaduzenje
			FROM documentdetails dd
			LEFT JOIN document d ON d.DocumentID = dd.DocumentID 
			WHERE d.DocumentTypeID = 11
			AND DATE(d.Date) = DATE(i_date)
			ORDER BY dd.ProductID
			INTO donos_zaduzenja;
      ELSE       				
			SELECT COALESCE(SUM(dd.Quantity * IF(d.DocumentTypeID = 1, dd.NewPrice,
			IF(d.DocumentTypeID = 11, (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= datum ORDER BY pld.ProductID DESC LIMIT 1), dd.PriceWithDiscount))),0) AS Zaduzenje
			FROM documentdetails dd
			LEFT JOIN document d ON d.DocumentID = dd.DocumentID 
			LEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID
			WHERE if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) >= last_pocetno_stanje
			AND if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) < datum
			AND dt.DocumentTypeID NOT IN (3, 15, 17, 20, 22)
			ORDER BY dd.ProductID
			INTO donos_zaduzenja;
    END CASE;
    CASE 
      WHEN donos_pocetno_stanje = 11 THEN 
			SELECT 0
			INTO donos_razduzenja;
      ELSE       				
			SELECT COALESCE(ROUND(SUM(dd.Quantity * IF(d.DocumentTypeID = 22, (-1) * dd.Price, dd.PriceWithDiscount)),4),0) AS Razduzenje
			FROM documentdetails dd
			INNER JOIN document d ON d.DocumentID = dd.DocumentID
			WHERE d.DocumentTypeID IN (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.DocumentTypeID = 3 OR dt.DocumentTypeID = 22)
			AND d.Date >= last_pocetno_stanje
			AND d.Date < datum
			ORDER BY dd.ProductID
		INTO donos_razduzenja;
    END CASE;
	CASE 
      WHEN donos_pocetno_stanje = 11 THEN 
			SELECT 0
			INTO donos_nivelacija;
      ELSE       				
			SELECT COALESCE(ROUND(SUM(dd.Quantity * (dd.NewPrice - dd.Price)),4),0) AS Nivelacija
			FROM documentdetails dd
			INNER JOIN document d ON d.DocumentID = dd.DocumentID
			AND d.Date >= last_pocetno_stanje
			WHERE d.Date < datum
			AND d.DocumentTypeID = 15
			ORDER BY dd.ProductID
			INTO donos_nivelacija;
    END CASE;	
	DROP TABLE IF EXISTS temp_donos;
	CREATE TABLE temp_donos(
		NazivDokumenta	VARCHAR (50),	
		VrednostPoDokumentu DECIMAL (15,2) DEFAULT 0,
		BrojDokumenta INT DEFAULT 0,
		DatumDokumenta DATE DEFAULT 0,
		TipDokumenta INT Default 0,
		Stock INT Default 0,
		DonosZaduzenja DECIMAL (15,2) DEFAULT 0,
		DonosRazduzenja DECIMAL (15,2) DEFAULT 0,
		DonosSum DECIMAL (15,2) DEFAULT 0,
		SumZaduzenje DECIMAL (15,2) DEFAULT 0,
		SumRazduzenje DECIMAL (15,2) DEFAULT 0,
		SumPrenos DECIMAL (15,2) DEFAULT 0,
		Dobavljac VARCHAR (128)
		);
	INSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumRazduzenje, SumZaduzenje, SumPrenos) VALUES (NULL, 0, -1, NULL, -1, 0, donos_zaduzenja + donos_nivelacija, donos_razduzenja, donos_zaduzenja + donos_nivelacija - donos_razduzenja, 0, 0, 0);
	INSERT INTO temp_donos
	SELECT
	(SELECT dt.Name
	FROM documenttype dt
	WHERE dt.DocumentTypeID = d.DocumentTypeID),
	SUM(ROUND(COALESCE(dd.Quantity *(IF( d.DocumentTypeID = 22, (-1 * dd.Price), IF(d.DocumentTypeID = 15,(dd.NewPrice - dd.Price), if(d.DocumentTypeID = 7, dd.NewPrice, 
	IF(d.DocumentTypeID = 1, dd.NewPrice, dd.PriceWithDiscount))))),0),4)),
	(SELECT MIN(d1.Number)
		FROM documentdetails dd1
		JOIN document d1 ON d1.DocumentID = dd1.DocumentID
		WHERE d1.DocumentID in (d.DocumentID)),
	(SELECT (if(d.DocumentTypeID = 1, d1.DeliveryDate, d1.Date)) 
		FROM documentdetails dd1
		JOIN document d1 ON d1.DocumentID = dd1.DocumentID
		WHERE d1.DocumentID in (d.DocumentID)
		LIMIT 1),
	(SELECT MIN(d1.DocumentTypeID)
		FROM documentdetails dd1
		JOIN document d1 ON d1.DocumentID = dd1.DocumentID
		WHERE d1.DocumentID in (d.DocumentID)),
	(SELECT dt1.Stock FROM documenttype dt1 WHERE dt1.DocumentTypeID = d.DocumentTypeID),
 	0,
	0,
	0,
	0,
	0,
	0,
	(SELECT (if(d.DocumentTypeID = 1, (SELECT CONCAT(p.Name, ", ", p.Address, ", " , p.ZIP, " ", p.City) FROM person p WHERE p.PersonID = d1.PersonID), 0))
		FROM documentdetails dd1
		JOIN document d1 ON d1.DocumentID = dd1.DocumentID
		WHERE d1.DocumentID in (d.DocumentID)
		LIMIT 1)
	FROM documentdetails dd
	JOIN document d ON d.DocumentID = dd.DocumentID 
	  								AND d.DocumentTypeID IN (SELECT dt1.DocumentTypeID 
																	FROM documenttype dt1
																	WHERE dt1.DocumentTypeID <> 3 AND dt1.DocumentTypeID <> 11 AND dt1.DocumentTypeID <> 19 AND dt1.DocumentTypeID <> 17)
									AND if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) > datum
									AND if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) <= end_of_workday
									AND if(d.DocumentTypeID IN (6,17), d.PointOfSaleID IN 
									(SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = i_department_id), 
									d.DepartmentID =  i_department_id)
	GROUP BY d.DocumentID;
	CASE 
      WHEN daily_report = 0 THEN 
      INSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumRazduzenje, SumZaduzenje, SumPrenos)
      	SELECT CONCAT('Dnevni promet',' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = d.PointOfSaleID),')'), SUM(dd.Quantity * dd.PriceWithDiscount), DAYOFYEAR(i_date) AS Number, wd.Date, 17, 0,0,0,0,0,0,0
				FROM documentdetails dd 
 				LEFT JOIN document d ON d.DocumentID = dd.DocumentID  
 				LEFT JOIN workday wd ON wd.WorkDayID = d.WorkDayID 
				WHERE d.DocumentTypeID = 3
				AND wd.Date = i_date 
				GROUP BY d.PointOfSaleID;
      ELSE      
		 		INSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumRazduzenje, SumZaduzenje, SumPrenos)
	SELECT CONCAT('Dnevni promet',' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = wd.PointOfSaleID),')'), (SELECT SUM(dd.Quantity * dd.PriceWithDiscount) 
 		FROM documentdetails dd 
 		LEFT JOIN document d ON d.DocumentID = dd.DocumentID  
 		LEFT JOIN workday wd ON wd.WorkDayID = d.WorkDayID 
 		WHERE wd.WorkDayID = dt.DailyTurnoverWorkDayID AND d.DocumentTypeID = 3), dt.DailyTurnoverNumber, DATE(dt.DailyTurnoverDate), 17, 0,0,0,0,0,0,0
		FROM dailyturnover dt 
		LEFT JOIN workday wd ON wd.WorkDayID = dt.DailyTurnoverWorkDayID
		WHERE wd.Date = i_date GROUP BY wd.PointOfSaleID;		
    END CASE;
	INSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumZaduzenje, SumRazduzenje, SumPrenos) 
	SELECT NULL, 0, -1, NULL, -1, 0, 0, 0, 0, 
	SUM(IF(td.TipDokumenta = 17, 0, IF(td.TipDokumenta IN (22), 0, td.VrednostPoDokumentu))) + DonosZaduzenja, SUM(IF(td.TipDokumenta = 17, td.VrednostPoDokumentu, IF(td.TipDokumenta IN (22), td.VrednostPoDokumentu, 0))) + DonosRazduzenja, 0
	FROM temp_donos td;
	UPDATE temp_donos SET SumPrenos = SumZaduzenje - SumRazduzenje;
	SELECT * FROM temp_donos;
	DROP TABLE IF EXISTS temp_donos; 
END//
DELIMITER ;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
