/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Person;

public class ReservationDetailsController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFiler;
    @FXML
    private TableView<Document> tableReservation;
    @FXML
    private TableColumn<Document, Integer> columnNumber;
    @FXML
    private TableColumn<Document, Date> columnDeliveryDate;
    @FXML
    private TableColumn<Document, String> columnNote;
    @FXML
    private TableColumn<Document, String> columnNote2;
    @FXML
    private TableColumn<Document, String> columnOrder;
    @FXML
    private TableColumn<Document, Long> columnStatus;
    @FXML
    private TableColumn<Document, Long> columnPerson;
    @FXML
    private TableColumn<Document, Long> columnPIB;
    @FXML
    private ComboBox<String> cbReservationType;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TextField tfFilter;

    public void initialize() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("number"));
        this.columnDeliveryDate.setCellValueFactory((Callback)new PropertyValueFactory("deliveryDate"));
        this.columnDeliveryDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(item));
                }
            }
        });
        this.columnPIB.setCellValueFactory((Callback)new PropertyValueFactory("personID"));
        this.columnPIB.setCellFactory(column -> new TableCell<Document, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    Person person = Person.getById((long)item, (ScreensController)ReservationDetailsController.this.controller);
                    this.setText(person.getPIB());
                }
            }
        });
        this.columnNote.setCellValueFactory((Callback)new PropertyValueFactory("note"));
        this.columnNote2.setCellValueFactory((Callback)new PropertyValueFactory("note2"));
        this.columnStatus.setCellValueFactory((Callback)new PropertyValueFactory("statusName"));
        this.columnOrder.setCellValueFactory((Callback)new PropertyValueFactory("order"));
        this.columnPerson.setCellValueFactory((Callback)new PropertyValueFactory("personID"));
        this.columnPerson.setCellFactory(column -> new TableCell<Document, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    Person person = Person.getById((long)item, (ScreensController)ReservationDetailsController.this.controller);
                    this.setText(!person.getName().equals("") ? person.getName() : person.getFirstLastName());
                }
            }
        });
        this.cbReservationType.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                    ReservationDetailsController.this.fillDataTable(true, false, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    ReservationDetailsController.this.fillDataTable(false, false, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    ReservationDetailsController.this.fillDataTable(false, true, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    ReservationDetailsController.this.fillDataTable(false, false, true);
                }
            }
        });
        this.tableReservation.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    if (this.tableReservation.getSelectionModel().getSelectedItem() != null && !((Document)this.tableReservation.getSelectionModel().getSelectedItem()).isRealized()) {
                        this.parameter.put("selectedReservation", this.tableReservation.getSelectionModel().getSelectedItem());
                        this.modalResult = ScreensController.MODAL_RESULT_OK;
                        ((Stage)this.rootPane.getScene().getWindow()).close();
                    } else {
                        this.controller.alert("Obavestenje", "Rezervacija koja je realizovana ne mo\u017ee se u\u010ditati.", this.rootPane.getScene().getWindow());
                        return;
                    }
                }
            });
            return row;
        });
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                    ReservationDetailsController.this.fillDataTable(true, false, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    ReservationDetailsController.this.fillDataTable(false, false, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    ReservationDetailsController.this.fillDataTable(false, true, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    ReservationDetailsController.this.fillDataTable(false, false, true);
                }
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                    ReservationDetailsController.this.fillDataTable(true, false, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    ReservationDetailsController.this.fillDataTable(false, false, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    ReservationDetailsController.this.fillDataTable(false, true, false);
                } else if (((String)ReservationDetailsController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    ReservationDetailsController.this.fillDataTable(false, false, true);
                }
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)this.parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpFrom.setValue((Object)Settings.fromDate((Date)Document.getDateFromFirstActiveReservation((ScreensController)this.controller)));
        this.dpTo.setValue((Object)LocalDate.now());
        this.cbReservationType.getItems().addAll((Object[])new String[]{"Aktivne", "Realizovane", "Istekle", "Sve"});
        this.cbReservationType.getSelectionModel().selectFirst();
        this.fillDataTable(false, false, false);
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void commit() {
        if (this.tableReservation.getSelectionModel().getSelectedItem() == null || ((Document)this.tableReservation.getSelectionModel().getSelectedItem()).isRealized()) {
            this.controller.alert("Obavestenje", "Rezervacija koja je realizovana ne mo\u017ee se u\u010ditati.", this.rootPane.getScene().getWindow());
            return;
        }
        this.parameter.put("selectedReservation", this.tableReservation.getSelectionModel().getSelectedItem());
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillDataTable(boolean sve, boolean realized, boolean timeout) {
        this.tableReservation.setItems(Document.getReservationObservableList((boolean)sve, (boolean)realized, (boolean)timeout, (LocalDate)((LocalDate)this.dpFrom.getValue()), (LocalDate)((LocalDate)this.dpTo.getValue()), (ScreensController)this.controller));
        if (this.tableReservation.getItems().isEmpty()) {
            this.tableReservation.setPlaceholder((Node)new Label("Tabela je prazna"));
        }
        this.filter();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableReservation.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(document -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (String.valueOf(document.getNumber()) != null && String.valueOf(document.getNumber()).contains(lowerCaseFilter)) {
                return true;
            }
            if (document.getNote() != null && document.getNote().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            Person person = Person.getById((long)document.getPersonID(), (ScreensController)this.controller);
            if (person != null && person.getPIB() != null && person.getPIB().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (person != null && person.getName().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return person != null && person.getFirstLastName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableReservation.comparatorProperty());
        this.tableReservation.setItems((ObservableList)sortedData);
    }

    @FXML
    private void actionNew() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedDocument", null);
        this.controller.showModalDialog("Rezervacija - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_REZERVACIJE_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
            this.fillDataTable(true, false, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
            this.fillDataTable(false, false, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
            this.fillDataTable(false, true, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
            this.fillDataTable(false, false, true);
        }
    }

    @FXML
    private void actionChange() {
        if (this.tableReservation.getSelectionModel().getSelectedItem() != null && !((Document)this.tableReservation.getSelectionModel().getSelectedItem()).isRealized()) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDocument", this.tableReservation.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Rezervacija - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_REZERVACIJE_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                this.fillDataTable(true, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                this.fillDataTable(false, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                this.fillDataTable(false, true, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                this.fillDataTable(false, false, true);
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite rezervaciju iz tabele koju \u017eelite da izmenite. Rezervacija koja je realizovana ne mo\u017ee se menjati.", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionView() {
        if (this.tableReservation.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDocument", this.tableReservation.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Rezervacija - Detalji Pregled", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_REZERVACIJE_PREGLED_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                this.fillDataTable(true, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                this.fillDataTable(false, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                this.fillDataTable(false, true, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                this.fillDataTable(false, false, true);
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite rezervaciju iz tabele koju \u017eelite da izmenite. Rezervacija koja je realizovana ne mo\u017ee se menjati.", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionPrint() {
        if (this.tableReservation.getSelectionModel().getSelectedItem() != null) {
            Faktura f = new Faktura();
            f.setDocument((Document)this.tableReservation.getSelectionModel().getSelectedItem());
            f.printRezervacija(this.controller, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionDelete() {
        if (this.tableReservation.getSelectionModel().getSelectedItem() != null && !((Document)this.tableReservation.getSelectionModel().getSelectedItem()).isRealized()) {
            int brisanje = this.controller.yesNoDialog("Brisanje", "Da li ste sigurni da \u017eelite da obri\u0161ete rezervaciju?", this.rootPane.getScene().getWindow());
            if (brisanje == ScreensController.MODAL_RESULT_YES) {
                try {
                    Document document = (Document)this.tableReservation.getSelectionModel().getSelectedItem();
                    DocumentDetails.deleteDetailes((Document)document, (Connection)this.controller.getSettings().getConnection());
                    if (document.getRelationShipType(this.controller) == 7) {
                        document.deleteDocumentRelationShipProfaktura(this.controller);
                    }
                    document.delete(this.controller);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                    this.fillDataTable(true, false, false);
                } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    this.fillDataTable(false, false, false);
                } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    this.fillDataTable(false, true, false);
                } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    this.fillDataTable(false, false, true);
                }
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite rezervaciju iz tabele koju \u017eelite da obri\u0161ete. Rezervacija koja je realizovana ne mo\u017ee se obrisati.", this.rootPane.getScene().getWindow());
        }
    }
}

