/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina.controller;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;

public class DiscountDetailesController
implements DialogController {
    ScreensController controller;
    int billItemIndex = -1;
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    boolean popustCeoRacun;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameter;
    @FXML
    private BorderPane rootBorderPane;
    @FXML
    private Label labelProductName;
    @FXML
    private TextField tfDiscount;
    @FXML
    Button numpad0;
    @FXML
    Button numpad1;
    @FXML
    Button numpad2;
    @FXML
    Button numpad3;
    @FXML
    Button numpad4;
    @FXML
    Button numpad5;
    @FXML
    Button numpad6;
    @FXML
    Button numpad7;
    @FXML
    Button numpad8;
    @FXML
    Button numpad9;
    @FXML
    Button numpadDecimal;
    @FXML
    Button numpadDel;
    @FXML
    RadioButton rbDiscount;
    @FXML
    RadioButton rbMoney;
    @FXML
    RadioButton rbFixedPrice;

    public void initialize() {
        ToggleGroup toggleGroup = new ToggleGroup();
        this.rbDiscount.setToggleGroup(toggleGroup);
        this.rbMoney.setToggleGroup(toggleGroup);
        this.rbFixedPrice.setToggleGroup(toggleGroup);
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootBorderPane.getStylesheets().clear();
            this.rootBorderPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tfDiscount.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.parameter = parameter;
        if (parameter.get("billItemIndex") != null && (Integer)parameter.get("billItemIndex") != -1) {
            this.billItemIndex = (Integer)parameter.get("billItemIndex");
            this.labelProductName.setText(((RoundItem)((Round)((Bill)this.controller.getBillList().get(0)).getRoundList().get(0)).getItemList().get(this.billItemIndex)).getProductDepartment().getProduct().getName());
        } else {
            this.labelProductName.setText("Popust za ceo racun: ");
            this.popustCeoRacun = true;
        }
        if (!this.popustCeoRacun) {
            this.rbFixedPrice.setVisible(true);
        } else {
            this.rbFixedPrice.setVisible(false);
        }
        this.tfDiscount.requestFocus();
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void numButtonCliclk(ActionEvent event) {
        if (this.tfDiscount.getText().equals("0")) {
            this.tfDiscount.setText("");
        }
        if ((Button)event.getSource() == this.numpad0) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "0");
        }
        if ((Button)event.getSource() == this.numpad1) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "1");
        }
        if ((Button)event.getSource() == this.numpad2) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "2");
        }
        if ((Button)event.getSource() == this.numpad3) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "3");
        }
        if ((Button)event.getSource() == this.numpad4) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "4");
        }
        if ((Button)event.getSource() == this.numpad5) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "5");
        }
        if ((Button)event.getSource() == this.numpad6) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "6");
        }
        if ((Button)event.getSource() == this.numpad7) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "7");
        }
        if ((Button)event.getSource() == this.numpad8) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "8");
        }
        if ((Button)event.getSource() == this.numpad9) {
            this.tfDiscount.setText(this.tfDiscount.getText() + "9");
        }
        if (!((Button)event.getSource() != this.numpadDecimal || this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()) != null && this.controller.getSettings().getSetting("kolicina.ceo.broj", this.controller.getPointOfSale()).equals("true"))) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            this.tfDiscount.setText(this.tfDiscount.getText() + dfs.getDecimalSeparator());
        }
        if ((Button)event.getSource() == this.numpadDel) {
            if (this.tfDiscount.getText().equals("")) {
                this.tfDiscount.setText("0");
            } else {
                this.tfDiscount.setText(this.tfDiscount.getText().substring(0, this.tfDiscount.getText().length() - 1));
            }
        }
    }

    @FXML
    private void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootBorderPane.getScene().getWindow()).close();
    }

    @FXML
    private void commit() {
        ArrayList itemList = ((Round)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getRoundList().get(0)).getItemList();
        try {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            if (!this.tfDiscount.getText().equals("")) {
                if (!this.popustCeoRacun) {
                    if (this.rbDiscount.isSelected()) {
                        ((RoundItem)itemList.get(this.billItemIndex)).getProductDepartment().getProduct().setDiscount(this.numberFormat.parse(this.tfDiscount.getText()).doubleValue());
                    } else if (this.rbMoney.isSelected()) {
                        double money = Double.parseDouble(this.tfDiscount.getText().replace(",", "."));
                        double price = ((RoundItem)itemList.get(this.billItemIndex)).getProductDepartment().getProduct().getPrice();
                        double quantity = ((RoundItem)itemList.get(this.billItemIndex)).getQuantity();
                        double discount = 100.0 * money / (price * quantity);
                        ((RoundItem)itemList.get(this.billItemIndex)).getProductDepartment().getProduct().setDiscount(discount);
                    } else if (this.rbFixedPrice.isSelected()) {
                        double discount = 100.0 - Double.parseDouble(this.tfDiscount.getText().trim().replace(",", ".")) * 100.0 / ((RoundItem)itemList.get(this.billItemIndex)).getProductDepartment().getProduct().getPrice();
                        ((RoundItem)itemList.get(this.billItemIndex)).getProductDepartment().getProduct().setDiscount(discount);
                    }
                } else if (this.rbDiscount.isSelected()) {
                    Bill b1 = (Bill)this.controller.getBillList().get(this.controller.getActiveBill());
                    String test = this.tfDiscount.getText();
                    double discount = Double.parseDouble(test.replace(",", "."));
                    b1.setDiscount(discount);
                } else if (this.rbMoney.isSelected()) {
                    double cenaBezPopusta = ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getSumWithDiscout();
                    double cenaSaPopustom = cenaBezPopusta - Double.parseDouble(this.tfDiscount.getText().replace(",", "."));
                    ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).setDiscount(100.0 - cenaSaPopustom * 100.0 / cenaBezPopusta);
                } else if (this.rbFixedPrice.isSelected()) {
                    // empty if block
                }
            }
            System.out.println("Popust: " + ((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getDiscount());
            ((Stage)this.rootBorderPane.getScene().getWindow()).close();
        }
        catch (ParseException e) {
            this.controller.alert("Upozorenje", "Popust nije validan", this.rootBorderPane.getScene().getWindow());
        }
    }
}

