/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina;

import com.sun.javafx.application.LauncherImpl;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.User;
import sun.management.VMManagement;

public class Main
extends Application {
    private static final String FOLDER_URL = "http://download.mastersoftware.rs/tmaster_update.zip";
    private static final String DESTINATION_FOLDER_PATH = "C:\\TMaster";
    Logger LOGGER = Logger.getLogger("global");
    private ScreensController screensController = null;
    StackPane root = new StackPane();
    private ProgressBar progressBar;
    private Label statusLabel;

    public void init() throws Exception {
        super.init();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int standardWidth = 1920;
        int standardHeight = 1080;
        Dimension screenSize = toolkit.getScreenSize();
        double screenWidth = screenSize.getWidth();
        double screenHeight = screenSize.getHeight();
        double widthPercentage = screenWidth / (double)standardWidth * 100.0;
        double heightPercentage = screenHeight / (double)standardHeight * 100.0;
        System.out.println("\u0160irina ekrana je " + widthPercentage + "% standardne rezolucije.");
        System.out.println("Visina ekrana je " + heightPercentage + "% standardne rezolucije.");
        int dpi = toolkit.getScreenResolution();
        System.out.println("DPI (ta\u010daka po in\u010du): " + dpi);
        double scale = (double)dpi / 96.0;
        System.out.println("Faktor skaliranja: " + scale + screenSize.getHeight());
        if (screenSize.getHeight() > 900.0 && scale == 1.0) {
            this.screensController = new ScreensController(4, null);
            this.screensController.setRoot(this.root);
            this.screensController.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA, this.root, "");
        } else {
            this.screensController = new ScreensController(4, null);
            this.screensController.setRoot(this.root);
            this.screensController.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA1, this.root, "");
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void startDownloadReplaceTask() {
        Task downloadReplaceTask = new Task(){

            protected Void call() throws Exception {
                this.updateMessage("Downloading folder...");
                Main.this.downloadFolder();
                this.updateMessage("Replacing folder...");
                Main.this.replaceFolder();
                this.updateMessage("Folder download and replace completed.");
                return null;
            }
        };
        this.progressBar.progressProperty().bind((ObservableValue)downloadReplaceTask.progressProperty());
        this.statusLabel.textProperty().bind((ObservableValue)downloadReplaceTask.messageProperty());
    }

    private void downloadFolder() throws IOException {
        URL url = new URL(FOLDER_URL);
        try (InputStream in = url.openStream();
             FileOutputStream out = new FileOutputStream("temp.zip");){
            int bytesRead;
            byte[] buffer = new byte[8192];
            long totalBytesRead = 0L;
            long totalFileSize = url.openConnection().getContentLength();
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                double d = (double)(totalBytesRead += (long)bytesRead) / (double)totalFileSize;
            }
        }
    }

    private void replaceFolder() throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream("temp.zip"));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    this.LOGGER.info("DIRECTORY ");
                    continue;
                }
                String entryPath = DESTINATION_FOLDER_PATH + File.separator + entry.getName();
                this.LOGGER.info("Path he " + entryPath);
                Path filePath = Paths.get(entryPath, new String[0]);
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.copy(zipInputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void restartApplication(String jarFilePath) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator;
        String javaCommand = javaBin + "java.exe";
        ProcessBuilder processBuilder = new ProcessBuilder(javaCommand, "-jar", jarFilePath);
        processBuilder.start();
        System.exit(0);
    }

    public void start(final Stage primaryStage) {
        try {
            Scene scene = new Scene((Parent)this.root);
            primaryStage.setFullScreenExitKeyCombination((KeyCombination)new KeyCodeCombination(KeyCode.ESCAPE, new KeyCombination.Modifier[0]));
            primaryStage.setMaximized(this.screensController.getSettings().isFullscreen());
            primaryStage.maximizedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        primaryStage.setMaximized(true);
                    }
                }
            });
            String version = this.readFile();
            if (version == null || version.isEmpty()) {
                version = "2.1";
            }
            primaryStage.setTitle("TMaster - autor: 5.com d.o.o. - verzija " + version);
            primaryStage.setScene(scene);
            primaryStage.getIcons().add((Object)new Image("rs/petcom/master/img/T.jpg"));
            primaryStage.show();
            primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    if (Main.this.screensController.getUser() != null) {
                        Log.logOut((long)Main.this.screensController.getUser().getUserID(), (int)Main.this.screensController.getPointOfSale().getPointOfSaleID(), (Connection)Main.this.screensController.getSettings().getConnection());
                    }
                }
            });
        }
        catch (Exception e) {
            Log.writeLog((User)this.screensController.getUser(), (String)("Error: " + e.getMessage()), (Connection)this.screensController.getSettings().getConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile() {
        String filePath = "C:\\TMaster\\ver.txt";
        File file = new File(filePath);
        BufferedReader reader = null;
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                reader = new BufferedReader(inputStreamReader);
                String line = reader.readLine();
                if (line != null) {
                    String string = line;
                    return string;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.LOGGER.info("The file exists.");
        } else {
            this.LOGGER.info("The file does not exist!!!!!");
        }
        return null;
    }

    public static void main(String[] args) {
        LauncherImpl.launchApplication(Main.class, null, (String[])args);
        Main.launch((String[])args);
    }

    public static boolean isAlreadyRunning() {
        FileChannel fileChannel;
        File userDir = new File(System.getProperty("user.home"));
        File file = new File(userDir, Main.myLockName());
        if (!file.exists()) {
            try {
                file.createNewFile();
                file.deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create Single Instance lock file!", e);
            }
        }
        try {
            fileChannel = new RandomAccessFile(file, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Single Instance lock file vanished!", e);
        }
        try {
            if (fileChannel.tryLock() != null) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fileChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static String myLockName() {
        return "." + Main.class.getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static boolean isRunning() {
        Preferences prefs = Preferences.systemRoot().node("JavaApplication3");
        if (prefs.get("RUNNINGPID", null) == null || prefs.get("RUNNINGPID", null).equals("")) {
            return false;
        }
        return Main.isProcessIdRunningOnWindows(Integer.parseInt(prefs.get("RUNNINGPID", null)));
    }

    public static String getCurrentPID() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Field jvm = runtime.getClass().getDeclaredField("jvm");
            jvm.setAccessible(true);
            VMManagement mgmt = (VMManagement)jvm.get(runtime);
            Method pid_method = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            pid_method.setAccessible(true);
            return pid_method.invoke((Object)mgmt, new Object[0]) + "";
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the current PID");
        }
    }

    public static boolean isProcessIdRunningOnWindows(int pid) {
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            String[] cmds = new String[]{"cmd", "/c", "tasklist /FI \"PID eq " + pid + "\""};
            Process proc = runtime.exec(cmds);
            InputStream inputstream = proc.getInputStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            while ((line = bufferedreader.readLine()) != null) {
                if (!line.contains(" " + pid + " ")) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot run the tasklist command to query if a pid is running or not");
        }
    }
}

