/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina.controller;

import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.person.Person;

public class PersonSpecificationController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label lblName;
    @FXML
    private Label lblSurName;
    @FXML
    private Label lblValue;
    @FXML
    private Label lblDiscount;
    @FXML
    private Label lblSurNameStatic;
    @FXML
    private Label lblNameStatic;
    @FXML
    private Label lblReservedValue;
    @FXML
    private Label lblPaidValue;
    @FXML
    private Label lblPaid;
    @FXML
    private Label lblReserved;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        Person person = (Person)parameter.get("person");
        double value = (Double)parameter.get("personValue");
        double reservatedValue = (Double)parameter.get("reservatedValue");
        if (person.getPersonTypeID() == 2) {
            this.lblNameStatic.setVisible(false);
            this.lblSurNameStatic.setText("Naziv Firme");
            this.lblSurName.setText(person.getName());
        } else {
            this.lblName.setText(person.getFirstName());
            this.lblSurName.setText(person.getLastName());
        }
        this.lblPaidValue.setText(Settings.getNumberFormat((int)2, (boolean)true).format(value));
        this.lblReservedValue.setText(Settings.getNumberFormat((int)2, (boolean)true).format(reservatedValue));
        this.lblValue.setText(Settings.getNumberFormat((int)2, (boolean)true).format(value + reservatedValue));
        this.lblDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(person.getDiscount()) + "%");
        if (!this.controller.getSettings().getActualByName("rezervacija.front.vidljivo.dugme").equals("true")) {
            this.lblPaid.setVisible(false);
            this.lblReserved.setVisible(false);
            this.lblPaidValue.setVisible(false);
            this.lblReservedValue.setVisible(false);
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionOK() {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

