/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina.comunicators;

import java.util.Arrays;
import jssc.SerialPort;
import jssc.SerialPortException;

public class SerialPortComunicator {
    SerialPort sp;

    public SerialPortComunicator(String serial) {
        this.sp = new SerialPort(serial);
        this.getFinalResponse(this.getResponse());
    }

    private byte[] getResponse() {
        byte[] response = null;
        try {
            this.sp.openPort();
            this.sp.setParams(9600, 8, 1, 0);
            this.sp.writeString("W");
            Thread.sleep(1000L);
            response = this.sp.readBytes();
            this.sp.closePort();
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(Arrays.toString(response));
        return response;
    }

    private byte[] getFinalResponse(byte[] response) {
        byte[] finalResponse = new byte[11];
        for (int position = 0; position < 11; ++position) {
            if (response[position] != 2) continue;
            int j = 0;
            for (int i = position; i < position + 11; ++i) {
                finalResponse[j++] = response[i];
            }
        }
        System.out.println(Arrays.toString(finalResponse));
        return finalResponse;
    }
}

