/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.trgovina;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DownloadAndReplaceTask
implements Runnable {
    Logger LOGGER = Logger.getLogger("global");
    private String zipUrl;
    private String destinationFolderPath;

    public DownloadAndReplaceTask(String zipUrl, String destinationFolderPath) {
        this.zipUrl = zipUrl;
        this.destinationFolderPath = destinationFolderPath;
    }

    @Override
    public void run() {
        try {
            ZipEntry entry;
            URL url = new URL(this.zipUrl);
            InputStream inputStream = url.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    int bytesRead;
                    this.LOGGER.info("Start  and replaced file: ");
                    String entryName = entry.getName();
                    String entryPath = Paths.get(this.destinationFolderPath, entryName).toString();
                    File entryFile = new File(entryPath);
                    entryFile.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(entryFile);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                        fileOutputStream.write(buffer, 0, bytesRead);
                    }
                    fileOutputStream.close();
                    this.LOGGER.info("Extracted and replaced file: " + entryName);
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            inputStream.close();
            this.LOGGER.info("ZIP file downloaded, contents extracted, and folder replaced successfully.");
        }
        catch (IOException e) {
            this.LOGGER.warning("Error occurred during download, extraction, and folder replacement: " + e.getMessage());
        }
    }
}

