/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.salesreportnew.reportmodels;

import java.io.InputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import rs.petcom.master.ScreensController;
import rs.petcom.print.JRPrintPreviewPane;

public class JasperStarter {
    BorderPane rootPane;
    Map<String, Object> reportParameters;
    String path;
    ScreensController controller;
    Connection connection;

    public JasperStarter(Map<String, Object> reportParameters, String path, BorderPane rootPane) {
        this.reportParameters = reportParameters;
        this.path = path;
        this.controller = (ScreensController)this.reportParameters.get("controller");
        this.connection = this.controller.getSettings().getConnection();
        this.rootPane = rootPane;
    }

    public void createReportConncetionDataSource() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)JasperStarter.this.path));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, JasperStarter.this.reportParameters, (Connection)JasperStarter.this.connection);
                    JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
                    final HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
                    hm2.put("report", printViewPane);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                            JasperStarter.this.controller.showModalDialog("Pregled prodaje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, JasperStarter.this.rootPane.getScene().getWindow());
                        }
                    });
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom prikaza pregleda prometa!", "Proverite da li ste danas imali neki promet. Verovatno je promet 0, ili za odabranog operatera nema promet", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    public void createReportCollectionDataSource() {
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izvestaja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> createReport = new Task<Void>(){

            protected Void call() throws Exception {
                JRBeanCollectionDataSource datasource = new JRBeanCollectionDataSource((Collection)((ObservableList)JasperStarter.this.reportParameters.get("datas")));
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)JasperStarter.this.path));
                JasperPrint jp = JasperFillManager.fillReport((JasperReport)report, JasperStarter.this.reportParameters, (JRDataSource)datasource);
                JasperViewer.viewReport((JasperPrint)jp, (boolean)false);
                return null;
            }
        };
        createReport.setOnSucceeded(eventValue -> taskUpdateStage.close());
        createReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilkom kreiranja izve\u0161taja", "", this.rootPane.getScene().getWindow());
        });
        createReport.exceptionProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.printStackTrace();
            }
        });
        new Thread((Runnable)createReport).start();
    }
}

