/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.salesreportnew;

import java.io.File;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.backoffice.reports.exports.AditionalFieldSalesReportExcelExport;
import rs.petcom.backoffice.reports.models.AditionalFieldSalesReportModel;
import rs.petcom.backoffice.salesreportnew.reportmodels.ExcelStarter;
import rs.petcom.backoffice.salesreportnew.reportmodels.JasperStarter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;

public class AdditionaFieldsSalesReportNewController
implements ControlledScreen {
    private ScreensController controller;
    private Map<String, Object> parameter;
    private Connection connection;
    private TreeItem<Object> root;
    private String rootString;
    private final String reportArticlesPath = "rs/petcom/backoffice/jasper/salesreportnew/AditionalFieldSalesReportNew.jasper";
    private final String reportFinancialPath = "rs/petcom/backoffice/jasper/salesreportnew/AditionalFieldSalesReportNewFinancial.jasper";
    private AditionalFieldSalesReportModel model;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private TextField aditionalFieldFilter;
    @FXML
    private TextField aditionalFieldDetailsFilter;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<AditionalField> tblAdtionalField;
    @FXML
    private TableColumn<AditionalField, String> colAditionalField;
    @FXML
    private TableView<AditionalFieldDetails> tblAditionalFieldDetails;
    @FXML
    private TableColumn<AditionalFieldDetails, CheckBox> colAditionalFieldDetailsChecked;
    @FXML
    private TableColumn<AditionalFieldDetails, String> colAditionalFieldDetailsName;
    @FXML
    private Label title;
    @FXML
    private Label lblSum;
    @FXML
    private Button btnConfirm;
    @FXML
    private Button btnCancel;
    @FXML
    private CheckBox cbSelectAll;
    @FXML
    private TableView<AditionalFieldSalesReportModel> tblAfdSumary;
    @FXML
    private TableColumn<AditionalFieldSalesReportModel, String> colAfdName;
    @FXML
    private TableColumn<AditionalFieldSalesReportModel, Double> colValuePerAfd;

    public void setScreenParent(ScreensController screenPage) {
    }

    public void init() {
    }

    public void setParameter(Object parameter) {
        this.parameter = (Map)parameter;
        this.controller = (ScreensController)this.parameter.get("controller");
        this.connection = this.controller.getSettings().getConnection();
        this.tblAditionalFieldDetails.setEditable(true);
        this.rootString = "Dodatna polja";
        this.root = new TreeItem();
        this.root.setValue((Object)this.rootString);
        this.model = new AditionalFieldSalesReportModel();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.colAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.colAditionalFieldDetailsName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.colAditionalFieldDetailsChecked.setCellValueFactory((Callback)new PropertyValueFactory("ddCheckBox"));
        this.populateAditionalFields();
        this.colAfdName.setCellValueFactory((Callback)new PropertyValueFactory("aditionalFieldDetailName"));
        this.colValuePerAfd.setCellValueFactory((Callback)new PropertyValueFactory("valuePerAditionalFieldDetail"));
        this.dpDateFrom.setValue((Object)LocalDate.now());
        this.dpDateTo.setValue((Object)LocalDate.now());
        this.dpDateFrom.valueProperty().addListener((ob, oldValue, newValue) -> this.populateAfdSumary());
        this.dpDateTo.valueProperty().addListener((ob, oldValue, newValue) -> this.populateAfdSumary());
        this.tblAdtionalField.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.populateAditionalFieldsDetails((AditionalField)newSelection);
                this.selectAllAditionalFields(true);
                this.cbSelectAll.setSelected(true);
                this.populateAfdSumary();
            }
        });
        this.cbSelectAll.selectedProperty().addListener((obs, oldSelection, newSelection) -> {
            if (this.cbSelectAll.isSelected()) {
                this.selectAllAditionalFields(true);
            } else {
                this.selectAllAditionalFields(false);
            }
            this.populateAfdSumary();
        });
        this.tblAdtionalField.getSelectionModel().selectFirst();
        this.populateAfdSumary();
        this.afFilter();
    }

    public Object getParameter() {
        return null;
    }

    private void populateAditionalFields() {
        ObservableList adFieldsList = AditionalField.getList((Connection)this.connection);
        this.tblAdtionalField.setItems(adFieldsList);
    }

    private void populateAditionalFieldsDetails(AditionalField field) {
        ObservableList adFieldDetailsList = AditionalFieldDetails.getListByAditionalFieldID((long)field.getAditionalFieldID(), (Connection)this.connection);
        this.addRowListener((ObservableList<AditionalFieldDetails>)adFieldDetailsList);
        this.tblAditionalFieldDetails.setItems(adFieldDetailsList);
        this.aditionalFieldDetailsFilter();
    }

    private void aditionalFieldDetailsFilter() {
        FilteredList filteredData = new FilteredList(this.tblAditionalFieldDetails.getItems(), d -> true);
        this.aditionalFieldDetailsFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(afDetail -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return afDetail.getName() != null && afDetail.getName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tblAditionalFieldDetails.comparatorProperty());
        this.tblAditionalFieldDetails.setItems((ObservableList)sortedData);
    }

    private void afFilter() {
        FilteredList filteredData = new FilteredList(this.tblAdtionalField.getItems(), f -> true);
        this.aditionalFieldFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(aditionField -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return aditionField.getName() != null && aditionField.getName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tblAdtionalField.comparatorProperty());
        this.tblAdtionalField.setItems((ObservableList)sortedData);
    }

    @FXML
    private void confirmArticles(ActionEvent event) {
        ObservableList list = this.tblAfdSumary.getItems();
        if (this.isListEmpty((ObservableList<AditionalFieldSalesReportModel>)list)) {
            return;
        }
        Map<String, Object> reportParameters = ReportMapModel.getReportMap(this.controller);
        reportParameters.put("controller", this.controller);
        reportParameters.put("dateFrom", Settings.sqlDateFromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())));
        reportParameters.put("dateTo", Settings.sqlDateFromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())));
        reportParameters.put("datas", this.getArticleReportDatas());
        JasperStarter jStarter = new JasperStarter(reportParameters, "rs/petcom/backoffice/jasper/salesreportnew/AditionalFieldSalesReportNew.jasper", this.rootPane);
        jStarter.createReportCollectionDataSource();
    }

    @FXML
    private void articlesToExcel() {
        final ObservableList<AditionalFieldSalesReportModel> list = this.getArticleReportDatas();
        if (this.isListEmpty(list)) {
            return;
        }
        final AditionalFieldSalesReportExcelExport export = new AditionalFieldSalesReportExcelExport();
        final File file = ExcelStarter.getFileForExport(this.controller);
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                if (file != null) {
                    export.articleReportToExcel(file, (ObservableList<AditionalFieldSalesReportModel>)list);
                }
                return null;
            }
        };
        creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Greska prilikom Export-a", "Export nije uspeo", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    @FXML
    private void confirmFinancial() {
        ObservableList list = this.tblAfdSumary.getItems();
        if (this.isListEmpty((ObservableList<AditionalFieldSalesReportModel>)list)) {
            return;
        }
        String afName = ((AditionalField)this.tblAdtionalField.getSelectionModel().getSelectedItem()).getName();
        Map<String, Object> reportParameters = ReportMapModel.getReportMap(this.controller);
        reportParameters.put("controller", this.controller);
        reportParameters.put("dateFrom", Settings.sqlDateFromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())));
        reportParameters.put("dateTo", Settings.sqlDateFromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())));
        reportParameters.put("datas", list);
        reportParameters.put("afName", afName);
        JasperStarter jStarter = new JasperStarter(reportParameters, "rs/petcom/backoffice/jasper/salesreportnew/AditionalFieldSalesReportNewFinancial.jasper", this.rootPane);
        jStarter.createReportCollectionDataSource();
    }

    private String getAditionalFieldDetailsParamters() {
        StringBuilder sb = new StringBuilder();
        for (AditionalFieldDetails detail : this.tblAditionalFieldDetails.getItems()) {
            if (!detail.getDdCheckBox().isSelected()) continue;
            sb.append("'");
            sb.append(detail.getName());
            sb.append("'");
            sb.append(",");
        }
        return sb.toString().isEmpty() ? "''" : sb.toString().substring(0, sb.length() - 1);
    }

    private void populateAfdSumary() {
        double sum = 0.0;
        String afName = ((AditionalField)this.tblAdtionalField.getSelectionModel().getSelectedItem()).getName();
        String afdNames = this.getAditionalFieldDetailsParamters();
        if (afName != null) {
            ObservableList<AditionalFieldSalesReportModel> sumary = this.model.getAfdSumary(this.connection, Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), afName, afdNames);
            this.tblAfdSumary.getItems().clear();
            if (sumary != null) {
                this.tblAfdSumary.getItems().addAll(sumary);
            }
            for (AditionalFieldSalesReportModel afd : this.tblAfdSumary.getItems()) {
                sum += afd.getValuePerAditionalFieldDetail();
            }
            this.lblSum.setText(String.valueOf(sum));
        }
    }

    private ObservableList<AditionalFieldSalesReportModel> getArticleReportDatas() {
        String afName = ((AditionalField)this.tblAdtionalField.getSelectionModel().getSelectedItem()).getName();
        return this.model.getAfdReportData(this.connection, Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), afName);
    }

    private void selectAllAditionalFields(boolean selection) {
        ObservableList adFieldDetailsList = this.tblAditionalFieldDetails.getItems();
        this.setSeletion((ObservableList<AditionalFieldDetails>)adFieldDetailsList, selection);
        this.tblAditionalFieldDetails.setItems(adFieldDetailsList);
    }

    private void setSeletion(ObservableList<AditionalFieldDetails> details, boolean selection) {
        for (AditionalFieldDetails detail : details) {
            detail.getDdCheckBox().setSelected(selection);
        }
    }

    private void addRowListener(ObservableList<AditionalFieldDetails> afDetails) {
        for (AditionalFieldDetails detail : afDetails) {
            detail.getDdCheckBox().selectedProperty().addListener((obs, oldSelection, newSelection) -> {
                this.aditionalFieldDetailsFilter.setText("");
                this.populateAfdSumary();
            });
        }
    }

    private boolean isListEmpty(ObservableList<AditionalFieldSalesReportModel> list) {
        if (list == null || list.size() < 1) {
            this.controller.alert("Obave\u0161tenje", "Za izabrani period nema podataka", this.rootPane.getScene().getWindow());
            return true;
        }
        return false;
    }
}

