/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.reports.models;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class SalesOfArticleReportModel {
    private String barcode;
    private String code;
    private String articleName;
    private double quantity;
    private double price;
    private double value;

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getArticleName() {
        return this.articleName;
    }

    public void setArticleName(String articleName) {
        this.articleName = articleName;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static ObservableList<SalesOfArticleReportModel> getSaleReportDatas(Connection connection, long wdFromId, long wdToId, String pointsOfSale, String productCategories, String sortParameter) {
        ObservableList salesList = FXCollections.observableArrayList();
        String query = "SELECT \r\n(SELECT b.BarCode FROM barcode b WHERE b.ProductID = p.ProductID order BY b.ProductID DESC LIMIT 1) AS bCode,\r\np.Name AS articleName, p.code, SUM(dd.Quantity) AS quantity, dd.PriceWithDiscount AS price, \r\nROUND((SUM(dd.Quantity) * dd.PriceWithDiscount),2) AS val,  d.PointOfSaleID FROM documentdetails dd\r\nJOIN document d ON dd.DocumentID = d.DocumentID\r\nJOIN product p ON dd.ProductID = p.ProductID\r\nWHERE d.WorkDayID BETWEEN ? AND ?  AND d.DocumentTypeID =3 AND d.PointOfSaleID IN (" + pointsOfSale + ") \r\nAND p.ProductCategoryID IN (" + productCategories + ")group BY p.ProductID, dd.PriceWithDiscount \r\norder BY " + sortParameter;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, wdFromId);
            ps.setLong(2, wdToId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SalesOfArticleReportModel model = new SalesOfArticleReportModel();
                model.setBarcode(rs.getString("bCode"));
                model.setCode(rs.getString("code"));
                model.setArticleName(rs.getString("articleName"));
                model.setQuantity(rs.getDouble("quantity"));
                model.setPrice(rs.getDouble("price"));
                model.setValue(rs.getDouble("val"));
                salesList.add((Object)model);
            }
            return salesList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

