/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.reports.models;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ScreensController;

public class ListOfSaleAndReservationsModel {
    private int number;
    private String docNumber;
    private String person;
    private String category;
    private String brand;
    private String purpose;
    private String barcode;
    private String productName;
    private double quantity;
    private double purchasePrice;
    private double purchaseValue;
    private double coef;
    private double priceWithoutVat;
    private double priceWithvat;
    private double selValue;
    private double discount;
    private double rabat;
    private double selValueWithRabat;
    private double docSum;

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String getPerson() {
        return this.person;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setPurchasePrice(double purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public double getPurchaseValue() {
        return this.purchaseValue;
    }

    public void setPurchaseValue(double purchaseValue) {
        this.purchaseValue = purchaseValue;
    }

    public double getCoef() {
        return this.coef;
    }

    public void setCoef(double coef) {
        this.coef = coef;
    }

    public double getPriceWithoutVat() {
        return this.priceWithoutVat;
    }

    public void setPriceWithoutVat(double priceWithoutVat) {
        this.priceWithoutVat = priceWithoutVat;
    }

    public double getPriceWithvat() {
        return this.priceWithvat;
    }

    public void setPriceWithvat(double priceWithvat) {
        this.priceWithvat = priceWithvat;
    }

    public double getSelValue() {
        return this.selValue;
    }

    public void setSelValue(double selValue) {
        this.selValue = selValue;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getRabat() {
        return this.rabat;
    }

    public void setRabat(double rabat) {
        this.rabat = rabat;
    }

    public double getSelValueWithRabat() {
        return this.selValueWithRabat;
    }

    public void setSelValueWithRabat(double selValueWithRabat) {
        this.selValueWithRabat = selValueWithRabat;
    }

    public double getDocSum() {
        return this.docSum;
    }

    public void setDocSum(double docSum) {
        this.docSum = docSum;
    }

    public static ObservableList<ListOfSaleAndReservationsModel> getListOfSaleDatas(ScreensController controller, java.util.Date from, java.util.Date to) {
        Date dateFrom = new Date(from.getTime());
        Date dateTo = new Date(to.getTime());
        ObservableList listOfSalesDatas = FXCollections.observableArrayList();
        int orderNumber = 1;
        String query = "SELECT docNumber, person, category, brand, purpose, bcode, productName, quantity, purchasePrice,\r\nROUND( COALESCE(selValueWithRabat/quantity/1.2/purchasePrice,0),2) AS coef,\r\nROUND(quantity * purchasePrice,2 ) AS purchaseValue,\r\npriceWithoutVat, priceWithVat,selValue, discount, rabat,\r\nselValueWithRabat,docSum\r\nFROM \t\r\n(SELECT if(d.DocumentTypeID =3 , CONCAT('F-',d.Number) ,CONCAT('R-',d.Number) ) AS docNumber,\r\nCOALESCE (if(p.PersonTypeID = 2, p.Name, CONCAT(p.FirstName,' ', p.LastName)),'NN LICE')AS person,\r\n(SELECT COALESCE(\r\n\t(SELECT afd.Name FROM aditionalfielddetails afd\r\n\tJOIN aditionalfielddetailsproduct afdp ON afd.AditionalFieldDetailsID = afdp.AditionalFieldDetailsID\r\n\tWHERE afd.AditionalFieldID = 8 AND afdp.ProductID = dd.ProductId), 'Bez opisa')) AS category,\r\n(SELECT COALESCE(\r\n\t(SELECT afd.Name FROM aditionalfielddetails afd\r\n\tJOIN aditionalfielddetailsproduct afdp ON afd.AditionalFieldDetailsID = afdp.AditionalFieldDetailsID\r\n\tWHERE afd.AditionalFieldID = 6 AND afdp.ProductID = dd.ProductId), 'Bez opisa')) AS brand,\r\n(SELECT COALESCE(\r\n\t(SELECT afd.Name FROM aditionalfielddetails afd\r\n\tJOIN aditionalfielddetailsproduct afdp ON afd.AditionalFieldDetailsID = afdp.AditionalFieldDetailsID\r\n\tWHERE afd.AditionalFieldID = 9 AND afdp.ProductID = dd.ProductId), 'Bez opisa')) AS purpose,\r\n(SELECT bc.BarCode FROM barcode bc WHERE bc.ProductID = dd.ProductId order BY bc.BarCodeID LIMIT 1) AS bcode,\r\nprod.Name AS productName,dd.Quantity, \r\n(SELECT COALESCE((SELECT dd1.PurchacePrice FROM documentdetails dd1 \r\n\tJOIN document d1 ON dd1.DocumentID = d1.DocumentID\r\n\tWHERE dd1.ProductID =dd.ProductID AND d1.DocumentTypeID = 1\r\n\torder BY d1.DocumentID DESC LIMIT 1),0)) AS purchasePrice,\r\n0 AS prchaseValue,\t\r\n0 AS koef,\r\nROUND((dd.Price -dd.Price * v.Value3),2) AS priceWithoutVat,\r\nROUND(dd.Price,2) AS priceWithVat,\r\nROUND(dd.Price * dd.quantity,2) AS selValue,\r\nROUND((dd.Price - dd.PriceWithDiscount)*100/dd.Price,2) AS discount,\r\nROUND((dd.Price*dd.quantity*((dd.Price - dd.PriceWithDiscount)*100/dd.Price))/100,2) AS rabat,\r\nROUND((dd.Price*dd.quantity)-((dd.Price * dd.quantity*((dd.Price - dd.PriceWithDiscount)*100/dd.Price))/100),2)  AS selValueWithRabat,\r\nd.SumWithDiscount as docSum\r\nFROM documentdetails dd \r\nJOIN document d ON dd.DocumentID = d.DocumentID\r\nLEFT JOIN person p ON d.PersonID = p.PersonID\r\nJOIN product prod ON dd.ProductID = prod.ProductID\r\nJOIN vat v ON prod.VatID = v.VatID\r\nWHERE dd.DocumentID  IN\r\n\t(SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID IN (3,29)\r\n\t\tAND  CAST(d.Date AS DATE) BETWEEN ? AND ? \r\n\t\tAND d.DocumentStatusID !=3 \r\n\t\tAND d.DocumentID NOT IN\r\n\t\t\t(SELECT d1.DocumentID FROM document d1 \r\n\t\t\t\tJOIN documentrelationship dr ON d1.DocumentID = dr.DocumentChildID\r\n\t\t\t\tWHERE d1.DocumentTypeID = 3 AND dr.RelationshipTypeID = 8) )\r\nORDER BY dd.DocumentDetailsID, docNumber )AS trt";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setDate(1, dateFrom);
            ps.setDate(2, dateTo);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ListOfSaleAndReservationsModel lsrm = new ListOfSaleAndReservationsModel();
                lsrm.setNumber(orderNumber);
                lsrm.setDocNumber(rs.getString("docNumber"));
                lsrm.setPerson(rs.getString("person"));
                lsrm.setCategory(rs.getString("category"));
                lsrm.setBrand(rs.getString("brand"));
                lsrm.setPurpose(rs.getString("purpose"));
                lsrm.setBarcode(rs.getString("bcode"));
                lsrm.setProductName(rs.getString("productName"));
                lsrm.setQuantity(rs.getDouble("quantity"));
                lsrm.setPurchasePrice(rs.getDouble("purchasePrice"));
                lsrm.setPurchaseValue(rs.getDouble("purchaseValue"));
                lsrm.setCoef(rs.getDouble("coef"));
                lsrm.setPriceWithoutVat(rs.getDouble("priceWithoutVat"));
                lsrm.setPriceWithvat(rs.getDouble("priceWithvat"));
                lsrm.setSelValue(rs.getDouble("selValue"));
                lsrm.setDiscount(rs.getDouble("discount"));
                lsrm.setRabat(rs.getDouble("rabat"));
                lsrm.setSelValueWithRabat(rs.getDouble("selValueWithRabat"));
                lsrm.setDocSum(rs.getDouble("docSum"));
                listOfSalesDatas.add((Object)lsrm);
                ++orderNumber;
            }
            return listOfSalesDatas;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void listOfsaleToExcel(File file, ObservableList<ListOfSaleAndReservationsModel> list) {
        double sumSelValue = 0.0;
        double sumPurchaseValue = 0.0;
        String oldDocNumber = "";
        String newDocNumber = "";
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Lista prodaje");
        XSSFCellStyle style = ListOfSaleAndReservationsModel.makeStyle(wb);
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Redni broj");
        header.createCell(1).setCellValue("Broj ra\u010duna");
        header.createCell(2).setCellValue("Kupac");
        header.createCell(3).setCellValue("Kategorija");
        header.createCell(4).setCellValue("Brend");
        header.createCell(5).setCellValue("\u0160ifra proizvoda");
        header.createCell(6).setCellValue("Opis proizvoda");
        header.createCell(7).setCellValue("Funkcija");
        header.createCell(8).setCellValue("Koli\u010dina");
        header.createCell(9).setCellValue("Jedini\u010dna nabavna cena");
        header.createCell(10).setCellValue("Jedini\u010dni koeficijent");
        header.createCell(11).setCellValue("Nabavna vrednost");
        header.createCell(12).setCellValue("MP cena bez PDV-a");
        header.createCell(13).setCellValue("MP cena sa PDV-om");
        header.createCell(14).setCellValue("Iznos Porud\u017ebine");
        header.createCell(15).setCellValue("Popust %");
        header.createCell(16).setCellValue("Rabat ");
        header.createCell(17).setCellValue("Porud\u017ebina sa rabatom");
        header.createCell(18).setCellValue("Ra\u010dun");
        header.createCell(19).setCellValue("Kupac");
        header.createCell(20).setCellValue("Ukupno za naplatu");
        XSSFRow emptyRow = sheet.createRow(1);
        int index = 2;
        for (ListOfSaleAndReservationsModel model : list) {
            newDocNumber = model.getDocNumber().trim();
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue((double)model.getNumber());
            row.createCell(1).setCellValue(model.getDocNumber());
            row.createCell(2).setCellValue(model.getPerson());
            row.createCell(3).setCellValue(model.getCategory());
            row.createCell(4).setCellValue(model.getBrand());
            row.createCell(5).setCellValue(model.getBarcode());
            row.createCell(6).setCellValue(model.getProductName());
            row.createCell(7).setCellValue(model.getPurpose());
            row.createCell(8).setCellValue(model.getQuantity());
            XSSFCell purchaseCell = row.createCell(9);
            purchaseCell.setCellValue(model.getPurchasePrice());
            XSSFCell coefCell = row.createCell(10);
            coefCell.setCellValue(model.coef);
            XSSFCell purchaseValueCell = row.createCell(11);
            purchaseValueCell.setCellValue(model.getPurchaseValue());
            if (model.getPurchasePrice() == 0.0) {
                purchaseCell.setCellStyle((CellStyle)style);
                coefCell.setCellStyle((CellStyle)style);
                purchaseValueCell.setCellStyle((CellStyle)style);
            }
            row.createCell(12).setCellValue(model.getPriceWithoutVat());
            row.createCell(13).setCellValue(model.getPriceWithvat());
            row.createCell(14).setCellValue(model.getSelValue());
            row.createCell(15).setCellValue(model.getDiscount());
            row.createCell(16).setCellValue(model.getRabat());
            row.createCell(17).setCellValue(model.getSelValueWithRabat());
            if (newDocNumber.equals(oldDocNumber)) {
                row.createCell(18).setCellValue("");
                row.createCell(19).setCellValue("");
                row.createCell(20).setCellValue("");
            } else {
                row.createCell(18).setCellValue(model.getDocNumber());
                row.createCell(19).setCellValue(model.getPerson());
                row.createCell(20).setCellValue(model.getDocSum());
            }
            sumSelValue += model.getSelValue();
            sumPurchaseValue += model.getPriceWithoutVat() * model.getQuantity();
            oldDocNumber = newDocNumber;
            ++index;
            ListOfSaleAndReservationsModel.makeSheetStyle(sheet, (CellStyle)style);
        }
        XSSFRow sellWithoutVatRow = sheet.createRow(index++);
        sellWithoutVatRow.createCell(19).setCellValue("Ukupna prodajna bez PDV:");
        sellWithoutVatRow.createCell(20).setCellValue(sumSelValue);
        XSSFRow rowEmpty = sheet.createRow(index++);
        XSSFRow purchaseRow = sheet.createRow(index++);
        purchaseRow.createCell(19).setCellValue("Ukupna nabavna vrednost:");
        purchaseRow.createCell(20).setCellValue(sumPurchaseValue);
        XSSFRow marginRow = sheet.createRow(index++);
        marginRow.createCell(19).setCellValue("Ukupna mar\u017ea:");
        marginRow.createCell(20).setCellValue(sumSelValue - sumPurchaseValue);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void makeSheetStyle(XSSFSheet sheet, CellStyle style) {
        int colCount = sheet.getRow(0).getLastCellNum();
        for (int i = 0; i < colCount; ++i) {
            sheet.autoSizeColumn(i);
            sheet.getRow(0).getCell(i).setCellStyle(style);
            if (i < 18) continue;
            for (int j = 2; j < sheet.getPhysicalNumberOfRows(); ++j) {
                sheet.getRow(j).getCell(i).setCellStyle(style);
            }
        }
    }

    private static XSSFCellStyle makeStyle(XSSFWorkbook wb) {
        XSSFColor myColor = new XSSFColor(Color.LIGHT_GRAY);
        XSSFCellStyle style = wb.createCellStyle();
        style.setFillForegroundColor(myColor);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }
}

