/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.reports.models;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.Settings;

public class ExciseTaxReportModel {
    private String revenueDate;
    private double excise;
    private double noExciseTax;
    private double basis;
    private double tax;
    private double total;
    private double cash;
    private double card;
    private double check;
    private double invoice;

    public String getRevenueDate() {
        return this.revenueDate;
    }

    public void setRevenueDate(String revenueDate) {
        this.revenueDate = revenueDate;
    }

    public double getExcise() {
        return this.excise;
    }

    public void setExcise(double excise) {
        this.excise = excise;
    }

    public double getNoExciseTax() {
        return this.noExciseTax;
    }

    public void setNoExciseTax(double noExciseTax) {
        this.noExciseTax = noExciseTax;
    }

    public double getBasis() {
        return this.basis;
    }

    public void setBasis(double basis) {
        this.basis = basis;
    }

    public double getTax() {
        return this.tax;
    }

    public void setTax(double tax) {
        this.tax = tax;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public double getCash() {
        return this.cash;
    }

    public void setCash(double cash) {
        this.cash = cash;
    }

    public double getCard() {
        return this.card;
    }

    public void setCard(double card) {
        this.card = card;
    }

    public double getCheck() {
        return this.check;
    }

    public void setCheck(double check) {
        this.check = check;
    }

    public double getInvoice() {
        return this.invoice;
    }

    public void setInvoice(double invoice) {
        this.invoice = invoice;
    }

    public static ObservableList<ExciseTaxReportModel> getExciseTaxRevenue(Connection connection, LocalDate dateFrom, LocalDate dateTo) {
        Date from = Settings.sqlDateFromLocalDate((LocalDate)dateFrom);
        Date to = Settings.sqlDateFromLocalDate((LocalDate)dateTo);
        ObservableList reportList = FXCollections.observableArrayList();
        String query = "SELECT datum, akciza, (ukupno - pdv - akciza) AS bezAkcize, (ukupno - pdv) AS osnovica, ukupno,pdv,gotovina, kartica,cek,faktura\r\n\r\nFROM (SELECT wd.Date AS datum,\r\n\r\n(SELECT  ROUND(SUM(dd2.Quantity * COALESCE(ep.Value, 0) * COALESCE(e.Value, 0)),2) FROM documentdetails dd2\r\nLEFT JOIN exciseproduct ep ON dd2.ProductID = ep.ProductID\r\nLEFT JOIN excise e ON e.ExciseID = ep.ExciseID\r\n\t WHERE dd2.DocumentID IN \r\n\t\t(SELECT d2.DocumentID FROM document d2 WHERE d2.WorkDayID = wd.WorkDayID AND d2.DocumentTypeID IN (3,18)) ) AS akciza,\r\n0 AS bezAkcize,0 AS osnovica,\r\n\r\n(SELECT ROUND( SUM(dd1.Quantity * dd1.PriceWithDiscount), 2) FROM documentdetails dd1 \r\n\tWHERE dd1.DocumentID IN \r\n\t\t(SELECT d1.DocumentID FROM document d1 WHERE d1.WorkDayID = wd.WorkDayID AND d1.DocumentTypeID IN (3,18)) ) AS ukupno,\r\n\t\r\n(SELECT ROUND(SUM(dd.Quantity * dd.PriceWithDiscount * v.Value3),2) FROM documentdetails dd\r\nLEFT JOIN vat v ON dd.VatID = v.VatID\r\n\t WHERE dd.DocumentID IN \r\n\t\t(SELECT d.DocumentID FROM document d WHERE d.WorkDayID = wd.WorkDayID  AND d.DocumentTypeID IN (3,18)) ) AS pdv,\r\n(SELECT  COALESCE(SUM(dp.Paid),0) FROM documentpayment dp\r\nLEFT JOIN document d3 ON dp.DocumentID = d3.DocumentID\r\nWHERE d3.WorkDayID = wd.WorkDayID  AND d3.DocumentTypeID IN (3,18) AND dp.PaymentMethodID=1) AS gotovina,\r\n \t\t\r\n(SELECT  COALESCE(SUM(dp.Paid),0) FROM documentpayment dp\r\nLEFT JOIN document d3 ON dp.DocumentID = d3.DocumentID\r\nWHERE d3.WorkDayID = wd.WorkDayID  AND d3.DocumentTypeID IN (3,18) AND dp.PaymentMethodID=2) AS kartica,\r\n\r\n(SELECT  COALESCE(SUM(dp.Paid),0) FROM documentpayment dp\r\nLEFT JOIN document d3 ON dp.DocumentID = d3.DocumentID\r\nWHERE d3.WorkDayID = wd.WorkDayID  AND d3.DocumentTypeID IN (3,18) AND dp.PaymentMethodID=3) AS cek,\r\n\r\n(SELECT  COALESCE(SUM(dp.Paid),0) FROM documentpayment dp\r\nLEFT JOIN document d3 ON dp.DocumentID = d3.DocumentID\r\nWHERE d3.WorkDayID = wd.WorkDayID  AND d3.DocumentTypeID IN (3,18) AND dp.PaymentMethodID=5) AS faktura\r\n\t \r\nFROM workday wd WHERE wd.Date BETWEEN ? AND ?  ) AS trt";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, from);
            ps.setDate(2, to);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ExciseTaxReportModel model = new ExciseTaxReportModel();
                String ld = Settings.formatLocalDate((LocalDate)rs.getDate("datum").toLocalDate());
                model.setRevenueDate(ld);
                model.setExcise(rs.getDouble("akciza"));
                model.setNoExciseTax(rs.getDouble("bezAkcize"));
                model.setBasis(rs.getDouble("osnovica"));
                model.setTax(rs.getDouble("pdv"));
                model.setTotal(rs.getDouble("ukupno"));
                model.setCash(rs.getDouble("gotovina"));
                model.setCard(rs.getDouble("kartica"));
                model.setCheck(rs.getDouble("cek"));
                model.setInvoice(rs.getDouble("faktura"));
                reportList.add((Object)model);
            }
            return reportList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

