/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.reports.exports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javafx.collections.ObservableList;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.backoffice.reports.models.AditionalFieldSalesReportModel;

public class AditionalFieldSalesReportExcelExport {
    private XSSFWorkbook articleWb = new XSSFWorkbook();
    private XSSFCellStyle style = AditionalFieldSalesReportExcelExport.createStyle(this.articleWb);

    public void articleReportToExcel(File file, ObservableList<AditionalFieldSalesReportModel> list) {
        int row = 0;
        double sum = 0.0;
        String aditionFieldDetail = "";
        XSSFSheet sheet = this.articleWb.createSheet("Prodaja po podgrupama");
        for (AditionalFieldSalesReportModel model : list) {
            if (!model.getAditionalFieldDetailName().equals(aditionFieldDetail)) {
                aditionFieldDetail = model.getAditionalFieldDetailName();
                if (row != 0) {
                    sum = this.insertRowAndResetSum(sheet, row++, sum);
                    this.createEmptyRow(sheet, row++);
                }
                this.createAfdNameRow(sheet, row++, model);
                this.createHeader(sheet, row++);
                this.createDataRow(sheet, row++, model);
                sum += model.getValue();
                continue;
            }
            this.createDataRow(sheet, row++, model);
            sum += model.getValue();
        }
        sum = this.insertRowAndResetSum(sheet, row++, sum);
        this.adjustColumnWidth(sheet);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            this.articleWb.write((OutputStream)fileOutputStream);
            this.articleWb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createHeader(XSSFSheet sheet, int row) {
        XSSFRow header = sheet.createRow(row);
        XSSFCell cell_0 = header.createCell(0);
        cell_0.setCellValue("\u0160ifra proizvoda");
        cell_0.setCellStyle((CellStyle)this.style);
        XSSFCell cell_1 = header.createCell(1);
        cell_1.setCellValue("Naziv proizvoda");
        cell_1.setCellStyle((CellStyle)this.style);
        XSSFCell cell_2 = header.createCell(2);
        cell_2.setCellValue("Koli\u010dina");
        cell_2.setCellStyle((CellStyle)this.style);
        XSSFCell cell_3 = header.createCell(3);
        cell_3.setCellValue("Cena");
        cell_3.setCellStyle((CellStyle)this.style);
        XSSFCell cell_4 = header.createCell(4);
        cell_4.setCellValue("Vrednost");
        cell_4.setCellStyle((CellStyle)this.style);
    }

    private void createEmptyRow(XSSFSheet sheet, int row) {
        XSSFRow header = sheet.createRow(row);
    }

    private void createDataRow(XSSFSheet sheet, int row, AditionalFieldSalesReportModel model) {
        XSSFRow header = sheet.createRow(row);
        header.createCell(0).setCellValue(model.getBarcode());
        header.createCell(1).setCellValue(model.getProductName());
        header.createCell(2).setCellValue(model.getQuantity());
        header.createCell(3).setCellValue(model.getPrice());
        header.createCell(4).setCellValue(model.getValue());
    }

    private void createAfdNameRow(XSSFSheet sheet, int row, AditionalFieldSalesReportModel model) {
        XSSFRow header = sheet.createRow(row);
        XSSFCell cell_0 = header.createCell(0);
        cell_0.setCellValue("Podgrupa:");
        cell_0.setCellStyle((CellStyle)this.style);
        XSSFCell cell_1 = header.createCell(1);
        cell_1.setCellValue(model.getAditionalFieldDetailName());
        cell_1.setCellStyle((CellStyle)this.style);
    }

    private void adjustColumnWidth(XSSFSheet sheet) {
        int colCount = sheet.getRow(0).getLastCellNum();
        for (int i = 0; i < colCount; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    private double insertRowAndResetSum(XSSFSheet sheet, int row, double sum) {
        XSSFRow new_Row = sheet.createRow(row);
        XSSFCell cell_0 = new_Row.createCell(3);
        cell_0.setCellValue("Ukupno:");
        cell_0.setCellStyle((CellStyle)this.style);
        XSSFCell cell_1 = new_Row.createCell(4);
        cell_1.setCellValue(sum);
        cell_1.setCellStyle((CellStyle)this.style);
        return 0.0;
    }

    private static XSSFCellStyle createStyle(XSSFWorkbook wb) {
        XSSFFont font = wb.createFont();
        font.setBold(true);
        XSSFCellStyle style = wb.createCellStyle();
        style.setFont((Font)font);
        return style;
    }
}

