/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.util.LinkedList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentPayment;

public final class TextHooverOnTableCell<S, T>
extends TextFieldTableCell<S, T> {
    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn(ScreensController controller) {
        return TextHooverOnTableCell.forTableColumn(new DefaultStringConverter(), controller);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(final StringConverter<T> converter, final ScreensController controller) {
        return new Callback<TableColumn<S, T>, TableCell<S, T>>(){

            public TableCell<S, T> call(TableColumn<S, T> list) {
                final TextFieldTableCell result = new TextFieldTableCell(converter);
                final Popup popup = new Popup();
                popup.setAutoHide(true);
                EventHandler<MouseEvent> hoverListener = new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        System.out.println(result.getText());
                        if (result.getText() != null && result.getText().equals("Kombinovano")) {
                            TableRow row = result.getTableRow();
                            Document document = (Document)row.getItem();
                            StringBuilder sb = new StringBuilder();
                            LinkedList payments = DocumentPayment.getCombinedPaymentByDocumentId((long)document.getDocumentID(), (ScreensController)controller);
                            for (int i = 0; i < payments.size(); ++i) {
                                DocumentPayment dp = (DocumentPayment)payments.get(i);
                                if (dp.getPaymentMethodID() == 1) {
                                    sb.append(" Gotovina: ");
                                    sb.append(dp.getPaid());
                                }
                                if (dp.getPaymentMethodID() == 2) {
                                    sb.append(" Kartica: ");
                                    sb.append(dp.getPaid());
                                }
                                if (dp.getPaymentMethodID() == 3) {
                                    sb.append(" \u010cek ");
                                    sb.append(dp.getPaid());
                                }
                                if (i == payments.size() - 1) continue;
                                sb.append(",");
                            }
                            Label popupContent = new Label(sb.toString());
                            popupContent.setStyle("-fx-background-color: #64b5f6; -fx-border-color: #000000; -fx-border-width: 1px; -fx-padding: 5px; -fx-text-fill: white;");
                            popup.getContent().clear();
                            popup.getContent().addAll((Object[])new Node[]{popupContent});
                            if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                                popup.hide();
                            } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                                popup.show((Node)result, event.getScreenX() + 10.0, event.getScreenY());
                            }
                        }
                    }
                };
                result.setOnMouseEntered((EventHandler)hoverListener);
                result.setOnMouseExited((EventHandler)hoverListener);
                return result;
            }
        };
    }
}

