/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.sql.Connection;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.PrijemnicaDetailes;
import rs.petcom.master.dal.product.Product;

public class ItemPrijemnicaDetalji
extends GridPane {
    private int rbWidth = 40;
    private int proizvodWidth = 290;
    private int kolicinaJMWidth = 80;
    private int nabavnaCenaWidth = 90;
    private int ukupnoWidth = 95;
    private int popustWidth = 60;
    private int nabavnaCenaSaPopustomWidth = 95;
    private int pdvWidth = 40;
    private int ukupnaVrednostSaPdvWidth = 95;
    private int prodajnaCenaWidth = 80;
    private int marzaWidth = 50;
    private int deleteWidth = 30;
    ScreensController controller;
    Label lRb = new Label();
    ComboBox<Product> cbArtikal = new ComboBox();
    TextField tfKolicina = new TextField();
    TextField tfNabavnaCena = new TextField();
    TextField tfUkupno = new TextField();
    TextField tfPopust = new TextField();
    TextField tfCenaSaPopustom = new TextField();
    TextField tfPdv = new TextField();
    TextField tfUkupnaVrednostSaPdv = new TextField();
    TextField tfProdajnaCena = new TextField();
    TextField tfMarza = new TextField();
    Button btnDelete = new Button();
    PrijemnicaDetailes pd;
    private static int height = 40;
    int departmentID;
    String redniBroj;
    double vatValue = 0.0;
    ArrayList<Product> productList;
    AutoCompleteCBWithoutProducts<Object> comboBoxListener;
    Product selectedProduct;

    public Product getProductIndex() {
        if (this.comboBoxListener.isItemSelected() < 0) {
            return null;
        }
        return (Product)this.cbArtikal.getItems().get(this.comboBoxListener.isItemSelected());
    }

    public ComboBox<Product> getCbArtikal() {
        return this.cbArtikal;
    }

    public void setProduct(Product p) {
        this.cbArtikal.getItems().add((Object)p);
        this.cbArtikal.getSelectionModel().select((Object)p);
    }

    public void setQuantity(double quatity) {
        this.tfKolicina.setText(Settings.getNumberFormat((int)4, (boolean)true).format(quatity));
    }

    public TextField getTfKolicina() {
        return this.tfKolicina;
    }

    public void setUkupno(double ukupno) {
        this.tfUkupno.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ukupno));
    }

    public void setDiscount(double discount) {
        this.tfPopust.setText(Settings.getNumberFormat((int)2, (boolean)true).format(discount));
    }

    public void setPrice(double price) {
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(price));
    }

    public void setDocumentDetailes(long documentDetailesID) {
        this.pd.setDocumentDetailsID(documentDetailesID);
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.tfCenaSaPopustom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(priceWithDiscount));
    }

    public void setPriceWithPdv(double priceWithPdv) {
        this.tfUkupnaVrednostSaPdv.setText(Settings.getNumberFormat((int)2, (boolean)true).format(priceWithPdv));
    }

    public void setSellPrice(double sellPrice) {
        this.tfProdajnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sellPrice));
    }

    public void setMargin(double margin) {
        this.tfMarza.setText(Settings.getNumberFormat((int)2, (boolean)true).format(margin));
    }

    public void setPd(PrijemnicaDetailes pd) {
        this.pd = pd;
    }

    public TextField getTfMarza() {
        return this.tfMarza;
    }

    public Button getBtnDelete() {
        return this.btnDelete;
    }

    public ItemPrijemnicaDetalji(ScreensController controller, int departmentID) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        nf.setGroupingUsed(true);
        this.departmentID = departmentID;
        this.pd = new PrijemnicaDetailes();
        this.pd.setProductCode("");
        this.pd.setProductName("");
        this.pd.setQuantity(0.0);
        this.pd.setPrice(0.0);
        this.pd.setDiscount(0.0);
        this.pd.setPriceWithDiscount(0.0);
        this.pd.setNewSellPrice(0.0);
        this.pd.setMargin(0.0);
        this.controller = controller;
        this.lRb.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.lRb.setAlignment(Pos.CENTER);
        this.lRb.setMinWidth(40.0);
        this.lRb.setPrefWidth(40.0);
        this.lRb.setMaxWidth(60.0);
        this.cbArtikal.setMinWidth(300.0);
        this.cbArtikal.setPrefWidth(300.0);
        this.cbArtikal.setMaxWidth(300.0);
        this.cbArtikal.setEditable(true);
        this.comboBoxListener = new AutoCompleteCBWithoutProducts(this.cbArtikal, controller, departmentID, ScreensController.FILTER_ALL, this.tfKolicina);
        this.cbArtikal.valueProperty().addListener((ov, oldValue, newValue) -> {
            this.selectedProduct = (Product)this.cbArtikal.getSelectionModel().getSelectedItem();
            this.tfPdv.setText(this.selectedProduct.getVatName());
            this.vatValue = this.selectedProduct.getVatValue();
            this.selectedProduct.getCurrentPrice((long)departmentID, controller.getSettings().getConnection());
            this.selectedProduct.getNabavnaCena(controller.getSettings().getConnection());
            this.tfProdajnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.selectedProduct.getPrice()));
            this.tfMarza.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPriceWithDiscount() > 0.0 ? this.selectedProduct.getPrice() / this.pd.getPriceWithDiscount() * 100.0 : this.selectedProduct.getPrice() / this.selectedProduct.getNabavnaCena() * 100.0));
            this.pd.setProductID(this.selectedProduct.getProductID());
            this.pd.setProductCode(this.selectedProduct.getCode());
            this.pd.setProductName(this.selectedProduct.getName());
            this.pd.setNewSellPrice(this.selectedProduct.getPrice());
            this.pd.setMargin(this.pd.getPriceWithDiscount() > 0.0 ? this.selectedProduct.getPrice() / this.pd.getPriceWithDiscount() * 100.0 : this.selectedProduct.getPrice() / this.selectedProduct.getNabavnaCena() * 100.0);
            this.pd.setPurchasePrice(this.selectedProduct.getNabavnaCena());
        });
        this.cbArtikal.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                    ItemPrijemnicaDetalji.this.tfKolicina.requestFocus();
                }
            }
        });
        this.tfKolicina.setMinWidth(80.0);
        this.tfKolicina.setPrefWidth(80.0);
        this.tfKolicina.setMaxWidth(Double.MAX_VALUE);
        this.tfKolicina.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfKolicina.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getQuantity()));
        this.tfKolicina.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.BACK_SPACE) && ItemPrijemnicaDetalji.this.tfKolicina.getText().equals("")) {
                    event.consume();
                    ItemPrijemnicaDetalji.this.cbArtikal.requestFocus();
                }
            }
        });
        this.tfKolicina.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    ItemPrijemnicaDetalji.this.tfKolicina.setText(Settings.getNumberFormat((int)4, (boolean)true).format(ItemPrijemnicaDetalji.this.pd.getQuantity()) + "");
                }
            }
        });
        this.tfKolicina.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ItemPrijemnicaDetalji.this.izracunajUkupno();
                try {
                    if (newValue.length() > 0) {
                        if (newValue.substring(newValue.length() - 1).equals(".")) {
                            ItemPrijemnicaDetalji.this.tfKolicina.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                        }
                        if (ItemPrijemnicaDetalji.this.tfKolicina.isFocused()) {
                            ItemPrijemnicaDetalji.this.pd.setQuantity(Settings.getNumberFormat((int)8, (boolean)true).parse(newValue).doubleValue());
                        }
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCena.setMaxWidth(Double.MAX_VALUE);
        this.tfNabavnaCena.setMinWidth(80.0);
        this.tfNabavnaCena.setPrefWidth(80.0);
        this.tfNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPrice()));
        this.tfNabavnaCena.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.BACK_SPACE) && ItemPrijemnicaDetalji.this.tfNabavnaCena.getText().equals("")) {
                    event.consume();
                    ItemPrijemnicaDetalji.this.tfKolicina.requestFocus();
                }
            }
        });
        this.tfNabavnaCena.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    try {
                        ItemPrijemnicaDetalji.this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ItemPrijemnicaDetalji.this.pd.getPrice() / ItemPrijemnicaDetalji.this.vatValue) + "");
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.tfNabavnaCena.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ItemPrijemnicaDetalji.this.izracunajUkupno();
                try {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        ItemPrijemnicaDetalji.this.tfNabavnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (ItemPrijemnicaDetalji.this.tfNabavnaCena.isFocused()) {
                        ItemPrijemnicaDetalji.this.pd.setPrice(Settings.getNumberFormat((int)5, (boolean)true).parse(newValue).doubleValue() * ItemPrijemnicaDetalji.this.vatValue);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupno.setMaxWidth(Double.MAX_VALUE);
        this.tfUkupno.setMinWidth(90.0);
        this.tfUkupno.setPrefWidth(90.0);
        this.tfUkupno.setEditable(false);
        this.tfUkupno.setFocusTraversable(false);
        this.tfPopust.setMaxWidth(Double.MAX_VALUE);
        this.tfPopust.setMinWidth(40.0);
        this.tfPopust.setPrefWidth(40.0);
        this.tfPopust.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfPopust.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getDiscount()));
        this.tfPopust.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.TAB)) {
                    ke.consume();
                    ItemPrijemnicaDetalji.this.tfProdajnaCena.requestFocus();
                }
            }
        });
        this.tfPopust.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    try {
                        ItemPrijemnicaDetalji.this.tfPopust.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ItemPrijemnicaDetalji.this.pd.getDiscount()) + "");
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.tfPopust.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ItemPrijemnicaDetalji.this.izracunajUkupno();
                try {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        ItemPrijemnicaDetalji.this.tfPopust.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (ItemPrijemnicaDetalji.this.tfPopust.isFocused()) {
                        ItemPrijemnicaDetalji.this.pd.setDiscount(Settings.getNumberFormat((int)3, (boolean)true).parse(newValue).doubleValue());
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfCenaSaPopustom.setMaxWidth(Double.MAX_VALUE);
        this.tfCenaSaPopustom.setMinWidth(90.0);
        this.tfCenaSaPopustom.setPrefWidth(90.0);
        this.tfCenaSaPopustom.setEditable(false);
        this.tfCenaSaPopustom.setFocusTraversable(false);
        this.tfPdv.setMaxWidth(Double.MAX_VALUE);
        this.tfPdv.setMinWidth(40.0);
        this.tfPdv.setPrefWidth(40.0);
        this.tfPdv.setEditable(false);
        this.tfPdv.setFocusTraversable(false);
        this.tfPdv.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ItemPrijemnicaDetalji.this.izracunajUkupno();
            }
        });
        this.tfUkupnaVrednostSaPdv.setMaxWidth(Double.MAX_VALUE);
        this.tfUkupnaVrednostSaPdv.setMinWidth(70.0);
        this.tfUkupnaVrednostSaPdv.setPrefWidth(70.0);
        this.tfUkupnaVrednostSaPdv.setFocusTraversable(false);
        this.tfUkupnaVrednostSaPdv.setEditable(false);
        this.tfProdajnaCena.setMaxWidth(Double.MAX_VALUE);
        this.tfProdajnaCena.setMinWidth(40.0);
        this.tfProdajnaCena.setPrefWidth(40.0);
        this.tfProdajnaCena.setFocusTraversable(false);
        this.tfProdajnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfProdajnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getNewSellPrice()));
        this.tfProdajnaCena.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.TAB)) {
                    ke.consume();
                    ItemPrijemnicaDetalji.this.tfMarza.requestFocus();
                }
            }
        });
        this.tfProdajnaCena.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        ItemPrijemnicaDetalji.this.tfProdajnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (ItemPrijemnicaDetalji.this.tfProdajnaCena.isFocused()) {
                        ItemPrijemnicaDetalji.this.pd.setNewSellPrice(Settings.getNumberFormat((int)2, (boolean)true).parse(newValue).doubleValue());
                        ItemPrijemnicaDetalji.this.izracunajMarzu();
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfProdajnaCena.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    try {
                        ItemPrijemnicaDetalji.this.tfProdajnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ItemPrijemnicaDetalji.this.pd.getNewSellPrice()) + "");
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.tfMarza.setMaxWidth(Double.MAX_VALUE);
        this.tfMarza.setMinWidth(40.0);
        this.tfMarza.setPrefWidth(40.0);
        this.tfMarza.setFocusTraversable(false);
        this.tfMarza.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        ItemPrijemnicaDetalji.this.tfMarza.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (ItemPrijemnicaDetalji.this.tfMarza.isFocused()) {
                        ItemPrijemnicaDetalji.this.pd.setMargin(Settings.getNumberFormat((int)2, (boolean)true).parse(newValue).doubleValue());
                        ItemPrijemnicaDetalji.this.izracunajProdajnuCenu();
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfMarza.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    try {
                        ItemPrijemnicaDetalji.this.tfMarza.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ItemPrijemnicaDetalji.this.pd.getMargin()) + "");
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.btnDelete.setMaxWidth(Double.MAX_VALUE);
        this.btnDelete.setMinWidth(30.0);
        this.btnDelete.setPrefWidth(30.0);
        this.btnDelete.setText("-");
        this.btnDelete.setFocusTraversable(false);
        this.setStyle("-fx-background: transparent;");
        this.setMinHeight(height + 5);
        this.setPrefHeight(height + 5);
        this.setMaxHeight(height + 5);
        ColumnConstraints rb = new ColumnConstraints((double)this.rbWidth, (double)this.rbWidth, (double)this.rbWidth);
        rb.setHalignment(HPos.CENTER);
        rb.setHgrow(Priority.ALWAYS);
        ColumnConstraints proizvod = new ColumnConstraints((double)this.proizvodWidth, (double)this.proizvodWidth, Double.MAX_VALUE);
        proizvod.setHgrow(Priority.ALWAYS);
        ColumnConstraints kolicinaJM = new ColumnConstraints((double)this.kolicinaJMWidth, (double)this.kolicinaJMWidth, Double.MAX_VALUE);
        kolicinaJM.setHgrow(Priority.ALWAYS);
        ColumnConstraints nabavnaCena = new ColumnConstraints((double)this.nabavnaCenaWidth, (double)this.nabavnaCenaWidth, Double.MAX_VALUE);
        nabavnaCena.setHgrow(Priority.ALWAYS);
        ColumnConstraints ukupno = new ColumnConstraints((double)this.ukupnoWidth, (double)this.ukupnoWidth, Double.MAX_VALUE);
        ukupno.setHgrow(Priority.ALWAYS);
        ColumnConstraints popust = new ColumnConstraints((double)this.popustWidth, (double)this.popustWidth, Double.MAX_VALUE);
        popust.setHgrow(Priority.ALWAYS);
        ColumnConstraints nabavnaCenaSaPopustom = new ColumnConstraints((double)this.nabavnaCenaSaPopustomWidth, (double)this.nabavnaCenaSaPopustomWidth, Double.MAX_VALUE);
        nabavnaCenaSaPopustom.setHgrow(Priority.ALWAYS);
        ColumnConstraints pdv = new ColumnConstraints((double)this.pdvWidth, (double)this.pdvWidth, Double.MAX_VALUE);
        pdv.setHgrow(Priority.ALWAYS);
        ColumnConstraints ukupnaVrednostSaPdv = new ColumnConstraints((double)this.ukupnaVrednostSaPdvWidth, (double)this.ukupnaVrednostSaPdvWidth, Double.MAX_VALUE);
        ukupnaVrednostSaPdv.setHgrow(Priority.ALWAYS);
        ColumnConstraints prodajnaCena = new ColumnConstraints((double)this.prodajnaCenaWidth, (double)this.prodajnaCenaWidth, Double.MAX_VALUE);
        prodajnaCena.setHgrow(Priority.ALWAYS);
        ColumnConstraints marza = new ColumnConstraints((double)this.marzaWidth, (double)this.marzaWidth, Double.MAX_VALUE);
        marza.setHgrow(Priority.ALWAYS);
        ColumnConstraints delete = new ColumnConstraints((double)this.deleteWidth, (double)this.deleteWidth, Double.MAX_VALUE);
        delete.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{rb, proizvod, kolicinaJM, nabavnaCena, ukupno, popust, nabavnaCenaSaPopustom, pdv, ukupnaVrednostSaPdv, prodajnaCena, marza, delete});
        RowConstraints row1 = new RowConstraints((double)(height - 1), (double)(height - 1), (double)(height - 1));
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        this.add((Node)this.lRb, 0, 0);
        this.add((Node)this.cbArtikal, 1, 0);
        this.add((Node)this.tfKolicina, 2, 0);
        this.add((Node)this.tfNabavnaCena, 3, 0);
        this.add((Node)this.tfUkupno, 4, 0);
        this.add((Node)this.tfPopust, 5, 0);
        this.add((Node)this.tfCenaSaPopustom, 6, 0);
        this.add((Node)this.tfPdv, 7, 0);
        this.add((Node)this.tfUkupnaVrednostSaPdv, 8, 0);
        this.add((Node)this.tfProdajnaCena, 9, 0);
        this.add((Node)this.tfMarza, 10, 0);
        this.add((Node)this.btnDelete, 11, 0);
    }

    private void izracunajUkupno() {
        double ukupnoBezPdvIPopusta = this.pd.getQuantity() * this.pd.getPrice() / this.vatValue;
        double ukupnoSaPopustom = ukupnoBezPdvIPopusta - ukupnoBezPdvIPopusta * this.pd.getDiscount() / 100.0;
        double ukupnoSaPdv = ukupnoSaPopustom * this.vatValue;
        double marza = this.pd.getNewSellPrice() / (ukupnoSaPdv / this.pd.getQuantity()) * 100.0;
        this.pd.setPriceWithDiscount(ukupnoSaPdv / this.pd.getQuantity());
        this.pd.setMargin(marza);
        this.tfUkupno.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ukupnoBezPdvIPopusta));
        this.tfCenaSaPopustom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPriceWithDiscount() * this.pd.getQuantity() / this.vatValue));
        this.tfUkupnaVrednostSaPdv.setText(Settings.getNumberFormat((int)2, (boolean)true).format(ukupnoSaPdv));
        this.tfMarza.setText("" + Settings.getNumberFormat((int)2, (boolean)true).format(marza));
    }

    private void izracunajProdajnuCenu() {
        this.pd.setNewSellPrice(this.pd.getPriceWithDiscount() / 100.0 * this.pd.getMargin() + this.pd.getPriceWithDiscount());
        this.tfProdajnaCena.setText("" + Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPriceWithDiscount() / 100.0 * this.pd.getMargin() + this.pd.getPriceWithDiscount()));
    }

    private void izracunajMarzu() {
        this.pd.setMargin(this.pd.getNewSellPrice() / this.pd.getPriceWithDiscount() * 100.0 - 100.0);
        this.tfMarza.setText("" + Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getNewSellPrice() / this.pd.getPriceWithDiscount() * 100.0 - 100.0));
    }

    public PrijemnicaDetailes getPd() {
        return this.pd;
    }

    public String getRedniBroj() {
        return this.redniBroj;
    }

    public void setRedniBroj(String redniBroj) {
        this.lRb.setText(redniBroj);
        this.redniBroj = redniBroj;
    }

    public void refresh() {
        Product p = Product.getByID((long)this.pd.getProductID(), (ScreensController)this.controller);
        if (p != null) {
            double margin = this.pd.getMargin();
            double sellPrice = this.pd.getNewSellPrice();
            this.setProduct(p);
            this.setQuantity(this.pd.getQuantity());
            this.setPrice(this.pd.getPrice() / p.getVatValue());
            this.setDiscount(this.pd.getDiscount());
            this.setPriceWithDiscount((this.pd.getPrice() * this.pd.getQuantity() - this.pd.getPrice() * this.pd.getQuantity() * this.pd.getDiscount() / 100.0) / p.getVatValue());
            this.setPriceWithPdv(this.pd.getPriceWithDiscount() * this.pd.getQuantity());
            if (this.pd.getDocumentDetailsID() <= 0L) {
                this.pd.setMargin(margin);
                this.pd.setNewSellPrice(sellPrice);
                this.setSellPrice(sellPrice);
                this.setMargin(margin);
            }
            this.setDocumentDetailes(this.pd.getDocumentDetailsID());
        } else {
            this.setQuantity(this.pd.getQuantity());
            this.setPrice(this.pd.getPrice());
            this.setDiscount(this.pd.getDiscount());
            this.setPriceWithDiscount(this.pd.getPriceWithDiscount());
        }
    }

    public void insertProductIntoComboBox() {
        this.productList = Product.getListByDepartment((int)this.departmentID, (Connection)this.controller.getSettings().getConnection());
        this.cbArtikal.setItems(FXCollections.observableArrayList(this.productList));
    }
}

