/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class FxUtil {
    public static <T> void autoCompleteComboBoxPlus(final ComboBox<T> comboBox, final AutoCompleteComparator<T> comparatorMethod) {
        final ObservableList data = comboBox.getItems();
        comboBox.setEditable(true);
        comboBox.getEditor().focusedProperty().addListener(observable -> {
            if (comboBox.getSelectionModel().getSelectedIndex() < 0) {
                comboBox.getEditor().setText("");
            }
        });
        comboBox.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){
            private boolean moveCaretToPos = false;
            private int caretPos;

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.UP) {
                    this.caretPos = -1;
                    if (comboBox.getEditor().getText() != null) {
                        this.moveCaret(comboBox.getEditor().getText().length());
                    }
                    return;
                }
                if (event.getCode() == KeyCode.DOWN) {
                    if (!comboBox.isShowing()) {
                        comboBox.show();
                    }
                    this.caretPos = -1;
                    if (comboBox.getEditor().getText() != null) {
                        this.moveCaret(comboBox.getEditor().getText().length());
                    }
                    return;
                }
                if (event.getCode() == KeyCode.BACK_SPACE) {
                    if (comboBox.getEditor().getText() != null) {
                        this.moveCaretToPos = true;
                        this.caretPos = comboBox.getEditor().getCaretPosition();
                    }
                } else if (event.getCode() == KeyCode.DELETE) {
                    if (comboBox.getEditor().getText() != null) {
                        this.moveCaretToPos = true;
                        this.caretPos = comboBox.getEditor().getCaretPosition();
                    }
                } else if (event.getCode() == KeyCode.ENTER) {
                    return;
                }
                if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.getCode().equals((Object)KeyCode.SHIFT) || event.getCode().equals((Object)KeyCode.CONTROL) || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
                    return;
                }
                ObservableList list = FXCollections.observableArrayList();
                for (Object aData : data) {
                    if (aData == null || comboBox.getEditor().getText() == null || !comparatorMethod.matches(comboBox.getEditor().getText(), aData)) continue;
                    list.add(aData);
                }
                String t = "";
                if (comboBox.getEditor().getText() != null) {
                    t = comboBox.getEditor().getText();
                }
                comboBox.setItems(list);
                comboBox.getEditor().setText(t);
                if (!this.moveCaretToPos) {
                    this.caretPos = -1;
                }
                this.moveCaret(t.length());
                if (!list.isEmpty()) {
                    comboBox.show();
                }
            }

            private void moveCaret(int textLength) {
                if (this.caretPos == -1) {
                    comboBox.getEditor().positionCaret(textLength);
                } else {
                    comboBox.getEditor().positionCaret(this.caretPos);
                }
                this.moveCaretToPos = false;
            }
        });
    }

    public static <T> List<T> getComboBoxValue(ComboBox<T> comboBox) {
        if (comboBox.getSelectionModel().getSelectedIndex() < 0) {
            return null;
        }
        return comboBox.getItems();
    }

    public static <T> ComboBox<T> getComboBox(ComboBox<T> comboBox) {
        return comboBox;
    }

    public static interface AutoCompleteComparator<T> {
        public boolean matches(String var1, T var2);
    }
}

