/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.sql.Connection;
import java.util.Collection;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.IndexedCheckModel;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.PropertyEditor;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Person;

public class CustomPropertyEditorFactory
implements Callback<PropertySheet.Item, PropertyEditor<?>> {
    ScreensController contriller;

    public ScreensController getContriller() {
        return this.contriller;
    }

    public void setContriller(ScreensController contriller) {
        this.contriller = contriller;
    }

    public PropertyEditor<?> call(PropertySheet.Item item) {
        Class type = item.getType();
        if (type == String.class) {
            return this.createTextEditor(item);
        }
        if (type != null && type == ObservableList.class) {
            return this.createCheckComboBoxEditor(item, (Collection)Person.getListByCategory((boolean)true, (Connection)this.contriller.getSettings().getConnection()));
        }
        return null;
    }

    public final PropertyEditor<?> createTextEditor(PropertySheet.Item property) {
        return new AbstractPropertyEditor<String, TextField>(property, new TextField()){

            protected StringProperty getObservableValue() {
                return ((TextField)this.getEditor()).textProperty();
            }

            public void setValue(String value) {
                ((TextField)this.getEditor()).setText(value);
            }
        };
    }

    public final <T> PropertyEditor<?> createCheckComboBoxEditor(PropertySheet.Item property, final Collection<T> choices) {
        return new AbstractPropertyEditor<ObservableList<T>, CheckComboBox<T>>(property, new CheckComboBox()){
            private ListProperty<T> list;
            {
                super(x0, (Node)x1);
                ((CheckComboBox)this.getEditor()).getItems().setAll(choices);
            }

            protected ListProperty<T> getObservableValue() {
                if (this.list == null) {
                    this.list = new SimpleListProperty(((CheckComboBox)this.getEditor()).getCheckModel().getCheckedItems());
                }
                return this.list;
            }

            public void setValue(ObservableList<T> checked) {
                checked.forEach(arg_0 -> ((IndexedCheckModel)((CheckComboBox)this.getEditor()).getCheckModel()).check(arg_0));
            }
        };
    }
}

