/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import rs.petcom.backoffice.gui.HeaderPrijemnicaDetalji;
import rs.petcom.backoffice.gui.ItemPrijemnicaDetalji;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.PrijemnicaDetailes;

public class BorderPanePrijemnicaDetalji
extends BorderPane {
    private static AnchorPane anchorPane = new AnchorPane();
    public static ScrollPane scrollPane = new ScrollPane();
    private static HeaderPrijemnicaDetalji header = new HeaderPrijemnicaDetalji();
    private ArrayList<ItemPrijemnicaDetalji> items = new ArrayList();
    private ArrayList<ItemPrijemnicaDetalji> deletedItems = new ArrayList();
    ScreensController controller;
    private ArrayList<PrijemnicaDetailes> prijemnicaDetalji;
    private int departmentID;

    public BorderPanePrijemnicaDetalji(ScreensController controller, ArrayList<PrijemnicaDetailes> prijemniceDetalji, int departmentID) {
        this.prijemnicaDetalji = prijemniceDetalji;
        this.controller = controller;
        this.departmentID = departmentID;
        this.setTop((Node)header);
        this.setCenter((Node)scrollPane);
        scrollPane.setContent((Node)anchorPane);
        scrollPane.setStyle("-fx-background-color: transparent;");
        anchorPane.setStyle("-fx-background-color: transparent;");
        this.setStyle("-fx-background-color: transparent;");
        if (prijemniceDetalji.isEmpty()) {
            this.items.add(new ItemPrijemnicaDetalji(controller, departmentID));
        } else {
            this.populateList(prijemniceDetalji, controller);
        }
        this.refresh();
    }

    public void refresh() {
        anchorPane.getChildren().clear();
        double offset = 0.0;
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setRedniBroj(i + 1 + ".");
            AnchorPane.setTopAnchor((Node)((Node)this.items.get(i)), (Double)offset);
            AnchorPane.setLeftAnchor((Node)((Node)this.items.get(i)), (Double)0.0);
            AnchorPane.setRightAnchor((Node)((Node)this.items.get(i)), (Double)0.0);
            this.items.get(i).refresh();
            this.items.get(i).getTfMarza().setOnKeyPressed(keyEvent -> {
                if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                    this.items.add(new ItemPrijemnicaDetalji(this.controller, this.departmentID));
                    this.refresh();
                    this.items.get(this.items.size() - 1).getCbArtikal().requestFocus();
                }
            });
            offset += 50.0;
            anchorPane.getChildren().add((Object)this.items.get(i));
        }
        Timer closinTimer = new Timer();
        closinTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                scrollPane.setVvalue(scrollPane.getVmax());
            }
        }, 100L);
    }

    public void refreshProducts() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).insertProductIntoComboBox();
        }
        this.refresh();
    }

    public void setPaneWidth(double width) {
        anchorPane.setPrefWidth(width - 20.0);
    }

    public ArrayList<ItemPrijemnicaDetalji> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<ItemPrijemnicaDetalji> items) {
        this.items = items;
    }

    public void deleteItem(ItemPrijemnicaDetalji item) {
        this.deletedItems.add(item);
        this.items.remove((Object)item);
    }

    public ArrayList<ItemPrijemnicaDetalji> getDeletedItems() {
        return this.deletedItems;
    }

    public void populateList(ArrayList<PrijemnicaDetailes> prijemniceDetalji, ScreensController controller) {
        for (int i = 0; i < prijemniceDetalji.size(); ++i) {
            ItemPrijemnicaDetalji item = new ItemPrijemnicaDetalji(controller, this.departmentID);
            item.setPd(prijemniceDetalji.get(i));
            item.refresh();
            this.items.add(item);
        }
        this.refresh();
    }

    public int getComboBoxInFocus() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).getCbArtikal().isFocused()) continue;
            return i;
        }
        return -1;
    }

    public double getSum() {
        double sum = 0.0;
        for (int i = 0; i < this.items.size(); ++i) {
            sum += this.items.get(i).getPd().getPrice() * this.items.get(i).getPd().getQuantity();
        }
        return sum;
    }

    public double getSumWithDiscount() {
        double sum = 0.0;
        for (int i = 0; i < this.items.size(); ++i) {
            sum += this.items.get(i).getPd().getPriceWithDiscount() * this.items.get(i).getPd().getQuantity();
        }
        return sum;
    }
}

