/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.Product;

public class AutoCompleteComboBoxListenerPopis<T>
implements EventHandler<KeyEvent> {
    private ComboBox comboBox;
    private ObservableList<T> data;
    private boolean moveCaretToPos = false;
    private int caretPos;
    private int cbType;
    private TextField tfKolicina;

    public AutoCompleteComboBoxListenerPopis(ComboBox comboBox, TextField tfKolicina, int cbType) {
        this.cbType = cbType;
        this.tfKolicina = tfKolicina;
        this.comboBox = comboBox;
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyReleased((EventHandler)this);
        this.setStringConverter();
        this.setCellFactoryUpdateItem();
        if (cbType != ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF) {
            this.setEventFilter();
        }
        this.setTextPropertyListener();
    }

    public void getFocus() {
        this.comboBox.requestFocus();
    }

    public void handle(KeyEvent event) {
        ObservableList list = FXCollections.observableArrayList();
        if (event.getCode() == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            if (!this.comboBox.isShowing()) {
                this.comboBox.show();
            }
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.ENTER) {
            return;
        }
        if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
            return;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            Product p = (Product)this.data.get(i);
            if (this.cbType == ScreensController.COMBOBOX_BARCODE && p.getBarcodeLast().toLowerCase().equals(this.comboBox.getEditor().getText().toLowerCase())) {
                list.add(this.data.get(i));
            }
            if (this.cbType == ScreensController.COMBOBOX_CODE && p.getCode().toLowerCase().equals(this.comboBox.getEditor().getText().toLowerCase())) {
                list.add(this.data.get(i));
            }
            if (this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE && (p.getCode() + " " + p.getName()).toLowerCase().contains(this.comboBox.getEditor().getText().toLowerCase())) {
                list.add(this.data.get(i));
            }
            if (this.cbType != ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE && this.cbType != ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF || !(p.getCode() + " " + p.getName() + " " + p.getBarcodeLast()).toLowerCase().contains(this.comboBox.getEditor().getText().toLowerCase())) continue;
            list.add(this.data.get(i));
        }
        String t = this.comboBox.getEditor().getText();
        this.comboBox.setItems(list);
        this.comboBox.getEditor().setText(t);
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(t.length());
        if (!list.isEmpty()) {
            this.comboBox.show();
        }
    }

    public void locateSelected() {
        for (int i = 0; i < this.data.size(); ++i) {
            Product p;
            if (this.cbType == ScreensController.COMBOBOX_BARCODE && (p = (Product)this.data.get(i)).getBarcodeLast().toLowerCase().startsWith(this.comboBox.getEditor().getText().toLowerCase())) {
                this.comboBox.getSelectionModel().select((Object)p);
            }
            if (this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE && (p = (Product)this.data.get(i)).toString().toLowerCase().contains(this.comboBox.getEditor().getText().toLowerCase())) {
                this.comboBox.getSelectionModel().select((Object)p);
            }
            if (this.cbType != ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE && this.cbType != ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF || !(p = (Product)this.data.get(i)).toString().toLowerCase().contains(this.comboBox.getEditor().getText().toLowerCase())) continue;
            this.comboBox.getSelectionModel().select((Object)p);
        }
    }

    public int isItemSelected() {
        ObservableList<T> products;
        String comboBoxText = this.comboBox.getEditor().getText().toLowerCase();
        if (this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE) {
            ObservableList<T> products2 = this.data;
            for (Product p : products2) {
                if (!(p.getCode() + " " + p.getName()).toLowerCase().equals(comboBoxText)) continue;
                return products2.indexOf((Object)p);
            }
            return -1;
        }
        if (this.cbType == ScreensController.COMBOBOX_BARCODE) {
            products = this.data;
            for (Product p : products) {
                if (!p.getBarcodeLast().equals(comboBoxText)) continue;
                return products.indexOf((Object)p);
            }
        }
        if (this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE || this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF) {
            products = this.data;
            for (Product p : products) {
                if (!(p.getCode() + " " + p.getName() + " " + p.getBarcodeLast()).toLowerCase().equals(comboBoxText)) continue;
                return products.indexOf((Object)p);
            }
            return -1;
        }
        return -1;
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.comboBox.getEditor().positionCaret(textLength);
        } else {
            this.comboBox.getEditor().positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }

    public void setStringConverter() {
        this.comboBox.setConverter((StringConverter)new StringConverter<Product>(){

            public String toString(Product object) {
                if (object == null) {
                    return "";
                }
                String p = "";
                if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE) {
                    p = object.getCode() + " " + object.getName();
                }
                if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_BARCODE) {
                    p = object.getBarcodeLast();
                }
                if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE || AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF) {
                    p = object.getCode() + " " + object.getName() + " " + object.getBarcodeLast();
                }
                if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_CODE) {
                    p = object.getCode();
                }
                return p;
            }

            public Product fromString(String string) {
                Product p = null;
                ArrayList productList = new ArrayList(AutoCompleteComboBoxListenerPopis.this.comboBox.getItems());
                for (int i = 0; i < productList.size(); ++i) {
                    if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE && (((Product)productList.get(i)).getCode() + " " + ((Product)productList.get(i)).getName()).toLowerCase().equals(string.toLowerCase())) {
                        p = (Product)productList.get(i);
                    }
                    if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_BARCODE && ((Product)productList.get(i)).getBarcodeLast().toLowerCase().equals(string.toLowerCase())) {
                        p = (Product)productList.get(i);
                    }
                    if ((AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE || AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF) && (((Product)productList.get(i)).getCode() + " " + ((Product)productList.get(i)).getName() + " " + ((Product)productList.get(i)).getBarcodeLast()).toLowerCase().equals(string.toLowerCase())) {
                        p = (Product)productList.get(i);
                    }
                    if (AutoCompleteComboBoxListenerPopis.this.cbType != ScreensController.COMBOBOX_CODE || !((Product)productList.get(i)).getCode().toLowerCase().equals(string.toLowerCase())) continue;
                    p = (Product)productList.get(i);
                }
                return p;
            }
        });
    }

    public void setCellFactoryUpdateItem() {
        this.comboBox.setCellFactory((Callback)new Callback<ListView<Product>, ListCell<Product>>(){

            public ListCell<Product> call(ListView<Product> param) {
                ListCell<Product> cell = new ListCell<Product>(){

                    public void updateItem(Product item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE) {
                                this.setText(item.getCode() + " " + item.getName());
                            }
                            if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_BARCODE) {
                                this.setText(item.getBarcodeLast());
                            }
                            if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE || AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE_WITHOUT_TF) {
                                this.setText(item.getCode() + " " + item.getName() + " " + item.getBarcodeLast());
                            }
                            if (AutoCompleteComboBoxListenerPopis.this.cbType == ScreensController.COMBOBOX_CODE) {
                                this.setText(item.getCode());
                            }
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
    }

    public void setEventFilter() {
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
                this.tfKolicina.requestFocus();
            }
        });
    }

    public void setTextPropertyListener() {
        this.comboBox.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                AutoCompleteComboBoxListenerPopis.this.loadProducts(newValue);
            }
        });
    }

    public void loadProducts(String cbText) {
    }
}

