/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.gui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.product.Product;

public class AutoCompleteCBWithoutProductsBuyers<T>
implements EventHandler<KeyEvent> {
    private ComboBox comboBox;
    private ObservableList<Product> data;
    private boolean moveCaretToPos = false;
    private boolean loadAllProduct = false;
    private int caretPos;
    private ScreensController controller;
    private int department;
    private String filterType;
    public TextField tfQunatity;
    ObservableList<BuyerOfferPriceDetailes> tableList;

    public AutoCompleteCBWithoutProductsBuyers(ComboBox comboBox, ScreensController controller, int departmentID, String filterType, TextField tfQunatity, ObservableList<BuyerOfferPriceDetailes> tableList) {
        this.comboBox = comboBox;
        this.controller = controller;
        this.department = departmentID;
        this.filterType = filterType;
        this.tfQunatity = tfQunatity;
        this.tableList = tableList;
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyReleased((EventHandler)this);
        if (tfQunatity != null) {
            this.setEventFilter();
        }
        this.setStringConverter();
        this.setCellFactoryUpdateItem();
    }

    public AutoCompleteCBWithoutProductsBuyers(ComboBox comboBox, ScreensController controller, int departmentID, String filterType, TextField tfQunatity) {
        this.comboBox = comboBox;
        this.controller = controller;
        this.department = departmentID;
        this.filterType = filterType;
        this.tfQunatity = tfQunatity;
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyReleased((EventHandler)this);
        if (tfQunatity != null) {
            this.setEventFilter();
        }
        this.setStringConverter();
        this.setCellFactoryUpdateItem();
    }

    public void handle(KeyEvent event) {
        String filterText = this.comboBox.getEditor().getText();
        if (event.getCode().isLetterKey() || event.getCode().isDigitKey()) {
            this.data = this.getProductList(filterText);
        }
        if (event.getCode() == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            if (!this.comboBox.isShowing()) {
                this.comboBox.show();
            }
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.ENTER) {
            return;
        }
        if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
            return;
        }
        ObservableList list = FXCollections.observableArrayList();
        for (int i = 0; i < this.data.size(); ++i) {
            Product p = (Product)this.data.get(i);
            if ((p.getCode() + " " + p.getName() + " " + p.getBarcode()).toLowerCase().contains(filterText.toLowerCase())) {
                list.add(this.data.get(i));
            }
            if (i == 5) break;
        }
        String t = filterText;
        this.comboBox.setItems(list);
        ObservableList detailes = FXCollections.observableArrayList();
        try {
            for (BuyerOfferPriceDetailes opd : this.tableList) {
                detailes.add((Object)Product.getByID((long)opd.getProductID(), (ScreensController)this.controller));
            }
            for (BuyerOfferPriceDetailes opd : detailes) {
                if (!list.contains((Object)opd)) continue;
                list.remove((Object)opd);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.comboBox.getEditor().setText(t);
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(t.length());
        if (!list.isEmpty()) {
            this.comboBox.show();
        }
    }

    public void setEventFilter() {
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
                this.tfQunatity.requestFocus();
            }
        });
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.comboBox.getEditor().positionCaret(textLength);
        } else {
            this.comboBox.getEditor().positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }

    public int isItemSelected() {
        String comboBoxText = this.comboBox.getEditor().getText().toLowerCase();
        ObservableList<Product> products = this.data;
        for (Product p : products) {
            if (!(p.getCode() + " " + p.getName()).toLowerCase().equals(comboBoxText)) continue;
            return products.indexOf((Object)p);
        }
        return -1;
    }

    public void setStringConverter() {
        this.comboBox.setConverter((StringConverter)new StringConverter<Product>(){

            public String toString(Product object) {
                if (object == null) {
                    return "";
                }
                return (object.getCode() != null ? (object.getCode().equals("") ? "" : object.getCode()) : "") + " " + object.getName() + " " + (object.getBarcodeLast() != null ? (object.getBarcodeLast().equals("") ? "" : object.getBarcodeLast()) : "");
            }

            public Product fromString(String string) {
                Product p = null;
                ArrayList productList = new ArrayList(AutoCompleteCBWithoutProductsBuyers.this.comboBox.getItems());
                for (int i = 0; i < productList.size(); ++i) {
                    StringBuilder stringBuilder = new StringBuilder().append(((Product)productList.get(i)).getCode() != null ? (((Product)productList.get(i)).getCode().equals("") ? "" : ((Product)productList.get(i)).getCode()) : "").append(" ").append(((Product)productList.get(i)).getName()).append(" ");
                    String string2 = ((Product)productList.get(i)).getBarcodeLast() != null ? (((Product)productList.get(i)).getBarcodeLast().equals("") ? "" : ((Product)productList.get(i)).getBarcodeLast()) : "";
                    if (!stringBuilder.append(string2).toString().toLowerCase().contains(string.toLowerCase())) continue;
                    p = (Product)productList.get(i);
                }
                return p;
            }
        });
    }

    public void setCellFactoryUpdateItem() {
        this.comboBox.setCellFactory((Callback)new Callback<ListView<Product>, ListCell<Product>>(){

            public ListCell<Product> call(ListView<Product> param) {
                ListCell<Product> cell = new ListCell<Product>(){

                    public void updateItem(Product item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText((item.getCode() != null ? (item.getCode().equals("") ? "" : item.getCode()) : "") + " " + item.getName() + " " + (item.getBarcodeLast() != null ? (item.getBarcodeLast().equals("") ? "" : item.getBarcodeLast()) : ""));
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
    }

    public ObservableList<Product> getProductList(String cbText) {
        if (!this.isLoadAllProduct()) {
            this.comboBox.setItems(FXCollections.observableArrayList((Collection)Product.getListByDepartmentAndFilter((String)cbText, (int)this.department, (Connection)this.controller.getSettings().getConnection(), (String)this.filterType, (int)10)));
        } else {
            this.comboBox.setItems(FXCollections.observableArrayList((Collection)Product.getList((String)cbText, (String)this.filterType, (int)10, (Connection)this.controller.getSettings().getConnection())));
        }
        return this.comboBox.getItems();
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public void setLoadAllProduct(boolean loadAllProduct) {
        this.loadAllProduct = loadAllProduct;
    }

    public boolean isLoadAllProduct() {
        return this.loadAllProduct;
    }
}

