/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.StampaStikera;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.print.JRPrintPreviewPane;

public class StampaStikeraControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    Object sviObjekti = new Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    ObservableList<ProductDepartment> productDepartments;
    ObservableList<Product> products;
    ObservableList<Product> productsForPrint;
    ObservableList<Product> data;
    Task<ObservableList<Product>> taskLoadingProducts;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private ComboBox<String> cbFilterColumnNumber;
    @FXML
    private CheckBox cbWithoutBarCode;
    @FXML
    private TableView<Product> tableProducts;
    @FXML
    private TableView<Product> tableProductsPrint;
    @FXML
    private TableColumn<Product, String> tcCode;
    @FXML
    private TableColumn<Product, String> tcName;
    @FXML
    private TableColumn<Product, String> tcBarcode;
    @FXML
    private TableColumn<Product, String> tcCodePrint;
    @FXML
    private TableColumn<Product, String> tcNamePrint;
    @FXML
    private TableColumn<Product, String> tcBarcodePrint;
    @FXML
    private TableColumn<Product, String> tcNumOfStickers;
    @FXML
    private TableColumn<Product, Double> tcPrice;
    @FXML
    private TableColumn<Product, Double> tcPricePrint;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPrintAll;
    @FXML
    private Button btnPrintList;
    @FXML
    private Button btnPrintSmallList;
    @FXML
    private TextField tfFilter;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        }
        this.cbFilterType.getSelectionModel().select((java.lang.Object)ScreensController.FILTER_BARCODE);
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                StampaStikeraControllerTrgovina.this.loadProducts();
                StampaStikeraControllerTrgovina.this.data = StampaStikeraControllerTrgovina.this.tableProducts.getItems();
            }
        });
        EventHandler<KeyEvent> hendler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                StampaStikeraControllerTrgovina.this.loadProducts();
            }
        };
        this.cbFilterType.getSelectionModel().selectedItemProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$init$0((EventHandler)hendler, arg_0, arg_1, arg_2));
    }

    public void setParameter(java.lang.Object parameter) {
        this.tableProductsPrint.setEditable(true);
        this.tcNumOfStickers.setCellFactory(TextFieldTableCell.forTableColumn());
        this.dpDateFrom.setDisable(true);
        this.dpDateTo.setDisable(true);
        this.dpDateFrom.setValue((java.lang.Object)LocalDate.now());
        this.dpDateTo.setValue((java.lang.Object)LocalDate.now());
        this.dpDateFrom.setConverter(this.controller.getSettings().getDatePickerConverter());
        this.dpDateTo.setConverter(this.controller.getSettings().getDatePickerConverter());
        this.dpDateFrom.setOnAction(actionValue -> this.loadProducts());
        this.dpDateTo.setOnAction(actionValue -> this.loadProducts());
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbFilterType.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_BARCODE, ScreensController.FILTER_CODE, ScreensController.FILTER_NAZIV, ScreensController.FILTER_DATE_CHANGED_PRICE});
        this.cbFilterColumnNumber.getItems().addAll((java.lang.Object[])new String[]{"3x9 sa borderom", "4x10 bez bordera, #", "3x9 sa borderom1"});
        this.cbFilterColumnNumber.setValue((java.lang.Object)"3x9 sa borderom");
        this.cbFilterColumnNumber.setValue((java.lang.Object)"3x9 sa borderom1");
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                StampaStikeraControllerTrgovina.this.loadDepartment();
            }
        });
        this.productsForPrint = FXCollections.observableArrayList();
        this.tableProducts.getItems().clear();
        this.tableProducts.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Product>(){

            public void changed(ObservableValue<? extends Product> observable, Product oldValue, Product newValue) {
                StampaStikeraControllerTrgovina.this.tableProductsPrint.getSelectionModel().clearSelection();
            }
        });
        this.tableProducts.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.addProductForPrint();
                }
            });
            return row;
        });
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.tcCode.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcName.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.tcPrice.setStyle("-fx-alignment: CENTER-RIGHT;");
        this.tcPrice.setCellFactory((Callback)new Callback<TableColumn<Product, Double>, TableCell<Product, Double>>(){

            public TableCell<Product, Double> call(TableColumn<Product, Double> param) {
                return new TableCell<Product, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((java.lang.Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                        }
                    }
                };
            }
        });
        this.tcBarcode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.tcCodePrint.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.tcCodePrint.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcNumOfStickers.setCellValueFactory((Callback)new PropertyValueFactory("numOfStickers"));
        this.tcNumOfStickers.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcNamePrint.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcNamePrint.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcPricePrint.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.tcPricePrint.setStyle("-fx-alignment: CENTER-RIGHT;");
        this.tcPricePrint.setCellFactory((Callback)new Callback<TableColumn<Product, Double>, TableCell<Product, Double>>(){

            public TableCell<Product, Double> call(TableColumn<Product, Double> param) {
                return new TableCell<Product, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((java.lang.Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                        }
                    }
                };
            }
        });
        this.tcBarcodePrint.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.tcBarcodePrint.setVisible(false);
        this.tfFilter.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    StampaStikeraControllerTrgovina.this.loadProducts();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    StampaStikeraControllerTrgovina.this.tfFilter.setText("");
                }
            }
        });
    }

    @FXML
    public void actionPrint(final ActionEvent event) {
        final String reportFileName = ((String)this.cbFilterColumnNumber.getSelectionModel().getSelectedItem()).equals("3x9 sa borderom") ? (((Button)event.getSource()).getId().equals("btnPrintList") || ((Button)event.getSource()).getId().equals("btnPrintListPDF") ? (this.cbWithoutBarCode.isSelected() ? "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomaduBezBc1.jasper" : "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomadu.jasper") : (this.cbWithoutBarCode.isSelected() ? "rs/petcom/backoffice/jasper/stikeri/StikeriZaSveArtikleBezBc1.jasper" : "rs/petcom/backoffice/jasper/stikeri/StikeriZaSveArtikle.jasper")) : (((String)this.cbFilterColumnNumber.getSelectionModel().getSelectedItem()).equals("3x9 sa borderom1") ? (((Button)event.getSource()).getId().equals("btnPrintList") || ((Button)event.getSource()).getId().equals("btnPrintListPDF") ? (this.cbWithoutBarCode.isSelected() ? "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomaduBezBc.jasper" : "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomadu.jasper") : (this.cbWithoutBarCode.isSelected() ? "rs/petcom/backoffice/jasper/stikeri/StikeriZaSveArtikleBezBc.jasper" : "rs/petcom/backoffice/jasper/stikeri/StikeriZaSveArtikle.jasper")) : (((String)this.cbFilterColumnNumber.getSelectionModel().getSelectedItem()).equals("4x10 bez bordera") ? (((Button)event.getSource()).getId().equals("btnPrintList") || ((Button)event.getSource()).getId().equals("btnPrintListPDF") ? (this.cbWithoutBarCode.isSelected() ? "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomadu4x10BezBc.jasper" : "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomadu4x10.jasper") : (this.cbWithoutBarCode.isSelected() ? "rs/petcom/backoffice/jasper/stikeri/StikeriZaSveArtikleMaliBezBc.jasper" : "rs/petcom/backoffice/jasper/stikeri/StikeriZaSveArtikleMali.jasper")) : ""));
        final HashMap<String, java.lang.Object> hashMap = new HashMap<String, java.lang.Object>();
        try {
            hashMap.put("departmentId", ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            hashMap.put("preduzece", this.cbObject.getSelectionModel().getSelectedItem());
            System.out.println("cbObject.getSelectionModel().getSelectedItem().getName() " + ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getName());
            final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje stikera u toku.", this.rootPane.getScene().getWindow());
            Task<Void> creatingReport = new Task<Void>(){

                protected Void call() throws Exception {
                    try {
                        JasperPrint jprint;
                        StringBuffer pList = new StringBuffer("");
                        ObservableList printList = FXCollections.observableArrayList();
                        printList = ((String)StampaStikeraControllerTrgovina.this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_DATE_CHANGED_PRICE) ? StampaStikeraControllerTrgovina.this.tableProducts.getItems() : StampaStikeraControllerTrgovina.this.tableProductsPrint.getItems();
                        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)StampaStikeraControllerTrgovina.this.getListforPeaces((ObservableList<Product>)printList, 3));
                        for (int i = 0; i < printList.size(); ++i) {
                            pList.append(((Product)printList.get(i)).getProductID() + (i == printList.size() - 1 ? "" : ","));
                        }
                        hashMap.put("list", ((Button)event.getSource()).getId().equals("btnPrintList") || ((Button)event.getSource()).getId().equals("btnPrintListPDF") || (((Button)event.getSource()).getId().equals("btnPrintAll") || ((Button)event.getSource()).getId().equals("btnPrintAllPDF")) && ((String)StampaStikeraControllerTrgovina.this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_DATE_CHANGED_PRICE));
                        hashMap.put("productList", pList);
                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                        hashMap.put("REPORT_VIRTUALIZER", virtualizer);
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        if (((Button)event.getSource()).getId().equals("btnPrintList") || ((Button)event.getSource()).getId().equals("btnPrintListPDF")) {
                            hashMap.put("preduzece", ((Object)StampaStikeraControllerTrgovina.this.cbObject.getSelectionModel().getSelectedItem()).getName());
                            jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hashMap, (JRDataSource)beanColDataSource);
                        } else {
                            jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hashMap, (Connection)StampaStikeraControllerTrgovina.this.controller.getSettings().getConnection());
                        }
                        virtualizer.setReadOnly(true);
                        if (((Button)event.getSource()).getText().equals("PDF")) {
                            StampaStikeraControllerTrgovina.this.controller.printFileFromPDF(StampaStikeraControllerTrgovina.this.controller.getPdfFromJasper(jprint, "\u0160tampa stikera", "Stikeri"));
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    taskUpdateStage.hide();
                                }
                            });
                        } else {
                            JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
                            final HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
                            hm2.put("report", printViewPane);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    taskUpdateStage.hide();
                                    StampaStikeraControllerTrgovina.this.controller.showModalDialog("\u0160tampa stikera", ScreensController.DIALOG_PRINT_PREVIEW, hm2, StampaStikeraControllerTrgovina.this.rootPane.getScene().getWindow());
                                }
                            });
                        }
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            new Thread((Runnable)creatingReport).start();
            creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.controller.alert("Obave\u0161tenje", "Odaberite objekat i odeljenje: " + e.getMessage(), this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        if (this.tableProductsPrint.getSelectionModel().getSelectedItem() != null) {
            for (int i = 0; i < this.productsForPrint.size(); ++i) {
                if (((Product)this.productsForPrint.get(i)).getProductID() != ((Product)this.tableProductsPrint.getSelectionModel().getSelectedItem()).getProductID()) continue;
                this.productsForPrint.remove(i);
            }
            this.refresh();
        }
    }

    @FXML
    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadProducts() {
        this.tableProducts.getItems().clear();
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje artikala u toku.", this.rootPane.getScene().getWindow());
        this.taskLoadingProducts = new Task<ObservableList<Product>>(){

            protected ObservableList<Product> call() throws Exception {
                if (StampaStikeraControllerTrgovina.this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
                    StampaStikeraControllerTrgovina.this.products = ((String)StampaStikeraControllerTrgovina.this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_DATE_CHANGED_PRICE) ? Product.getListByChangedPrice((LocalDate)((LocalDate)StampaStikeraControllerTrgovina.this.dpDateFrom.getValue()), (LocalDate)((LocalDate)StampaStikeraControllerTrgovina.this.dpDateTo.getValue()), (String)StampaStikeraControllerTrgovina.this.tfFilter.getText(), (int)((Department)StampaStikeraControllerTrgovina.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (Connection)StampaStikeraControllerTrgovina.this.controller.getSettings().getConnection()) : FXCollections.observableArrayList((Collection)Product.getListByDepartmentAndFilter((String)StampaStikeraControllerTrgovina.this.tfFilter.getText(), (int)((Department)StampaStikeraControllerTrgovina.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (Connection)StampaStikeraControllerTrgovina.this.controller.getSettings().getConnection(), (String)((String)StampaStikeraControllerTrgovina.this.cbFilterType.getSelectionModel().getSelectedItem()), (int)100));
                    return StampaStikeraControllerTrgovina.this.products;
                }
                return null;
            }
        };
        this.taskLoadingProducts.setOnFailed(value -> taskUpdateStage.hide());
        this.taskLoadingProducts.setOnSucceeded(value -> {
            taskUpdateStage.hide();
            if (this.taskLoadingProducts.getValue() != null) {
                this.tableProducts.setItems(this.products);
            }
            if (this.products.size() == 1) {
                this.addProductForPrint((Product)this.products.get(0));
            }
            this.tableProducts.getSelectionModel().selectFirst();
        });
        new Thread((Runnable)this.taskLoadingProducts).start();
    }

    private void addProductForPrint(Product product) {
        if (product != null) {
            if (!this.contains(product.getProductID())) {
                this.productsForPrint.add((java.lang.Object)product);
            }
            this.refresh();
        }
    }

    private void addProductForPrint() {
        Product product = (Product)this.tableProducts.getSelectionModel().getSelectedItem();
        if (this.products != null) {
            if (!this.contains(product.getProductID())) {
                this.productsForPrint.add((java.lang.Object)product);
            }
            this.refresh();
        }
    }

    private boolean contains(long productID) {
        for (int i = 0; i < this.productsForPrint.size(); ++i) {
            if (((Product)this.productsForPrint.get(i)).getProductID() != productID) continue;
            return true;
        }
        return false;
    }

    private void refresh() {
        this.tableProductsPrint.setItems(this.productsForPrint);
        this.tableProductsPrint.refresh();
    }

    public void createAndInsertInTempTable(Connection connection) throws SQLException {
        String create = " CREATE TABLE `temp_productsprintstickers` ( `ProductName` VARCHAR(100) NULL DEFAULT NULL, `Code` VARCHAR(50) NULL, `BarCode` VARCHAR(100) NULL DEFAULT NULL, `Price` DECIMAL(15,2) NULL DEFAULT NULL, `NetType` VARCHAR(50) NULL DEFAULT NULL, `NetPrice` DECIMAL(15,2) NULL DEFAULT NULL, `UnitCode` VARCHAR(50) NULL DEFAULT NULL, `Dobavljac` VARCHAR(100) NULL DEFAULT NULL)  COLLATE='utf8_general_ci' ENGINE=InnoDB ;";
        String insert = "insert into temp_productsprintstickers select p.Name as ProductName,  p.Code,  b.BarCode, current_price_before_date(?, now(), ?) as Cena,\t nat.Name as NetType, ROUND(('Cena' / p.NetAmount), 2) as NetPrice, u.Code as UnitCode, getDobavljac(p.ProductID) as Dobavljac from product p  join productdepartment pd on pd.ProductID = p.ProductID and pd.DepartmentID = ? join barcode b on b.ProductID = p.ProductID and b.BarCodeID in (select max(b1.BarCodeID) from barcode b1  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twhere b1.ProductID = p.ProductID) left join netamounttype nat on nat.NetAmountTypeID = p.NetAmountTypeID left join unit u on u.UnitID = p.UnitID where p.ProductID = ?";
        String drop = "DROP TABLE IF EXISTS temp_productsprintstickers;";
        PreparedStatement ps = connection.prepareStatement(drop);
        ps.executeUpdate();
        ps = connection.prepareStatement(create);
        ps.executeUpdate();
        for (Product p : this.productsForPrint) {
            ps = connection.prepareStatement(insert);
            ps.setLong(1, p.getProductID());
            ps.setInt(2, ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            ps.setInt(3, ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            ps.setLong(4, p.getProductID());
            ps.executeUpdate();
        }
    }

    @FXML
    public void printSmallList(final ActionEvent event) {
        System.out.println("stampa male liste");
        final String reportFileName = "rs/petcom/backoffice/jasper/stikeri/StikeriKalkulacijaPoKomadu4x10.jasper";
        final HashMap<String, java.lang.Object> hashMap = new HashMap<String, java.lang.Object>();
        try {
            hashMap.put("departmentId", ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            hashMap.put("preduzece", this.cbObject.getSelectionModel().getSelectedItem());
            System.out.println("cbObject.getSelectionModel().getSelectedItem().getName() " + ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getName());
            final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje stikera u toku.", this.rootPane.getScene().getWindow());
            Task<Void> creatingReport = new Task<Void>(){

                protected Void call() throws Exception {
                    try {
                        StringBuffer pList = new StringBuffer("");
                        ObservableList printList = FXCollections.observableArrayList();
                        printList = ((String)StampaStikeraControllerTrgovina.this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_DATE_CHANGED_PRICE) ? StampaStikeraControllerTrgovina.this.tableProducts.getItems() : StampaStikeraControllerTrgovina.this.tableProductsPrint.getItems();
                        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)StampaStikeraControllerTrgovina.this.getListforPeaces((ObservableList<Product>)printList, 3));
                        for (int i = 0; i < printList.size(); ++i) {
                            pList.append(((Product)printList.get(i)).getProductID() + (i == printList.size() - 1 ? "" : ","));
                        }
                        hashMap.put("list", ((Button)event.getSource()).getId().equals("btnPrintSmallList") || ((Button)event.getSource()).getId().equals("btnPrintList") || ((Button)event.getSource()).getId().equals("btnPrintListPDF") || (((Button)event.getSource()).getId().equals("btnPrintAll") || ((Button)event.getSource()).getId().equals("btnPrintAllPDF")) && ((String)StampaStikeraControllerTrgovina.this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_DATE_CHANGED_PRICE));
                        hashMap.put("productList", pList);
                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                        hashMap.put("REPORT_VIRTUALIZER", virtualizer);
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hashMap, (JRDataSource)beanColDataSource);
                        virtualizer.setReadOnly(true);
                        if (((Button)event.getSource()).getText().equals("PDF")) {
                            StampaStikeraControllerTrgovina.this.controller.printFileFromPDF(StampaStikeraControllerTrgovina.this.controller.getPdfFromJasper(jprint, "\u0160tampa stikera", "Stikeri"));
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    taskUpdateStage.hide();
                                }
                            });
                        } else {
                            JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
                            final HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
                            hm2.put("report", printViewPane);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    taskUpdateStage.hide();
                                    StampaStikeraControllerTrgovina.this.controller.showModalDialog("\u0160tampa stikera", ScreensController.DIALOG_PRINT_PREVIEW, hm2, StampaStikeraControllerTrgovina.this.rootPane.getScene().getWindow());
                                }
                            });
                        }
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            new Thread((Runnable)creatingReport).start();
            creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.controller.alert("Obave\u0161tenje", "Odaberite objekat i odeljenje: " + e.getMessage(), this.rootPane.getScene().getWindow());
        }
    }

    private ObservableList<StampaStikera> getListforPeaces(ObservableList<Product> productList, int quantity) {
        ObservableList stikerList = FXCollections.observableArrayList();
        for (Product product : productList) {
            double price = product.getPrice();
            int priceInt = (int)price;
            int mod = (int)Settings.roundOnTwo((double)(price % (double)priceInt * 100.0));
            String priceDec = "";
            if (mod == 0) {
                priceDec = "00";
            } else {
                new String();
                priceDec = String.valueOf(mod);
            }
            StampaStikera stampaStikera = new StampaStikera();
            stampaStikera.setBarCode(product.getBarcode());
            stampaStikera.setCode(product.getCode());
            stampaStikera.setPersonName("Nenad");
            stampaStikera.setPriceDec(priceDec);
            stampaStikera.setPriceInt(priceInt);
            stampaStikera.setProductName(product.getName());
            stampaStikera.setQuantity(quantity);
            stampaStikera.setNetAmount(this.getNetAmountPrice(product.getNetAmount(), price));
            if (product.getNetAmount() == 1.0) {
                stampaStikera.setUnitCode(Product.getUnit((int)product.getUnitID(), (ScreensController)this.controller));
            } else {
                stampaStikera.setUnitCode(Product.getNetAmoubtUnit((int)product.getNetAmountTypeID(), (ScreensController)this.controller));
            }
            for (int i = 0; i < Integer.parseInt(product.getNumOfStickers()); ++i) {
                stikerList.add((java.lang.Object)stampaStikera);
            }
        }
        return stikerList;
    }

    @FXML
    private void setNumberOfStickers(TableColumn.CellEditEvent<Product, String> result) {
        Product product = (Product)this.tableProductsPrint.getSelectionModel().getSelectedItem();
        product.setNumOfStickers((String)result.getNewValue());
    }

    public String getNetAmountPrice(double productNetAmount, double price) {
        double result = Settings.round((double)(price / productNetAmount), (int)2);
        return String.valueOf(result);
    }

    private /* synthetic */ void lambda$init$0(EventHandler hendler, ObservableValue obsValue, String oldValue, String newValue) {
        if (newValue.equals(ScreensController.FILTER_DATE_CHANGED_PRICE)) {
            this.dpDateFrom.setDisable(false);
            this.dpDateTo.setDisable(false);
            this.tfFilter.removeEventHandler(KeyEvent.KEY_RELEASED, hendler);
        } else if (newValue.equals(ScreensController.FILTER_NAZIV)) {
            this.dpDateFrom.setDisable(true);
            this.dpDateTo.setDisable(true);
            this.tfFilter.addEventHandler(KeyEvent.KEY_RELEASED, hendler);
        } else {
            this.dpDateFrom.setDisable(true);
            this.dpDateTo.setDisable(true);
            this.tfFilter.removeEventHandler(KeyEvent.KEY_RELEASED, hendler);
        }
        this.loadProducts();
        this.tfFilter.setText("");
    }
}

