/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.controller.trgovina.GeneratePlstFile;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.EditingCell;

public class ProductsNewControllerTrgovina
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<Product> productList = null;
    private boolean active = true;
    private String departmentIDS = "";
    private String pointOfSaleIDS = "";
    private String productTypeIDS = "";
    private String productCategoryIDS = "";
    private String aditionalFiledIDS = "";
    private String aditionalFiledDetailsIDS = "";
    private String vatIDS = "";
    private String popustDozvoljen = "-1";
    private String merljiv = "-1";
    private String tezinski = "-1";
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private ComboBox<String> cbLimit;
    @FXML
    private TableView<Product> productTable;
    @FXML
    private TableColumn<Product, String> codeCol;
    @FXML
    private TableColumn<Product, String> nameCol;
    @FXML
    private TableColumn<Product, String> colBarCode;
    @FXML
    private TableColumn<Product, String> jedinicaMereCol;
    @FXML
    private TableColumn<Product, Double> cenaCol;
    @FXML
    private TableColumn<Product, Boolean> tcActive;
    @FXML
    private Button btnActivate;

    public void initialize() {
        Callback<TableColumn<Product, Double>, TableCell<Product, Double>> cellFactory = new Callback<TableColumn<Product, Double>, TableCell<Product, Double>>(){

            public TableCell<Product, Double> call(TableColumn<Product, Double> p) {
                return new EditingCell(ProductsNewControllerTrgovina.this.productTable);
            }
        };
        this.productTable.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    ProductsNewControllerTrgovina.this.productTable.getFocusModel().focus(ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedIndex(), ProductsNewControllerTrgovina.this.cenaCol);
                }
            }
        });
        this.productTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionUpdate();
                }
            });
            return row;
        });
        this.tfFilter.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    if (!((String)ProductsNewControllerTrgovina.this.cbLimit.getSelectionModel().getSelectedItem()).equals("Sve")) {
                        ProductsNewControllerTrgovina.this.loadTableProduct();
                    }
                    ProductsNewControllerTrgovina.this.productTable.requestFocus();
                    if (!ProductsNewControllerTrgovina.this.tfFilter.getText().trim().equals("")) {
                        ProductsNewControllerTrgovina.this.productTable.getSelectionModel().selectFirst();
                        ProductsNewControllerTrgovina.this.productTable.getFocusModel().focus(ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedIndex(), ProductsNewControllerTrgovina.this.cenaCol);
                    }
                }
            }
        });
        this.codeCol.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.jedinicaMereCol.setCellValueFactory((Callback)new PropertyValueFactory("UnitName"));
        this.cenaCol.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.cenaCol.setCellFactory((Callback)cellFactory);
        this.cenaCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Product, Double>>(){

            public void handle(TableColumn.CellEditEvent<Product, Double> t) {
                if (((Product)t.getTableView().getItems().get(t.getTablePosition().getRow())).getPrice() != Settings.round((double)((Double)t.getNewValue()), (int)2)) {
                    try {
                        Product p = (Product)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        PriceListDetailes.insertProductPriceTrgovina((PriceList)PriceList.getActive((LocalDateTime)LocalDateTime.now(), (int)ProductsNewControllerTrgovina.this.controller.getObject().getObjectID(), (Connection)ProductsNewControllerTrgovina.this.controller.getSettings().getConnection()), (long)p.getProductID(), (double)Settings.round((double)((Double)t.getNewValue()), (int)2), (Connection)ProductsNewControllerTrgovina.this.controller.getSettings().getConnection());
                        Log.writeLog((User)ProductsNewControllerTrgovina.this.controller.getUser(), (String)("Brza promena cene za artikal " + p.getName() + " sa " + t.getOldValue() + " na " + t.getNewValue()), (Connection)ProductsNewControllerTrgovina.this.controller.getSettings().getConnection());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    ProductsNewControllerTrgovina.this.loadTableProduct();
                }
            }
        });
        this.tcActive.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.tcActive.setCellFactory(column -> new TableCell<Product, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.cbFilterType.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProductsNewControllerTrgovina.this.tfFilter.setText("");
                ProductsNewControllerTrgovina.this.loadTableProduct();
            }
        });
        this.btnActivate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem() != null) {
                    ((Product)ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).setActive(!((Product)ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).isActive());
                    ((Product)ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductByActivity(ProductsNewControllerTrgovina.this.controller.getSettings().getConnection());
                    if (((Product)ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).isActive()) {
                        ProductsNewControllerTrgovina.this.btnActivate.setText("Deaktiviraj");
                    } else {
                        ProductsNewControllerTrgovina.this.btnActivate.setText("Aktiviraj");
                    }
                }
                ProductsNewControllerTrgovina.this.productTable.refresh();
            }
        });
        this.productTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Product>(){

            public void onChanged(ListChangeListener.Change<? extends Product> c) {
                if (ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem() != null) {
                    if (((Product)ProductsNewControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).isActive()) {
                        ProductsNewControllerTrgovina.this.btnActivate.setText("Deaktiviraj");
                    } else {
                        ProductsNewControllerTrgovina.this.btnActivate.setText("Aktiviraj");
                    }
                }
            }
        });
        this.cbLimit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)ProductsNewControllerTrgovina.this.cbLimit.getSelectionModel().getSelectedItem()).equals("Sve")) {
                    ProductsNewControllerTrgovina.this.tfFilter.setText("");
                }
                ProductsNewControllerTrgovina.this.loadTableProduct();
            }
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null || newValue.isEmpty()) {
                    ProductsNewControllerTrgovina.this.productTable.getSelectionModel().clearSelection();
                    ProductsNewControllerTrgovina.this.filter();
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tcActive.setVisible(false);
        this.cbFilterType.getItems().addAll((Object[])new String[]{"Sve", "Naziv", "Sifra", "Barkod"});
        this.cbFilterType.getSelectionModel().selectFirst();
        this.cbLimit.getItems().addAll((Object[])new String[]{"100", "1000", "Sve"});
        this.cbLimit.getSelectionModel().selectFirst();
        this.loadTableProduct();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        boolean fromInvoice = false;
        hm.put("controller", this.controller);
        hm.put("selectedProduct", null);
        hm.put("fromInvoice", fromInvoice);
        this.controller.showModalDialog("Dodavanje - Izmena artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT_NEW, hm, this.rootPane.getScene().getWindow());
        this.loadTableProduct();
    }

    @FXML
    private void actionUpdate() {
        if (this.productTable.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedProduct", this.productTable.getSelectionModel().getSelectedItem());
            hm.put("fromInvoice", false);
            this.controller.showModalDialog("Dodavanje - Izmena artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT_NEW, hm, this.rootPane.getScene().getWindow());
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati artikal iz tabele ako zelite da ga izmenite", this.rootPane.getScene().getWindow());
        }
        this.loadTableProduct();
    }

    private void loadTableProduct() {
        this.productTable.setItems(Product.getNewTrgovinaList((ScreensController)this.controller, (String)(((String)this.cbLimit.getSelectionModel().getSelectedItem()).equals("Sve") ? "100000000" : (String)this.cbLimit.getSelectionModel().getSelectedItem()), (String)((String)this.cbFilterType.getSelectionModel().getSelectedItem()), (String)this.tfFilter.getText().trim(), (boolean)false));
        this.filter();
    }

    @FXML
    private void filterAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int res = this.controller.showModalDialog("Filtriraj", ScreensController.DIALOG_FILTER_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (res == ScreensController.MODAL_RESULT_OK) {
            this.departmentIDS = (String)hm.get("departmentIDS");
            this.pointOfSaleIDS = (String)hm.get("pointOfSaleIDS");
            this.productTypeIDS = (String)hm.get("productTypeIDS");
            this.productCategoryIDS = (String)hm.get("productCategoryIDS");
            this.aditionalFiledIDS = (String)hm.get("aditionalFiledIDS");
            this.aditionalFiledDetailsIDS = (String)hm.get("aditionalFiledDetailsIDS");
            this.vatIDS = (String)hm.get("vatIDS");
            this.active = (Boolean)hm.get("active");
            this.popustDozvoljen = (String)hm.get("popustDozvoljen");
            this.merljiv = (String)hm.get("merljiv");
            this.tezinski = (String)hm.get("tezinski");
            this.fillProductTable();
        }
    }

    private void fillProductTable() {
        this.tfFilter.setText("");
        this.productList = Product.getNewFilteredList((String)(this.departmentIDS.equals("") ? "-1" : this.departmentIDS.substring(0, this.departmentIDS.length() - 1)), (String)(this.pointOfSaleIDS.equals("") ? "-1" : this.pointOfSaleIDS.substring(0, this.pointOfSaleIDS.length() - 1)), (String)(this.productTypeIDS.equals("") ? "-1" : this.productTypeIDS.substring(0, this.productTypeIDS.length() - 1)), (String)(this.productCategoryIDS.equals("") ? "-1" : this.productCategoryIDS.substring(0, this.productCategoryIDS.length() - 1)), (String)(this.aditionalFiledIDS.equals("") ? "-1" : this.aditionalFiledIDS.substring(0, this.aditionalFiledIDS.length() - 1)), (String)(this.aditionalFiledDetailsIDS.equals("") ? "-1" : this.aditionalFiledDetailsIDS.substring(0, this.aditionalFiledDetailsIDS.length() - 1)), (String)(this.vatIDS.equals("") ? "-1" : this.vatIDS.substring(0, this.vatIDS.length() - 1)), (boolean)this.active, (String)this.popustDozvoljen, (String)this.merljiv, (String)this.tezinski, (ScreensController)this.controller);
        this.productTable.setItems(this.productList);
        this.filter();
    }

    private void filter() {
        if (((String)this.cbLimit.getSelectionModel().getSelectedItem()).equals("Sve")) {
            FilteredList filteredData = new FilteredList(this.productTable.getItems(), p -> true);
            this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(product -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                    if (product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                    if (product.getBarcode() != null && product.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                    if (product.getCode() != null && product.getCode().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                } else if (((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_NAZIV) ? product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter) : (((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE) ? product.getBarcode() != null && product.getBarcode().toLowerCase().startsWith(lowerCaseFilter) : ((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) && product.getCode() != null && product.getCode().toLowerCase().startsWith(lowerCaseFilter))) {
                    return true;
                }
                return false;
            }));
            SortedList sortedData = new SortedList((ObservableList)filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.productTable.comparatorProperty());
            this.productTable.setItems((ObservableList)sortedData);
        }
    }

    @FXML
    public void createFile(ActionEvent actionEvent) {
        try {
            File file = new File(this.controller.getSettings().getPlstPath() + "/plst.txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "Cp1252"));
            writer.write(this.generateFilePlst());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String generateFilePlst() {
        StringBuilder stringBuilder = new StringBuilder();
        for (GeneratePlstFile generatePlstFile : Barcode.getPlst((ScreensController)this.controller)) {
            stringBuilder.append(generatePlstFile.getGroupDetartment()).append(generatePlstFile.getCodeProduct()).append(generatePlstFile.getTypeProduct()).append(generatePlstFile.getNumberCountPackage()).append(generatePlstFile.getPrice()).append(generatePlstFile.getExpirationDate()).append(generatePlstFile.getBarCode()).append(this.genrateNameProduct(generatePlstFile.getNameProduct()));
            stringBuilder.append("\r\n");
            System.out.println(stringBuilder.toString().length());
        }
        return stringBuilder.toString();
    }

    private String generateFilePlu() {
        StringBuilder stringBuilder = new StringBuilder();
        for (GeneratePlstFile generatePlstFile : Barcode.getPlu((ScreensController)this.controller)) {
            stringBuilder.append(generatePlstFile.getBarCode() + "\t").append(generatePlstFile.getNameProduct() + "\t").append(generatePlstFile.getPrice() + "\t").append(generatePlstFile.getBarCode());
            stringBuilder.append("\r\n");
            System.out.println(stringBuilder.toString().length());
        }
        return stringBuilder.toString();
    }

    private static String convertFromUtf8ToIso(String s1) {
        if (s1 == null) {
            return null;
        }
        String s = new String(s1.getBytes(StandardCharsets.UTF_8));
        byte[] b = s.getBytes(StandardCharsets.ISO_8859_1);
        return new String(b, StandardCharsets.US_ASCII);
    }

    private String genrateNameProduct(String nameProduct) {
        int length;
        StringBuilder stringBuilder = new StringBuilder();
        if (nameProduct.isEmpty()) {
            throw new RuntimeException("Ime proizvoda je prazno");
        }
        stringBuilder.append(nameProduct);
        for (int i = length = nameProduct.length(); i < 250; ++i) {
            stringBuilder.append(" ");
        }
        System.out.println(stringBuilder.length());
        return stringBuilder.toString();
    }

    @FXML
    public void createFileShide(ActionEvent actionEvent) {
        try {
            File file = new File(this.controller.getSettings().getPlstPath() + "/plu.txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "Cp1252"));
            writer.write(this.generateFilePlu());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

