/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Excise;
import rs.petcom.master.dal.ExciseProduct;
import rs.petcom.master.dal.Group;
import rs.petcom.master.dal.KitchenDisplay;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.NetAmountType;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSaleProductDescription;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.ProductToPrinter;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Description;
import rs.petcom.master.dal.product.GroupPointOfSaleProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.ProductGroup;
import rs.petcom.master.dal.product.ProductGroupDetaile;
import rs.petcom.master.dal.product.ProductType;

public class ProductsControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    Product oldValue = null;
    Product selectedProduct = null;
    Printer selectedPrinter = null;
    ProductToPrinter selectedProductToPrinter = null;
    ProductDepartment pd = new ProductDepartment();
    Barcode selectedBarcode = null;
    PointOfSaleProductDescription selectedPointOfSaleProductDescription = null;
    Description selectedDescription = null;
    Product selectedDodatni = null;
    ProductType selectedProductType = new ProductType();
    Group selectedGroup = new Group();
    AditionalField selectedAditionalField;
    ComboBox<AditionalFieldDetails> combo;
    Department selectedDepartment;
    Excise selectedExcise;
    Object sviObjekti = new Object(-1, "Svi objekti");
    KitchenDisplay nemaDisplaya = new KitchenDisplay(-1, -1, "");
    ObservableList<Product> productList = null;
    ObservableList<Vat> vatList;
    ObservableList<ProductCategory> productCategoryList;
    ObservableList<ProductType> productTypeList;
    ObservableList<Unit> productUnitList;
    ObservableList<Barcode> barcodeList;
    ObservableList<PointOfSaleProductDescription> descriptionIdList;
    ObservableList<GroupPointOfSaleProduct> additionalList;
    private ObservableList<Excise> lista;
    private String departmentIDS = "";
    private String pointOfSaleIDS = "";
    private String productTypeIDS = "";
    private String productCategoryIDS = "";
    private String aditionalFiledIDS = "";
    private String aditionalFiledDetailsIDS = "";
    private String vatIDS = "";
    private boolean active = true;
    private String popustDozvoljen = "-1";
    private String merljiv = "-1";
    private String tezinski = "-1";
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Product> productTable;
    @FXML
    TableColumn<Product, String> codeCol;
    @FXML
    TableColumn<Product, String> nameCol;
    @FXML
    TableColumn<Product, String> colBarCode;
    @FXML
    TableColumn<Product, String> jedinicaMereCol;
    @FXML
    TableColumn<Product, Double> cenaCol;
    @FXML
    ComboBox<String> cbFilterType;
    @FXML
    Tab tabGrupe;
    @FXML
    Tab tabBarkod;
    @FXML
    Tab tabPOSPriner;
    @FXML
    Tab tabDepartment;
    @FXML
    TextField tfFilter;
    @FXML
    TextField tfCode;
    @FXML
    TextField tfBarcode;
    @FXML
    TextField tfTezinskiKod;
    @FXML
    TextField tfPLUcode;
    @FXML
    TextField tfBarcodeOsnovni;
    @FXML
    TextField tfCena;
    @FXML
    TextField tfNabavnaCena;
    @FXML
    TextField tfName;
    @FXML
    TextField tfShortName;
    @FXML
    TextField tfNetAmount;
    @FXML
    TextField tfWriteOff;
    @FXML
    TextField tfJedinicaMere;
    @FXML
    CheckBox cbActive;
    @FXML
    CheckBox cbMeasurable;
    @FXML
    CheckBox cbDiscountAllowed;
    @FXML
    CheckBox cbIsWeight;
    @FXML
    Label lblExciseValue;
    @FXML
    Label lblExciseValueByJM;
    @FXML
    ComboBox<Vat> cbVat;
    @FXML
    ComboBox<ProductCategory> cbCategory;
    @FXML
    ComboBox<ProductType> cbType;
    @FXML
    ComboBox<Unit> cbUnit;
    @FXML
    ComboBox<NetAmountType> cbNetAmountType;
    @FXML
    ComboBox<AditionalFieldDetails> cbAditionalFieldDetails;
    @FXML
    ComboBox<Excise> cbExcise;
    @FXML
    AnchorPane apGrupe;
    @FXML
    AnchorPane apNormativ;
    @FXML
    HBox hbGrupeNormativ;
    @FXML
    TableView<Barcode> tableBarcode;
    @FXML
    TableColumn<Barcode, Long> colId;
    @FXML
    TableColumn<Barcode, String> colBarcode;
    @FXML
    TableView<ProductGroup> tableGroup;
    @FXML
    TableView<Department> tableDepartment;
    @FXML
    TableColumn<Department, String> colDepartmentName;
    ArrayList<ProductDepartment> productDepartments = null;
    ArrayList<Product> aditionalProducts = null;
    @FXML
    private TableView<AditionalField> tableAditionalFields;
    @FXML
    private TableColumn<AditionalField, Long> tcAditionalFieldID;
    @FXML
    private TableColumn<AditionalField, String> tcNameAditionalField;
    @FXML
    private TableColumn<AditionalField, ComboBox<AditionalFieldDetails>> tcDetailsAditionalField;
    @FXML
    private Label labelInfoAditionalField;

    public void initialize() {
        this.cbFilterType.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProductsControllerTrgovina.this.tfFilter.setText("");
            }
        });
        this.tfJedinicaMere.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    ProductsControllerTrgovina.this.tfJedinicaMere.setText(oldValue);
                }
                if (!newValue.equals("")) {
                    ProductsControllerTrgovina.this.lblExciseValueByJM.setText(String.valueOf(Settings.round((double)(Double.parseDouble(ProductsControllerTrgovina.this.lblExciseValue.getText()) * Double.parseDouble(newValue) / 1.0), (int)2)));
                }
            }
        });
        this.tfBarcode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.trim().length() == 5) {
                    ProductsControllerTrgovina.this.cbIsWeight.setDisable(false);
                    ProductsControllerTrgovina.this.cbIsWeight.setSelected(true);
                } else {
                    ProductsControllerTrgovina.this.cbIsWeight.setDisable(true);
                    ProductsControllerTrgovina.this.cbIsWeight.setSelected(false);
                }
            }
        });
        this.cbExcise.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ProductsControllerTrgovina.this.cbExcise.getSelectionModel().getSelectedItem() != null) {
                    ProductsControllerTrgovina.this.selectedExcise = (Excise)ProductsControllerTrgovina.this.cbExcise.getSelectionModel().getSelectedItem();
                    if (ProductsControllerTrgovina.this.selectedExcise.getExciseId() != -1L) {
                        ProductsControllerTrgovina.this.lblExciseValue.setText(String.valueOf(((Excise)ProductsControllerTrgovina.this.cbExcise.getSelectionModel().getSelectedItem()).getValue()));
                    }
                }
            }
        });
        this.tfFilter.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    ProductsControllerTrgovina.this.fillProductTable();
                    ProductsControllerTrgovina.this.loadAditionalFieldDetails();
                    ProductsControllerTrgovina.this.loadBarcodeObject();
                    ProductsControllerTrgovina.this.loadCurrentPriceAndNabavnaCena();
                    ProductsControllerTrgovina.this.loadAditionalFields();
                    ProductsControllerTrgovina.this.showProduct((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem());
                    if (ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem() != null) {
                        ProductsControllerTrgovina.this.loadExciseField();
                    }
                }
            }
        });
        this.cbFilterType.getItems().addAll((java.lang.Object[])new String[]{"Sve", "Naziv", "Sifra", "Barkod"});
        this.cbFilterType.getSelectionModel().selectFirst();
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbIsWeight.setDisable(true);
        this.fillExciseComboBox();
        this.tfFilter.setText("");
        this.fillProductTable();
        if (this.controller.getSettings().isSinhorinizacija()) {
            this.vatList = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
            this.productCategoryList = ProductCategory.getObeservableList((Connection)this.controller.getServerConnection());
            this.productTypeList = this.selectedProductType.getObeservableList(this.active, this.controller.getServerConnection());
            this.productUnitList = Unit.getList((Connection)this.controller.getServerConnection());
        } else {
            this.vatList = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
            this.productCategoryList = ProductCategory.getObeservableList((Connection)this.controller.getSettings().getConnection());
            this.productTypeList = this.selectedProductType.getObeservableList(this.active, this.controller.getSettings().getConnection());
            this.productUnitList = Unit.getList((Connection)this.controller.getSettings().getConnection());
        }
        this.codeCol.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.jedinicaMereCol.setCellValueFactory((Callback)new PropertyValueFactory("UnitName"));
        this.cenaCol.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.productTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Product>(){

            public void onChanged(ListChangeListener.Change<? extends Product> c) {
                try {
                    ProductsControllerTrgovina.this.tableGroup.getSelectionModel().clearSelection();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ProductsControllerTrgovina.this.loadAditionalFieldDetails();
                ProductsControllerTrgovina.this.loadBarcodeObject();
                ProductsControllerTrgovina.this.loadCurrentPriceAndNabavnaCena();
                ProductsControllerTrgovina.this.loadAditionalFields();
                ProductsControllerTrgovina.this.showProduct((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem());
                if (ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem() != null) {
                    ProductsControllerTrgovina.this.loadExciseField();
                }
            }
        });
        this.tableAditionalFields.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<AditionalField>(){

            public void onChanged(ListChangeListener.Change<? extends AditionalField> c) {
                ProductsControllerTrgovina.this.selectedAditionalField = (AditionalField)ProductsControllerTrgovina.this.tableAditionalFields.getSelectionModel().getSelectedItem();
            }
        });
        this.tfCode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setCode(newValue);
            }
        });
        this.tfPLUcode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setPlucode(newValue);
            }
        });
        this.tfNetAmount.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setNetAmount(Double.parseDouble(newValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.tfName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setName(newValue);
            }
        });
        this.tfShortName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setShortName(newValue);
            }
        });
        this.tfWriteOff.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setWriteOff(Double.parseDouble(newValue));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbVat.setItems(this.vatList);
        this.cbVat.valueProperty().addListener((ChangeListener)new ChangeListener<Vat>(){

            public void changed(ObservableValue<? extends Vat> observable, Vat oldValue, Vat newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setVatID(newValue.getVatID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbCategory.setItems(this.productCategoryList);
        this.cbCategory.valueProperty().addListener((ChangeListener)new ChangeListener<ProductCategory>(){

            public void changed(ObservableValue<? extends ProductCategory> observable, ProductCategory oldValue, ProductCategory newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setProductCategoryID(newValue.getProductCategoryID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbType.setItems(this.productTypeList);
        this.cbType.valueProperty().addListener((ChangeListener)new ChangeListener<ProductType>(){

            public void changed(ObservableValue<? extends ProductType> observable, ProductType oldValue, ProductType newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setProductTypeID(newValue.getProductTypeID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbUnit.setItems(this.productUnitList);
        this.cbUnit.valueProperty().addListener((ChangeListener)new ChangeListener<Unit>(){

            public void changed(ObservableValue<? extends Unit> observable, Unit oldValue, Unit newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setUnitID(newValue.getUnitID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbNetAmountType.setItems(NetAmountType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbNetAmountType.valueProperty().addListener((ChangeListener)new ChangeListener<NetAmountType>(){

            public void changed(ObservableValue<? extends NetAmountType> observable, NetAmountType oldValue, NetAmountType newValue) {
                try {
                    ProductsControllerTrgovina.this.selectedProduct.setNetAmountTypeID(newValue.getNetAmountTypeID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbActive.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setActive(newValue.booleanValue());
            }
        });
        this.cbMeasurable.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setMeasurable(newValue.booleanValue());
            }
        });
        this.cbDiscountAllowed.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ProductsControllerTrgovina.this.selectedProduct.setDiscountAllowed(newValue.booleanValue());
            }
        });
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("BarCodeID"));
        this.colBarcode.setCellValueFactory((Callback)new PropertyValueFactory("BarCode"));
        this.tableBarcode.setItems(this.barcodeList);
        this.tableBarcode.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Barcode>(){

            public void onChanged(ListChangeListener.Change<? extends Barcode> c) {
                ProductsControllerTrgovina.this.selectedBarcode = (Barcode)ProductsControllerTrgovina.this.tableBarcode.getSelectionModel().getSelectedItem();
                ProductsControllerTrgovina.this.showBarcode();
            }
        });
        this.colDepartmentName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
    }

    private void showProduct(Product p) {
        try {
            block9: {
                this.oldValue = p.getCopy();
                this.selectedProduct = p;
                if (this.selectedProduct.getBarcodeObject().getIsWeight().booleanValue()) {
                    this.tfTezinskiKod.setDisable(false);
                    try {
                        if (this.selectedProduct.getBarcodeObject().getBarCode().length() <= 5) {
                            this.tfTezinskiKod.setText(("00000" + this.selectedProduct.getBarcodeObject().getBarCode()).substring(this.selectedProduct.getBarcodeObject().getBarCode().length()));
                            this.tfBarcodeOsnovni.setText("");
                            this.tfBarcodeOsnovni.setDisable(true);
                            break block9;
                        }
                        this.controller.alert("Tezinski kod", "Tezinski kod ne moze imati vise od 5 karaktera, proverite artikal ciji je ID: " + this.selectedProduct.getProductID(), this.rootPane.getScene().getWindow());
                    }
                    catch (NullPointerException nullPointerException) {}
                } else {
                    this.tfBarcodeOsnovni.setDisable(false);
                    try {
                        this.tfBarcodeOsnovni.setText(this.selectedProduct.getBarcodeObject().getBarCode());
                        this.tfTezinskiKod.setText("");
                        this.tfTezinskiKod.setDisable(true);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            this.tfCode.setText(this.selectedProduct.getCode());
            this.tfPLUcode.setText(this.selectedProduct.getPlucode());
            this.tfCena.setText(this.selectedProduct.getPrice() + "");
            this.tfNabavnaCena.setText(String.valueOf(this.selectedProduct.getNabavnaCena()));
            this.tfName.setText(this.selectedProduct.getName());
            this.tfShortName.setText(this.selectedProduct.getShortName());
            this.cbActive.setSelected(this.selectedProduct.isActive());
            this.cbMeasurable.setSelected(this.selectedProduct.isMeasurable());
            this.cbDiscountAllowed.setSelected(this.selectedProduct.isDiscountAllowed());
            this.cbVat.setValue((java.lang.Object)this.getVatByIndex(this.selectedProduct.getVatID()));
            this.cbUnit.setValue((java.lang.Object)this.getProductUnitByIndex(this.selectedProduct.getUnitID()));
            this.cbCategory.setValue((java.lang.Object)this.getProductCategoryByIndex(this.selectedProduct.getProductCategoryID()));
            this.cbType.setValue((java.lang.Object)this.getProductTypeByIndex(this.selectedProduct.getProductTypeID()));
            this.cbNetAmountType.getSelectionModel().select((java.lang.Object)NetAmountType.getNetTypById((int)this.selectedProduct.getNetAmountTypeID(), (Connection)this.controller.getSettings().getConnection()));
            this.tfNetAmount.setText(this.selectedProduct.getNetAmount() + "");
            this.tfWriteOff.setText(String.valueOf(this.selectedProduct.getWriteOff()));
            this.loadBarcode(p);
            this.loadGroup();
            this.loadDepartment(p);
        }
        catch (NullPointerException e) {
            this.tfCode.setText("");
            this.tfPLUcode.setText("");
            this.tfBarcodeOsnovni.setText("");
            this.tfTezinskiKod.setText("");
            this.tfCena.setText("");
            this.tfName.setText("");
            this.tfShortName.setText("");
            this.cbActive.setSelected(false);
            this.cbMeasurable.setSelected(false);
            this.cbDiscountAllowed.setSelected(false);
            this.cbVat.getSelectionModel().select(0);
            this.cbCategory.getSelectionModel().select(0);
            this.cbType.getSelectionModel().select(0);
            this.tfWriteOff.setText("0");
            this.tfNabavnaCena.setText("0");
        }
    }

    private Vat getVatByIndex(int id) {
        for (Vat v : this.vatList) {
            if (v.getVatID() != id) continue;
            return v;
        }
        return null;
    }

    private ProductCategory getProductCategoryByIndex(int id) {
        for (ProductCategory pc : this.productCategoryList) {
            if (pc.getProductCategoryID() != id) continue;
            return pc;
        }
        return null;
    }

    private ProductType getProductTypeByIndex(int id) {
        for (ProductType pt : this.productTypeList) {
            if (pt.getProductTypeID() != id) continue;
            return pt;
        }
        return null;
    }

    private Unit getProductUnitByIndex(int id) {
        for (Unit u : this.productUnitList) {
            if (u.getUnitID() != id) continue;
            return u;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void commitArtikal() {
        if (this.controller.getSettings().isSinhorinizacija()) {
            try {
                try {
                    this.controller.getServerConnection().setAutoCommit(false);
                    if (((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID() != new Long(0L).longValue()) {
                        this.selectedProduct.update(this.controller.getUser(), Boolean.valueOf(this.cbMeasurable.isSelected()), Boolean.valueOf(this.cbDiscountAllowed.isSelected()), this.controller.getServerConnection());
                        if (this.selectedProduct.getBarcodeObject().getBarCodeID() > 0L || !this.selectedProduct.getBarcodeObject().getBarCode().equals("")) {
                            if (this.selectedProduct.getBarcodeObject().getIsWeight().booleanValue()) {
                                if (this.tfTezinskiKod.getText().length() <= 5) {
                                    if (!this.selectedProduct.getBarcodeObject().getBarCode().equals(this.tfTezinskiKod.getText())) {
                                        this.selectedProduct.getBarcodeObject().setBarCode(this.tfTezinskiKod.getText());
                                        this.selectedProduct.getBarcodeObject().updateById(this.controller);
                                    }
                                } else {
                                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", "Tezinski kod ne moze imati vise 5 od karaktera, molim Vas ispravite", this.rootPane.getScene().getWindow());
                                }
                            } else if (this.selectedProduct.getBarcodeObject().getBarCode() != null && !this.selectedProduct.getBarcodeObject().getBarCode().equals(this.tfBarcodeOsnovni.getText())) {
                                if (this.tfBarcodeOsnovni.getText().equals("")) {
                                    this.selectedProduct.getBarcodeObject().delete(this.controller.getServerConnection());
                                } else {
                                    this.selectedProduct.getBarcodeObject().setBarCode(this.tfBarcodeOsnovni.getText());
                                    this.selectedProduct.getBarcodeObject().updateById(this.controller);
                                }
                            }
                        } else if (!this.tfBarcodeOsnovni.getText().equals("")) {
                            Barcode b = new Barcode();
                            b.setBarCode(this.tfBarcodeOsnovni.getText());
                            b.setProductID(this.selectedProduct.getProductID());
                            b.insertNewBarCode(this.controller.getServerConnection());
                        }
                        if (this.selectedProduct.getPrice() != Double.parseDouble(this.tfCena.getText())) {
                            PriceListDetailes.insertProductPriceTrgovina((PriceList)PriceList.getActive((LocalDateTime)LocalDateTime.now(), (int)this.controller.getObject().getObjectID(), (Connection)this.controller.getServerConnection()), (long)this.selectedProduct.getProductID(), (double)Double.parseDouble(this.tfCena.getText()), (Connection)this.controller.getServerConnection());
                        }
                    } else {
                        this.selectedProduct.insert(this.controller.getUser(), this.controller.getServerConnection());
                    }
                    this.fillProductTable();
                    this.controller.getServerConnection().commit();
                    this.saveExcise(this.selectedProduct);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", "Tezinski kod ili barkod vec postoji u bazi podataka i jedinstven je, molim Vas unestite drugi", this.rootPane.getScene().getWindow());
                    try {
                        this.controller.getSettings().getConnection().rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                finally {
                    try {
                        this.controller.getSettings().getConnection().setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                Log.writeLog((User)this.controller.getUser(), (String)e.getMessage(), (Connection)this.controller.getSettings().getConnection());
                this.controller.alert("Obavestenje", "Odaberite artikal iz tabele", this.rootPane.getScene().getWindow());
            }
        } else {
            try {
                try {
                    this.controller.getSettings().getConnection().setAutoCommit(false);
                    if (((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID() != new Long(0L).longValue()) {
                        this.selectedProduct.update(this.controller.getUser(), Boolean.valueOf(this.cbMeasurable.isSelected()), Boolean.valueOf(this.cbDiscountAllowed.isSelected()), this.controller.getSettings().getConnection());
                        if (this.selectedProduct.getBarcodeObject().getBarCodeID() > 0L || !this.selectedProduct.getBarcodeObject().getBarCode().equals("")) {
                            if (this.selectedProduct.getBarcodeObject().getIsWeight().booleanValue()) {
                                if (this.tfTezinskiKod.getText().length() <= 5) {
                                    if (!this.selectedProduct.getBarcodeObject().getBarCode().equals(this.tfTezinskiKod.getText())) {
                                        this.selectedProduct.getBarcodeObject().setBarCode(this.tfTezinskiKod.getText());
                                        this.selectedProduct.getBarcodeObject().updateById(this.controller);
                                    }
                                } else {
                                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", "Tezinski kod ne moze imati vise 5 od karaktera, molim Vas ispravite", this.rootPane.getScene().getWindow());
                                }
                            } else if (this.selectedProduct.getBarcodeObject().getBarCode() != null && !this.selectedProduct.getBarcodeObject().getBarCode().equals(this.tfBarcodeOsnovni.getText())) {
                                if (this.tfBarcodeOsnovni.getText().equals("")) {
                                    this.selectedProduct.getBarcodeObject().delete(this.controller.getSettings().getConnection());
                                } else {
                                    this.selectedProduct.getBarcodeObject().setBarCode(this.tfBarcodeOsnovni.getText());
                                    this.selectedProduct.getBarcodeObject().updateById(this.controller);
                                }
                            }
                        } else if (!this.tfBarcodeOsnovni.getText().equals("")) {
                            Barcode b = new Barcode();
                            b.setBarCode(this.tfBarcodeOsnovni.getText());
                            b.setProductID(this.selectedProduct.getProductID());
                            b.insertNewBarCode(this.controller.getSettings().getConnection());
                        }
                        if (this.selectedProduct.getPrice() != Double.parseDouble(this.tfCena.getText())) {
                            PriceListDetailes.insertProductPriceTrgovina((PriceList)PriceList.getActive((LocalDateTime)LocalDateTime.now(), (int)this.controller.getObject().getObjectID(), (Connection)this.controller.getSettings().getConnection()), (long)this.selectedProduct.getProductID(), (double)Double.parseDouble(this.tfCena.getText()), (Connection)this.controller.getSettings().getConnection());
                        }
                    } else {
                        this.selectedProduct.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
                    }
                    this.fillProductTable();
                    this.controller.getSettings().getConnection().commit();
                    this.saveExcise(this.selectedProduct);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", "Tezinski kod ili barkod vec postoji u bazi podataka i jedinstven je, molim Vas unestite drugi", this.rootPane.getScene().getWindow());
                    try {
                        this.controller.getSettings().getConnection().rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                finally {
                    try {
                        this.controller.getSettings().getConnection().setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                Log.writeLog((User)this.controller.getUser(), (String)e.getMessage(), (Connection)this.controller.getSettings().getConnection());
                this.controller.alert("Obavestenje", "Odaberite artikal iz tabele", this.rootPane.getScene().getWindow());
            }
        }
    }

    @FXML
    private void cancelAction() {
        this.selectedProduct = this.oldValue.getCopy();
        this.showProduct(this.selectedProduct);
    }

    @FXML
    private void sacuvajDodatnePodatke() {
        try {
            if (this.selectedProduct.getProductID() != new Long(0L).longValue()) {
                try {
                    this.selectedProduct.update(this.controller.getUser(), Boolean.valueOf(this.cbMeasurable.isSelected()), Boolean.valueOf(this.cbDiscountAllowed.isSelected()), this.controller.getSettings().getConnection());
                    this.pd.updateKitchenMonitor(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID(), ((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductDepartmentID(), this.controller.getSettings().getConnection());
                    this.fillProductTable();
                }
                catch (SQLException e) {
                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", e.getMessage(), this.rootPane.getScene().getWindow());
                    e.printStackTrace();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void newAction() {
        HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
        hm2.put("controller", this.controller);
        int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.fillProductTable();
        }
    }

    private void loadBarcode(Product product) {
        try {
            this.barcodeList = Barcode.getBarCodes((Product)product, (Connection)this.controller.getSettings().getConnection());
            this.tableBarcode.setItems(this.barcodeList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void showBarcode() {
        try {
            this.tfBarcode.setText(this.selectedBarcode.getBarCode());
            this.cbIsWeight.setSelected(this.selectedBarcode.getIsWeight().booleanValue());
        }
        catch (NullPointerException e) {
            this.tfBarcode.setText("");
        }
    }

    @FXML
    private void barcodeSave() {
        if (this.selectedBarcode != null) {
            try {
                this.selectedBarcode.setBarCode(this.tfBarcode.getText());
                if (this.selectedBarcode.getBarCode().trim().length() == 5 && this.cbIsWeight.isSelected()) {
                    this.selectedBarcode.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                } else {
                    this.selectedBarcode.setIsWeight(Boolean.valueOf(false));
                }
                this.selectedBarcode.update(this.controller);
                this.loadBarcode(this.selectedProduct);
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161na izmena: " + e.getMessage(), this.rootPane.getScene().getWindow());
            }
        }
        this.selectedBarcode = null;
    }

    @FXML
    private void barcodeNew() {
        if (this.selectedProduct != null) {
            if (!this.tfBarcode.getText().equals("") || this.tfBarcode.getText() != null) {
                if (this.selectedBarcode != null) {
                    this.controller.alert("Obave\u0161tenje", "Morate odselektovati barkod", this.rootPane.getScene().getWindow());
                } else {
                    Barcode bc = new Barcode();
                    bc.setBarCode(this.tfBarcode.getText());
                    bc.setProductID(this.selectedProduct.getProductID());
                    bc.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                    try {
                        bc.insertNewBarCode(this.controller.getSettings().getConnection());
                        this.loadBarcode(this.selectedProduct);
                    }
                    catch (SQLException e) {
                        this.controller.alert("Obave\u0161tenje", "Neuspe\u0161na dodavanje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                    }
                }
            } else {
                this.controller.alert("Obave\u0161tenje", "Morate popuniti text polje", this.rootPane.getScene().getWindow());
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Selektujte proizvod", this.rootPane.getScene().getWindow());
        }
        this.selectedBarcode = null;
    }

    @FXML
    private void barcodeDelete() {
        if (this.selectedBarcode != null) {
            try {
                this.selectedBarcode.delete(this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no brisanje: " + e.getMessage(), this.rootPane.getScene().getWindow());
            }
            this.loadBarcode(this.selectedProduct);
        }
    }

    private void loadGroup() {
        try {
            this.tableGroup.setItems(ProductGroup.getListByProductID((long)((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void loadDepartment(Product product) {
        this.tableDepartment.getItems().clear();
        if (product != null) {
            ObservableList list = ProductDepartment.getListByProductId((Product)product, (Connection)this.controller.getSettings().getConnection());
            for (ProductDepartment productDepartment : list) {
                this.tableDepartment.getItems().add((java.lang.Object)productDepartment.getDepartment());
            }
        }
    }

    @FXML
    private void groupNew() {
        if (this.productTable.getSelectionModel().getSelectedItem() != null) {
            try {
                HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                hm.put("connection", this.controller.getSettings().getConnection());
                hm.put("product", this.productTable.getSelectionModel().getSelectedItem());
                hm.put("groups", new ArrayList(this.tableGroup.getItems()));
                int result = this.controller.showModalDialog("Izbor grupe", ScreensController.DIALOG_SELECT_GROUP_BACKOFFICE, hm, this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_OK) {
                    ProductGroupDetaile.insert((int)((ProductGroup)hm.get("group")).getProductGroupID(), (long)((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)this.controller.getSettings().getConnection());
                    this.loadGroup();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite proizvod. ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void departmentNew() {
        if (this.productTable.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("product", this.productTable.getSelectionModel().getSelectedItem());
            hm.put("departments", this.tableDepartment.getItems());
            int result = this.controller.showModalDialog("Izbor odeljenja", ScreensController.DIALOG_SELECT_DEPARTMENT_BACKOFFICE, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                try {
                    ProductDepartment pd = new ProductDepartment();
                    pd.setProductID(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                    pd.setSort(0);
                    pd.setActive(true);
                    pd.setFavorite(false);
                    pd.setDepartmentID(((Department)hm.get("department")).getDepartmentID());
                    pd.insert(this.controller.getSettings().getConnection());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.loadDepartment((Product)this.productTable.getSelectionModel().getSelectedItem());
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite proizvod. ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void departmentDelete() {
        if (this.productTable.getSelectionModel().getSelectedItem() != null) {
            ProductDepartment productDepartment = new ProductDepartment();
            try {
                productDepartment.setProductID(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                productDepartment.setDepartmentID(((Department)this.tableDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
                productDepartment.deleteByDepartmentID(this.controller.getSettings().getConnection());
                this.loadDepartment((Product)this.productTable.getSelectionModel().getSelectedItem());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite proizvod. ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void groupDelete() {
        try {
            if (this.controller.getSettings().isSinhorinizacija()) {
                ProductGroupDetaile.delete((int)((ProductGroup)this.tableGroup.getSelectionModel().getSelectedItem()).getProductGroupDetailsID(), (Connection)this.controller.getServerConnection());
            } else {
                ProductGroupDetaile.delete((int)((ProductGroup)this.tableGroup.getSelectionModel().getSelectedItem()).getProductGroupDetailsID(), (Connection)this.controller.getSettings().getConnection());
            }
            this.loadGroup();
        }
        catch (NullPointerException e) {
            this.controller.alert("Obave\u0161tenje", "Izaberite grupu za brisanje. ", this.rootPane.getScene().getWindow());
            e.printStackTrace();
        }
    }

    public String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public ProductDepartment getProductDepartment(long productID) {
        ProductDepartment pDepartment = null;
        for (ProductDepartment productDepartment : this.productDepartments) {
            if (productDepartment.getProduct().getProductID() != productID) continue;
            pDepartment = productDepartment;
        }
        return pDepartment;
    }

    private void loadAditionalFields() {
        this.tableAditionalFields.getItems().clear();
        this.tcAditionalFieldID.setCellValueFactory((Callback)new PropertyValueFactory("AditionalFieldID"));
        this.tcNameAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcDetailsAditionalField.setCellValueFactory(param -> {
            this.combo = new ComboBox();
            AditionalFieldDetails adi = new AditionalFieldDetails();
            adi.setAditionalFieldDetailsID(-1L);
            adi.setName("");
            this.combo.getItems().add((java.lang.Object)adi);
            if (this.controller.getSettings().isSinhorinizacija()) {
                this.combo.getItems().addAll((Collection)AditionalFieldDetails.getListByAditionalFieldID((long)((AditionalField)param.getValue()).getAditionalFieldID(), (Connection)this.controller.getServerConnection()));
            } else {
                this.combo.getItems().addAll((Collection)AditionalFieldDetails.getListByAditionalFieldID((long)((AditionalField)param.getValue()).getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection()));
            }
            for (AditionalFieldDetailsProduct afp : this.selectedProduct.getListAditionalFieldDetailsProduct()) {
                for (AditionalFieldDetails adf : this.combo.getItems()) {
                    if (afp.getAditionalFieldDetailsID() != adf.getAditionalFieldDetailsID()) continue;
                    this.combo.getSelectionModel().select((java.lang.Object)adf);
                }
            }
            this.combo.getStyleClass().clear();
            this.combo.setStyle("-fx-border-color: #7CB72A; -fx-border-width: 1px; -fx-border-style: solid;-fx-border-radius: 3px;-fx-text-fill: black;-fx-font-size: 14px;");
            this.combo.setPrefWidth(this.tcDetailsAditionalField.getPrefWidth() - 10.0);
            this.combo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<AditionalFieldDetails>(){

                public void changed(ObservableValue<? extends AditionalFieldDetails> observable, AditionalFieldDetails oldValue, AditionalFieldDetails newValue) {
                    if (ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem() != null) {
                        if (oldValue == null) {
                            if (ProductsControllerTrgovina.this.controller.getSettings().isSinhorinizacija()) {
                                ObservableList list = AditionalFieldDetailsProduct.getListByProductID((long)((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                if (!list.isEmpty()) {
                                    for (AditionalFieldDetailsProduct afp : list) {
                                        if (afp.getAditionalFieldID() == ((AditionalField)param.getValue()).getAditionalFieldID()) continue;
                                        afp.setProductID(((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                                        afp.setAditionalFieldID(((AditionalField)param.getValue()).getAditionalFieldID());
                                        afp.setAditionalFieldDetailsID(newValue.getAditionalFieldDetailsID());
                                        afp.insert(ProductsControllerTrgovina.this.controller.getServerConnection());
                                        break;
                                    }
                                } else {
                                    AditionalFieldDetailsProduct afp = new AditionalFieldDetailsProduct();
                                    afp.setProductID(((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                                    afp.setAditionalFieldID(((AditionalField)param.getValue()).getAditionalFieldID());
                                    afp.setAditionalFieldDetailsID(newValue.getAditionalFieldDetailsID());
                                    afp.insert(ProductsControllerTrgovina.this.controller.getServerConnection());
                                    if (ProductsControllerTrgovina.this.controller.getSettings().isSinhorinizacija()) {
                                        ((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductBySysDTEdit(ProductsControllerTrgovina.this.controller.getServerConnection());
                                    } else {
                                        ((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductBySysDTEdit(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                    }
                                }
                            } else {
                                ObservableList list = AditionalFieldDetailsProduct.getListByProductID((long)((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                if (!list.isEmpty()) {
                                    for (AditionalFieldDetailsProduct afp : list) {
                                        if (afp.getAditionalFieldID() == ((AditionalField)param.getValue()).getAditionalFieldID()) continue;
                                        afp.setProductID(((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                                        afp.setAditionalFieldID(((AditionalField)param.getValue()).getAditionalFieldID());
                                        afp.setAditionalFieldDetailsID(newValue.getAditionalFieldDetailsID());
                                        afp.insert(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                        if (ProductsControllerTrgovina.this.controller.getSettings().isSinhorinizacija()) {
                                            ((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductBySysDTEdit(ProductsControllerTrgovina.this.controller.getServerConnection());
                                        } else {
                                            ((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductBySysDTEdit(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                        }
                                        break;
                                    }
                                } else {
                                    AditionalFieldDetailsProduct afp = new AditionalFieldDetailsProduct();
                                    afp.setProductID(((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                                    afp.setAditionalFieldID(((AditionalField)param.getValue()).getAditionalFieldID());
                                    afp.setAditionalFieldDetailsID(newValue.getAditionalFieldDetailsID());
                                    afp.insert(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                    if (ProductsControllerTrgovina.this.controller.getSettings().isSinhorinizacija()) {
                                        ((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductBySysDTEdit(ProductsControllerTrgovina.this.controller.getServerConnection());
                                    } else {
                                        ((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).updateProductBySysDTEdit(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                    }
                                }
                            }
                        } else {
                            for (AditionalFieldDetailsProduct afp : AditionalFieldDetailsProduct.getListByProductID((long)((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)ProductsControllerTrgovina.this.controller.getSettings().getConnection())) {
                                if (afp.getAditionalFieldID() != ((AditionalField)param.getValue()).getAditionalFieldID() || oldValue == null) continue;
                                if (newValue.getAditionalFieldDetailsID() == -1L) {
                                    if (oldValue.getAditionalFieldDetailsID() != afp.getAditionalFieldDetailsID()) continue;
                                    afp.setAditionalFieldDetailsID(oldValue.getAditionalFieldDetailsID());
                                    afp.setProductID(((Product)ProductsControllerTrgovina.this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                                    afp.deleteByComboBox(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                                    continue;
                                }
                                afp.setAditionalFieldDetailsID(newValue.getAditionalFieldDetailsID());
                                afp.setAditionalFieldDetailsProductID(afp.getAditionalFieldDetailsProductID());
                                afp.update(ProductsControllerTrgovina.this.controller.getSettings().getConnection());
                            }
                        }
                        Settings.startInfoAnimation((String)"Sa\u010duvana izmena", (Label)ProductsControllerTrgovina.this.labelInfoAditionalField, (int)3, (int)14);
                    }
                }
            });
            return new SimpleObjectProperty(this.combo);
        });
        try {
            this.tableAditionalFields.setItems(AditionalField.getList((Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void loadExciseField() {
        this.clearExciseField();
        if (this.selectedProduct != null) {
            ExciseProduct exciseProduct = this.controller.getSettings().isSinhorinizacija() ? ExciseProduct.getByProductId((Connection)this.controller.getServerConnection(), (long)this.selectedProduct.getProductID()) : ExciseProduct.getByProductId((Connection)this.controller.getSettings().getConnection(), (long)this.selectedProduct.getProductID());
            if (exciseProduct != null && !this.lista.isEmpty()) {
                for (Excise excise : this.cbExcise.getItems()) {
                    if (exciseProduct.getExciseId() != excise.getExciseId()) continue;
                    this.cbExcise.getSelectionModel().select((java.lang.Object)excise);
                    this.lblExciseValue.setText(String.valueOf(excise.getValue()));
                    this.tfJedinicaMere.setText(String.valueOf(exciseProduct.getValue()));
                    this.lblExciseValueByJM.setText(String.valueOf(Settings.round((double)(excise.getValue() * exciseProduct.getValue() / 1.0), (int)2)));
                }
            }
        } else {
            this.fillExciseComboBox();
        }
    }

    private void clearExciseField() {
        this.cbExcise.getSelectionModel().select(0);
        this.lblExciseValue.setText("");
        this.tfJedinicaMere.setText("");
        this.lblExciseValueByJM.setText("");
    }

    private void fillExciseComboBox() {
        this.cbExcise.getItems().clear();
        this.lista = Excise.getList((ScreensController)this.controller, (String)"");
        Excise excise = new Excise();
        excise.setExciseId(-1L);
        excise.setName("Bez akcize");
        this.cbExcise.getItems().add((java.lang.Object)excise);
        for (Excise exc : this.lista) {
            this.cbExcise.getItems().add((java.lang.Object)exc);
        }
        this.cbExcise.getSelectionModel().select((java.lang.Object)excise);
    }

    private void saveExcise(Product product) {
        if (this.controller.getSettings().isSinhorinizacija()) {
            if (((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId() != -1L) {
                if (product != null) {
                    ExciseProduct exciseProduct = ExciseProduct.getByProductId((Connection)this.controller.getServerConnection(), (long)product.getProductID());
                    if (exciseProduct != null) {
                        if (this.selectedExcise.getExciseId() == -1L) {
                            exciseProduct.delete(this.controller.getServerConnection());
                        } else {
                            exciseProduct.setExciseId(((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId());
                            exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                            exciseProduct.update(this.controller.getServerConnection());
                        }
                    } else {
                        exciseProduct = new ExciseProduct();
                        exciseProduct.setExciseId(this.selectedExcise.getExciseId());
                        exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                        exciseProduct.setProductId(product.getProductID());
                        exciseProduct.insert(this.controller.getServerConnection());
                    }
                }
                this.selectedExcise = null;
                this.clearExciseField();
            }
        } else if (((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId() != -1L) {
            if (product != null) {
                ExciseProduct exciseProduct = ExciseProduct.getByProductId((Connection)this.controller.getSettings().getConnection(), (long)product.getProductID());
                if (exciseProduct != null) {
                    if (this.selectedExcise.getExciseId() == -1L) {
                        exciseProduct.delete(this.controller.getSettings().getConnection());
                    } else {
                        exciseProduct.setExciseId(((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId());
                        exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                        exciseProduct.update(this.controller.getSettings().getConnection());
                    }
                } else {
                    exciseProduct = new ExciseProduct();
                    exciseProduct.setExciseId(this.selectedExcise.getExciseId());
                    exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                    exciseProduct.setProductId(product.getProductID());
                    exciseProduct.insert(this.controller.getSettings().getConnection());
                }
            }
            this.selectedExcise = null;
            this.clearExciseField();
        }
    }

    @FXML
    private void cbTipArtiklaChange() {
        this.fillProductTable();
    }

    @FXML
    private void cbGrupaArtiklaChange() {
        this.fillProductTable();
    }

    private void loadBarcodeObject() {
        if (this.controller.getSettings().isSinhorinizacija()) {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).setBarcodeObject(((Product)this.productTable.getSelectionModel().getSelectedItem()).getBarcodeByProductID(this.controller.getServerConnection()));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).setBarcodeObject(((Product)this.productTable.getSelectionModel().getSelectedItem()).getBarcodeByProductID(this.controller.getSettings().getConnection()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void loadAditionalFieldDetails() {
        if (this.controller.getSettings().isSinhorinizacija()) {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID((long)((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)this.controller.getServerConnection()));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID((long)((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID(), (Connection)this.controller.getSettings().getConnection()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void loadCurrentPriceAndNabavnaCena() {
        if (this.controller.getSettings().isSinhorinizacija()) {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).getCurrentPrice((long)this.controller.getObject().getDepartment(this.controller.getObject().getObjectID(), this.controller.getServerConnection()).getDepartmentID(), this.controller.getServerConnection());
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).getNabavnaCena(this.controller.getServerConnection());
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).getCurrentPrice((long)this.controller.getObject().getDepartment(this.controller.getObject().getObjectID(), this.controller.getSettings().getConnection()).getDepartmentID(), this.controller.getSettings().getConnection());
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).getNabavnaCena(this.controller.getSettings().getConnection());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @FXML
    private void filterAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int res = this.controller.showModalDialog("Filtriraj", ScreensController.DIALOG_FILTER_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (res == ScreensController.MODAL_RESULT_OK) {
            this.departmentIDS = (String)hm.get("departmentIDS");
            this.pointOfSaleIDS = (String)hm.get("pointOfSaleIDS");
            this.productTypeIDS = (String)hm.get("productTypeIDS");
            this.productCategoryIDS = (String)hm.get("productCategoryIDS");
            this.aditionalFiledIDS = (String)hm.get("aditionalFiledIDS");
            this.aditionalFiledDetailsIDS = (String)hm.get("aditionalFiledDetailsIDS");
            this.vatIDS = (String)hm.get("vatIDS");
            this.active = (Boolean)hm.get("active");
            this.popustDozvoljen = (String)hm.get("popustDozvoljen");
            this.merljiv = (String)hm.get("merljiv");
            this.tezinski = (String)hm.get("tezinski");
            this.fillProductTable();
        }
    }

    private void fillProductTable() {
        this.productTable.getSelectionModel().clearSelection();
        this.productList = Product.getNewFilteredList((String)(this.departmentIDS.equals("") ? "-1" : this.departmentIDS.substring(0, this.departmentIDS.length() - 1)), (String)(this.pointOfSaleIDS.equals("") ? "-1" : this.pointOfSaleIDS.substring(0, this.pointOfSaleIDS.length() - 1)), (String)(this.productTypeIDS.equals("") ? "-1" : this.productTypeIDS.substring(0, this.productTypeIDS.length() - 1)), (String)(this.productCategoryIDS.equals("") ? "-1" : this.productCategoryIDS.substring(0, this.productCategoryIDS.length() - 1)), (String)(this.aditionalFiledIDS.equals("") ? "-1" : this.aditionalFiledIDS.substring(0, this.aditionalFiledIDS.length() - 1)), (String)(this.aditionalFiledDetailsIDS.equals("") ? "-1" : this.aditionalFiledDetailsIDS.substring(0, this.aditionalFiledDetailsIDS.length() - 1)), (String)(this.vatIDS.equals("") ? "-1" : this.vatIDS.substring(0, this.vatIDS.length() - 1)), (boolean)this.active, (String)this.popustDozvoljen, (String)this.merljiv, (String)this.tezinski, (ScreensController)this.controller);
        this.productTable.setItems(this.productList);
        this.filter();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.productTable.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(product -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                if (product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (product.getBarcode() != null && product.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (product.getCode() != null && product.getCode().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            } else if (((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_NAZIV) ? product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter) : (((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE) ? product.getBarcode() != null && product.getBarcode().toLowerCase().startsWith(lowerCaseFilter) : ((String)this.cbFilterType.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) && product.getCode() != null && product.getCode().toLowerCase().startsWith(lowerCaseFilter))) {
                return true;
            }
            return false;
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.productTable.comparatorProperty());
        this.productTable.setItems((ObservableList)sortedData);
    }
}

