/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.lang.time.DateFormatUtils;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentRecord;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.Otpis;
import rs.petcom.master.dal.document.OtpisDetailes;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.document.PrijemnicaDetailes;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonVatType;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.gui.AutoCompleteComboBoxListenerNew;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class PrijemnicaDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    Connection connection;
    Prijemnica prijemnica;
    int modalResult;
    boolean napomenaVidljiva;
    ArrayList<PrijemnicaDetailes> deletedItems;
    ObservableList<PrijemnicaDetailes> prijemniceDetailsList = FXCollections.observableArrayList();
    ObservableList<PrijemnicaDetailes> data = FXCollections.observableArrayList();
    ObservableList<OtpisDetailes> prijemniceDetailsOtpisList = FXCollections.observableArrayList();
    ArrayList<Product> productList;
    Object objekat;
    Department department;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    Product selectedProduct;
    PrijemnicaDetailes pd = new PrijemnicaDetailes();
    ComboBoxCellFactory cbCellFactory;
    double ukupno = 0.0;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gpNapomena;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfExternalNumber;
    @FXML
    private TextField tfPlace;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfNabavnaCena;
    @FXML
    private TextField tfNabavnaCenaSaPDVom;
    @FXML
    private TextField tfUkupnaNabavnaCena;
    @FXML
    private TextField tfUkupnaNabavnaCenaSaPDVom;
    @FXML
    private TextField tfRabat;
    @FXML
    private TextField tfSellPrice;
    @FXML
    private TextField tfMargin;
    @FXML
    private TextField tfDependentExpenses;
    @FXML
    private Label labelNapomena;
    @FXML
    private Label lblSumQuantity;
    @FXML
    private Label lblSum;
    @FXML
    private Label lblSumWithDiscount;
    @FXML
    private Label lblSumWithVat;
    @FXML
    private Label lblSumSellPrice;
    @FXML
    private DateTimePicker dpDeliveryDate;
    @FXML
    private DateTimePicker dpCurrencyDate;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private ComboBox<DocumentStatus> cbStatus;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnNapomena;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnSacuvaj;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnImportCsv;
    @FXML
    private Button btnSacuvajNovo;
    @FXML
    private Button btnNoviProizvod;
    @FXML
    private TextArea taNapomena;
    @FXML
    private TableView<PrijemnicaDetailes> tablePrijemniceDetails;
    @FXML
    private TableColumn<java.lang.Object, Product> tcProduct;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPurchasePriceWithoutRabat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSellPrice;
    @FXML
    private TableColumn<java.lang.Object, Double> tcMargin;
    @FXML
    private TableColumn<PrijemnicaDetailes, String> tcJedinicaMere;
    @FXML
    private TableColumn<PrijemnicaDetailes, Product> tcVat;
    @FXML
    private CheckBox cbPaid;
    private String oldValuePurchasePriceWithPdv;
    private String oldValuePurchasePrice;
    private String oldValuePurchaseValueWithPdv;
    private String oldValuePurchaseValue;
    private SimpleDateFormat sdf;
    private Date date2;
    private String[] oldFieldValues;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.deletedItems = new ArrayList();
        this.btnRemove.setDisable(false);
        this.controller = (ScreensController)parameter.get("controller");
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.connection = this.controller.getSettings().getConnection();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.oldFieldValues = new String[5];
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        new AutoCompleteComboBoxListenerNew(this.cbPerson);
        this.cbStatus.setItems(DocumentStatus.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbStatus.setOnKeyPressed(event -> {
            if (event.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                // empty if block
            }
        });
        this.cbFilter.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilter.getSelectionModel().selectFirst();
        this.cbFilter.setOnAction(actionEvent -> {
            this.cbProductAutoComplete.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
            this.cbCellFactory.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
        });
        this.objekat = (Object)parameter.get("object");
        this.department = (Department)parameter.get("department");
        this.prijemnica = (Prijemnica)parameter.get("prijemnica");
        if (this.prijemnica.getDocumentID() < 1L) {
            this.dpDeliveryDate.valueProperty().addListener((observable, oldDate, newDate) -> {
                if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                    this.dpDeliveryDate.setValue((java.lang.Object)this.lastDocumentLockDate.plusDays(1L));
                    this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
                }
                this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)1, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDeliveryDate.getValue()))));
            });
            this.tfExternalNumber.setDisable(true);
        }
        this.tfNumber.focusedProperty().addListener((ov, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.giveErrorMessageIfNumberExsists();
            }
        });
        this.tfExternalNumber.focusedProperty().addListener((ov, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.giveErrorMessageIfExternalNumberExsists();
            }
        });
        if (this.objekat.getObjectVatTypeID() == 2) {
            this.tfNabavnaCena.setDisable(true);
            this.tfUkupnaNabavnaCena.setDisable(true);
        }
        this.tfNumber.setText(String.valueOf(this.prijemnica.getNumber()));
        this.tfExternalNumber.setText(this.prijemnica.getExternalNumber());
        this.dpDeliveryDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.prijemnica.getDeliveryDate()));
        this.dpCurrencyDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.prijemnica.getPaymentDate()));
        this.setDobavljac(this.prijemnica.getDobavljac());
        this.tfPlace.setText(this.prijemnica.getPlace());
        this.setStatus(this.prijemnica.getDocumentStatus());
        this.tfPlace.setText(this.objekat.getName());
        this.tfPlace.setEditable(false);
        this.taNapomena.setText(this.prijemnica.getComment());
        if (this.prijemnica.isRealized()) {
            this.cbPaid.setSelected(this.prijemnica.isRealized());
            this.cbPaid.setDisable(this.prijemnica.isRealized());
        }
        this.date2 = new Date();
        this.sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String dateDDString = this.sdf.format(this.date2);
            this.date2 = this.sdf.parse(dateDDString);
            if (this.sdf.parse(DateFormatUtils.format((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())), (String)"yyyy-MM-dd")).before(this.date2)) {
                this.tfSellPrice.setEditable(false);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.dpDeliveryDate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    Date date1 = PrijemnicaDetailesControllerTrgovina.this.sdf.parse(DateFormatUtils.format((Date)Settings.fromLocalDate((LocalDate)((LocalDate)PrijemnicaDetailesControllerTrgovina.this.dpDeliveryDate.getValue())), (String)"yyyy-MM-dd"));
                    String dateDDString = PrijemnicaDetailesControllerTrgovina.this.sdf.format(PrijemnicaDetailesControllerTrgovina.this.date2);
                    PrijemnicaDetailesControllerTrgovina.this.date2 = PrijemnicaDetailesControllerTrgovina.this.sdf.parse(dateDDString);
                    if (date1.before(PrijemnicaDetailesControllerTrgovina.this.date2)) {
                        PrijemnicaDetailesControllerTrgovina.this.tfSellPrice.setEditable(false);
                        LocalDateTime dateTime = WorkDay.getKrajaDanaZaDatum((Date)Settings.fromLocalDate((LocalDate)((LocalDate)PrijemnicaDetailesControllerTrgovina.this.dpDeliveryDate.getValue())), (int)1, (ScreensController)PrijemnicaDetailesControllerTrgovina.this.controller);
                        PrijemnicaDetailesControllerTrgovina.this.prijemniceDetailsList.clear();
                        for (PrijemnicaDetailes prijemnicaDetailes : PrijemnicaDetailesControllerTrgovina.this.tablePrijemniceDetails.getItems()) {
                            double cena = PriceListDetailes.getPreviousPrice((long)1L, (long)prijemnicaDetailes.getProductID(), (Date)(dateTime != null ? Settings.DatefromLocalDateTime((LocalDateTime)dateTime) : new Date()), (Connection)PrijemnicaDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                            if (cena == 0.0) {
                                cena = prijemnicaDetailes.getNewSellPrice();
                            }
                            prijemnicaDetailes.setNewSellPrice(cena);
                            prijemnicaDetailes.setSellPrice(prijemnicaDetailes.getNewSellPrice());
                            PrijemnicaDetailesControllerTrgovina.this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetailes);
                        }
                        PrijemnicaDetailesControllerTrgovina.this.loadDetails();
                    } else {
                        PrijemnicaDetailesControllerTrgovina.this.tfSellPrice.setEditable(false);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfDependentExpenses.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.prijemnica.getDependentExpenses()));
        this.tfDependentExpenses.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfDependentExpenses.setText(Settings.getNumberFormat((int)2, (boolean)true).parse(this.tfDependentExpenses.getText()).doubleValue() + "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfDependentExpenses.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.length() > 0 && newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfDependentExpenses.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
        });
        if (this.prijemnica.getDocumentID() > 0L && LocalDateTime.now().getDayOfYear() > Settings.LocalDateTimefromDate((Date)this.prijemnica.getDate()).getDayOfYear()) {
            this.tcSellPrice.setEditable(false);
            this.tcMargin.setEditable(false);
            this.cbProduct.setDisable(false);
        }
        if (this.prijemnica.getDocumentID() > 0L) {
            this.cbProduct.setDisable(false);
            this.tfExternalNumber.setDisable(false);
        }
        this.pd = new PrijemnicaDetailes();
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, this.department, (String)this.cbFilter.getSelectionModel().getSelectedItem());
        this.tcProduct.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcProduct.setCellFactory((Callback)this.cbCellFactory);
        this.tcProduct.setOnEditCommit(cellEditEvent -> {
            Product selectedTableProduct = (Product)cellEditEvent.getNewValue();
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTableProduct.getCurrentPrice((long)this.department.getDepartmentID(), this.controller.getSettings().getConnection());
            selectedTableProduct.getNabavnaCena(this.controller.getSettings().getConnection());
            selectedTablePrij.setProduct(selectedTableProduct);
            selectedTablePrij.setProductID(selectedTableProduct.getProductID());
            selectedTablePrij.setProductCode(selectedTableProduct.getCode());
            selectedTablePrij.setProductName(selectedTableProduct.getName());
            selectedTablePrij.setSellPrice(selectedTableProduct.getPrice());
            selectedTablePrij.setNewSellPrice(selectedTableProduct.getPrice());
            selectedTablePrij.setMargin(selectedTablePrij.getPriceWithDiscount() > 0.0 ? (selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0 : (selectedTablePrij.getNewSellPrice() - this.selectedProduct.getNabavnaCena()) / this.selectedProduct.getNabavnaCena() * 100.0);
            selectedTablePrij.setPurchasePrice(selectedTableProduct.getNabavnaCena());
            selectedTablePrij.setVat(selectedTableProduct.getVatValue());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.tcJedinicaMere.setCellValueFactory((Callback)new PropertyValueFactory("jedinicaMere"));
        this.cbPerson.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PrijemnicaDetailesControllerTrgovina.this.cbPerson.getSelectionModel().getSelectedIndex() != -1) {
                    PrijemnicaDetailesControllerTrgovina.this.cbProduct.setDisable(false);
                    PrijemnicaDetailesControllerTrgovina.this.tfExternalNumber.setDisable(false);
                } else {
                    PrijemnicaDetailesControllerTrgovina.this.cbProduct.setDisable(true);
                    PrijemnicaDetailesControllerTrgovina.this.tfExternalNumber.setDisable(true);
                }
            }
        });
        this.cbPerson.valueProperty().addListener((observable, oldPersonValue, newPersonValue) -> this.editVat((Person)newPersonValue));
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.selectedProduct = Product.getByID((long)((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID(), (ScreensController)this.controller);
            }
            try {
                LocalDateTime dateTime = WorkDay.getKrajaDanaZaDatum((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())), (int)1, (ScreensController)this.controller);
                this.selectedProduct.setPrice(PriceListDetailes.getPreviousPrice((long)1L, (long)this.selectedProduct.getProductID(), (Date)(dateTime != null ? Settings.DatefromLocalDateTime((LocalDateTime)dateTime) : Settings.DatefromLocalDateTime((LocalDateTime)LocalDateTime.now())), (Connection)this.controller.getSettings().getConnection()));
                this.selectedProduct.getPurchacePricePrijemnica(this.controller.getSettings().getConnection());
                this.pd.setProduct(Product.getByID((long)this.selectedProduct.getProductID(), (ScreensController)this.controller));
                this.pd.setProductID(this.selectedProduct.getProductID());
                this.pd.setProductCode(this.pd.getProduct().getCode());
                this.pd.setProductName(this.pd.getProduct().getName());
                this.pd.setSellPrice(this.selectedProduct.getPrice());
                this.pd.setNewSellPrice(this.selectedProduct.getPrice());
                Vat vat = this.getVatForPrijemnica(((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())).getPersonVatTypeID());
                if ("\u0402".equalsIgnoreCase(vat.getCode())) {
                    this.pd.setVat(this.selectedProduct.getVatValue() == 0.0 ? 1.0 : this.selectedProduct.getVatValue());
                } else {
                    this.pd.getProduct().setVatID(vat.getVatID());
                    this.pd.setVat(vat.getValue());
                }
                this.pd.setJedinicaMere(Unit.getUnitById((int)this.selectedProduct.getUnitID(), (Connection)this.controller.getSettings().getConnection()).getCode());
                if (this.selectedProduct.getPurchacePrice() != 0.0) {
                    this.pd.setPurchasePriceWithoutRabat(this.selectedProduct.getPurchacePrice());
                    this.pd.setPurchasePrice(this.selectedProduct.getPurchacePrice());
                    this.pd.setPrice(this.selectedProduct.getPurchacePrice() * this.pd.getVat());
                    this.pd.setPriceWithDiscount(this.pd.getPrice() - this.pd.getPrice() * this.pd.getDiscount() / 100.0);
                }
                this.pd.setMargin(this.pd.getPriceWithDiscount() > 0.0 ? (this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0 : (this.pd.getNewSellPrice() - this.selectedProduct.getNabavnaCena()) / this.selectedProduct.getNabavnaCena() * 100.0);
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPurchasePriceWithoutRabat()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPriceWithDiscount()));
                this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.selectedProduct.getPrice()));
                this.tfMargin.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getMargin()));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), (String)this.cbFilter.getSelectionModel().getSelectedItem(), this.tfQuantity);
        this.prijemniceDetailsList = PrijemnicaDetailes.getlist((Prijemnica)this.prijemnica, (long)this.department.getDepartmentID(), (ScreensController)this.controller);
        LocalDateTime dateTime = WorkDay.getKrajaDanaZaDatum((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())), (int)1, (ScreensController)this.controller);
        for (PrijemnicaDetailes prijemnicaDetailes : this.prijemniceDetailsList) {
            if (!(prijemnicaDetailes.getQuantity() > 0.0)) continue;
            prijemnicaDetailes.setSellPrice(PriceListDetailes.getPreviousPrice((long)1L, (long)prijemnicaDetailes.getProductID(), (Date)(dateTime != null ? Settings.DatefromLocalDateTime((LocalDateTime)dateTime) : Settings.DatefromLocalDateTime((LocalDateTime)LocalDateTime.now())), (Connection)this.controller.getSettings().getConnection()));
            this.tablePrijemniceDetails.getItems().add((java.lang.Object)prijemnicaDetailes);
        }
        this.calculateSum();
        this.tfQuantity.setText("");
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && PrijemnicaDetailesControllerTrgovina.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    PrijemnicaDetailesControllerTrgovina.this.cbProduct.requestFocus();
                }
                if (event.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    event.consume();
                    try {
                        PrijemnicaDetailesControllerTrgovina.this.pd.setQuantity(Settings.getNumberFormat((int)4, (boolean)true).parse(PrijemnicaDetailesControllerTrgovina.this.tfQuantity.getText().trim()).doubleValue());
                        PrijemnicaDetailesControllerTrgovina.this.actionAddPrijemnicaDetails(null);
                        PrijemnicaDetailesControllerTrgovina.this.tfQuantity.setText("");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.tfQuantity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getQuantity()) + "");
            }
        });
        this.tfQuantity.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (this.tfQuantity.isFocused()) {
                    this.pd.setQuantity(Settings.getNumberFormat((int)4, (boolean)true).parse(this.tfQuantity.getText().trim()).doubleValue());
                }
                if (newValue.length() > 0) {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        this.tfQuantity.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (!this.tfNabavnaCena.getText().equals("0,0000")) {
                        this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                        this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumPurchasePrice()));
                        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumWithVat()));
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.izracunajUkupno();
        });
        this.tfNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfNabavnaCena.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfNabavnaCena.getText().equals("")) {
                keyEvent.consume();
                this.tfQuantity.requestFocus();
            }
        });
        this.tfNabavnaCena.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            System.out.println(this.oldValuePurchasePrice + "Nesaaa");
            if (oldValue.booleanValue()) {
                try {
                    this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCena.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfNabavnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfNabavnaCena.isFocused()) {
                this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
                if (newValue.isEmpty()) {
                    this.pd.setPurchasePriceWithoutRabat(0.0);
                } else {
                    this.pd.setPurchasePriceWithoutRabat(Double.parseDouble(newValue.replace(",", ".")));
                }
                this.pd.setPurchasePrice(this.pd.getPurchasePriceWithoutRabat());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfNabavnaCenaSaPDVom.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfNabavnaCenaSaPDVom.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfNabavnaCenaSaPDVom.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCena.requestFocus();
            }
        });
        this.tfNabavnaCenaSaPDVom.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            if (oldValue.booleanValue()) {
                try {
                    this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPurchasePriceWithoutRabat() * this.pd.getVat()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCenaSaPDVom.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.isEmpty() && newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfNabavnaCenaSaPDVom.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
            if (this.tfNabavnaCenaSaPDVom.isFocused()) {
                if (!newValue.isEmpty()) {
                    this.pd.setPrice(Double.parseDouble(newValue.replace(",", ".")));
                    this.pd.setPriceWithDiscount(Double.parseDouble(newValue.replace(",", ".")));
                } else {
                    this.pd.setPrice(0.0);
                    this.pd.setPriceWithDiscount(0.0);
                }
                this.pd.setPurchasePriceWithoutRabat(this.pd.getPrice() / this.pd.getVat());
                this.pd.setPurchasePrice(this.pd.getPrice() / this.pd.getVat());
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfUkupnaNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCena.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfUkupnaNabavnaCena.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfUkupnaNabavnaCena.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            if (oldValue.booleanValue()) {
                try {
                    this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupnaNabavnaCena.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.tfUkupnaNabavnaCena.isFocused()) {
                if (!newValue.isEmpty()) {
                    this.pd.setSumPurchasePrice(Double.parseDouble(newValue.replace(".", "").replace(",", ".")));
                } else {
                    this.pd.setSumPurchasePrice(0.0);
                }
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setSumWithVat(this.pd.getSumPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfUkupnaNabavnaCenaSaPDVom.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCenaSaPDVom.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfUkupnaNabavnaCenaSaPDVom.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfUkupnaNabavnaCenaSaPDVom.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            if (oldValue.booleanValue()) {
                try {
                    this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupnaNabavnaCenaSaPDVom.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.tfUkupnaNabavnaCenaSaPDVom.isFocused()) {
                if (!newValue.isEmpty()) {
                    this.pd.setSumWithVat(Double.parseDouble(newValue.replace(".", "").replace(",", ".")));
                } else {
                    this.pd.setSumWithVat(0.0);
                }
                this.pd.setSumPurchasePrice(this.pd.getSumWithVat() / this.pd.getVat());
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getSumPurchasePrice()));
            }
            this.izracunajUkupno();
        });
        this.tfRabat.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfRabat.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfRabat.getText().equals("")) {
                keyEvent.consume();
                this.tfUkupnaNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfRabat.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                System.out.println("usao u fokus");
                this.tfRabat.setText("0");
            }
            if (oldValue.booleanValue()) {
                try {
                    this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getDiscount()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfRabat.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfRabat.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfRabat.isFocused()) {
                this.pd.setDiscount(Double.parseDouble(newValue.replace(",", ".")));
            }
            this.izracunajUkupno();
        });
        this.tfSellPrice.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSellPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.length() >= 2 && newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfSellPrice.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfSellPrice.isFocused()) {
                    this.pd.setNewSellPrice(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                    this.izracunajMarzu();
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSellPrice.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getNewSellPrice()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfMargin.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfMargin.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfMargin.isFocused()) {
                    this.pd.setMargin(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                    this.izracunajProdajnuCenu();
                }
            }
            catch (StringIndexOutOfBoundsException | ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfMargin.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfMargin.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getMargin()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfRabat.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.cbProduct.requestFocus();
                this.actionAddPrijemnicaDetails(null);
                keyEvent.consume();
            }
        });
        this.deletedItems.clear();
        this.taNapomena.setText(this.prijemnica.getComment());
        this.taNapomena.setFocusTraversable(false);
        this.btnSacuvaj.setFocusTraversable(false);
        this.btnOdustani.setFocusTraversable(false);
        this.btnAdd.setFocusTraversable(false);
        this.btnRemove.setFocusTraversable(false);
        this.btnImportCsv.setFocusTraversable(false);
        this.tfPlace.setFocusTraversable(false);
        this.btnSacuvajNovo.setFocusTraversable(false);
        this.btnNoviProizvod.setFocusTraversable(false);
        this.tablePrijemniceDetails.setFocusTraversable(false);
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionNewPerson(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", PersonCategory.SUPPLIER);
        String title = PersonCategory.SUPPLIER.equals("Firma") ? "Kreiranje novog kupca" : "Kreiranje novog dobavlja\u010da";
        this.controller.showModalDialog(title, ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
    }

    public void initialize() {
        this.napomenaVidljiva = true;
        this.toggleNapomena(null);
        this.calculateSum();
        Platform.runLater(() -> this.btnSacuvaj.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvaj.fire()));
        Platform.runLater(() -> this.btnSacuvajNovo.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvajNovo.fire()));
        Platform.runLater(() -> this.btnNoviProizvod.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnNoviProizvod.fire()));
        this.tfFilter.textProperty().addListener((obs, oldValue, newValue) -> this.loadDetails());
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        DoubleTableCellFactory cellFactory2 = new DoubleTableCellFactory(2, true);
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit(cellEditEvent -> {
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSumWithVat(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcQuantity);
        this.tcPurchasePriceWithoutRabat.setCellValueFactory((Callback)new PropertyValueFactory("PurchasePrice"));
        this.tcPurchasePriceWithoutRabat.setCellFactory((Callback)cellFactory2);
        this.tcPurchasePriceWithoutRabat.setOnEditCommit(cellEditEvent -> {
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setPurchasePriceWithoutRabat(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPurchasePrice(selectedTablePrij.getPurchasePriceWithoutRabat() - selectedTablePrij.getPurchasePriceWithoutRabat() * selectedTablePrij.getDiscount() / 100.0);
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSumWithVat(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            selectedTablePrij.setMargin((selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcPurchasePriceWithoutRabat);
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory2);
        this.tcDiscount.setOnEditCommit(cellEditEvent -> {
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPurchasePrice(selectedTablePrij.getPurchasePriceWithoutRabat() - selectedTablePrij.getPurchasePriceWithoutRabat() * selectedTablePrij.getDiscount() / 100.0);
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSumWithVat(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            selectedTablePrij.setMargin((selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcDiscount);
        this.tcSumWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcSumWithDiscount.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithDiscount);
        this.tcVat.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcVat.setCellFactory((Callback)new Callback<TableColumn<PrijemnicaDetailes, Product>, TableCell<PrijemnicaDetailes, Product>>(){

            public TableCell<PrijemnicaDetailes, Product> call(TableColumn<PrijemnicaDetailes, Product> param) {
                return new TableCell<PrijemnicaDetailes, Product>(){

                    protected void updateItem(Product item, boolean arg1) {
                        super.updateItem((java.lang.Object)item, arg1);
                        if (item == null) {
                            this.setText(null);
                        } else if (item.getVatID() != 2000) {
                            this.setText(Vat.getById((int)item.getVatID(), (Connection)PrijemnicaDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getName());
                        } else {
                            this.setText("8%");
                        }
                    }
                };
            }
        });
        this.makeHeaderWrappable(this.tcVat);
        this.tcSumWithVat.setCellValueFactory((Callback)new PropertyValueFactory("SumWithVat"));
        this.tcSumWithVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithVat);
        this.tcSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("NewSellPrice"));
        this.tcSellPrice.setCellFactory((Callback)cellFactory2);
        this.tcSellPrice.setOnEditCommit(cellEditEvent -> {
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setNewSellPrice(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setMargin((selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcSellPrice);
        this.tcMargin.setCellValueFactory((Callback)new PropertyValueFactory("Margin"));
        this.tcMargin.setCellFactory((Callback)cellFactory2);
        this.tcMargin.setOnEditCommit(cellEditEvent -> {
            PrijemnicaDetailes selectedTablePrij = (PrijemnicaDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setMargin(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setNewSellPrice(selectedTablePrij.getPriceWithDiscount() / 100.0 * selectedTablePrij.getMargin() + selectedTablePrij.getPriceWithDiscount());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void actionSave(ActionEvent event) {
        this.tfExternalNumber.requestFocus();
        try {
            if (this.prijemnica.getDocumentID() == -1L && Prijemnica.exists((String)this.tfExternalNumber.getText(), (Person)((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())), (Connection)this.controller.getSettings().getConnection())) {
                this.controller.alert("Prijemnica ve\u0107 postoji", "Prijemnica sa unetim brojem i odabranim komitentom ve\u0107 postoji", this.rootPane.getScene().getWindow());
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.controller.alert("Obavestenje", "Morate odabrati komitenta", this.rootPane.getScene().getWindow());
            return;
        }
        try {
            this.calculateSum();
            if (this.prijemnica.existsNumber(this.tfNumber.getText(), this.prijemnica.getDate(), this.controller.getSettings().getConnection()) && this.prijemnica.getDocumentID() <= 0L) {
                this.controller.alert("Obavestenje", "Broj prijemnice vec postoji u bazi, molim Vas da ga izmenite", this.rootPane.getScene().getWindow());
                return;
            }
            this.prijemnica.setNumber(Integer.parseInt(this.tfNumber.getText()));
            this.controller.getSettings().getConnection().setAutoCommit(false);
            LocalDateTime dateTime = LocalDateTime.of((LocalDate)this.dpDeliveryDate.getValue(), LocalTime.now());
            this.prijemnica.setDeliveryDate(Settings.DatefromLocalDateTime((LocalDateTime)dateTime));
            this.prijemnica.setDate(this.prijemnica.getDeliveryDate());
            this.prijemnica.setPaymentDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpCurrencyDate.getDateTimeValue()));
            try {
                this.prijemnica.setDobavljac((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.controller.alert("Obavestenje", "Morate odabrati dobavljaca", this.rootPane.getScene().getWindow());
            }
            this.prijemnica.setPlace(this.tfPlace.getText());
            this.prijemnica.setDocumentStatus((DocumentStatus)this.cbStatus.getSelectionModel().getSelectedItem());
            this.prijemnica.setComment(this.taNapomena.getText());
            this.prijemnica.setExternalNumber(this.tfExternalNumber.getText());
            try {
                this.prijemnica.setDependentExpenses(Double.parseDouble(this.tfDependentExpenses.getText()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            long prijemnicaID = -1L;
            if (this.prijemnica.getDocumentID() > 0L) {
                this.prijemnica.update(this.controller);
            } else {
                prijemnicaID = this.prijemnica.insert(this.controller, Date.from(((LocalDate)this.dpDeliveryDate.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            }
            if (this.cbPaid.isSelected() && !this.cbPaid.isDisable()) {
                this.prijemnica.setRealized(this.cbPaid.isSelected());
                if (this.prijemnica.isRealized()) {
                    PaymentRecord paymentRecord = new PaymentRecord();
                    paymentRecord.setDocumentID(prijemnicaID);
                    paymentRecord.setNote("");
                    try {
                        paymentRecord.setPaidAmount(Settings.getNumberFormat((int)2, (boolean)true).parse(this.lblSumWithVat.getText()).doubleValue());
                    }
                    catch (ParseException e) {
                        paymentRecord.setPaidAmount(0.0);
                    }
                    paymentRecord.insert(this.controller);
                }
            }
            for (int i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getDocumentDetailsID() > 0L) {
                    this.deletedItems.get(i).updatePrijemnica(this.controller.getSettings().getConnection());
                    continue;
                }
                this.deletedItems.remove(i);
            }
            long documentID = this.prijemnica.getDocumentID();
            for (int i = 0; i < this.prijemniceDetailsList.size(); ++i) {
                PrijemnicaDetailes tableItem = (PrijemnicaDetailes)this.prijemniceDetailsList.get(i);
                if (tableItem.getDocumentDetailsID() > 0L) {
                    if (tableItem.getProduct() != null) {
                        if (tableItem.getNewSellPrice() != tableItem.getSellPrice()) {
                            PriceListDetailes.insertProductPrice((long)tableItem.getProductID(), (double)tableItem.getNewSellPrice(), (long)documentID, (ScreensController)this.controller);
                            tableItem.setSellPrice(tableItem.getNewSellPrice());
                        }
                        tableItem.updateWithDiscount(this.controller);
                    }
                } else if (tableItem.getProduct() != null) {
                    tableItem.setDocumentID(this.prijemnica.getDocumentID());
                    Long id = tableItem.insertWithDiscount(this.controller);
                    if (tableItem.getNewSellPrice() != tableItem.getSellPrice()) {
                        PriceListDetailes.insertProductPrice((long)tableItem.getProductID(), (double)tableItem.getNewSellPrice(), (long)tableItem.getDocumentID(), (ScreensController)this.controller);
                    }
                    tableItem.setDocumentDetailsID(id.longValue());
                }
                if (!Boolean.parseBoolean(this.controller.getSettings().getActualByName("fifo_nabavna_cena"))) continue;
                ProductDepartment productDepartment = ProductDepartment.getByProductAndDepartment((long)tableItem.getProduct().getProductID(), (int)this.department.getDepartmentID(), (ScreensController)this.controller);
                productDepartment.setAverageValue(Settings.test((Product)productDepartment.getProduct(), (Department)this.department, (LocalDate)LocalDate.now(), (ScreensController)this.controller));
                productDepartment.updateAverageValue(this.controller);
            }
            if (!this.prijemniceDetailsOtpisList.isEmpty()) {
                Otpis otpis = new Otpis();
                otpis.setDepartmentID(this.department.getDepartmentID());
                otpis.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDeliveryDate.getDateTimeValue()));
                otpis.setNumber(Document.getNextNumber((int)7, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDeliveryDate.getValue())));
                otpis.setComment("Otpis pri prijemu");
                Long id = otpis.insert(this.controller);
                for (OtpisDetailes otpisDetailes : this.prijemniceDetailsOtpisList) {
                    otpisDetailes.setDocumentID(id.longValue());
                    otpisDetailes.insert(this.controller);
                }
            }
            this.controller.getSettings().getConnection().commit();
            if ((Button)event.getSource() == this.btnSacuvajNovo) {
                this.modalResult = ScreensController.MODAL_RESULT_OK_NEW;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            } else {
                this.modalResult = ScreensController.MODAL_RESULT_OK;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            }
        }
        catch (Exception e) {
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
    }

    public void actionAddPrijemnicaDetails(ActionEvent event) {
        if (this.pd.getDiscount() > 0.0) {
            this.pd.setPriceWithDiscount(this.pd.getPrice() * (1.0 - this.pd.getDiscount() / 100.0));
            this.pd.setPrice(this.pd.getPriceWithDiscount());
            this.pd.setPurchasePrice(this.pd.getPurchasePrice() * (1.0 - this.pd.getDiscount() / 100.0));
            this.pd.setSumWithVat(this.pd.getPriceWithDiscount() * this.pd.getQuantity());
            this.izracunajMarzu();
            this.izracunajUkupno();
        }
        PrijemnicaDetailes prijemnicaDetails = new PrijemnicaDetailes();
        prijemnicaDetails.setDocumentDetailsID(-1L);
        prijemnicaDetails.setProduct(this.pd.getProduct());
        prijemnicaDetails.setJedinicaMere(this.pd.getJedinicaMere());
        prijemnicaDetails.setProductID(this.pd.getProductID());
        prijemnicaDetails.setProductCode(this.pd.getProductCode());
        prijemnicaDetails.setProductName(this.pd.getProductName());
        if (this.pd.getProduct().getWriteOff() != 0.0) {
            prijemnicaDetails.setQuantity(this.pd.getQuantity() - this.pd.getQuantity() * this.pd.getProduct().getWriteOff() / 100.0);
        } else {
            prijemnicaDetails.setQuantity(this.pd.getQuantity());
        }
        if (prijemnicaDetails.getQuantity() == 0.0) {
            this.controller.alert("Obavestenje", "Uneta kolicina ne moze biti 0 ili manja od 0", this.rootPane.getScene().getWindow());
            this.tfQuantity.requestFocus();
            return;
        }
        prijemnicaDetails.setPrice(this.pd.getPrice());
        prijemnicaDetails.setPriceWithDiscount(this.pd.getPriceWithDiscount());
        prijemnicaDetails.setSum(this.pd.getPrice() * this.pd.getQuantity());
        prijemnicaDetails.setSumWithDiscount(this.pd.getPurchasePrice() * this.pd.getQuantity());
        prijemnicaDetails.setDiscount(this.pd.getDiscount());
        prijemnicaDetails.setVat(this.pd.getVat());
        prijemnicaDetails.setSumWithVat(this.pd.getSumWithVat());
        prijemnicaDetails.setNewSellPrice(this.pd.getNewSellPrice());
        prijemnicaDetails.setSellPrice(this.pd.getSellPrice());
        prijemnicaDetails.setMargin(this.pd.getMargin());
        prijemnicaDetails.setPurchasePrice(this.pd.getPurchasePrice());
        prijemnicaDetails.setPurchasePriceWithoutRabat(this.pd.getPurchasePriceWithoutRabat());
        if (this.pd.getProduct().getWriteOff() != 0.0) {
            OtpisDetailes otpisDetailes = new OtpisDetailes();
            otpisDetailes.setProduct(this.pd.getProduct());
            otpisDetailes.setPurchasePriceWithVat(prijemnicaDetails.getPrice());
            otpisDetailes.setQuantity(this.pd.getQuantity() * this.pd.getProduct().getWriteOff() / 100.0);
            otpisDetailes.setCurrentPrice(prijemnicaDetails.getSellPrice());
            otpisDetailes.setPurchasePriceWithoutVat(prijemnicaDetails.getPriceWithoutVatAndDiscount());
            this.prijemniceDetailsOtpisList.add((java.lang.Object)otpisDetailes);
        }
        this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetails);
        this.tfFilter.setText("");
        this.loadDetails();
        this.tablePrijemniceDetails.scrollTo(this.tablePrijemniceDetails.getItems().size() - 1);
        this.calculateSum();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText("");
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfMargin.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.cbProduct.requestFocus();
    }

    @FXML
    public void actionNewProduct(ActionEvent event) {
        if (this.department != null) {
            boolean fromInvoice = true;
            HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
            hm2.put("controller", this.controller);
            hm2.put("fromInvoice", fromInvoice);
            int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT_NEW, hm2, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.tablePrijemniceDetails.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((PrijemnicaDetailes)this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.prijemniceDetailsList.remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.tablePrijemniceDetails.getItems().remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
        }
        this.tfFilter.setText("");
        this.loadDetails();
        this.calculateSum();
    }

    @FXML
    public void toggleNapomena(ActionEvent event) {
        boolean bl = this.napomenaVidljiva = !this.napomenaVidljiva;
        if (this.napomenaVidljiva) {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(100.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(10.0);
            this.tablePrijemniceDetails.setPrefHeight(200.0);
            this.taNapomena.setVisible(true);
            this.labelNapomena.setVisible(true);
        } else {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(0.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(0.0);
            this.tablePrijemniceDetails.setPrefHeight(300.0);
            this.taNapomena.setVisible(false);
            this.labelNapomena.setVisible(false);
        }
    }

    private void calculateSum() {
        double sumKolicina = 0.0;
        double sumUkupnaNabavnaCena = 0.0;
        double sumUkupnaNabavnaCenaSaRabatom = 0.0;
        double sumUkupnaCenaSaPDVom = 0.0;
        double sumProdajnaCena = 0.0;
        double sum = 0.0;
        for (PrijemnicaDetailes prijemnicaDetailes : this.prijemniceDetailsList) {
            if (!(prijemnicaDetailes.getQuantity() > 0.0)) continue;
            sumKolicina += prijemnicaDetailes.getQuantity();
            sumUkupnaNabavnaCena += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice();
            sumUkupnaNabavnaCenaSaRabatom += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice();
            sumUkupnaCenaSaPDVom += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice() * prijemnicaDetailes.getVat();
            sumProdajnaCena += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getNewSellPrice();
            sum += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePriceWithoutRabat() * prijemnicaDetailes.getVat();
        }
        try {
            this.prijemnica.setSum(sum);
            this.prijemnica.setSumWithDiscount(sumUkupnaCenaSaPDVom);
            this.prijemnica.setDiscount(Settings.round((double)(100.0 - this.prijemnica.getSumWithDiscount() * 100.0 / this.prijemnica.getSum()), (int)2));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.lblSumQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumKolicina));
        this.lblSum.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumUkupnaNabavnaCena));
        this.lblSumWithDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumUkupnaNabavnaCenaSaRabatom));
        this.lblSumWithVat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumUkupnaCenaSaPDVom));
        this.lblSumSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumProdajnaCena));
    }

    private void loadDetails() {
        this.tablePrijemniceDetails.getItems().clear();
        for (int i = 0; i < this.prijemniceDetailsList.size(); ++i) {
            if (!(((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getQuantity() > 0.0)) continue;
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                if (!(((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getName().toLowerCase().contains(this.tfFilter.getText().toLowerCase()) || ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast() != null && ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast().contains(this.tfFilter.getText()) || ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode() != null && ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode().toLowerCase().contains(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
                continue;
            }
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE)) {
                if ((((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast() == null || !((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast().equals(this.tfFilter.getText())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
                continue;
            }
            if (!((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) || (((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode() == null || !((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode().toLowerCase().equals(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
            this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
        }
    }

    private void setDobavljac(Person dobavlac) {
        if (dobavlac != null) {
            for (Person p : this.cbPerson.getItems()) {
                if (p.getPersonID() != this.prijemnica.getDobavljac().getPersonID()) continue;
                this.cbPerson.getSelectionModel().select((java.lang.Object)p);
                break;
            }
        }
    }

    private void setStatus(DocumentStatus status) {
        if (this.prijemnica.getDocumentStatus() == null) {
            this.prijemnica.setDocumentStatus((DocumentStatus)this.cbStatus.getItems().get(0));
        }
        for (DocumentStatus ds : this.cbStatus.getItems()) {
            if (ds.getDocumentStatusID() != this.prijemnica.getDocumentStatus().getDocumentStatusID()) continue;
            this.cbStatus.getSelectionModel().select((java.lang.Object)ds);
            break;
        }
    }

    @FXML
    private void actionImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((java.lang.Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int colPrice = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)PrijemnicaDetailesControllerTrgovina.this.controller, (long)2L)) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (csvImport.getCsvName().equals("Bar Kod") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colBarcode = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Cena") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colPrice = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)PrijemnicaDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    double priceWithoutVatAndDiscount;
                                    if (!p.isActive()) {
                                        unexistedProducts.add(colNames[colBarcode] + " - blokiran artikal");
                                        continue;
                                    }
                                    p.getCurrentPrice((long)PrijemnicaDetailesControllerTrgovina.this.department.getDepartmentID(), PrijemnicaDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                    if (p.getCurrentPrice((long)PrijemnicaDetailesControllerTrgovina.this.department.getDepartmentID(), PrijemnicaDetailesControllerTrgovina.this.controller.getSettings().getConnection()) == 0.0) {
                                        // empty if block
                                    }
                                    double quantity = 0.0;
                                    if (colNames[colQuantity].contains(",")) {
                                        System.out.println(colNames[colBarcode]);
                                        quantity = Double.parseDouble(colNames[colQuantity].replace(",", ".").trim());
                                    } else {
                                        quantity = Double.parseDouble(colNames[colQuantity].trim());
                                    }
                                    try {
                                        try {
                                            priceWithoutVatAndDiscount = Double.parseDouble(colNames[colPrice].replace(",", "."));
                                        }
                                        catch (NumberFormatException e) {
                                            priceWithoutVatAndDiscount = Double.parseDouble(colNames[colPrice]);
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException e) {
                                        priceWithoutVatAndDiscount = p.getPrice();
                                    }
                                    PrijemnicaDetailesControllerTrgovina.this.ukupno += quantity * priceWithoutVatAndDiscount;
                                    PrijemnicaDetailes prijemnicaDetails = new PrijemnicaDetailes();
                                    prijemnicaDetails.setDocumentDetailsID(-1L);
                                    prijemnicaDetails.setProduct(p);
                                    prijemnicaDetails.setProductID(p.getProductID());
                                    prijemnicaDetails.setProductCode(p.getCode());
                                    prijemnicaDetails.setProductName(p.getName());
                                    prijemnicaDetails.setJedinicaMere(Unit.getUnitById((int)p.getUnitID(), (Connection)PrijemnicaDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getCode());
                                    if (p.getWriteOff() != 0.0) {
                                        prijemnicaDetails.setQuantity(quantity - quantity * p.getWriteOff() / 100.0);
                                    } else {
                                        prijemnicaDetails.setQuantity(quantity);
                                    }
                                    prijemnicaDetails.setPurchasePrice(priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setPurchasePriceWithoutRabat(priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setPriceWithoutVatAndDiscount(priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setPrice(priceWithoutVatAndDiscount * p.getVatValue());
                                    prijemnicaDetails.setPriceWithDiscount(priceWithoutVatAndDiscount * p.getVatValue());
                                    prijemnicaDetails.setSum(quantity * priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setDiscount(0.0);
                                    prijemnicaDetails.setSumWithDiscount(quantity * priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setVat(p.getVatValue());
                                    prijemnicaDetails.setSumWithVat(quantity * priceWithoutVatAndDiscount * p.getVatValue());
                                    prijemnicaDetails.setNewSellPrice(p.getPrice());
                                    prijemnicaDetails.setSellPrice(p.getPrice());
                                    prijemnicaDetails.setMargin((p.getPrice() - prijemnicaDetails.getPriceWithDiscount()) / prijemnicaDetails.getPriceWithDiscount() * 100.0);
                                    PrijemnicaDetailesControllerTrgovina.this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetails);
                                    if (p.getWriteOff() != 0.0) {
                                        OtpisDetailes otpisDetailes = new OtpisDetailes();
                                        otpisDetailes.setProduct(p);
                                        otpisDetailes.setPurchasePriceWithVat(prijemnicaDetails.getPrice());
                                        otpisDetailes.setQuantity(quantity * p.getWriteOff() / 100.0);
                                        otpisDetailes.setCurrentPrice(prijemnicaDetails.getSellPrice());
                                        otpisDetailes.setPurchasePriceWithoutVat(prijemnicaDetails.getPriceWithoutVatAndDiscount());
                                        PrijemnicaDetailesControllerTrgovina.this.prijemniceDetailsOtpisList.add((java.lang.Object)otpisDetailes);
                                    }
                                } else {
                                    unexistedProducts.add(colNames[colBarcode] + " - nepostojeci artikal");
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.loadDetails();
                this.calculateSum();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    public ComboBox<DocumentStatus> getCbStatus() {
        return this.cbStatus;
    }

    private void izracunajUkupno() {
        double margin = (this.pd.getNewSellPrice() - this.pd.getPrice()) / this.pd.getPrice() * 100.0;
        this.pd.setSum(this.pd.getPrice() * this.pd.getQuantity());
        this.pd.setSumWithDiscount(this.pd.getPurchasePrice() * this.pd.getQuantity());
        this.pd.setMargin(margin);
        this.izracunajMarzu();
    }

    private void izracunajProdajnuCenu() {
        this.pd.setNewSellPrice(Settings.round((double)(this.pd.getPrice() / 100.0 * this.pd.getMargin() + this.pd.getPrice()), (int)2));
        this.tfSellPrice.setText("" + Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getNewSellPrice()));
    }

    private void izracunajMarzu() {
        this.pd.setMargin((this.pd.getNewSellPrice() - this.pd.getPrice()) / this.pd.getPrice() * 100.0);
        this.tfMargin.setText("" + Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getMargin()));
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    private void getOldValuesForFields(String purcahsePriceWithPdv, String purcahsePrice, String purcahseValueWithPdv, String purchaseValue) {
        this.oldValuePurchasePriceWithPdv = purcahsePriceWithPdv.replace(".", "").replace(",", ".");
        this.oldValuePurchasePrice = purcahsePrice.replace(".", "").replace(",", ".");
        this.oldValuePurchaseValueWithPdv = purcahseValueWithPdv.replace(".", "").replace(",", ".");
        this.oldValuePurchaseValue = purchaseValue.replace(".", "").replace(",", ".");
    }

    private Vat getVatForPrijemnica(int pvtId) {
        Connection connection = this.controller.getSettings().getConnection();
        PersonVatType pvt = PersonVatType.getById((Connection)connection, (int)pvtId);
        String codeString = "\u0402";
        switch (pvt.getName()) {
            case "Poljoprivredno gazdinstvo": {
                codeString = "GRUPA_P";
                Vat vat = new Vat();
                vat.setActive(true);
                vat.setVatID(2000);
                vat.setCode("GRUPA_P");
                vat.setName("8%");
                vat.setValue(1.08);
                vat.setValue2(0.92);
                vat.setValue3(0.07407407);
                return vat;
            }
            case "PDV obveznik": {
                codeString = "\u0402";
                break;
            }
            case "Nije PDV obveznik": {
                codeString = "\u0410";
                break;
            }
        }
        return Vat.getByCode((String)codeString, (Connection)connection);
    }

    private void editVat(Person person) {
        this.prijemniceDetailsList.clear();
        Vat vat = this.getVatForPrijemnica(person.getPersonVatTypeID());
        for (PrijemnicaDetailes prijemnicaDetailes : this.tablePrijemniceDetails.getItems()) {
            if (vat.getCode().equals("GRUPA_DJ")) {
                Product p = Product.getByID((long)prijemnicaDetailes.getProduct().getProductID(), (ScreensController)this.controller);
                vat = Vat.getById((int)p.getVatID(), (Connection)this.controller.getSettings().getConnection());
            }
            prijemnicaDetailes.setVat(vat.getValue());
            prijemnicaDetailes.setSumWithVat(Settings.round((double)(prijemnicaDetailes.getSumWithDiscount() * vat.getValue()), (int)2));
            prijemnicaDetailes.getProduct().setVatID(vat.getVatID());
            this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetailes);
        }
        this.loadDetails();
        this.calculateSum();
    }

    private void giveErrorMessageIfNumberExsists() {
        Date numberDate;
        String number = this.tfNumber.getText().trim();
        boolean numberExsists = this.prijemnica.existsNumber(number, numberDate = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())), this.connection);
        if (numberExsists) {
            if (this.prijemnica.getDocumentID() > -1L) {
                this.controller.alert("Obave\u0161tenje", "Broj prijemnice vec postoji u bazi. Prijemnici \u0107e ostati ve\u0107 dodeljen broj", this.rootPane.getScene().getWindow());
                this.tfNumber.setText(String.valueOf(this.prijemnica.getNumber()));
            } else {
                this.controller.alert("Obave\u0161tenje", "Broj prijemnice vec postoji u bazi. Prijemnica \u0107e dobiti prvi slobodan broj ", this.rootPane.getScene().getWindow());
                this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)1, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDeliveryDate.getValue()))));
            }
        }
    }

    private void giveErrorMessageIfExternalNumberExsists() {
        String externalNumber = this.tfExternalNumber.getText();
        if (externalNumber != null | !externalNumber.isEmpty()) {
            Person person = (Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex());
            boolean documentExsists = Prijemnica.exists((String)externalNumber.trim(), (Person)person, (Connection)this.connection);
            if (this.prijemnica.getDocumentID() == -1L && documentExsists) {
                this.controller.alert("Prijemnica ve\u0107 postoji", "Prijemnica sa unetim brojem i odabranim komitentom ve\u0107 postoji", this.rootPane.getScene().getWindow());
                this.tfExternalNumber.setText("");
            }
        }
    }
}

