/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.OtpisDetailes;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.document.PrijemnicaCentralniMagacin;
import rs.petcom.master.dal.document.PrijemnicaCentralniMagacinDetailes;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.AutoCompleteComboBoxListener;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class PrijemnicaCentralniMagacinDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    PrijemnicaCentralniMagacin prijemnica;
    int modalResult;
    boolean napomenaVidljiva;
    ArrayList<PrijemnicaCentralniMagacinDetailes> deletedItems;
    ObservableList<PrijemnicaCentralniMagacinDetailes> prijemniceDetailsList = FXCollections.observableArrayList();
    ObservableList<PrijemnicaCentralniMagacinDetailes> data = FXCollections.observableArrayList();
    ObservableList<OtpisDetailes> prijemniceDetailsOtpisList = FXCollections.observableArrayList();
    ArrayList<Product> productList;
    Object objekat;
    WarehouseCentral department;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    Product selectedProduct;
    PrijemnicaCentralniMagacinDetailes pd;
    ComboBoxCellFactory cbCellFactory;
    double ukupno = 0.0;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gpNapomena;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfExternalNumber;
    @FXML
    private TextField tfPlace;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfNabavnaCena;
    @FXML
    private TextField tfNabavnaCenaSaPDVom;
    @FXML
    private TextField tfUkupnaNabavnaCena;
    @FXML
    private TextField tfUkupnaNabavnaCenaSaPDVom;
    @FXML
    private TextField tfRabat;
    @FXML
    private TextField tfSellPrice;
    @FXML
    private TextField tfMargin;
    @FXML
    private TextField tfDependentExpenses;
    @FXML
    private Label labelNapomena;
    @FXML
    private Label lblSumQuantity;
    @FXML
    private Label lblSumPriceWithoutVatAndDiscount;
    @FXML
    private Label lblSum;
    @FXML
    private Label lblSumWithDiscount;
    @FXML
    private Label lblSumWithVat;
    @FXML
    private Label lblSumSellPrice;
    @FXML
    private DateTimePicker dpDate;
    @FXML
    private DateTimePicker dpDeliveryDate;
    @FXML
    private DateTimePicker dpCurrencyDate;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private ComboBox<DocumentStatus> cbStatus;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnNapomena;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnSacuvaj;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnImportCsv;
    @FXML
    private Button btnSacuvajNovo;
    @FXML
    private Button btnNoviProizvod;
    @FXML
    private TextArea taNapomena;
    @FXML
    private TableView<PrijemnicaCentralniMagacinDetailes> tablePrijemniceDetails;
    @FXML
    private TableColumn<java.lang.Object, Product> tcProduct;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPurchasePriceWithoutRabat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSellPrice;
    @FXML
    private TableColumn<java.lang.Object, Double> tcMargin;
    @FXML
    private TableColumn<PrijemnicaCentralniMagacinDetailes, String> tcJedinicaMere;
    @FXML
    private TableColumn<PrijemnicaCentralniMagacinDetailes, Product> tcVat;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.deletedItems = new ArrayList();
        this.btnRemove.setDisable(false);
        this.controller = (ScreensController)parameter.get("controller");
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        new AutoCompleteComboBoxListener(this.cbPerson);
        this.cbStatus.setItems(DocumentStatus.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbStatus.setOnKeyPressed(event -> {
            if (event.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                // empty if block
            }
        });
        this.cbFilter.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilter.getSelectionModel().selectFirst();
        this.cbFilter.setOnAction(actionEvent -> {
            this.cbProductAutoComplete.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
            this.cbCellFactory.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
        });
        this.objekat = (Object)parameter.get("object");
        this.department = (WarehouseCentral)parameter.get("department");
        this.prijemnica = (PrijemnicaCentralniMagacin)parameter.get("prijemnica");
        this.tfNumber.setText(String.valueOf(this.prijemnica.getNumber()));
        this.tfExternalNumber.setText(this.prijemnica.getExternalNumber());
        this.dpDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.prijemnica.getDate()));
        this.dpDeliveryDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.prijemnica.getDeliveryDate()));
        this.dpCurrencyDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.prijemnica.getPaymentDate()));
        this.setDobavljac(this.prijemnica.getDobavljac());
        this.tfPlace.setText(this.prijemnica.getPlace());
        this.setStatus(this.prijemnica.getDocumentStatus());
        this.tfPlace.setText(this.objekat.getName());
        this.tfPlace.setEditable(false);
        this.taNapomena.setText(this.prijemnica.getComment());
        this.tfDependentExpenses.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.prijemnica.getDependentExpenses()));
        this.tfDependentExpenses.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfDependentExpenses.setText(Settings.getNumberFormat((int)2, (boolean)true).parse(this.tfDependentExpenses.getText()).doubleValue() + "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfDependentExpenses.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.length() > 0 && newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfDependentExpenses.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
        });
        if (this.prijemnica.getDocumentID() > 0L && LocalDateTime.now().getDayOfYear() > Settings.LocalDateTimefromDate((Date)this.prijemnica.getDate()).getDayOfYear()) {
            this.tcSellPrice.setEditable(false);
            this.tcMargin.setEditable(false);
        }
        this.pd = new PrijemnicaCentralniMagacinDetailes();
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, Department.getByObjectID((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection()), ScreensController.FILTER_ALL);
        this.tcProduct.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcProduct.setCellFactory((Callback)this.cbCellFactory);
        this.tcProduct.setOnEditCommit(cellEditEvent -> {
            Product selectedTableProduct = (Product)cellEditEvent.getNewValue();
            PrijemnicaCentralniMagacinDetailes selectedTablePrij = (PrijemnicaCentralniMagacinDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTableProduct.getCurrentPrice((long)Department.getByObjectID((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), this.controller.getSettings().getConnection());
            selectedTableProduct.getNabavnaCena(this.controller.getSettings().getConnection());
            selectedTablePrij.setProduct(selectedTableProduct);
            selectedTablePrij.setProductID(selectedTableProduct.getProductID());
            selectedTablePrij.setProductCode(selectedTableProduct.getCode());
            selectedTablePrij.setProductName(selectedTableProduct.getName());
            selectedTablePrij.setSellPrice(selectedTableProduct.getPrice());
            selectedTablePrij.setNewSellPrice(selectedTableProduct.getPrice());
            selectedTablePrij.setMargin(selectedTablePrij.getPriceWithDiscount() > 0.0 ? (selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0 : (selectedTablePrij.getNewSellPrice() - this.selectedProduct.getNabavnaCena()) / this.selectedProduct.getNabavnaCena() * 100.0);
            selectedTablePrij.setPurchasePrice(selectedTableProduct.getNabavnaCena());
            selectedTablePrij.setVat(selectedTableProduct.getVatValue());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.tcJedinicaMere.setCellValueFactory((Callback)new PropertyValueFactory("jedinicaMere"));
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
            }
            try {
                this.selectedProduct.getCurrentPriceBeforeDatePrijemnica(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDeliveryDate.getDateTimeValue()), (long)Department.getByObjectID((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), this.controller.getSettings().getConnection());
                this.selectedProduct.getNabavnaCena(this.controller.getSettings().getConnection());
                this.selectedProduct.getPurchacePricePrijemnica(this.controller.getSettings().getConnection());
                this.pd.setProduct(this.selectedProduct);
                this.pd.setProductID(this.selectedProduct.getProductID());
                this.pd.setProductCode(this.selectedProduct.getCode());
                this.pd.setProductName(this.selectedProduct.getName());
                this.pd.setSellPrice(this.selectedProduct.getPrice());
                this.pd.setNewSellPrice(this.selectedProduct.getPrice());
                this.pd.setVat(this.selectedProduct.getVatValue() == 0.0 ? 1.0 : this.selectedProduct.getVatValue());
                this.pd.setJedinicaMere(Unit.getUnitById((int)this.selectedProduct.getUnitID(), (Connection)this.controller.getSettings().getConnection()).getCode());
                if (this.selectedProduct.getPurchacePrice() != 0.0) {
                    this.pd.setPurchasePriceWithoutRabat(this.selectedProduct.getPurchacePrice());
                    this.pd.setPurchasePrice(this.selectedProduct.getPurchacePrice());
                    this.pd.setPrice(this.selectedProduct.getPurchacePrice() * this.pd.getVat());
                    this.pd.setPriceWithDiscount(this.selectedProduct.getPurchacePrice() * this.pd.getVat());
                }
                this.pd.setMargin(this.pd.getPriceWithDiscount() > 0.0 ? (this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0 : (this.pd.getNewSellPrice() - this.selectedProduct.getNabavnaCena()) / this.selectedProduct.getNabavnaCena() * 100.0);
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePriceWithoutRabat()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfSellPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.selectedProduct.getPrice()));
                this.tfMargin.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getMargin()));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, Department.getByObjectID((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
        this.prijemniceDetailsList = PrijemnicaCentralniMagacinDetailes.getlist((PrijemnicaCentralniMagacin)this.prijemnica, (int)this.controller.getObject().getObjectID(), (ScreensController)this.controller);
        for (PrijemnicaCentralniMagacinDetailes prijemnicaDetailes : this.prijemniceDetailsList) {
            this.tablePrijemniceDetails.getItems().add((java.lang.Object)prijemnicaDetailes);
        }
        this.calculateSum();
        this.tfQuantity.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfQuantity.setText("");
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.cbProduct.requestFocus();
                }
            }
        });
        this.tfQuantity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getQuantity()) + "");
            }
        });
        this.tfQuantity.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.length() > 0) {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        this.tfQuantity.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (this.tfQuantity.isFocused()) {
                        this.pd.setQuantity(Settings.getNumberFormat((int)4, (boolean)true).parse((String)newValue).doubleValue());
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfNabavnaCena.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfNabavnaCena.getText().equals("")) {
                keyEvent.consume();
                this.tfQuantity.requestFocus();
            }
        });
        this.tfNabavnaCena.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCena.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfNabavnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfNabavnaCena.isFocused()) {
                this.pd.setPurchasePriceWithoutRabat(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPurchasePrice(this.pd.getPurchasePriceWithoutRabat());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfNabavnaCenaSaPDVom.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfNabavnaCenaSaPDVom.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfNabavnaCenaSaPDVom.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCena.requestFocus();
            }
        });
        this.tfNabavnaCenaSaPDVom.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePriceWithoutRabat() * this.pd.getVat()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCenaSaPDVom.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfNabavnaCenaSaPDVom.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
            if (this.tfNabavnaCenaSaPDVom.isFocused()) {
                this.pd.setPrice(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPriceWithDiscount(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPurchasePriceWithoutRabat(this.pd.getPrice() / this.pd.getVat());
                this.pd.setPurchasePrice(this.pd.getPrice() / this.pd.getVat());
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfUkupnaNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCena.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfUkupnaNabavnaCena.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfUkupnaNabavnaCena.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupnaNabavnaCena.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfUkupnaNabavnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
            if (this.tfUkupnaNabavnaCena.isFocused()) {
                this.pd.setSumPurchasePrice(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setSumWithVat(this.pd.getSumPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfUkupnaNabavnaCenaSaPDVom.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCenaSaPDVom.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfUkupnaNabavnaCenaSaPDVom.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfUkupnaNabavnaCenaSaPDVom.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupnaNabavnaCenaSaPDVom.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfUkupnaNabavnaCenaSaPDVom.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfUkupnaNabavnaCenaSaPDVom.isFocused()) {
                this.pd.setSumWithVat(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPrice(this.pd.getSumWithVat() / this.pd.getQuantity());
                this.pd.setPriceWithDiscount(this.pd.getSumWithVat() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getPrice() - this.pd.getPrice() * this.selectedProduct.getVatValue3());
                this.pd.setSumPurchasePrice(this.pd.getPurchasePrice() * this.pd.getQuantity());
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
            }
            this.izracunajUkupno();
        });
        this.tfRabat.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfRabat.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfRabat.getText().equals("")) {
                keyEvent.consume();
                this.tfUkupnaNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfRabat.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getDiscount()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfRabat.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfRabat.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfRabat.isFocused()) {
                this.pd.setDiscount(Double.parseDouble(newValue.replace(",", ".")));
            } else if (this.pd.getDiscount() != 0.0) {
                this.pd.setPurchasePrice(this.pd.getPurchasePrice() - this.pd.getPurchasePrice() * this.pd.getDiscount() / 100.0);
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPrice());
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
            }
            this.izracunajUkupno();
        });
        this.tfSellPrice.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSellPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfSellPrice.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfSellPrice.isFocused()) {
                    this.pd.setNewSellPrice(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                    this.izracunajMarzu();
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSellPrice.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getNewSellPrice()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfMargin.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfMargin.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfMargin.isFocused()) {
                    this.pd.setMargin(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                    this.izracunajProdajnuCenu();
                }
            }
            catch (StringIndexOutOfBoundsException | ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfMargin.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfMargin.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getMargin()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfMargin.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.cbProduct.requestFocus();
                this.actionAddPrijemnicaDetails(null);
                keyEvent.consume();
            }
        });
        this.deletedItems.clear();
        this.taNapomena.setText(this.prijemnica.getComment());
        this.taNapomena.setFocusTraversable(false);
        this.btnSacuvaj.setFocusTraversable(false);
        this.dpDate.setFocusTraversable(false);
        this.btnOdustani.setFocusTraversable(false);
        this.btnAdd.setFocusTraversable(false);
        this.btnRemove.setFocusTraversable(false);
        this.btnImportCsv.setFocusTraversable(false);
        this.tfPlace.setFocusTraversable(false);
        this.btnSacuvajNovo.setFocusTraversable(false);
        this.btnNoviProizvod.setFocusTraversable(false);
        this.tablePrijemniceDetails.setFocusTraversable(false);
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        this.napomenaVidljiva = true;
        this.toggleNapomena(null);
        this.calculateSum();
        Platform.runLater(() -> this.btnSacuvaj.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvaj.fire()));
        Platform.runLater(() -> this.btnSacuvajNovo.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvajNovo.fire()));
        Platform.runLater(() -> this.btnNoviProizvod.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnNoviProizvod.fire()));
        this.tfFilter.textProperty().addListener((obs, oldValue, newValue) -> this.loadDetails());
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        DoubleTableCellFactory cellFactory2 = new DoubleTableCellFactory(2, true);
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit(cellEditEvent -> {
            PrijemnicaCentralniMagacinDetailes selectedTablePrij = (PrijemnicaCentralniMagacinDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcQuantity);
        this.tcPurchasePriceWithoutRabat.setCellValueFactory((Callback)new PropertyValueFactory("PurchasePriceWithoutRabat"));
        this.tcPurchasePriceWithoutRabat.setCellFactory((Callback)cellFactory2);
        this.tcPurchasePriceWithoutRabat.setOnEditCommit(cellEditEvent -> {
            PrijemnicaCentralniMagacinDetailes selectedTablePrij = (PrijemnicaCentralniMagacinDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setPurchasePriceWithoutRabat(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPurchasePrice(selectedTablePrij.getPurchasePriceWithoutRabat() - selectedTablePrij.getPurchasePriceWithoutRabat() * selectedTablePrij.getDiscount() / 100.0);
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            selectedTablePrij.setMargin((selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcPurchasePriceWithoutRabat);
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory2);
        this.tcDiscount.setOnEditCommit(cellEditEvent -> {
            PrijemnicaCentralniMagacinDetailes selectedTablePrij = (PrijemnicaCentralniMagacinDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setPurchasePrice(selectedTablePrij.getPurchasePriceWithoutRabat() - selectedTablePrij.getPurchasePriceWithoutRabat() * selectedTablePrij.getDiscount() / 100.0);
            selectedTablePrij.setPriceWithDiscount(selectedTablePrij.getPurchasePrice() * selectedTablePrij.getVat());
            selectedTablePrij.setSumWithDiscount(selectedTablePrij.getQuantity() * selectedTablePrij.getPurchasePrice());
            selectedTablePrij.setSum(selectedTablePrij.getSumWithDiscount() * selectedTablePrij.getVat());
            selectedTablePrij.setMargin((selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcDiscount);
        this.tcSumWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcSumWithDiscount.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithDiscount);
        this.tcVat.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcVat.setCellFactory((Callback)new Callback<TableColumn<PrijemnicaCentralniMagacinDetailes, Product>, TableCell<PrijemnicaCentralniMagacinDetailes, Product>>(){

            public TableCell<PrijemnicaCentralniMagacinDetailes, Product> call(TableColumn<PrijemnicaCentralniMagacinDetailes, Product> param) {
                return new TableCell<PrijemnicaCentralniMagacinDetailes, Product>(){

                    protected void updateItem(Product item, boolean arg1) {
                        super.updateItem((java.lang.Object)item, arg1);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(item.getVatName());
                        }
                    }
                };
            }
        });
        this.makeHeaderWrappable(this.tcVat);
        this.tcSumWithVat.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcSumWithVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithVat);
        this.tcSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("NewSellPrice"));
        this.tcSellPrice.setCellFactory((Callback)cellFactory2);
        this.tcSellPrice.setOnEditCommit(cellEditEvent -> {
            PrijemnicaCentralniMagacinDetailes selectedTablePrij = (PrijemnicaCentralniMagacinDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setNewSellPrice(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setMargin((selectedTablePrij.getNewSellPrice() - selectedTablePrij.getPriceWithDiscount()) / selectedTablePrij.getPriceWithDiscount() * 100.0);
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcSellPrice);
        this.tcMargin.setCellValueFactory((Callback)new PropertyValueFactory("Margin"));
        this.tcMargin.setCellFactory((Callback)cellFactory2);
        this.tcMargin.setOnEditCommit(cellEditEvent -> {
            PrijemnicaCentralniMagacinDetailes selectedTablePrij = (PrijemnicaCentralniMagacinDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setMargin(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setNewSellPrice(selectedTablePrij.getPriceWithDiscount() / 100.0 * selectedTablePrij.getMargin() + selectedTablePrij.getPriceWithDiscount());
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void actionSave(ActionEvent event) {
        this.tfExternalNumber.requestFocus();
        if (this.prijemnica.getDocumentID() == -1L && Prijemnica.exists((String)this.tfExternalNumber.getText(), (Person)((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())), (Connection)this.controller.getSettings().getConnection())) {
            this.controller.alert("Prijemnica ve\u0107 postoji", "Prijemnica sa unetim brojem i odabranim komitentom ve\u0107 postoji", this.rootPane.getScene().getWindow());
            return;
        }
        try {
            int i;
            this.calculateSum();
            this.controller.getSettings().getConnection().setAutoCommit(false);
            this.prijemnica.setNumber(Integer.parseInt(this.tfNumber.getText()));
            this.prijemnica.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue()));
            this.prijemnica.setDeliveryDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDeliveryDate.getDateTimeValue()));
            this.prijemnica.setPaymentDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpCurrencyDate.getDateTimeValue()));
            try {
                this.prijemnica.setDobavljac((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.controller.alert("Obavestenje", "Morate odabrati dobavljaca", this.rootPane.getScene().getWindow());
            }
            this.prijemnica.setPlace(this.tfPlace.getText());
            this.prijemnica.setDocumentStatus((DocumentStatus)this.cbStatus.getSelectionModel().getSelectedItem());
            this.prijemnica.setComment(this.taNapomena.getText());
            this.prijemnica.setExternalNumber(this.tfExternalNumber.getText());
            try {
                this.prijemnica.setSum(Settings.getNumberFormat((int)4, (boolean)true).parse(this.lblSum.getText()).doubleValue());
            }
            catch (NumberFormatException | ParseException e1) {
                this.prijemnica.setSum(0.0);
            }
            try {
                this.prijemnica.setDependentExpenses(Double.parseDouble(this.tfDependentExpenses.getText()));
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            if (this.prijemnica.getDocumentID() > 0L) {
                this.prijemnica.update(this.controller);
            } else {
                this.prijemnica.insert(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getDocumentDetailsID() > 0L) {
                    this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
                    continue;
                }
                this.deletedItems.remove(i);
            }
            for (i = 0; i < this.prijemniceDetailsList.size(); ++i) {
                PrijemnicaCentralniMagacinDetailes tableItem = (PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i);
                if (tableItem.getDocumentDetailsID() > 0L) {
                    if (tableItem.getProduct() == null) continue;
                    if (tableItem.getNewSellPrice() != tableItem.getSellPrice()) {
                        PriceListDetailes.insertProductPrice((long)tableItem.getProductID(), (double)tableItem.getNewSellPrice(), (long)tableItem.getDocumentID(), (ScreensController)this.controller);
                        tableItem.setSellPrice(tableItem.getNewSellPrice());
                    }
                    tableItem.updateWithDiscount(this.controller);
                    continue;
                }
                if (tableItem.getProduct() == null) continue;
                tableItem.setDocumentID(this.prijemnica.getDocumentID());
                Long id = tableItem.insertWithDiscount(this.controller);
                if (tableItem.getNewSellPrice() != tableItem.getSellPrice()) {
                    PriceListDetailes.insertProductPrice((long)tableItem.getProductID(), (double)tableItem.getNewSellPrice(), (long)tableItem.getDocumentID(), (ScreensController)this.controller);
                }
                tableItem.setDocumentDetailsID(id.longValue());
            }
            this.controller.getSettings().getConnection().commit();
            if ((Button)event.getSource() == this.btnSacuvajNovo) {
                this.modalResult = ScreensController.MODAL_RESULT_OK_NEW;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            } else {
                this.modalResult = ScreensController.MODAL_RESULT_OK;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            }
        }
        catch (SQLException e) {
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
    }

    public void actionAddPrijemnicaDetails(ActionEvent event) {
        PrijemnicaCentralniMagacinDetailes prijemnicaDetails = new PrijemnicaCentralniMagacinDetailes();
        prijemnicaDetails.setDocumentDetailsID(-1L);
        prijemnicaDetails.setProduct(this.pd.getProduct());
        prijemnicaDetails.setJedinicaMere(this.pd.getJedinicaMere());
        prijemnicaDetails.setProductID(this.pd.getProductID());
        prijemnicaDetails.setProductCode(this.pd.getProductCode());
        prijemnicaDetails.setProductName(this.pd.getProductName());
        if (this.pd.getProduct().getWriteOff() != 0.0) {
            prijemnicaDetails.setQuantity(this.pd.getQuantity() - this.pd.getQuantity() * this.pd.getProduct().getWriteOff() / 100.0);
        } else {
            prijemnicaDetails.setQuantity(this.pd.getQuantity());
        }
        prijemnicaDetails.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
        prijemnicaDetails.setPriceWithDiscount(this.pd.getPrice() - this.pd.getPrice() * this.pd.getDiscount() / 100.0);
        prijemnicaDetails.setSum(this.pd.getSum());
        prijemnicaDetails.setDiscount(this.pd.getDiscount());
        prijemnicaDetails.setSumWithDiscount(this.pd.getSumWithDiscount());
        prijemnicaDetails.setVat(this.pd.getVat());
        prijemnicaDetails.setNewSellPrice(this.pd.getNewSellPrice());
        prijemnicaDetails.setSellPrice(this.pd.getSellPrice());
        prijemnicaDetails.setMargin(this.pd.getMargin());
        prijemnicaDetails.setPurchasePrice(this.pd.getPurchasePrice());
        prijemnicaDetails.setPurchasePriceWithoutRabat(this.pd.getPurchasePriceWithoutRabat());
        if (this.pd.getProduct().getWriteOff() != 0.0) {
            OtpisDetailes otpisDetailes = new OtpisDetailes();
            otpisDetailes.setProduct(this.pd.getProduct());
            otpisDetailes.setPurchasePriceWithVat(prijemnicaDetails.getPrice());
            otpisDetailes.setQuantity(this.pd.getQuantity() * this.pd.getProduct().getWriteOff() / 100.0);
            otpisDetailes.setCurrentPrice(prijemnicaDetails.getSellPrice());
            otpisDetailes.setPurchasePriceWithoutVat(prijemnicaDetails.getPriceWithoutVatAndDiscount());
            this.prijemniceDetailsOtpisList.add((java.lang.Object)otpisDetailes);
        }
        this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetails);
        this.tfFilter.setText("");
        this.loadDetails();
        this.tablePrijemniceDetails.scrollTo(this.tablePrijemniceDetails.getItems().size() - 1);
        this.calculateSum();
        this.pd = new PrijemnicaCentralniMagacinDetailes();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText("");
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfRabat.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfMargin.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
    }

    @FXML
    public void actionNewProduct(ActionEvent event) {
        if (this.department != null) {
            HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
            hm2.put("controller", this.controller);
            int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.tablePrijemniceDetails.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((PrijemnicaCentralniMagacinDetailes)this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.prijemniceDetailsList.remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.tablePrijemniceDetails.getItems().remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
        }
        this.tfFilter.setText("");
        this.loadDetails();
        this.calculateSum();
    }

    @FXML
    public void toggleNapomena(ActionEvent event) {
        boolean bl = this.napomenaVidljiva = !this.napomenaVidljiva;
        if (this.napomenaVidljiva) {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(100.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(10.0);
            this.tablePrijemniceDetails.setPrefHeight(200.0);
            this.taNapomena.setVisible(true);
            this.labelNapomena.setVisible(true);
        } else {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(0.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(0.0);
            this.tablePrijemniceDetails.setPrefHeight(300.0);
            this.taNapomena.setVisible(false);
            this.labelNapomena.setVisible(false);
        }
    }

    private void calculateSum() {
        double sumKolicina = 0.0;
        double sumNabavnaCena = 0.0;
        double sumUkupnaNabavnaCena = 0.0;
        double sumUkupnaNabavnaCenaSaRabatom = 0.0;
        double sumUkupnaCenaSaPDVom = 0.0;
        double sumProdajnaCena = 0.0;
        for (PrijemnicaCentralniMagacinDetailes prijemnicaDetailes : this.prijemniceDetailsList) {
            sumKolicina += prijemnicaDetailes.getQuantity();
            sumNabavnaCena += prijemnicaDetailes.getPurchasePriceWithoutRabat();
            sumUkupnaNabavnaCena += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice();
            sumUkupnaNabavnaCenaSaRabatom += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice();
            sumUkupnaCenaSaPDVom += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice() * prijemnicaDetailes.getVat();
            sumProdajnaCena += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getNewSellPrice();
        }
        this.lblSumQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumKolicina));
        this.lblSumPriceWithoutVatAndDiscount.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumNabavnaCena));
        this.lblSum.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumUkupnaNabavnaCena));
        this.lblSumWithDiscount.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumUkupnaNabavnaCenaSaRabatom));
        this.lblSumWithVat.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumUkupnaCenaSaPDVom));
        this.lblSumSellPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(sumProdajnaCena));
    }

    private void loadDetails() {
        this.tablePrijemniceDetails.getItems().clear();
        for (int i = 0; i < this.prijemniceDetailsList.size(); ++i) {
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                if (!(((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getName().toLowerCase().contains(this.tfFilter.getText().toLowerCase()) || ((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast() != null && ((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast().contains(this.tfFilter.getText()) || ((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode() != null && ((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode().toLowerCase().contains(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
                continue;
            }
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE)) {
                if ((((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast() == null || !((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast().equals(this.tfFilter.getText())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
                continue;
            }
            if (!((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) || (((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode() == null || !((PrijemnicaCentralniMagacinDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode().toLowerCase().equals(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
            this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
        }
    }

    private void setDobavljac(Person dobavlac) {
        if (dobavlac != null) {
            for (Person p : this.cbPerson.getItems()) {
                if (p.getPersonID() != this.prijemnica.getDobavljac().getPersonID()) continue;
                this.cbPerson.getSelectionModel().select((java.lang.Object)p);
                break;
            }
        }
    }

    private void setStatus(DocumentStatus status) {
        if (this.prijemnica.getDocumentStatus() == null) {
            this.prijemnica.setDocumentStatus((DocumentStatus)this.cbStatus.getItems().get(0));
        }
        for (DocumentStatus ds : this.cbStatus.getItems()) {
            if (ds.getDocumentStatusID() != this.prijemnica.getDocumentStatus().getDocumentStatusID()) continue;
            this.cbStatus.getSelectionModel().select((java.lang.Object)ds);
            break;
        }
    }

    @FXML
    private void actionImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((java.lang.Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int colPrice = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller, (long)2L)) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (csvImport.getCsvName().equals("Bar Kod") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colBarcode = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Cena") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colPrice = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    double priceWithoutVatAndDiscount;
                                    p.getCurrentPrice((long)Department.getByObjectID((Object)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getObject(), (Connection)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getDepartmentID(), PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                    if (p.getCurrentPrice((long)Department.getByObjectID((Object)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getObject(), (Connection)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getDepartmentID(), PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getSettings().getConnection()) == 0.0) {
                                        // empty if block
                                    }
                                    double quantity = 0.0;
                                    quantity = Double.parseDouble(colNames[colQuantity].replace(",", ".").trim());
                                    try {
                                        priceWithoutVatAndDiscount = Double.parseDouble(colNames[colPrice].replace(",", "."));
                                    }
                                    catch (NumberFormatException e) {
                                        priceWithoutVatAndDiscount = Double.parseDouble(colNames[colPrice]);
                                    }
                                    PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.ukupno += quantity * priceWithoutVatAndDiscount;
                                    PrijemnicaCentralniMagacinDetailes prijemnicaDetails = new PrijemnicaCentralniMagacinDetailes();
                                    prijemnicaDetails.setDocumentDetailsID(-1L);
                                    prijemnicaDetails.setProduct(p);
                                    prijemnicaDetails.setProductID(p.getProductID());
                                    prijemnicaDetails.setProductCode(p.getCode());
                                    prijemnicaDetails.setProductName(p.getName());
                                    prijemnicaDetails.setJedinicaMere(Unit.getUnitById((int)p.getUnitID(), (Connection)PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getCode());
                                    if (p.getWriteOff() != 0.0) {
                                        prijemnicaDetails.setQuantity(quantity - quantity * p.getWriteOff() / 100.0);
                                    } else {
                                        prijemnicaDetails.setQuantity(quantity);
                                    }
                                    prijemnicaDetails.setPurchasePrice(priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setPurchasePriceWithoutRabat(priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setPriceWithoutVatAndDiscount(priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setPrice(priceWithoutVatAndDiscount * p.getVatValue());
                                    prijemnicaDetails.setPriceWithDiscount(priceWithoutVatAndDiscount * p.getVatValue());
                                    prijemnicaDetails.setSum(quantity * priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setDiscount(0.0);
                                    prijemnicaDetails.setSumWithDiscount(quantity * priceWithoutVatAndDiscount);
                                    prijemnicaDetails.setVat(p.getVatValue());
                                    prijemnicaDetails.setSumWithVat(quantity * priceWithoutVatAndDiscount * p.getVatValue());
                                    prijemnicaDetails.setNewSellPrice(p.getPrice());
                                    prijemnicaDetails.setSellPrice(p.getPrice());
                                    prijemnicaDetails.setMargin((p.getPrice() - prijemnicaDetails.getPriceWithDiscount()) / prijemnicaDetails.getPriceWithDiscount() * 100.0);
                                    PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetails);
                                    if (p.getWriteOff() != 0.0) {
                                        OtpisDetailes otpisDetailes = new OtpisDetailes();
                                        otpisDetailes.setProduct(p);
                                        otpisDetailes.setPurchasePriceWithVat(prijemnicaDetails.getPrice());
                                        otpisDetailes.setQuantity(quantity * p.getWriteOff() / 100.0);
                                        otpisDetailes.setCurrentPrice(prijemnicaDetails.getSellPrice());
                                        otpisDetailes.setPurchasePriceWithoutVat(prijemnicaDetails.getPriceWithoutVatAndDiscount());
                                        PrijemnicaCentralniMagacinDetailesControllerTrgovina.this.prijemniceDetailsOtpisList.add((java.lang.Object)otpisDetailes);
                                    }
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.loadDetails();
                this.calculateSum();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    public ComboBox<DocumentStatus> getCbStatus() {
        return this.cbStatus;
    }

    private void izracunajUkupno() {
        double ukupnaNabavnaCena = this.pd.getQuantity() * this.pd.getPurchasePrice();
        double ukupnaNabavnaCenaSaPDVom = this.pd.getQuantity() * this.pd.getPurchasePrice() * this.pd.getVat();
        double margin = (this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0;
        this.pd.setSum(this.pd.getPrice() * this.pd.getQuantity());
        this.pd.setSumWithDiscount(this.pd.getPurchasePrice() * this.pd.getQuantity());
        this.pd.setMargin(margin);
        this.izracunajMarzu();
    }

    private void izracunajProdajnuCenu() {
        this.pd.setNewSellPrice(this.pd.getPriceWithDiscount() / 100.0 * this.pd.getMargin() + this.pd.getPriceWithDiscount());
        this.tfSellPrice.setText("" + Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getNewSellPrice()));
    }

    private void izracunajMarzu() {
        this.pd.setMargin((this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0);
        this.tfMargin.setText("" + Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getMargin()));
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }
}

