/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.RelationshipType;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Person;

public class PregledRezervacijaController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Document> tableDocument;
    @FXML
    private TableColumn<Document, Date> columnDateOff;
    @FXML
    private TableColumn<Document, Date> columnDateCreated;
    @FXML
    private TableColumn<Document, String> columnNumber;
    @FXML
    private TableColumn<Document, String> columnNote;
    @FXML
    private TableColumn<Document, String> columnNote2;
    @FXML
    private TableColumn<Document, String> columnOrder;
    @FXML
    private TableColumn<Document, Double> columnValue;
    @FXML
    private TableColumn<Document, Long> columnPerson;
    @FXML
    private TableColumn<Document, Long> columnStatus;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private ComboBox<String> cbReservationType;
    @FXML
    private VBox actionPanel;
    @FXML
    private TextField tfFilter;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void initialize() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.columnDateOff.setCellValueFactory((Callback)new PropertyValueFactory("DeliveryDate"));
        this.columnDateOff.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(new SimpleDateFormat("dd.MM.yyyy").format(item));
                }
            }
        });
        this.columnDateCreated.setCellValueFactory((Callback)new PropertyValueFactory("sysDTCreated"));
        this.columnDateCreated.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(new SimpleDateFormat("dd.MM.yyyy").format(item));
                }
            }
        });
        this.columnPerson.setCellValueFactory((Callback)new PropertyValueFactory("personID"));
        this.columnPerson.setCellFactory(column -> new TableCell<Document, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    Person person = Person.getById((long)item, (ScreensController)PregledRezervacijaController.this.controller);
                    this.setText(!person.getName().equals("") ? person.getName() : person.getFirstLastName());
                }
            }
        });
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.columnNote.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.columnNote2.setCellValueFactory((Callback)new PropertyValueFactory("Note2"));
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    PregledRezervacijaController.this.loadTableData(false, false, false);
                } else if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    PregledRezervacijaController.this.loadTableData(false, true, false);
                } else if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    PregledRezervacijaController.this.loadTableData(false, false, true);
                }
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    PregledRezervacijaController.this.loadTableData(false, false, false);
                } else if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    PregledRezervacijaController.this.loadTableData(false, true, false);
                } else if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    PregledRezervacijaController.this.loadTableData(false, false, true);
                }
            }
        });
        this.cbReservationType.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    PregledRezervacijaController.this.loadTableData(false, false, false);
                } else if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    PregledRezervacijaController.this.loadTableData(false, true, false);
                } else if (((String)PregledRezervacijaController.this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    PregledRezervacijaController.this.loadTableData(false, false, true);
                }
            }
        });
        this.columnStatus.setCellValueFactory((Callback)new PropertyValueFactory("statusName"));
        this.columnOrder.setCellValueFactory((Callback)new PropertyValueFactory("order"));
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.actionPanel.setPrefWidth(this.rootPane.getPrefWidth() / 5.0);
        this.dpFrom.setValue((Object)Settings.fromDate((Date)Document.getDateFromFirstActiveReservation((ScreensController)this.controller)));
        this.dpTo.setValue((Object)LocalDate.now());
        this.cbReservationType.getItems().addAll((Object[])new String[]{"Aktivne", "Realizovane", "Istekle"});
        this.cbReservationType.getSelectionModel().selectFirst();
        this.tableDocument.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.loadTableData(false, false, false);
    }

    private void loadTableData(boolean sve, boolean realized, boolean timeout) {
        this.tableDocument.setItems(Document.getReservationObservableList((boolean)sve, (boolean)realized, (boolean)timeout, (LocalDate)((LocalDate)this.dpFrom.getValue()), (LocalDate)((LocalDate)this.dpTo.getValue()), (ScreensController)this.controller));
        if (this.tableDocument.getItems().isEmpty()) {
            this.tableDocument.setPlaceholder((Node)new Label("Tabela je prazna"));
        }
        this.filter();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedDocument", null);
        this.controller.showModalDialog("Prijemnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_REZERVACIJE_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
            this.loadTableData(false, false, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
            this.loadTableData(false, true, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
            this.loadTableData(false, false, true);
        }
    }

    @FXML
    private void actionEdit() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null && !((Document)this.tableDocument.getSelectionModel().getSelectedItem()).isRealized()) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDocument", this.tableDocument.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Rezervacija - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_REZERVACIJE_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                this.loadTableData(false, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                this.loadTableData(false, true, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                this.loadTableData(false, false, true);
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite rezervaciju iz tabele koju \u017eelite da izmenite. Rezervacija koja je realizovana ne mo\u017ee se menjati.", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionDelete() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null && !((Document)this.tableDocument.getSelectionModel().getSelectedItem()).isRealized()) {
            int brisanje = this.controller.yesNoDialog("Brisanje", "Da li ste sigurni da \u017eelite da obri\u0161ete rezervaciju?", this.rootPane.getScene().getWindow());
            if (brisanje == ScreensController.MODAL_RESULT_YES) {
                try {
                    Document document = (Document)this.tableDocument.getSelectionModel().getSelectedItem();
                    DocumentDetails.deleteDetailes((Document)document, (Connection)this.controller.getSettings().getConnection());
                    if (document.getRelationShipType(this.controller) == 7) {
                        document.deleteDocumentRelationShipProfaktura(this.controller);
                    }
                    document.delete(this.controller);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                    this.loadTableData(true, false, false);
                } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                    this.loadTableData(false, false, false);
                } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                    this.loadTableData(false, true, false);
                } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                    this.loadTableData(false, false, true);
                }
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite rezervaciju iz tabele koju \u017eelite da obri\u0161ete. Rezervacija koja je realizovana ne mo\u017ee se obrisati.", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionView() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDocument", this.tableDocument.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Rezervacija - Detalji Pregled", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_REZERVACIJE_PREGLED_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Sve")) {
                this.loadTableData(true, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
                this.loadTableData(false, false, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
                this.loadTableData(false, true, false);
            } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
                this.loadTableData(false, false, true);
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite rezervaciju iz tabele koju \u017eelite da izmenite. Rezervacija koja je realizovana ne mo\u017ee se menjati.", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionPrint() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            Faktura f = new Faktura();
            f.setDocument((Document)this.tableDocument.getSelectionModel().getSelectedItem());
            f.printRezervacija(this.controller, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionOrder() {
        ObservableList orderList = FXCollections.observableArrayList();
        ObservableList newList = FXCollections.observableArrayList();
        String note = "Rezervacije broj: ";
        for (Document document : this.tableDocument.getSelectionModel().getSelectedItems()) {
            orderList.addAll((Collection)DocumentDetails.getObeservableList((long)document.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            note = note + document.getNumber() + ", ";
        }
        Document selectedDocument = new Document();
        selectedDocument.setSysDTCreated(new Date());
        selectedDocument.setNumber(Document.getNextNumber((int)DocumentType.getByCode((String)"POR", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (long)this.controller.getPointOfSale().getPointOfSaleID(), (ScreensController)this.controller));
        selectedDocument.setDocumentStatusID(DocumentStatus.getStatusByName((ScreensController)this.controller, (String)"U izradi").getDocumentStatusID());
        selectedDocument.setDocumentTypeID(DocumentType.getByCode((String)"POR", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        selectedDocument.setSysUserAddID(this.controller.getUser().getUserID());
        selectedDocument.setDate(new Date());
        selectedDocument.setDeliveryDate(new Date());
        selectedDocument.setYear(Calendar.getInstance().get(1));
        selectedDocument.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
        selectedDocument.setPersonID(0L);
        double sum = 0.0;
        for (DocumentDetails documentDetails : orderList) {
            sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
        }
        selectedDocument.setNote(note.substring(0, note.length() - 2));
        selectedDocument.setSum(sum);
        selectedDocument.setSumWithDiscount(sum);
        long id = selectedDocument.insert(this.controller);
        for (DocumentDetails documentDetails : orderList) {
            boolean ubaci = true;
            for (DocumentDetails ddDetails : newList) {
                if (ddDetails.getProductID() != documentDetails.getProductID() || ddDetails.getPriceWithDiscount() != documentDetails.getPriceWithDiscount()) continue;
                ddDetails.setQuantity(ddDetails.getQuantity() + documentDetails.getQuantity());
                ubaci = false;
            }
            if (!ubaci) continue;
            newList.add((Object)documentDetails);
        }
        for (DocumentDetails documentDetails : newList) {
            documentDetails.setClosed(true);
            documentDetails.setDocumentDetailsID(-1L);
            documentDetails.setSysDTCreated(new Date());
            documentDetails.setSysUserAddID(this.controller.getUser().getUserID());
            documentDetails.setDocumentID(id);
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        for (Document document : this.tableDocument.getSelectionModel().getSelectedItems()) {
            DocumentRelationship documentRelationship = new DocumentRelationship();
            documentRelationship.setActive(true);
            documentRelationship.setDocumentChildID(id);
            documentRelationship.setDocumentParentID(document.getDocumentID());
            documentRelationship.setRelationshipTypeID(RelationshipType.getByName((ScreensController)this.controller, (String)"Rezervacija - Porudzbenica").getRelationshipTypeID());
            documentRelationship.setSysDTCreated(new Date());
            documentRelationship.setSysUserAddID(this.controller.getUser().getUserID());
            documentRelationship.insert(this.controller.getSettings().getConnection());
        }
        if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Aktivne")) {
            this.loadTableData(false, false, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Realizovane")) {
            this.loadTableData(false, true, false);
        } else if (((String)this.cbReservationType.getSelectionModel().getSelectedItem()).equals("Istekle")) {
            this.loadTableData(false, false, true);
        }
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableDocument.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(document -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (String.valueOf(document.getNumber()) != null && String.valueOf(document.getNumber()).contains(lowerCaseFilter)) {
                return true;
            }
            Person person = Person.getById((long)document.getPersonID(), (ScreensController)this.controller);
            if (String.valueOf(person.getName()) != null && String.valueOf(person.getName()).toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (String.valueOf(person.getFirstLastName()) != null && String.valueOf(person.getFirstLastName().toLowerCase()).contains(lowerCaseFilter)) {
                return true;
            }
            return document.getNote() != null && document.getNote().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableDocument.comparatorProperty());
        this.tableDocument.setItems((ObservableList)sortedData);
    }
}

