/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.RelationshipType;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.fical.FiscalPrinter;

public class PregledProfakturaController
implements ControlledScreen {
    ScreensController controller;
    DocumentType docType;
    ObservableList<Document> documentList;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    TableView<Document> documentsTable;
    @FXML
    TableColumn<Document, Integer> tcDocBroj;
    @FXML
    TableColumn<Document, Date> tcDocDatum;
    @FXML
    TableColumn<Document, String> tcDocKomitent;
    @FXML
    TableColumn<Document, String> tcNote;
    @FXML
    TableColumn<Document, Double> tcDocVrednost;
    @FXML
    private TextField tfFilter;
    @FXML
    DatePicker dpWorkDayFrom;
    @FXML
    DatePicker dpWorkDayTo;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnFakturisi;
    @FXML
    private Button btndelete;
    @FXML
    private Button btnRezervisi;
    @FXML
    private Button btnIzmeni;
    @FXML
    private Button btnDodaj;
    @FXML
    private Button btnPregled;
    @FXML
    private CheckBox cbRealized;
    @FXML
    private CheckBox cbReservated;

    public void initialize() {
        this.documentsTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tcDocBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocKomitent.setCellValueFactory((Callback)new PropertyValueFactory("personName"));
        this.tcNote.setCellValueFactory((Callback)new PropertyValueFactory("note2"));
        this.tcDocVrednost.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            }
        });
        this.documentsTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> observable, Document oldValue, Document newValue) {
                if (newValue == null) {
                    PregledProfakturaController.this.btnPrint.setDisable(true);
                    PregledProfakturaController.this.btnFakturisi.setDisable(true);
                    PregledProfakturaController.this.btnRezervisi.setDisable(true);
                    PregledProfakturaController.this.btndelete.setDisable(true);
                } else if (PregledProfakturaController.this.cbRealized.isSelected() || PregledProfakturaController.this.cbReservated.isSelected()) {
                    PregledProfakturaController.this.btnDodaj.setDisable(true);
                    PregledProfakturaController.this.btnIzmeni.setDisable(true);
                    PregledProfakturaController.this.btnPrint.setDisable(false);
                    PregledProfakturaController.this.btnFakturisi.setDisable(true);
                    PregledProfakturaController.this.btnRezervisi.setDisable(true);
                    PregledProfakturaController.this.btndelete.setDisable(true);
                } else {
                    PregledProfakturaController.this.btnDodaj.setDisable(false);
                    PregledProfakturaController.this.btnIzmeni.setDisable(false);
                    PregledProfakturaController.this.btnPrint.setDisable(false);
                    PregledProfakturaController.this.btnFakturisi.setDisable(false);
                    PregledProfakturaController.this.btnRezervisi.setDisable(false);
                    PregledProfakturaController.this.btndelete.setDisable(false);
                }
            }
        });
        this.dpWorkDayFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PregledProfakturaController.this.loadDocTable();
            }
        });
        this.dpWorkDayTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PregledProfakturaController.this.loadDocTable();
            }
        });
        this.cbRealized.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PregledProfakturaController.this.cbRealized.isSelected()) {
                    PregledProfakturaController.this.documentsTable.setDisable(false);
                    PregledProfakturaController.this.cbReservated.setSelected(false);
                } else {
                    PregledProfakturaController.this.documentsTable.setDisable(false);
                    PregledProfakturaController.this.btnDodaj.setDisable(false);
                    PregledProfakturaController.this.btnIzmeni.setDisable(false);
                    PregledProfakturaController.this.cbReservated.setSelected(false);
                }
                PregledProfakturaController.this.loadDocTable();
            }
        });
        this.cbReservated.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PregledProfakturaController.this.cbReservated.isSelected()) {
                    PregledProfakturaController.this.documentsTable.setDisable(false);
                    PregledProfakturaController.this.cbRealized.setSelected(false);
                } else {
                    PregledProfakturaController.this.documentsTable.setDisable(false);
                    PregledProfakturaController.this.btnDodaj.setDisable(false);
                    PregledProfakturaController.this.btnIzmeni.setDisable(false);
                    PregledProfakturaController.this.cbRealized.setSelected(false);
                }
                PregledProfakturaController.this.loadDocTable();
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.docType = DocumentType.getByCode((String)"PROF", (Connection)this.controller.getSettings().getConnection());
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.dpWorkDayFrom.setValue((java.lang.Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDate()));
        this.dpWorkDayTo.setValue((java.lang.Object)LocalDate.now());
        this.loadDocTable();
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void actionAdd() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("profaktura", null);
        int result = this.controller.showModalDialog("Profaktura - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_PROFAKTURA_DETAILES, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadDocTable();
        }
    }

    @FXML
    private void actionShow() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("profaktura", this.documentsTable.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Profaktura - Detalji - Pregled", ScreensController.SCREEN_BACKOFFICE_DOC_PROFAKTURA_DETAILES_VIEW, hm, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionChange() {
        if (this.documentsTable.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("profaktura", this.documentsTable.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Profaktura - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_PROFAKTURA_DETAILES, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocTable();
            }
        }
    }

    @FXML
    private void actionPrint() {
        Faktura f = new Faktura();
        f.setDocument((Document)this.documentsTable.getSelectionModel().getSelectedItem());
        f.printProfaktura(this.controller, this.rootPane.getScene().getWindow());
    }

    @FXML
    private void actionDelete() {
        try {
            DocumentDetails.deleteDetailes((Document)((Document)this.documentsTable.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection());
            ((Document)this.documentsTable.getSelectionModel().getSelectedItem()).delete(this.controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.loadDocTable();
    }

    @FXML
    private void actionRezervisi() {
        ObservableList orderList = FXCollections.observableArrayList();
        ObservableList newList = FXCollections.observableArrayList();
        String note = "Profakture broj: ";
        String note2 = "";
        long personID = ((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getPersonID();
        boolean provera = false;
        for (Document document : this.documentsTable.getSelectionModel().getSelectedItems()) {
            if (document.getPersonID() == personID) continue;
            provera = true;
            break;
        }
        if (provera) {
            this.controller.alert("Obavestenje", "Odabrali ste razlicite komitente, proverite selektovane profakture", this.rootPane.getScene().getWindow());
            return;
        }
        for (Document document : this.documentsTable.getSelectionModel().getSelectedItems()) {
            orderList.addAll((Collection)DocumentDetails.getObeservableList((long)document.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            note = note + document.getNumber() + ", ";
            note2 = document.getNote2();
            document.setReservated(true);
            try {
                document.update(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Document selectedDocument = new Document();
        selectedDocument.setSysDTCreated(new Date());
        selectedDocument.setNumber(Document.getNextNumber((int)DocumentType.getByCode((String)"RE", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (long)this.controller.getPointOfSale().getPointOfSaleID(), (ScreensController)this.controller));
        selectedDocument.setDocumentStatusID(DocumentStatus.getStatusByName((ScreensController)this.controller, (String)"U izradi").getDocumentStatusID());
        selectedDocument.setDocumentTypeID(DocumentType.getByCode((String)"RE", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        selectedDocument.setSysUserAddID(this.controller.getUser().getUserID());
        selectedDocument.setDate(new Date());
        Date datum = this.getDate();
        if (datum != null) {
            selectedDocument.setDeliveryDate(datum);
            selectedDocument.setYear(Calendar.getInstance().get(1));
            selectedDocument.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
            selectedDocument.setPersonID(((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getPersonID());
            selectedDocument.setReservated(true);
            double sum = 0.0;
            for (DocumentDetails documentDetails : orderList) {
                sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
            }
            selectedDocument.setNote(note.substring(0, note.length() - 2));
            selectedDocument.setNote2(note2);
            selectedDocument.setSum(sum);
            selectedDocument.setSumWithDiscount(sum);
            long id = selectedDocument.insert(this.controller);
            for (DocumentDetails documentDetails : orderList) {
                boolean ubaci = true;
                for (DocumentDetails ddDetails : newList) {
                    if (ddDetails.getProductID() != documentDetails.getProductID() || ddDetails.getPriceWithDiscount() != documentDetails.getPriceWithDiscount()) continue;
                    ddDetails.setQuantity(ddDetails.getQuantity() + documentDetails.getQuantity());
                    ubaci = false;
                }
                if (!ubaci) continue;
                newList.add((java.lang.Object)documentDetails);
            }
            for (DocumentDetails documentDetails : newList) {
                documentDetails.setDocumentDetailsID(-1L);
                documentDetails.setSysDTCreated(new Date());
                documentDetails.setSysUserAddID(this.controller.getUser().getUserID());
                documentDetails.setDocumentID(id);
                documentDetails.insert(this.controller.getSettings().getConnection());
            }
            for (Document document : this.documentsTable.getSelectionModel().getSelectedItems()) {
                DocumentRelationship documentRelationship = new DocumentRelationship();
                documentRelationship.setActive(true);
                documentRelationship.setDocumentChildID(id);
                documentRelationship.setDocumentParentID(document.getDocumentID());
                documentRelationship.setRelationshipTypeID(RelationshipType.getByName((ScreensController)this.controller, (String)"Profaktura - Rezervacija").getRelationshipTypeID());
                documentRelationship.setSysDTCreated(new Date());
                documentRelationship.setSysUserAddID(this.controller.getUser().getUserID());
                documentRelationship.insert(this.controller.getSettings().getConnection());
            }
        } else {
            return;
        }
        this.loadDocTable();
    }

    @FXML
    private void actionFakturisi() {
        ((Document)this.documentsTable.getSelectionModel().getSelectedItem()).setRealized(true);
        ((Document)this.documentsTable.getSelectionModel().getSelectedItem()).updateRealized(this.controller);
        final Document documentRacun = Document.getByID((long)((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        documentRacun.setDocumentTypeID(DocumentType.getByCode((String)"R", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        documentRacun.setPaymentMethodID(5);
        documentRacun.setNumber(Document.getNextNumber((int)documentRacun.getDocumentTypeID(), (long)documentRacun.getPointOfSaleID(), (ScreensController)this.controller));
        documentRacun.setDate(new Date());
        documentRacun.setDeliveryDate(new Date());
        documentRacun.setCurrencyDate(new Date());
        documentRacun.setWorkDayID(WorkDay.getLastOpenWD((ScreensController)this.controller).getWorkDayID());
        Document documentFaktura = Document.getByID((long)((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        documentFaktura.setDocumentTypeID(DocumentType.getByCode((String)"F", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        documentFaktura.setPaymentMethodID(5);
        documentFaktura.setNumber(Document.getNextNumber((int)documentFaktura.getDocumentTypeID(), (long)documentRacun.getPointOfSaleID(), (ScreensController)this.controller));
        documentFaktura.setDate(new Date());
        documentRacun.setDeliveryDate(null);
        documentFaktura.setCurrencyDate(new Date());
        documentFaktura.setWorkDayID(WorkDay.getLastOpenWD((ScreensController)this.controller).getWorkDayID());
        long racun = documentRacun.insert(this.controller);
        long faktura = documentFaktura.insert(this.controller);
        DocumentRelationship documentRelationship = new DocumentRelationship();
        documentRelationship.setDocumentParentID(racun);
        documentRelationship.setDocumentChildID(faktura);
        documentRelationship.setActive(true);
        documentRelationship.setSysUserAddID(this.controller.getUser().getUserID());
        documentRelationship.setRelationshipTypeID(1);
        documentRelationship.insert(this.controller.getSettings().getConnection());
        for (DocumentDetails dd : DocumentDetails.getObeservableList((long)((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
            dd.setDocumentID(racun);
            dd.setSysDTCreated(new Date());
            dd.setSysDTEdit(null);
            dd.setSysUserAddID(this.controller.getUser().getUserID());
            dd.setSysUserEditID(this.controller.getUser().getUserID());
            dd.insert(this.controller.getSettings().getConnection());
        }
        int result = this.controller.yesNoDialog("Pitanje", "Da li \u017eelite da \u0161tampate fiskali ra\u010dun?", this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_YES) {
            this.runTask();
            new Thread(){

                @Override
                public void run() {
                    try {
                        String BI = FiscalPrinter.printCopy((Document)documentRacun, (String)PregledProfakturaController.this.controller.getSettings().getFiscalFolder(), (User)PregledProfakturaController.this.controller.getUser(), (boolean)false, (Connection)PregledProfakturaController.this.controller.getSettings().getConnection());
                        Document d = Document.getByID((long)documentRacun.getDocumentID(), (Connection)PregledProfakturaController.this.controller.getSettings().getConnection());
                        d.setFullNumber(BI);
                        d.setAlternativeFullNumber(FiscalPrinter.getIBFM((String)PregledProfakturaController.this.controller.getSettings().getFiscalFolder()));
                        d.update(PregledProfakturaController.this.controller);
                    }
                    catch (SQLException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PregledProfakturaController.this.controller.alert("Gre\u0161ka prilikom snimanja ra\u010duna!", "Do\u0161lo je do gre\u0161ke prilikom snimanja ra\u010duna. \nPoruka gre\u0161ke: \n" + e.getMessage(), PregledProfakturaController.this.rootPane.getScene().getWindow());
                            }
                        });
                        Log.writeLog((User)PregledProfakturaController.this.controller.getUser(), (String)("PointOfSale: " + PregledProfakturaController.this.controller.getPointOfSale().getName() + " " + e.getLocalizedMessage()), (Connection)PregledProfakturaController.this.controller.getSettings().getConnection());
                        e.printStackTrace();
                    }
                }
            }.start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Faktura f = new Faktura();
        f.setDocument(documentRacun);
        if (documentRacun.getExciseExists(this.controller)) {
            f.printExcise(this.controller, this.rootPane.getScene().getWindow());
        } else {
            f.print(this.controller, this.rootPane.getScene().getWindow());
        }
        this.loadDocTable();
    }

    private void loadDocTable() {
        this.documentList = Document.getProfakturaList((int)this.docType.getDocumentTypeID(), (String)((LocalDate)this.dpWorkDayFrom.getValue()).toString(), (String)((LocalDate)this.dpWorkDayTo.getValue()).toString(), (boolean)this.cbRealized.isSelected(), (boolean)this.cbReservated.isSelected(), (ScreensController)this.controller);
        this.documentsTable.setItems(this.documentList);
        this.filter();
    }

    public void runTask() {
        double wndwWidth = 300.0;
        Label updateLabel = new Label("Stampa ra\u010duna u toku...");
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{updateLabel, progress});
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        final Stage taskUpdateStage = new Stage();
        taskUpdateStage.setScene(new Scene((Parent)updatePane));
        taskUpdateStage.initOwner(this.rootPane.getScene().getWindow());
        taskUpdateStage.initStyle(StageStyle.UTILITY);
        taskUpdateStage.show();
        Task<Void> longTask = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 50;
                for (int i = 1; i <= max && this.isCancelled(); ++i) {
                    this.updateProgress(i, max);
                    this.updateMessage("Task part " + String.valueOf(i) + " complete");
                }
                return null;
            }
        };
        longTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                taskUpdateStage.hide();
            }
        });
        progress.progressProperty().bind((ObservableValue)longTask.progressProperty());
        updateLabel.textProperty().bind((ObservableValue)longTask.messageProperty());
        taskUpdateStage.show();
        new Thread((Runnable)longTask).start();
    }

    private Date getDate() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int result = this.controller.showModalDialog("Odaberi datum", ScreensController.SCREEN_BACKOFFICE_ODABERI_DATUM_REZERVACIJE, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            return Settings.DatefromLocalDateTime((LocalDateTime)((LocalDateTime)hm.get("datumIstekaRezervacije")));
        }
        this.controller.alert("Obavestenje", "Morate odabrati datum do kada vazi rezervacija", this.rootPane.getScene().getWindow());
        return null;
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.documentsTable.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(document -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            Person person = Person.getById((long)document.getPersonID(), (ScreensController)this.controller);
            if (person != null && person.getName().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return person != null && person.getFirstLastName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.documentsTable.comparatorProperty());
        this.documentsTable.setItems((ObservableList)sortedData);
    }
}

