/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.Faktura;

public class PregledPorudzbenicaController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Document> tableDocument;
    @FXML
    private TableColumn<Document, String> columnNumber;
    @FXML
    private TableColumn<Document, String> columnNote;
    @FXML
    private TableColumn<Document, Date> columnDate;
    @FXML
    private TableColumn<Document, Double> columnValue;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TextField tfFilter;

    public void initialize() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.columnNote.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.columnDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(item));
                }
            }
        });
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PregledPorudzbenicaController.this.loadTableData();
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PregledPorudzbenicaController.this.loadTableData();
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpFrom.setValue((Object)LocalDate.now());
        this.dpTo.setValue((Object)LocalDate.now());
        this.loadTableData();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    private void loadTableData() {
        this.tableDocument.setItems(Document.getOrdersObservableList((LocalDate)((LocalDate)this.dpFrom.getValue()), (LocalDate)((LocalDate)this.dpTo.getValue()), (ScreensController)this.controller));
        if (this.tableDocument.getItems().isEmpty()) {
            this.tableDocument.setPlaceholder((Node)new Label("Tabela je prazna"));
        }
        this.filter();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableDocument.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(document -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (String.valueOf(document.getNumber()) != null && String.valueOf(document.getNumber()).contains(lowerCaseFilter)) {
                return true;
            }
            return document.getNote() != null && document.getNote().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableDocument.comparatorProperty());
        this.tableDocument.setItems((ObservableList)sortedData);
    }

    @FXML
    private void actionNew() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedDocument", null);
        this.controller.showModalDialog("Prijemnica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_PORUDZBENICE_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        this.loadTableData();
    }

    @FXML
    private void actionEdit() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null && !((Document)this.tableDocument.getSelectionModel().getSelectedItem()).isRealized()) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDocument", this.tableDocument.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Rezervacija - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_PORUDZBENICE_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            this.loadTableData();
        } else {
            this.controller.alert("Obavestenje", "Odaberite porudzbenicu iz tabele koju \u017eelite da izmenite.", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionShow() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null && !((Document)this.tableDocument.getSelectionModel().getSelectedItem()).isRealized()) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDocument", this.tableDocument.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Porudzbenica - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_DETALJI_PORUDZBENICE_PREGLED_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            this.loadTableData();
        }
    }

    @FXML
    private void actionPrint() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            Faktura f = new Faktura();
            f.setDocument((Document)this.tableDocument.getSelectionModel().getSelectedItem());
            f.printPorudzbenica(this.controller, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionDelete() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            int brisanje = this.controller.yesNoDialog("Brisanje", "Da li ste sigurni da \u017eelite da obri\u0161ete porudzbenicu?", this.rootPane.getScene().getWindow());
            if (brisanje == ScreensController.MODAL_RESULT_YES) {
                try {
                    DocumentRelationship.deleteByChildID((Document)((Document)this.tableDocument.getSelectionModel().getSelectedItem()), (ScreensController)this.controller);
                    DocumentDetails.deleteDetailes((Document)((Document)this.tableDocument.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection());
                    ((Document)this.tableDocument.getSelectionModel().getSelectedItem()).delete(this.controller);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.loadTableData();
            }
        } else {
            this.controller.alert("Obavestenje", "Odaberite porudzbenica iz tabele koju \u017eelite da obri\u0161ete", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void exportExcelAction() {
        Connection connection = this.controller.getSettings().getConnection();
        Document document = (Document)this.tableDocument.getSelectionModel().getSelectedItem();
        if (document == null) {
            this.controller.alert("Obavestenje", "Odaberite porudzbenica iz tabele za koju \u017eelite da uradite export", this.rootPane.getScene().getWindow());
            return;
        }
        ArrayList details = DocumentDetails.getListForOrder((long)document.getDocumentID(), (Connection)connection);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        String putanja = file.getPath();
        Document.getPorudzbenicaToExcel((ScreensController)this.controller, (List)details, (String)putanja, (Document)document, (BorderPane)this.rootPane);
    }
}

