/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.KepKnjiga;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.person.Address;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class KepKnjigaControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    JRPrintPreviewPaneOld printViewPane;
    Object sviObjekti = new Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<WorkDay> tableWD;
    @FXML
    private TableColumn<WorkDay, java.util.Date> columnDate;
    @FXML
    private TableView<KepKnjiga> tableKK;
    @FXML
    private TableColumn<KepKnjiga, String> columnKK_naziv;
    @FXML
    private TableColumn<KepKnjiga, String> columnKK_dobavljac;
    @FXML
    private TableColumn<KepKnjiga, java.util.Date> columnKK_datum;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_vrednost;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_donosZaduzenje;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_donosRazduzenje;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_donosSum;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_zaduzenje;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_razduzenje;
    @FXML
    private TableColumn<KepKnjiga, Double> columnKK_prenos;

    public void initialize() {
        this.tableWD.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<WorkDay>(){

            public void changed(ObservableValue<? extends WorkDay> observable, WorkDay oldValue, WorkDay newValue) {
                KepKnjigaControllerTrgovina.this.loadTableKKDetails();
            }
        });
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.columnDate.setCellFactory(column -> new TableCell<WorkDay, java.util.Date>(){

            protected void updateItem(java.util.Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateFromatter().format(item));
                }
            }
        });
        this.columnKK_datum.setCellValueFactory((Callback)new PropertyValueFactory("datumDokumenta"));
        this.columnKK_datum.setCellFactory(column -> new TableCell<KepKnjiga, java.util.Date>(){

            protected void updateItem(java.util.Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateFromatter().format(item));
                }
            }
        });
        this.columnKK_naziv.setCellValueFactory((Callback)new PropertyValueFactory("nazivDokumenta"));
        this.columnKK_dobavljac.setCellValueFactory((Callback)new PropertyValueFactory("dobavljac"));
        this.columnKK_vrednost.setCellValueFactory((Callback)new PropertyValueFactory("vrednostPoDokumentu"));
        this.columnKK_donosZaduzenje.setCellValueFactory((Callback)new PropertyValueFactory("donosZaduzenja"));
        this.columnKK_donosRazduzenje.setCellValueFactory((Callback)new PropertyValueFactory("donosRazduzenja"));
        this.columnKK_donosSum.setCellValueFactory((Callback)new PropertyValueFactory("donosSum"));
        this.columnKK_zaduzenje.setCellValueFactory((Callback)new PropertyValueFactory("sumZaduzenje"));
        this.columnKK_razduzenje.setCellValueFactory((Callback)new PropertyValueFactory("sumRazduzenje"));
        this.columnKK_prenos.setCellValueFactory((Callback)new PropertyValueFactory("sumPrenos"));
        this.dpDateFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KepKnjigaControllerTrgovina.this.loadTableWD();
            }
        });
        this.dpDateTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KepKnjigaControllerTrgovina.this.loadTableWD();
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadDepartment();
        this.dpDateFrom.setValue((java.lang.Object)Settings.fromDate((java.util.Date)WorkDay.getFistWarkDayEver((Connection)this.controller.getSettings().getConnection()).getDate()));
        this.dpDateTo.setValue((java.lang.Object)LocalDate.now());
        this.loadTableWD();
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void printDetailsAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/KepKnjigaTrgovina.jasper";
        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)this.tableKK.getItems());
        CompanyConfig companyConfig = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", this.controller.getObject());
        try {
            hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID((long)companyConfig.getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("danOd", new Date(((WorkDay)this.tableWD.getSelectionModel().getSelectedItem()).getDate().getTime()));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (JRDataSource)beanColDataSource);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        for (KepKnjiga kepKnjiga : KepKnjiga.createKepKnjigas((java.util.Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (ScreensController)this.controller)) {
            System.out.println(kepKnjiga);
        }
        String reportFileName = "rs/petcom/backoffice/jasper/KepKnjigaNew.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", "null");
        }
        hm.put("objekat", Object.get((Connection)this.controller.getSettings().getConnection()));
        try {
            hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        CompanyConfig company = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
        try {
            hm.put("objekat", this.controller.getObject());
            hm.put("company", company);
            hm.put("company", CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller));
            hm.put("departmentId", ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            hm.put("danOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())).getTime()));
            try {
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
                this.printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
                hm2.put("report", this.printViewPane);
                this.controller.showModalDialog("KEP knjiga", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        catch (NullPointerException e) {
            this.controller.alert("Obavestenje", "Morate odabrati objekat i odeljenje: " + e.getMessage(), this.rootPane.getScene().getWindow());
            return;
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (!this.cbDepartment.getItems().isEmpty()) {
            this.cbDepartment.getSelectionModel().selectFirst();
        }
    }

    private void loadTableWD() {
        this.tableWD.getItems().clear();
        for (WorkDay workDay : WorkDay.getListByKepKnjiga((LocalDate)((LocalDate)this.dpDateFrom.getValue()), (LocalDate)((LocalDate)this.dpDateTo.getValue()), (Connection)this.controller.getSettings().getConnection())) {
            this.tableWD.getItems().add((java.lang.Object)workDay);
        }
    }

    private void loadTableKKDetails() {
        ObservableList listaKepKnjigas;
        if (this.tableWD.getSelectionModel().getSelectedItem() != null && !(listaKepKnjigas = KepKnjiga.createKepKnjigas((java.util.Date)((WorkDay)this.tableWD.getSelectionModel().getSelectedItem()).getDate(), (ScreensController)this.controller)).isEmpty()) {
            this.tableKK.setItems(listaKepKnjigas);
        }
    }
}

