/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.PropertySheet;
import rs.petcom.backoffice.gui.CustomPropertyEditorFactory;
import rs.petcom.backoffice.gui.FxUtil;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.SviArtikli;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.gui.AditionalFieldDetailsLabel;

public class FilterProductNewController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameters;
    private HashMap<Long, ObservableList<Long>> hashMap = new HashMap();
    @FXML
    private BorderPane rootPane;
    @FXML
    private VBox vBox;
    @FXML
    private CheckComboBox<ProductCategory> cbProductCategory;
    @FXML
    private CheckComboBox<Vat> cbVat;
    @FXML
    private ComboBox<SviArtikli> cbIsWeight;
    @FXML
    private ComboBox<SviArtikli> cbMeasurable;
    @FXML
    private ComboBox<SviArtikli> cbDiscountAllowed;
    @FXML
    private CheckBox cbActive;

    @FXML
    public void initialize() {
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillAditionalField();
        this.fillComboBox();
        this.fillComboBoxProductCategory();
        this.fillComboBoxVat();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void fillAditionalField() {
        final ArrayList list = AditionalField.getFrontBack((boolean)true, (Connection)this.controller.getSettings().getConnection());
        for (AditionalField aditionalField : list) {
            this.hashMap.put(aditionalField.getAditionalFieldID(), (ObservableList<Long>)FXCollections.observableArrayList());
            final FlowPane flowPaneDetails = new FlowPane();
            flowPaneDetails.getStyleClass().addAll((Object[])new String[]{"flowPane"});
            flowPaneDetails.setPadding(new Insets(6.0, 6.0, 6.0, 6.0));
            flowPaneDetails.setHgap(6.0);
            flowPaneDetails.setVgap(6.0);
            Label label = new Label();
            label.setPrefWidth(80.0);
            label.setText(aditionalField.getName() + ": ");
            flowPaneDetails.getChildren().add((Object)label);
            ComboBox comboBoxAFD = new ComboBox();
            comboBoxAFD.setItems(AditionalFieldDetails.getListByAditionalFieldID((long)aditionalField.getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection()));
            comboBoxAFD.setPrefWidth(120.0);
            FxUtil.autoCompleteComboBoxPlus(comboBoxAFD, (typedText, itemToCompare) -> itemToCompare.getName().toLowerCase().startsWith(typedText.toLowerCase()));
            FxUtil.getComboBox(comboBoxAFD);
            comboBoxAFD.addEventHandler(KeyEvent.KEY_PRESSED, t -> this.createButtonDetails(aditionalField, (ComboBox<AditionalFieldDetails>)comboBoxAFD, flowPaneDetails));
            comboBoxAFD.setCellFactory(lv -> {
                ListCell<AditionalFieldDetails> cell = new ListCell<AditionalFieldDetails>(){

                    protected void updateItem(AditionalFieldDetails item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : item.getName());
                    }
                };
                cell.setOnMousePressed(arg_0 -> this.lambda$null$2((ListCell)cell, aditionalField, comboBoxAFD, flowPaneDetails, arg_0));
                return cell;
            });
            flowPaneDetails.getChildren().add((Object)comboBoxAFD);
            this.vBox.getChildren().add((Object)flowPaneDetails);
            this.vBox.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    if (newValue != null) {
                        flowPaneDetails.setPrefHeight(newValue.doubleValue() / (double)list.size());
                    }
                }
            });
        }
    }

    private void fillComboBoxProductCategory() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        ObservableList list = ProductCategory.getObeservableList((Connection)this.controller.getSettings().getConnection());
        ProductCategory pCategory = new ProductCategory(-1, "Sve kategorije");
        this.cbProductCategory.getItems().add((Object)pCategory);
        for (ProductCategory productCategory : list) {
            this.cbProductCategory.getItems().add((Object)productCategory);
        }
        if (this.cbProductCategory.getItems().size() > 0) {
            this.cbProductCategory.getCheckModel().check(0);
        }
    }

    private void fillComboBoxVat() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        Vat vatSvi = new Vat();
        vatSvi.setVatID(-1);
        vatSvi.setName("Svi porezi");
        this.cbVat.getItems().add((Object)vatSvi);
        ObservableList list = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
        for (Vat vat : list) {
            this.cbVat.getItems().add((Object)vat);
        }
        if (this.cbVat.getItems().size() > 0) {
            this.cbVat.getCheckModel().check(0);
        }
    }

    @FXML
    private void showProductAction() {
        String productCategoryIDS = "";
        for (ProductCategory productCategory : this.cbProductCategory.getCheckModel().getCheckedItems()) {
            productCategoryIDS = productCategoryIDS + productCategory.getProductCategoryID() + ",";
        }
        String vatIDS = "";
        for (Vat vat : this.cbVat.getCheckModel().getCheckedItems()) {
            vatIDS = vatIDS + vat.getVatID() + ",";
        }
        this.parameters.put("productTypeIDS", "1,");
        this.parameters.put("productCategoryIDS", productCategoryIDS);
        this.parameters.put("vatIDS", vatIDS);
        this.parameters.put("active", true);
        this.parameters.put("popustDozvoljen", ((SviArtikli)this.cbDiscountAllowed.getSelectionModel().getSelectedItem()).getId());
        this.parameters.put("merljiv", ((SviArtikli)this.cbMeasurable.getSelectionModel().getSelectedItem()).getId());
        this.parameters.put("tezinski", ((SviArtikli)this.cbIsWeight.getSelectionModel().getSelectedItem()).getId());
        this.parameters.put("hashMap", this.hashMap);
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        for (Map.Entry<Long, ObservableList<Long>> entry : this.hashMap.entrySet()) {
            Long key = entry.getKey();
            System.out.println(key);
            ObservableList<Long> value = entry.getValue();
            for (Long l : value) {
                System.out.println(l);
            }
        }
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void closeAction() {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillComboBox() {
        SviArtikli sviArtikli = new SviArtikli();
        sviArtikli.setId("-1");
        sviArtikli.setName("SviArtikli");
        SviArtikli ne = new SviArtikli();
        ne.setId("0");
        ne.setName("Ne");
        SviArtikli da = new SviArtikli();
        da.setId("1");
        da.setName("Da");
        this.cbIsWeight.getItems().addAll((Object[])new SviArtikli[]{sviArtikli, ne, da});
        this.cbMeasurable.getItems().addAll((Object[])new SviArtikli[]{sviArtikli, ne, da});
        this.cbDiscountAllowed.getItems().addAll((Object[])new SviArtikli[]{sviArtikli, ne, da});
        this.cbIsWeight.getSelectionModel().selectFirst();
        this.cbMeasurable.getSelectionModel().selectFirst();
        this.cbDiscountAllowed.getSelectionModel().selectFirst();
    }

    private void createButtonDetails(AditionalField aditionalField, ComboBox<AditionalFieldDetails> comboBox, FlowPane flowPaneDetails) {
        Button closeButton = new Button("X");
        closeButton.setStyle("-fx-base: #f2f2f2;\r\n\t-fx-font-size: 10px;\r\n\t-fx-text-fill: #21252e;\r\n\t-fx-border-width: 0.0px;\r\n\t-fx-font-weight: normal;\r\n\t-fx-background-radius: 5.0px;\r\n");
        AditionalFieldDetailsLabel label = new AditionalFieldDetailsLabel((AditionalFieldDetails)comboBox.getItems().get(comboBox.getSelectionModel().getSelectedIndex()));
        label.setPrefHeight(30.0);
        label.setStyle("-fx-border-color: #7CB72A;\r\n\t-fx-border-width: 1.0px;\r\n\t-fx-border-style: solid;\r\n\t-fx-text-fill: #21252e;\r\n\t-fx-border-radius: 5.0px;\r\n\t-fx-background-radius: 5.0px; -fx-padding: 4.0;");
        label.setGraphic((Node)closeButton);
        label.setContentDisplay(ContentDisplay.RIGHT);
        flowPaneDetails.getChildren().add((Object)label);
        this.hashMap.get(aditionalField.getAditionalFieldID()).add((Object)label.getAditionalFieldDetails().getAditionalFieldDetailsID());
        closeButton.setOnAction(event -> this.remove(label, flowPaneDetails, comboBox));
        comboBox.getItems().remove((Object)label.getAditionalFieldDetails());
        comboBox.getEditor().setText("");
    }

    private void remove(AditionalFieldDetailsLabel label, FlowPane flowPaneDetails, ComboBox<AditionalFieldDetails> comboBox) {
        flowPaneDetails.getChildren().remove((Object)label);
        this.hashMap.get(label.getAditionalFieldDetails().getAditionalFiledID()).remove((Object)label.getAditionalFieldDetails().getAditionalFieldDetailsID());
        comboBox.getItems().add((Object)label.getAditionalFieldDetails());
    }

    private /* synthetic */ void lambda$null$2(ListCell cell, AditionalField aditionalField, ComboBox comboBoxAFD, FlowPane flowPaneDetails, MouseEvent e) {
        if (!cell.isEmpty()) {
            System.out.println("Click on " + ((AditionalFieldDetails)cell.getItem()).getName());
            this.createButtonDetails(aditionalField, (ComboBox<AditionalFieldDetails>)comboBoxAFD, flowPaneDetails);
        }
    }
}

