/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.FinancialDiscount;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.RelationshipType;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;

public class DetaljiRezervacijeTrgovinaController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Document selectedDocument;
    private Person selectedPerson;
    private DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
    private double discount;
    private ObservableList<Document> listaDodatihProfaktura = FXCollections.observableArrayList();
    private HashMap<String, Object> buyerSpecificationMap;
    private Product selProduct;
    private boolean isDiscountAllowed;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfAvans;
    @FXML
    private TextField tfPriceWithDiscount;
    @FXML
    private Label lblValue;
    @FXML
    private Label lblSelectedPerson;
    @FXML
    private Label lblDiscount;
    @FXML
    private Button btnComitent;
    @FXML
    private Button btnSpecification;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private TableView<DocumentDetails> tableDocument;
    @FXML
    private TableColumn<DocumentDetails, Long> columnProduct;
    @FXML
    private TableColumn<Object, Double> columnQuantity;
    @FXML
    private TableColumn<Object, Double> columnDiscount;
    @FXML
    private TableColumn<Object, Double> columnPrice;
    @FXML
    private TableColumn<Object, Double> columnPriceWithDiscount;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<DocumentDetails, Boolean> columnStatus;
    @FXML
    private DatePicker dpDeliveryDate;
    @FXML
    private TextArea taNote;

    @FXML
    private void initialize() {
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("ProductID"));
        this.columnProduct.setCellFactory(column -> new TableCell<DocumentDetails, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(Product.getByID((long)item, (ScreensController)DetaljiRezervacijeTrgovinaController.this.controller).getName());
                }
            }
        });
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.columnQuantity.setCellFactory((Callback)this.cellFactory);
        this.columnQuantity.setOnEditCommit(cellEditEvent -> {
            DocumentDetails selectedTablePrij = (DocumentDetails)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setValue(Settings.round((double)(selectedTablePrij.getQuantity() * selectedTablePrij.getPriceWithDiscount()), (int)2));
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.fillLabelValue();
        });
        this.columnPriceWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithDiscount"));
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.columnDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.columnStatus.setCellValueFactory((Callback)new PropertyValueFactory("Closed"));
        this.columnStatus.setCellFactory(column -> new TableCell<DocumentDetails, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Aktivna");
                    } else {
                        this.setText("Realizovana");
                    }
                }
            }
        });
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER) || event.getCode().equals((Object)KeyCode.TAB)) {
                    DetaljiRezervacijeTrgovinaController.this.tfPrice.requestFocus();
                }
            }
        });
        this.tfPrice.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER) || event.getCode().equals((Object)KeyCode.TAB)) {
                    DetaljiRezervacijeTrgovinaController.this.actionAdd();
                    DetaljiRezervacijeTrgovinaController.this.tfPriceWithDiscount.setText("");
                }
            }
        });
        this.tfPrice.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCode().equals((Object)KeyCode.ENTER) || !event.getCode().equals((Object)KeyCode.TAB)) {
                    double price = Double.parseDouble(DetaljiRezervacijeTrgovinaController.this.tfPrice.getText().trim());
                    if (DetaljiRezervacijeTrgovinaController.this.tfPrice.getText().equals("")) {
                        DetaljiRezervacijeTrgovinaController.this.tfPrice.setText("0");
                    }
                    DetaljiRezervacijeTrgovinaController.this.tfPriceWithDiscount.setText(String.valueOf(DetaljiRezervacijeTrgovinaController.this.getPriceWithDiscount(price, DetaljiRezervacijeTrgovinaController.this.discount)));
                }
            }
        });
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null && this.selectedPerson != null) {
                this.selProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
                this.isDiscountAllowed = this.selProduct.isDiscountAllowed();
                if (!this.isDiscountAllowed) {
                    this.controller.alert("Obave\u0161tenje", "Proizvodu: " + this.selProduct.getName() + " nije dozvoljen popust", this.rootPane.getScene().getWindow());
                    this.discount = 0.0;
                } else {
                    this.discount = this.getDiscountForReservation();
                }
                this.tfPrice.setText(String.valueOf(Product.getCurrentPrice((long)((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID(), (long)1L, (boolean)false, (Connection)this.controller.getSettings().getConnection())));
                this.tfQuantity.setText("1");
                double price = Double.parseDouble(this.tfPrice.getText().trim());
                this.tfPriceWithDiscount.setText(String.valueOf(this.getPriceWithDiscount(price, this.discount)));
            }
        });
        this.tableDocument.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DocumentDetails>(){

            public void changed(ObservableValue<? extends DocumentDetails> observable, DocumentDetails oldValue, DocumentDetails newValue) {
                if (DetaljiRezervacijeTrgovinaController.this.tableDocument.getSelectionModel().getSelectedItem() != null) {
                    DetaljiRezervacijeTrgovinaController.this.tfQuantity.requestFocus();
                }
            }
        });
        this.tableDocument.setRowFactory(param -> new TableRow<DocumentDetails>(){

            protected void updateItem(final DocumentDetails item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    this.disableProperty().bind((ObservableValue)new BooleanBinding(){

                        protected boolean computeValue() {
                            return item.isClosed();
                        }
                    });
                }
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedDocument = (Document)parameter.get("selectedDocument");
        this.cbProduct.setDisable(true);
        this.buyerSpecificationMap = new HashMap();
        if (this.selectedDocument != null) {
            // empty if block
        }
        this.lblDiscount.setText(String.valueOf(this.discount) + " %");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tfNumber.setDisable(true);
        if (this.selectedDocument != null) {
            this.cbProduct.setDisable(false);
            this.tfNumber.setText(String.valueOf(this.selectedDocument.getNumber()));
            this.tableDocument.setItems(DocumentDetails.getObeservableList((long)this.selectedDocument.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            this.dpDeliveryDate.setValue((Object)Settings.fromDate((Date)this.selectedDocument.getDeliveryDate()));
            this.taNote.setText(this.selectedDocument.getNote());
            this.tfAvans.setText(String.valueOf(this.selectedDocument.getNote2()));
            this.selectedPerson = Person.getById((long)this.selectedDocument.getPersonID(), (ScreensController)this.controller);
            this.lblSelectedPerson.setText(!this.selectedPerson.getName().equals("") ? this.selectedPerson.getName() : this.selectedPerson.getFirstLastName());
            this.getDiscountForReservation();
            this.discount = this.selectedDocument.getDiscount();
            this.selectedPerson.setDiscount(this.discount);
            this.btnComitent.setDisable(true);
            this.lblDiscount.setText(String.valueOf(this.discount) + " %");
            this.fillLabelValue();
        } else {
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)DocumentType.getByCode((String)"RE", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (long)this.controller.getPointOfSale().getPointOfSaleID(), (ScreensController)this.controller)));
            this.dpDeliveryDate.setValue((Object)LocalDate.now());
        }
        new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionAdd() {
        if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
            double price = Double.parseDouble(this.tfPrice.getText().trim());
            DocumentDetails ddDetails = new DocumentDetails();
            ddDetails.setDocumentDetailsID(-1L);
            ddDetails.setProductID(((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID());
            ddDetails.setQuantity(Double.parseDouble(this.tfQuantity.getText().trim()));
            ddDetails.setPrice(price);
            ddDetails.setDiscount(0.0);
            ddDetails.setDiscount(this.discount);
            ddDetails.setPriceWithDiscount(this.getPriceWithDiscount(price, this.discount));
            ddDetails.setUnitID(((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getUnitID());
            ddDetails.setVatID(((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getVatID());
            ddDetails.setSysDTCreated(new Date());
            ddDetails.setSysUserAddID(this.controller.getUser().getUserID());
            ddDetails.setValue(ddDetails.getQuantity() * ddDetails.getPriceWithDiscount());
            this.tableDocument.getItems().add((Object)ddDetails);
        }
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            ((DocumentDetails)this.tableDocument.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(this.tfQuantity.getText().trim()));
            ((DocumentDetails)this.tableDocument.getSelectionModel().getSelectedItem()).setPriceWithDiscount(Double.parseDouble(this.tfPrice.getText().trim()));
            this.tableDocument.getSelectionModel().clearSelection();
        }
        this.tableDocument.refresh();
        this.fillLabelValue();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText("");
        this.tfPrice.setText("");
        this.tfPriceWithDiscount.setText("");
        this.cbProduct.requestFocus();
    }

    @FXML
    private void actionRemove() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            this.tableDocument.getItems().remove(this.tableDocument.getSelectionModel().getSelectedIndex());
            this.tableDocument.refresh();
            this.tableDocument.getSelectionModel().clearSelection();
            this.cbProduct.requestFocus();
        }
        this.fillLabelValue();
    }

    @FXML
    private void actionCommit() {
        double sum;
        SimpleDateFormat formatter;
        String dateInString;
        if (this.selectedDocument != null) {
            this.selectedDocument.setSysDTEdit(new Date());
            this.selectedDocument.setNote(this.taNote.getText().trim());
            this.selectedDocument.setSysUserEditID(this.controller.getUser().getUserID());
            this.selectedDocument.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
            this.selectedDocument.setPaid(0.0);
            this.selectedDocument.setNote2(this.tfAvans.getText());
            dateInString = new SimpleDateFormat("yyyy-MM-dd").format(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue()))) + " 23:59:59";
            formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                this.selectedDocument.setDeliveryDate(formatter.parse(dateInString));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            sum = 0.0;
            try {
                DocumentDetails.deleteDetailes((Document)this.selectedDocument, (Connection)this.controller.getSettings().getConnection());
                for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                    documentDetails.setDocumentID(this.selectedDocument.getDocumentID());
                    documentDetails.insert(this.controller.getSettings().getConnection());
                    sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
                }
                this.selectedDocument.setSum(sum);
                this.selectedDocument.setSumWithDiscount(sum);
                this.selectedDocument.update(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            if (this.selectedPerson == null) {
                this.controller.alert("Obavestenje", "Morate odabrati kupca pre kreiranja rezervacije", this.rootPane.getScene().getWindow());
                return;
            }
            this.selectedDocument = new Document();
            this.selectedDocument.setPersonID(this.selectedPerson.getPersonID());
            this.selectedDocument.setDiscount(Double.parseDouble(this.lblDiscount.getText().replace("%", "").trim()));
            this.selectedDocument.setSysDTCreated(new Date());
            this.selectedDocument.setNote(this.taNote.getText().trim());
            this.selectedDocument.setNumber(Integer.parseInt(this.tfNumber.getText().trim()));
            this.selectedDocument.setDocumentStatusID(DocumentStatus.getStatusByName((ScreensController)this.controller, (String)"U izradi").getDocumentStatusID());
            this.selectedDocument.setDocumentTypeID(DocumentType.getByCode((String)"RE", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
            this.selectedDocument.setSysUserAddID(this.controller.getUser().getUserID());
            dateInString = new SimpleDateFormat("yyyy-MM-dd").format(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue()))) + " 23:59:59";
            formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                this.selectedDocument.setDeliveryDate(formatter.parse(dateInString));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.selectedDocument.setDate(new Date());
            this.selectedDocument.setYear(Calendar.getInstance().get(1));
            this.selectedDocument.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
            this.selectedDocument.setPaid(0.0);
            this.selectedDocument.setNote2(this.tfAvans.getText());
            sum = 0.0;
            for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
            }
            this.selectedDocument.setSum(sum);
            this.selectedDocument.setSumWithDiscount(sum);
            long id = this.selectedDocument.insert(this.controller);
            for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                Product p = Product.getByID((long)documentDetails.getProductID(), (ScreensController)this.controller);
                documentDetails.setProduct(p);
                documentDetails.setDocumentID(id);
                documentDetails.insert(this.controller.getSettings().getConnection());
            }
        }
        for (Document document : this.listaDodatihProfaktura) {
            document.setReservated(true);
            DocumentRelationship documentRelationship = new DocumentRelationship();
            documentRelationship.setActive(true);
            documentRelationship.setDocumentChildID(this.selectedDocument.getDocumentID());
            documentRelationship.setDocumentParentID(document.getDocumentID());
            documentRelationship.setRelationshipTypeID(RelationshipType.getByName((ScreensController)this.controller, (String)"Profaktura - Rezervacija").getRelationshipTypeID());
            documentRelationship.setSysDTCreated(new Date());
            documentRelationship.setSysUserAddID(this.controller.getUser().getUserID());
            documentRelationship.insert(this.controller.getSettings().getConnection());
            try {
                document.update(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionBuyer() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        this.selectedPerson = (Person)hm.get("person");
        if (this.selectedPerson != null) {
            if (this.selectedPerson.getName().trim().equals("")) {
                this.lblSelectedPerson.setText(this.selectedPerson.getFirstLastName());
            } else {
                this.selectedPerson.getName();
            }
            this.cbProduct.setDisable(false);
        }
        this.discount = this.getDiscountForReservation();
        this.selectedPerson.setDiscount(this.discount);
        this.lblDiscount.setText(String.valueOf(this.discount + " %"));
    }

    @FXML
    private void actionClose() {
        this.listaDodatihProfaktura.clear();
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionReadProfaktura() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("aktivniKupac", this.selectedPerson);
        this.controller.showModalDialog("Profaktura - Detalji", ScreensController.SCREEN_BACKOFFICE_PROFAKTURA_SELECT_DIALOG, hm, this.rootPane.getScene().getWindow());
        Document selectedProfaktura = (Document)hm.get("selectedProfaktura");
        if (selectedProfaktura != null) {
            if (this.selectedPerson != null) {
                this.selectedPerson = Person.getById((long)selectedProfaktura.getPersonID(), (ScreensController)this.controller);
                this.lblSelectedPerson.setText(!this.selectedPerson.getName().equals("") ? this.selectedPerson.getName() : this.selectedPerson.getFirstLastName());
            }
            ObservableList newList = FXCollections.observableArrayList();
            for (DocumentDetails documentDetails : DocumentDetails.getObeservableList((long)selectedProfaktura.getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                documentDetails.setClosed(false);
                documentDetails.setDocumentDetailsID(-1L);
                this.tableDocument.getItems().add((Object)documentDetails);
            }
            for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                boolean ubaci = true;
                for (DocumentDetails ddDetails : newList) {
                    if (ddDetails.getProductID() != documentDetails.getProductID() || ddDetails.getPriceWithDiscount() != documentDetails.getPriceWithDiscount()) continue;
                    ddDetails.setQuantity(ddDetails.getQuantity() + documentDetails.getQuantity());
                    ubaci = false;
                }
                if (!ubaci) continue;
                newList.add((Object)documentDetails);
            }
            if (this.taNote.getText().equals("")) {
                this.taNote.setText("Profakture broj: " + selectedProfaktura.getNumber());
            } else {
                this.taNote.setText(this.taNote.getText() + ", " + selectedProfaktura.getNumber());
            }
            this.tfAvans.setText(selectedProfaktura.getNote2());
            this.listaDodatihProfaktura.add((Object)selectedProfaktura);
            this.tableDocument.getItems().clear();
            this.selectedPerson = Person.getById((long)selectedProfaktura.getPersonID(), (ScreensController)this.controller);
            if (this.selectedPerson != null) {
                this.lblSelectedPerson.setText(!this.selectedPerson.getName().equals("") ? this.selectedPerson.getName() : this.selectedPerson.getFirstLastName());
            }
            this.lblDiscount.setText(String.valueOf(selectedProfaktura.getDiscount()) + " %");
            this.tableDocument.setItems(newList);
            this.tableDocument.refresh();
            this.fillLabelValue();
        }
    }

    private void fillLabelValue() {
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
            System.out.println("Kolicina: " + documentDetails.getQuantity() + ", Cena: " + documentDetails.getPriceWithDiscount() + ", Ukupno: " + documentDetails.getQuantity() * documentDetails.getPriceWithDiscount());
            sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
        }
        this.lblValue.setText("\t" + String.valueOf(Settings.round((double)sum, (int)2)));
    }

    private double getPriceWithDiscount(double price, double discount) {
        double priceWithDiscount = price * (1.0 - discount / 100.0);
        return Settings.roundOnTwo((double)priceWithDiscount);
    }

    private double getDiscountForReservation() {
        Loyality loyality = Loyality.getByPerson((Person)this.selectedPerson, (ScreensController)this.controller);
        double value = Document.getSumBillForPeriodByLoyaltyID((Loyality)loyality, (ScreensController)this.controller);
        double reservationValue = Document.getActiveReservationsSumForPeriod((Loyality)loyality, (ScreensController)this.controller);
        System.out.println(reservationValue);
        this.buyerSpecificationMap.put("personValue", value);
        this.buyerSpecificationMap.put("reservatedValue", reservationValue);
        return FinancialDiscount.getDiscountforFinancialDiscount((Loyality)loyality, (double)value, (double)reservationValue, (ScreensController)this.controller);
    }

    @FXML
    private void getBuyerSpecification() {
        if (this.selectedPerson != null) {
            Loyality loyality = Loyality.getByPerson((Person)this.selectedPerson, (ScreensController)this.controller);
            double value = Document.getSumBillForPeriodByLoyaltyID((Loyality)loyality, (ScreensController)this.controller);
            double reservationValue = Document.getActiveReservationsSumForPeriod((Loyality)loyality, (ScreensController)this.controller);
            this.buyerSpecificationMap.put("personValue", value);
            this.buyerSpecificationMap.put("reservatedValue", reservationValue);
            this.buyerSpecificationMap.put("person", this.selectedPerson);
            this.buyerSpecificationMap.put("controller", this.controller);
            this.controller.showModalDialog("Specifikacija stalnog kupca", ScreensController.SCREEN_LOYALTY_SPECIFICATION, this.buyerSpecificationMap, this.rootPane.getScene().getWindow());
        } else {
            this.controller.alert("Gre\u0161ka kod izbora kuca", "Morate izabrati kupca da bi ste videli njegovu specifikaciju", this.rootPane.getScene().getWindow());
        }
    }
}

