/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.product.Product;

public class DetaljiPorudzbenicePregledTrgovinaController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Document selectedDocument;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<DocumentDetails> tableDocument;
    @FXML
    private TableColumn<DocumentDetails, Long> columnProduct;
    @FXML
    private TableColumn<Object, Double> columnQuantity;
    @FXML
    private TableColumn<Object, Double> columnPrice;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<Object, String> columnBarcode;
    @FXML
    private TextField tfFilter;
    @FXML
    private Label lblValue;

    @FXML
    private void initialize() {
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("ProductID"));
        this.columnProduct.setCellFactory(column -> new TableCell<DocumentDetails, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(Product.getByID((long)item, (ScreensController)DetaljiPorudzbenicePregledTrgovinaController.this.controller).getName());
                }
            }
        });
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithDiscount"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.columnBarcode.setCellValueFactory((Callback)new PropertyValueFactory("Barcode"));
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedDocument = (Document)parameter.get("selectedDocument");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tableDocument.setItems(DocumentDetails.getObeservableList((long)this.selectedDocument.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
        this.filter();
        this.fillLabelValue();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionClose() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillLabelValue() {
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
            sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
        }
        this.lblValue.setText("\t" + String.valueOf(Settings.round((double)sum, (int)2)));
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableDocument.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(document -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            Product product = Product.getByID((long)document.getProductID(), (ScreensController)this.controller);
            if (product.getShortName() != null && product.getShortName().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableDocument.comparatorProperty());
        this.tableDocument.setItems((ObservableList)sortedData);
    }
}

