/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.setup;

import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Synchronization;

public class SynchronizationAddController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Synchronization selectedSynchronization;
    boolean colorAnimation;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfDatabase;
    @FXML
    private CheckBox cbActive;
    @FXML
    private Button btnTest;
    @FXML
    private Button btnSave;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedSynchronization = (Synchronization)parameter.get("synchronisation");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillData();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void saveAction(ActionEvent event) {
        if (this.btnTest.getId().equals("1")) {
            if (this.selectedSynchronization != null) {
                this.selectedSynchronization.setDatabaseName(this.tfDatabase.getText());
                this.selectedSynchronization.setIpAddress(this.tfAddress.getText().trim());
                this.selectedSynchronization.setActive(this.cbActive.isSelected());
                this.selectedSynchronization.update(this.controller);
            } else {
                this.selectedSynchronization = new Synchronization();
                this.selectedSynchronization.setDatabaseName(this.tfDatabase.getText());
                this.selectedSynchronization.setIpAddress(this.tfAddress.getText().trim());
                this.selectedSynchronization.setActive(this.cbActive.isSelected());
                this.selectedSynchronization.insert(this.controller);
            }
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void closeAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void testAction(ActionEvent event) {
        if (Settings.getNewConnection((String)this.tfAddress.getText().trim(), (String)this.tfDatabase.getText().trim()) != null) {
            this.btnTest.setStyle("-fx-background-color: green");
            this.btnSave.setDisable(false);
            this.btnTest.setId("1");
        } else {
            this.btnTest.setStyle("-fx-background-color: red");
            this.btnTest.setId("-1");
            this.btnSave.setDisable(true);
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(() -> this.btnTest.setStyle("-fx-background-color: black"), 5L, TimeUnit.SECONDS);
    }

    private void fillData() {
        if (this.selectedSynchronization != null) {
            this.btnSave.setText("Izmeni");
            this.tfDatabase.setText(this.selectedSynchronization.getDatabaseName());
            this.tfAddress.setText(this.selectedSynchronization.getIpAddress());
            this.cbActive.setSelected(this.selectedSynchronization.isActive());
        } else {
            this.btnSave.setText("Sa\u010duvaj novi");
            this.tfDatabase.setText("");
            this.tfAddress.setText("");
            this.cbActive.setSelected(false);
        }
    }
}

