/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.setup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import rs.petcom.enums.FiscalPrinterDriver;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;

public class SetupController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfDbServer;
    @FXML
    private TextField tfDatabase;
    @FXML
    private TextField tfposCode;
    @FXML
    private TextField tfFiscalFolder;
    @FXML
    private TextField tfDefaultQuantity;
    @FXML
    private TextField tfTezinskiBarKod;
    @FXML
    private TextField tfBackground;
    @FXML
    private TextField tfJasperToPDF;
    @FXML
    private TextField tfBrojArtikalaZaUcitavanje;
    @FXML
    private TextField tfLpfrPath;
    @FXML
    private TextField tfPlstPath;
    @FXML
    private TextField tfVprfath;
    @FXML
    private TextField tfJID;
    @FXML
    private TextField tfPAK;
    @FXML
    private TextField tfPASSWORD;
    @FXML
    private TextField tfPutanjaSertifikat;
    @FXML
    private ComboBox<ComboBoxSetup> tfWorkDayCloseProductsReport;
    @FXML
    private ComboBox<ComboBoxSetup> tfWorkDayCloseOperatorReport;
    @FXML
    private ComboBox<ComboBoxSetup> tfWorkDayClosePluReport;
    @FXML
    private ComboBox<ComboBoxSetup> tfWorkDayCloseStateReport;
    @FXML
    private ComboBox<ComboBoxSetup> tfWorkDayCloseDailyReport;
    @FXML
    private ComboBox<ComboBoxSetup> tfFullscreen;
    @FXML
    private ComboBox<ComboBoxSetup> tfLoyality;
    @FXML
    private ComboBox<ComboBoxSetup> tfPonudiSledeciKod;
    @FXML
    private ComboBox<ComboBoxSetup> tfPonudiSledeciBarKod;
    @FXML
    private ComboBox<ComboBoxSetup> tfSrednjaNabavnaCena;
    @FXML
    private ComboBox<ComboBoxSetup> tfPopust;
    @FXML
    private ComboBox<ComboBoxSetup> tfSabiranjeArtikala;
    @FXML
    private ComboBox<ComboBoxSetup> tfKolPLUkod;
    @FXML
    private ComboBox<ComboBoxSetup> tfKolStanje;
    @FXML
    private ComboBox<ComboBoxSetup> tfNumerikUkljucen;
    @FXML
    private ComboBox<ComboBoxSetup> tfUplacenIznosNeophodan;
    @FXML
    private ComboBox<ComboBoxSetup> tfTrainingMode;
    @FXML
    private ComboBox<ComboBoxSetup> tfStampa;
    @FXML
    private ComboBox<ComboBoxSetup> cbVprf;
    @FXML
    private ComboBox<ComboBoxSetup> cbLCD;
    @FXML
    ComboBox<FiscalPrinterDriver> cbFiscalDriver;

    public void initialize() {
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillTextFields();
    }

    public void setParameter(Object parameter) {
        FiscalPrinterDriver[] fpDrivers;
        for (FiscalPrinterDriver driver : fpDrivers = FiscalPrinterDriver.values()) {
            this.cbFiscalDriver.getItems().add((Object)driver);
            this.cbFiscalDriver.getSelectionModel().select((Object)this.controller.getSettings().getFpDriver());
        }
    }

    public Object getParameter() {
        return null;
    }

    private void fillTextFields() {
        this.tfDbServer.setText(this.controller.getSettings().getDbserver());
        this.tfDatabase.setText(this.controller.getSettings().getDatabase());
        this.controller.getSettings();
        this.tfposCode.setText(Settings.getPosCode());
        this.tfFiscalFolder.setText(this.controller.getSettings().getFiscalFolder());
        this.tfDefaultQuantity.setText(String.valueOf(this.controller.getSettings().getDefaultQuantity()));
        this.tfTezinskiBarKod.setText(String.valueOf(this.controller.getSettings().getTezinskiBarKod()));
        this.tfBackground.setText(this.controller.getSettings().getPozadina());
        this.tfJasperToPDF.setText(this.controller.getSettings().getJasperToPDF());
        this.tfBrojArtikalaZaUcitavanje.setText(String.valueOf(this.controller.getSettings().getBrojArtikalaZaUcitavanje()));
        this.tfLpfrPath.setText(this.controller.getSettings().getLpfrPath());
        this.tfPlstPath.setText(this.controller.getSettings().getPlstPath());
        this.tfPASSWORD.setText(this.controller.getSettings().getPasswordVprf());
        this.tfPutanjaSertifikat.setText(this.controller.getSettings().getPutanjaSertifikat());
        this.tfJID.setText(this.controller.getSettings().getJID());
        this.tfPAK.setText(this.controller.getSettings().getPAK());
        this.tfVprfath.setText(this.controller.getSettings().getVprfPath());
        ObservableList lista = FXCollections.observableArrayList();
        ComboBoxSetup comboBoxSetup = new ComboBoxSetup();
        comboBoxSetup.setId(0);
        comboBoxSetup.setName("Ne");
        lista.add((Object)comboBoxSetup);
        ComboBoxSetup comboBoxSetup1 = new ComboBoxSetup();
        comboBoxSetup1.setId(1);
        comboBoxSetup1.setName("Da");
        lista.add((Object)comboBoxSetup1);
        ObservableList listaWD = FXCollections.observableArrayList();
        for (int i = 0; i < 11; ++i) {
            ComboBoxSetup cbSetup = new ComboBoxSetup();
            cbSetup.setId(i);
            cbSetup.setName(String.valueOf(i));
            listaWD.add((Object)cbSetup);
        }
        this.tfWorkDayCloseProductsReport.setItems(listaWD);
        this.tfWorkDayCloseProductsReport.getSelectionModel().select(this.controller.getSettings().getWdProductsReport());
        this.tfWorkDayCloseOperatorReport.setItems(listaWD);
        this.tfWorkDayCloseOperatorReport.getSelectionModel().select(this.controller.getSettings().getWdOperatorReport());
        this.tfWorkDayClosePluReport.setItems(listaWD);
        this.tfWorkDayClosePluReport.getSelectionModel().select(this.controller.getSettings().getWdPluReport());
        this.tfWorkDayCloseStateReport.setItems(listaWD);
        this.tfWorkDayCloseStateReport.getSelectionModel().select(this.controller.getSettings().getWdStateReport());
        this.tfWorkDayCloseDailyReport.setItems(listaWD);
        this.tfWorkDayCloseDailyReport.getSelectionModel().select(this.controller.getSettings().getWdDailyReport());
        this.tfFullscreen.setItems(lista);
        this.tfFullscreen.getSelectionModel().select(this.controller.getSettings().isFullscreen() ? 1 : 0);
        this.tfLoyality.setItems(lista);
        this.tfLoyality.getSelectionModel().select(this.controller.getSettings().isLoyality() ? 1 : 0);
        this.tfPonudiSledeciKod.setItems(lista);
        this.tfPonudiSledeciKod.getSelectionModel().select(this.controller.getSettings().isPonudiSledeciKod() ? 1 : 0);
        this.tfPonudiSledeciBarKod.setItems(lista);
        this.tfPonudiSledeciBarKod.getSelectionModel().select(this.controller.getSettings().isPonudiSledeciBarKod() ? 1 : 0);
        this.tfSrednjaNabavnaCena.setItems(lista);
        this.tfSrednjaNabavnaCena.getSelectionModel().select(this.controller.getSettings().isSrednjaNabavnaCena() ? 1 : 0);
        this.tfPopust.setItems(lista);
        this.tfPopust.getSelectionModel().select(this.controller.getSettings().isPopust() ? 1 : 0);
        this.tfSabiranjeArtikala.setItems(lista);
        this.tfSabiranjeArtikala.getSelectionModel().select(this.controller.getSettings().isSabiranjeArtikala() ? 1 : 0);
        this.tfKolPLUkod.setItems(lista);
        this.tfKolPLUkod.getSelectionModel().select(this.controller.getSettings().isKolPlukod() ? 1 : 0);
        this.tfKolStanje.setItems(lista);
        this.tfKolStanje.getSelectionModel().select(this.controller.getSettings().isKolStanje() ? 1 : 0);
        this.tfNumerikUkljucen.setItems(lista);
        this.tfNumerikUkljucen.getSelectionModel().select(this.controller.getSettings().isNumerikUkljucen() ? 1 : 0);
        this.tfUplacenIznosNeophodan.setItems(lista);
        this.tfUplacenIznosNeophodan.getSelectionModel().select(this.controller.getSettings().getUplacenIznos());
        this.tfTrainingMode.setItems(lista);
        this.tfStampa.setItems(lista);
        this.tfTrainingMode.getSelectionModel().select(this.controller.getSettings().isTrainingMode() ? 1 : 0);
        this.tfStampa.getSelectionModel().select(Boolean.parseBoolean(this.controller.getSettings().getStampa()) ? 1 : 0);
        this.cbLCD.setItems(lista);
        this.cbLCD.getSelectionModel().select(Boolean.parseBoolean(this.controller.getSettings().getLCD()) ? 1 : 0);
        this.cbVprf.setItems(lista);
        this.cbVprf.getSelectionModel().select(Boolean.parseBoolean(this.controller.getSettings().getPrimaryAdressVprf()) ? 1 : 0);
    }

    private boolean checkTextFields() {
        boolean provera = false;
        block0: for (Node node : this.rootPane.getChildren()) {
            if (!(node instanceof GridPane)) continue;
            for (Node nodeText : ((GridPane)node).getChildren()) {
                if (!(nodeText instanceof TextField) || "tfPlstPath".equals(nodeText.getId()) || !((TextField)nodeText).getText().equals("")) continue;
                provera = true;
                continue block0;
            }
        }
        return provera;
    }

    @FXML
    private void saveAction() {
        if (!this.checkTextFields()) {
            this.saveTerminalData();
        } else {
            this.controller.alert("Obavestenje", "Tekstualno polje ne moze biti prazno", this.rootPane.getScene().getWindow());
        }
    }

    private void saveTerminalData() {
        try {
            File makeDirTMaster = new File("C:\\TMaster");
            if (makeDirTMaster != null) {
                makeDirTMaster.mkdir();
            }
            FileOutputStream outputStream = new FileOutputStream("./setup.cnf");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("dbserver=" + this.tfDbServer.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setDbserver(this.tfDbServer.getText().trim());
            bufferedWriter.write("database=" + this.tfDatabase.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setDatabase(this.tfDatabase.getText().trim());
            bufferedWriter.write("posCode=" + this.tfposCode.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setPosCode(this.tfposCode.getText().trim());
            this.controller.getSettings();
            this.controller.setPointOfSale(new PointOfSale(Settings.getPosCode(), this.controller.getSettings().getConnection()));
            bufferedWriter.write("fiscalFolder=" + this.tfFiscalFolder.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setFiscalFolder(this.tfFiscalFolder.getText().trim());
            bufferedWriter.write("defaultQuantity=" + this.tfDefaultQuantity.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setDefaultQuantity(Integer.parseInt(this.tfDefaultQuantity.getText().trim()));
            bufferedWriter.write("workDayClose.productsReport=" + String.valueOf(((ComboBoxSetup)this.tfWorkDayCloseProductsReport.getSelectionModel().getSelectedItem()).getId()).trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setWdProductsReport(((ComboBoxSetup)this.tfWorkDayCloseProductsReport.getSelectionModel().getSelectedItem()).getId());
            bufferedWriter.write("workDayClose.operatorReport=" + String.valueOf(((ComboBoxSetup)this.tfWorkDayCloseOperatorReport.getSelectionModel().getSelectedItem()).getId()).trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setWdOperatorReport(((ComboBoxSetup)this.tfWorkDayCloseOperatorReport.getSelectionModel().getSelectedItem()).getId());
            bufferedWriter.write("workDayClose.pluReport=" + String.valueOf(((ComboBoxSetup)this.tfWorkDayClosePluReport.getSelectionModel().getSelectedItem()).getId()).trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setWdPluReport(((ComboBoxSetup)this.tfWorkDayClosePluReport.getSelectionModel().getSelectedItem()).getId());
            bufferedWriter.write("workDayClose.stateReport=" + String.valueOf(((ComboBoxSetup)this.tfWorkDayCloseStateReport.getSelectionModel().getSelectedItem()).getId()).trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setWdStateReport(((ComboBoxSetup)this.tfWorkDayCloseStateReport.getSelectionModel().getSelectedItem()).getId());
            bufferedWriter.write("workDayClose.dailyReport=" + String.valueOf(((ComboBoxSetup)this.tfWorkDayCloseDailyReport.getSelectionModel().getSelectedItem()).getId()).trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setWdDailyReport(((ComboBoxSetup)this.tfWorkDayCloseDailyReport.getSelectionModel().getSelectedItem()).getId());
            bufferedWriter.write("fullscreen=" + (((ComboBoxSetup)this.tfFullscreen.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setFullscreen(((ComboBoxSetup)this.tfFullscreen.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("loyality=" + (((ComboBoxSetup)this.tfLoyality.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            bufferedWriter.write("LCD=" + (((ComboBoxSetup)this.cbLCD.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setLoyality(((ComboBoxSetup)this.tfLoyality.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("uplacenIznosNeophodan=" + (((ComboBoxSetup)this.tfUplacenIznosNeophodan.getSelectionModel().getSelectedItem()).getId() == 1 ? "1" : "0"));
            bufferedWriter.newLine();
            this.controller.getSettings().setUplacenIznos(((ComboBoxSetup)this.tfUplacenIznosNeophodan.getSelectionModel().getSelectedItem()).getId());
            bufferedWriter.write("tezinskiBarKod=" + this.tfTezinskiBarKod.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setTezinskiBarKod(Integer.parseInt(this.tfTezinskiBarKod.getText().trim()));
            bufferedWriter.write("sabiranjeArtikala=" + (((ComboBoxSetup)this.tfSabiranjeArtikala.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setSabiranjeArtikala(((ComboBoxSetup)this.tfSabiranjeArtikala.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("background=" + this.tfBackground.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setPozadina(this.tfBackground.getText().trim());
            bufferedWriter.write("kolPLUkod=" + (((ComboBoxSetup)this.tfKolPLUkod.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setKolPlukod(((ComboBoxSetup)this.tfKolPLUkod.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("kolStanje=" + (((ComboBoxSetup)this.tfKolStanje.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setKolStanje(((ComboBoxSetup)this.tfKolStanje.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("numerikUkljucen=" + (((ComboBoxSetup)this.tfNumerikUkljucen.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setNumerikUkljucen(((ComboBoxSetup)this.tfNumerikUkljucen.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("jasperToPDF=" + this.tfJasperToPDF.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setJasperToPDF(this.tfJasperToPDF.getText().trim());
            bufferedWriter.write("brojArtikalaZaUcitavanje=" + this.tfBrojArtikalaZaUcitavanje.getText().trim());
            bufferedWriter.newLine();
            this.controller.getSettings().setBrojArtikalaZaUcitavanje(Integer.parseInt(this.tfBrojArtikalaZaUcitavanje.getText().trim()));
            bufferedWriter.write("ponudiSledeciKod=" + (((ComboBoxSetup)this.tfPonudiSledeciKod.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setPonudiSledeciKod(((ComboBoxSetup)this.tfPonudiSledeciKod.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("ponudiSledeciBarKod=" + (((ComboBoxSetup)this.tfPonudiSledeciBarKod.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setPonudiSledeciBarKod(((ComboBoxSetup)this.tfPonudiSledeciBarKod.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("srednjaNabavnaCena=" + (((ComboBoxSetup)this.tfSrednjaNabavnaCena.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setSrednjaNabavnaCena(((ComboBoxSetup)this.tfSrednjaNabavnaCena.getSelectionModel().getSelectedItem()).getId() == 1);
            bufferedWriter.write("fpDriver=" + ((FiscalPrinterDriver)this.cbFiscalDriver.getSelectionModel().getSelectedItem()).name());
            this.controller.getSettings().setFpDriver((FiscalPrinterDriver)this.cbFiscalDriver.getSelectionModel().getSelectedItem());
            bufferedWriter.newLine();
            bufferedWriter.write("trening=" + (((ComboBoxSetup)this.tfTrainingMode.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            this.controller.getSettings().setTrainingMode(((ComboBoxSetup)this.tfTrainingMode.getSelectionModel().getSelectedItem()).getId() == 1);
            if (this.tfPlstPath.getText() != null) {
                bufferedWriter.write("PlstPutanja=" + this.tfPlstPath.getText().trim());
                this.controller.getSettings().setLpfrPath(this.tfPlstPath.getText().trim());
                bufferedWriter.newLine();
            }
            bufferedWriter.write("LpfrPutanja=" + this.tfLpfrPath.getText().trim());
            this.controller.getSettings().setLpfrPath(this.tfLpfrPath.getText().trim());
            bufferedWriter.newLine();
            bufferedWriter.write("primarnaAdresaVprf=" + (((ComboBoxSetup)this.cbVprf.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.newLine();
            if (this.tfVprfath.getText() != null) {
                bufferedWriter.write("VprfPutanja=" + this.tfVprfath.getText().trim());
                this.controller.getSettings().setLpfrPath(this.tfVprfath.getText().trim());
                bufferedWriter.newLine();
            }
            if (this.tfPAK != null) {
                bufferedWriter.write("tfPak=" + this.tfPAK.getText().trim());
                this.controller.getSettings().setLpfrPath(this.tfPAK.getText().trim());
                bufferedWriter.newLine();
            }
            if (this.tfJID != null) {
                bufferedWriter.write("tfJID=" + this.tfJID.getText().trim());
                this.controller.getSettings().setLpfrPath(this.tfJID.getText().trim());
                bufferedWriter.newLine();
            }
            if (this.tfPASSWORD != null) {
                bufferedWriter.write("tfPASSWORD=" + this.tfPASSWORD.getText().trim());
                this.controller.getSettings().setLpfrPath(this.tfPASSWORD.getText().trim());
                bufferedWriter.newLine();
            }
            if (this.tfPutanjaSertifikat != null) {
                bufferedWriter.write("tfPutanjaSertifikat=" + this.tfPutanjaSertifikat.getText().trim());
                this.controller.getSettings().setLpfrPath(this.tfPutanjaSertifikat.getText().trim());
                bufferedWriter.newLine();
            }
            bufferedWriter.write("stampa=" + (((ComboBoxSetup)this.tfStampa.getSelectionModel().getSelectedItem()).getId() == 1 ? "true" : "false"));
            bufferedWriter.flush();
            bufferedWriter.close();
            this.controller.alert("Obavestenje", "Podaci su sacuvani", this.rootPane.getScene().getWindow());
            this.controller.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_BACKOFFICE);
        }
        catch (IOException ex) {
            this.controller.alert("Obavestenje", "Podaci nisu sacuvani", this.rootPane.getScene().getWindow());
            return;
        }
    }

    public class ComboBoxSetup {
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

