/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.setup;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Present;
import rs.petcom.master.gui.DoubleTableCellFactory;
import rs.petcom.master.gui.trgovina.TooltipTableRow;

public class PresentController
implements ControlledScreen {
    private ScreensController controller;
    private Present selectedPresent;
    private DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextArea taFilter;
    @FXML
    private TableView<Present> tvPresent;
    @FXML
    private TableColumn<Object, Double> tcBillSumFrom;
    @FXML
    private TableColumn<Object, Double> tcBillSumTo;
    @FXML
    private TableColumn<Object, Double> tcDiscountPercent;
    @FXML
    private TableColumn<Object, Double> tcDiscountMonay;
    @FXML
    private TableColumn<Present, String> tcMessage;
    @FXML
    private TableColumn<Present, Boolean> tcActivePresent;
    @FXML
    private TableColumn<Present, Boolean> tcActiveDiscount;

    public void initialize() {
        this.tvPresent.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Present>(){

            public void onChanged(ListChangeListener.Change<? extends Present> c) {
                PresentController.this.selectedPresent = (Present)PresentController.this.tvPresent.getSelectionModel().getSelectedItem();
            }
        });
        this.tvPresent.setRowFactory(tableView -> new TooltipTableRow(present -> present.getMessage()));
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
        }
        this.loadPresentTable();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void addAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("present", null);
        int result = this.controller.showModalDialog("Podesavanje poklona i popusta - kreiranje", ScreensController.SCREEN_BACKOFFICE_DODAVANJE_POKLONA_POPUSTA, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            // empty if block
        }
        this.loadPresentTable();
    }

    @FXML
    private void editAction() {
        if (this.selectedPresent != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("present", this.selectedPresent);
            int result = this.controller.showModalDialog("Podesavanje poklona i popusta - izmena", ScreensController.SCREEN_BACKOFFICE_DODAVANJE_POKLONA_POPUSTA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
        }
        this.selectedPresent = null;
        this.loadPresentTable();
    }

    @FXML
    private void deleteAction() {
        if (this.selectedPresent != null) {
            this.selectedPresent.delete(this.controller);
        } else {
            this.controller.alert("Obavestenje", "Ne postoji poklon za brisanje, morate ga prvo kreirati", this.rootPane.getScene().getWindow());
        }
        this.loadPresentTable();
    }

    private void loadPresentTable() {
        this.tcBillSumFrom.setCellValueFactory((Callback)new PropertyValueFactory("billSumFrom"));
        this.tcBillSumFrom.setCellFactory((Callback)this.cellFactory);
        this.makeHeaderWrappable(this.tcBillSumFrom);
        this.tcBillSumTo.setCellValueFactory((Callback)new PropertyValueFactory("billSumTo"));
        this.tcBillSumTo.setCellFactory((Callback)this.cellFactory);
        this.makeHeaderWrappable(this.tcBillSumTo);
        this.tcDiscountPercent.setCellValueFactory((Callback)new PropertyValueFactory("discountPercent"));
        this.tcDiscountPercent.setCellFactory((Callback)this.cellFactory);
        this.makeHeaderWrappable(this.tcDiscountPercent);
        this.tcDiscountMonay.setCellValueFactory((Callback)new PropertyValueFactory("discountMonay"));
        this.tcDiscountMonay.setCellFactory((Callback)this.cellFactory);
        this.makeHeaderWrappable(this.tcDiscountMonay);
        this.tcMessage.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        this.tcActivePresent.setCellValueFactory((Callback)new PropertyValueFactory("activePresent"));
        this.tcActivePresent.setCellFactory(column -> new TableCell<Present, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.makeHeaderWrappable(this.tcActivePresent);
        this.tcActiveDiscount.setCellValueFactory((Callback)new PropertyValueFactory("activeDiscount"));
        this.tcActiveDiscount.setCellFactory(column -> new TableCell<Present, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.makeHeaderWrappable(this.tcActiveDiscount);
        this.tvPresent.setItems(Present.getPresentList((ScreensController)this.controller));
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }
}

