/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class TrakaRadaController
implements ControlledScreen {
    ScreensController controller;
    PointOfSale sviPosovi = new PointOfSale(-1, "Sva prodajna mesta");
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnPrintPDF;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.setItems(rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection()));
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.popuniFilterPos();
        this.dpDateFrom.setValue((Object)LocalDate.now());
        this.dpDateTo.setValue((Object)LocalDate.now());
    }

    public void setParameter(Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void objekatChange() {
        this.popuniFilterPos();
    }

    @FXML
    public void showReport(final ActionEvent event) {
        final String reportFileName = "rs/petcom/backoffice/jasper/TrakaRada.jasper";
        final HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())).getTime()));
        hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())).getTime()));
        hm.put("objekatId", ((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hm.put("posId", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hm.put("uslovi", "Objekat :" + ((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()).getName() + "\nProdajno mesto: " + ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getName() + "\nZa perod od: " + Settings.getDateFromatter().format(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue()))) + " do: " + Settings.getDateFromatter().format(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue()))));
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<HashMap<String, Object>> creatingReport = new Task<HashMap<String, Object>>(){

            protected HashMap<String, Object> call() throws Exception {
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)TrakaRadaController.this.controller.getSettings().getConnection());
                if (!((Button)event.getSource()).getText().equals("PDF")) {
                    JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                    JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                    virtualizer.setReadOnly(true);
                    HashMap<String, Object> hm2 = new HashMap<String, Object>();
                    hm2.put("report", printViewPane);
                    hm2.put("REPORT_VIRTUALIZER", virtualizer);
                    return hm2;
                }
                TrakaRadaController.this.controller.printFileFromPDF(TrakaRadaController.this.controller.getPdfFromJasper(jprint, "\u0160tampa trake rada", "TrakaRada"));
                return null;
            }
        };
        creatingReport.setOnSucceeded(arg_0 -> this.lambda$showReport$0(taskUpdateStage, (Task)creatingReport, arg_0));
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Gre\u0161ka u kreiranju izve\u0161taja", this.rootPane.getScene().getWindow());
        });
        new Thread((Runnable)creatingReport).start();
    }

    private void popuniFilterPos() {
        this.cbPos.getItems().clear();
        this.cbPos.getItems().add((Object)this.sviPosovi);
        for (PointOfSale p : PointOfSale.getPosList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbPos.getItems().add((Object)p);
        }
        this.cbPos.getSelectionModel().select((Object)this.sviPosovi);
    }

    private /* synthetic */ void lambda$showReport$0(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        if (creatingReport.getValue() != null) {
            this.controller.showModalDialog("Traka rada", ScreensController.DIALOG_PRINT_PREVIEW, (HashMap)creatingReport.getValue(), this.rootPane.getScene().getWindow());
        }
    }
}

