/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JasperViewer;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.print.DynamicColumnDataSource;
import rs.petcom.print.DynamicColumnsDataJasper;
import rs.petcom.print.DynamicReportBuilder;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class StockReportController
implements ControlledScreen {
    ScreensController controller;
    ArrayList<AditionalField> selectedAditionalField;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private BorderPane reportPane;
    @FXML
    private CheckBox cbSamoSaPromenama;
    @FXML
    private RadioButton rbIzborCene1;
    @FXML
    private TableView<AditionalField> tableAditionalField;
    @FXML
    private TableColumn<AditionalField, Long> columnID;
    @FXML
    private TableColumn<AditionalField, String> columnName;
    @FXML
    private TableColumn<AditionalField, CheckBox> columnCheckBoxField;

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                StockReportController.this.loadDepartment();
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void setParameter(java.lang.Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dateFrom.setConverter(this.converter);
        this.dateFrom.setValue((java.lang.Object)Settings.fromDate((java.util.Date)WorkDay.getFirstStart((Connection)this.controller.getSettings().getConnection())));
        this.dateTo.setConverter(this.converter);
        this.dateTo.setValue((java.lang.Object)LocalDate.now());
        this.cbObject.setItems(Object.getList((Connection)this.controller.getSettings().getConnection()));
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.columnID.setCellValueFactory((Callback)new PropertyValueFactory("AditionalFieldID"));
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnCheckBoxField.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<AditionalField, CheckBox>, ObservableValue<CheckBox>>(){

            public ObservableValue<CheckBox> call(TableColumn.CellDataFeatures<AditionalField, CheckBox> arg0) {
                CheckBox checkBox = new CheckBox();
                final AditionalField object = (AditionalField)arg0.getValue();
                checkBox.selectedProperty().setValue(Boolean.valueOf(false));
                checkBox.setSelected(object.isSelected());
                checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                        object.setSelected(new_val.booleanValue());
                    }
                });
                return new SimpleObjectProperty((java.lang.Object)checkBox);
            }
        });
        this.tableAditionalField.setItems(AditionalField.getList((Connection)this.controller.getSettings().getConnection()));
    }

    @FXML
    private void showReport(final ActionEvent event) {
        try {
            final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
            LocalDate currentDate = LocalDate.now();
            PreparedStatement ps1 = this.controller.getSettings().getConnection().prepareStatement("CALL `stock_report_receiving_report`('" + new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()) + "', '" + new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()) + "', '" + ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() + "', '" + (this.cbSamoSaPromenama.isSelected() ? 1 : 0) + "', '" + (this.rbIzborCene1.isSelected() ? 1 : 0) + "')");
            ps1.executeQuery();
            ps1.close();
            final String reportFileName = "rs/petcom/backoffice/jasper/StockReportProba.jasper";
            String uslovi = this.controller.getBundle().getString("dateFrom") + this.converter.toString(this.dateFrom.getValue());
            final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("danOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
            hm.put("danDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
            hm.put("objekat", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("company", CompanyConfig.getByID((long)((Object)this.cbObject.getSelectionModel().getSelectedItem()).getCompanyConfigID(), (ScreensController)this.controller));
            hm.put("uslovi", uslovi);
            Task<Void> creatingReport = new Task<Void>(){

                protected Void call() throws Exception {
                    try {
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        final JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)StockReportController.this.controller.getSettings().getConnection());
                        if (((Button)event.getSource()).getText().equals("PDF")) {
                            StockReportController.this.controller.printFileFromPDF(StockReportController.this.controller.getPdfFromJasper(jprint, "Stanje na lageru", "Stanje"));
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    taskUpdateStage.hide();
                                }
                            });
                        } else {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    taskUpdateStage.hide();
                                    JasperViewer.viewReport((JasperPrint)jprint, (boolean)false);
                                }
                            });
                        }
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                        throw new Exception();
                    }
                    return null;
                }
            };
            new Thread((Runnable)creatingReport).start();
            creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
            });
        }
        catch (SQLException e) {
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja: " + e.getMessage(), this.rootPane.getScene().getWindow());
            e.printStackTrace();
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        this.cbDepartment.getSelectionModel().select(0);
    }

    @FXML
    private void showReportTest() {
        int aditionalColCounter = 0;
        this.selectedAditionalField = new ArrayList();
        FastReportBuilder drb = new FastReportBuilder();
        try {
            drb.addColumn("Sifra", "code", String.class.getName(), 30).addColumn("Naziv", "name", String.class.getName(), 30).addColumn("JM", "jm", String.class.getName(), 50).addColumn("Pocetno stanje", "pocetnoStanje", Double.class.getName(), 50).addColumn("Izlaz", "izlaz", Double.class.getName(), 30, true).addColumn("Ulaz", "ulaz", Double.class.getName(), 60, true).addColumn("Zavrasno stanje", "zavrsnoStanje", Double.class.getName(), 30, true).addColumn("Vrednost fin.", "vrednostFinansijska", Double.class.getName(), 30, true).addColumn("Prodajna vrednost", "prodajnaVrednost", Double.class.getName(), 30, true);
            for (int i = 0; i < this.tableAditionalField.getItems().size(); ++i) {
                if (!((AditionalField)this.tableAditionalField.getItems().get(i)).isSelected()) continue;
                drb.addColumn(((AditionalField)this.tableAditionalField.getItems().get(i)).getName(), "dodatnoPolje" + ++aditionalColCounter, String.class.getName(), 30);
                this.selectedAditionalField.add((AditionalField)this.tableAditionalField.getItems().get(i));
            }
            DynamicReport dr = drb.setTitle("Izve\u0161taj o zalihama").setSubtitle("Datum: " + new java.util.Date()).setPrintBackgroundOnOddRows(true).setUseFullPageWidth(true).build();
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource((Collection)DynamicColumnsDataJasper.getStockReportData((LocalDate)((LocalDate)this.dateFrom.getValue()), (LocalDate)((LocalDate)this.dateTo.getValue()), (int)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (boolean)this.cbSamoSaPromenama.isSelected(), (!this.rbIzborCene1.isSelected() ? 1 : 0) != 0, this.selectedAditionalField, (Connection)this.controller.getSettings().getConnection()));
            JasperPrint jp = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jp);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Pregled stanja zaliha", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
            printViewPane = null;
        }
        catch (ColumnBuilderException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void runReport(List<String> columnHeaders, List<List<String>> rows) throws JRException {
        InputStream is = this.getClass().getResourceAsStream("../../../DynamicColumns.jrxml");
        JasperDesign jasperReportDesign = JRXmlLoader.load((InputStream)is);
        DynamicReportBuilder reportBuilder = new DynamicReportBuilder(jasperReportDesign, columnHeaders.size());
        reportBuilder.addDynamicColumns();
        JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperReportDesign);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("REPORT_TITLE", "Sample Dynamic Columns Report");
        DynamicColumnDataSource pdfDataSource = new DynamicColumnDataSource(columnHeaders, rows);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params, (JRDataSource)pdfDataSource);
        JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)"/tmp/DynamicColumns.pdf");
    }
}

