/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.Product;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class StockReportBaseTableController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<AditionalField> aditionlFieldFilter = FXCollections.observableArrayList();
    String aditionlFieldDetailsFilter = "";
    ObservableList<Product> list;
    ObservableList<TableColumn<Product, String>> columnList = FXCollections.observableArrayList();
    private ObservableList<VBox> listTreeItem = FXCollections.observableArrayList();
    private List<CheckBoxTreeItem<AditionalFieldDetails>> listAditionalFieldDetailsCheckBox = new ArrayList<CheckBoxTreeItem<AditionalFieldDetails>>();
    String pathWithoutName = null;
    ToggleGroup rbGroup = new ToggleGroup();
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Product> table;
    @FXML
    private TableColumn<Product, String> cKod;
    @FXML
    private TableColumn<Product, String> cBarKod;
    @FXML
    private TableColumn<Product, String> cArtikal;
    @FXML
    private TableColumn<Product, String> cJM;
    @FXML
    private TableColumn<Product, Double> cStanje;
    @FXML
    private TableColumn<Product, Double> cReserve;
    @FXML
    private TableColumn<Product, Double> cSrednjaCena;
    @FXML
    private TableColumn<Product, Double> cSrednjaVrednost;
    @FXML
    private TableColumn<Product, Double> cPoslednjaNCena;
    @FXML
    private TableColumn<Product, Double> cPoslednjaNValue;
    @FXML
    private TableColumn<Product, Double> cCena;
    @FXML
    private TableColumn<Product, Double> cVrednost;
    @FXML
    private TextField tfFilter;
    @FXML
    private Label lblFinansijskaVrednost;
    @FXML
    private Label lblAveragePurchaseValue;
    @FXML
    private Label lblRazlika;
    @FXML
    private HBox hBoxAditionalField;
    @FXML
    private TilePane tilePane;
    @FXML
    private CheckBox withoutZero;
    @FXML
    private CheckBox srednjaNcena;
    @FXML
    private CheckBox srednjaNvrednost;
    @FXML
    private CheckBox prodajnaNcena;
    @FXML
    private CheckBox prodajnaNvrednost;
    @FXML
    private CheckBox prodajnaCena;
    @FXML
    private CheckBox prodajnaVrednost;
    @FXML
    private RadioButton rbKod;
    @FXML
    private RadioButton rbBarkod;
    @FXML
    private RadioButton rbArtikal;
    @FXML
    private DatePicker dpTo;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void initialize() {
        this.cKod.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.makeHeaderWrappable(this.cKod);
        this.cBarKod.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.makeHeaderWrappable(this.cBarKod);
        this.cArtikal.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.makeHeaderWrappable(this.cArtikal);
        this.cJM.setCellValueFactory((Callback)new PropertyValueFactory("UnitName"));
        this.makeHeaderWrappable(this.cJM);
        this.cStanje.setCellValueFactory((Callback)new PropertyValueFactory("Stock"));
        this.makeHeaderWrappable(this.cStanje);
        this.cReserve.setCellValueFactory((Callback)new PropertyValueFactory("stockReservation"));
        this.makeHeaderWrappable(this.cReserve);
        this.cPoslednjaNCena.setCellValueFactory((Callback)new PropertyValueFactory("nabavnaCena"));
        this.makeHeaderWrappable(this.cPoslednjaNCena);
        this.cPoslednjaNValue.setCellValueFactory((Callback)new PropertyValueFactory("nabavnaCenaValue"));
        this.makeHeaderWrappable(this.cPoslednjaNValue);
        this.cSrednjaCena.setCellValueFactory((Callback)new PropertyValueFactory("srednjaNabavnaCena"));
        this.makeHeaderWrappable(this.cSrednjaCena);
        this.cSrednjaVrednost.setCellValueFactory((Callback)new PropertyValueFactory("srednjaNabavnaValue"));
        this.makeHeaderWrappable(this.cSrednjaVrednost);
        this.cCena.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.makeHeaderWrappable(this.cCena);
        this.cVrednost.setCellValueFactory((Callback)new PropertyValueFactory("valueLager"));
        this.makeHeaderWrappable(this.cVrednost);
        this.srednjaNcena.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockReportBaseTableController.this.cSrednjaCena.setVisible(StockReportBaseTableController.this.srednjaNcena.isSelected());
                if (!StockReportBaseTableController.this.srednjaNcena.isSelected()) {
                    StockReportBaseTableController.this.srednjaNvrednost.setSelected(StockReportBaseTableController.this.srednjaNcena.isSelected());
                    StockReportBaseTableController.this.cSrednjaVrednost.setVisible(StockReportBaseTableController.this.srednjaNvrednost.isSelected());
                }
                StockReportBaseTableController.this.srednjaNvrednost.setDisable(!StockReportBaseTableController.this.srednjaNcena.isSelected());
            }
        });
        this.srednjaNvrednost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockReportBaseTableController.this.cSrednjaVrednost.setVisible(StockReportBaseTableController.this.srednjaNvrednost.isSelected());
            }
        });
        this.prodajnaNcena.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockReportBaseTableController.this.cPoslednjaNCena.setVisible(StockReportBaseTableController.this.prodajnaNcena.isSelected());
                if (!StockReportBaseTableController.this.prodajnaNcena.isSelected()) {
                    StockReportBaseTableController.this.prodajnaNvrednost.setSelected(StockReportBaseTableController.this.prodajnaNcena.isSelected());
                    StockReportBaseTableController.this.cPoslednjaNValue.setVisible(StockReportBaseTableController.this.prodajnaNvrednost.isSelected());
                }
                StockReportBaseTableController.this.prodajnaNvrednost.setDisable(!StockReportBaseTableController.this.prodajnaNcena.isSelected());
            }
        });
        this.prodajnaNvrednost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockReportBaseTableController.this.cPoslednjaNValue.setVisible(StockReportBaseTableController.this.prodajnaNvrednost.isSelected());
            }
        });
        this.prodajnaCena.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockReportBaseTableController.this.cCena.setVisible(StockReportBaseTableController.this.prodajnaCena.isSelected());
                if (!StockReportBaseTableController.this.prodajnaCena.isSelected()) {
                    StockReportBaseTableController.this.prodajnaVrednost.setSelected(StockReportBaseTableController.this.prodajnaCena.isSelected());
                    StockReportBaseTableController.this.cVrednost.setVisible(StockReportBaseTableController.this.prodajnaVrednost.isSelected());
                }
                StockReportBaseTableController.this.prodajnaVrednost.setDisable(!StockReportBaseTableController.this.prodajnaCena.isSelected());
            }
        });
        this.prodajnaVrednost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockReportBaseTableController.this.cVrednost.setVisible(StockReportBaseTableController.this.prodajnaVrednost.isSelected());
            }
        });
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                    hm.put("controller", this.controller);
                    hm.put("product", this.table.getSelectionModel().getSelectedItem());
                    hm.put("dateTo", this.dpTo.getValue());
                    hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
                    hm.put("dateLagera", Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue())));
                    int yesOrNo = this.controller.showModalDialog("Pregled robne kartice", ScreensController.DIALOG_ROBNA_KARTICA_DETALJI_ARTIKLA, hm, this.rootPane.getScene().getWindow());
                    if (yesOrNo == ScreensController.MODAL_RESULT_OK) {
                        this.table.getSelectionModel().clearSelection();
                    }
                }
            });
            return row;
        });
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        for (Department department : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)department);
            this.cbDepartment.getSelectionModel().select(0);
        }
        this.createCheckBoxAditionalField();
        this.dpTo.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
        this.rbKod.setToggleGroup(this.rbGroup);
        this.rbBarkod.setToggleGroup(this.rbGroup);
        this.rbArtikal.setToggleGroup(this.rbGroup);
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void pdfAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((java.lang.Object)new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.PDF"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            this.pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            ObservableList newList = FXCollections.observableArrayList();
            for (Product product : this.table.getItems()) {
                if (product.getStock() == 0.0) continue;
                newList.add((java.lang.Object)product);
            }
            Product.getReceivingReportToPDF((ScreensController)this.controller, (ObservableList)newList, (String)this.pathWithoutName, (String)file.getName());
            this.controller.printFileFromPDF(file);
        }
    }

    @FXML
    private void excelAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((java.lang.Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            String filePath;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            this.pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            ObservableList newList = FXCollections.observableArrayList();
            for (Product product : this.table.getItems()) {
                if (product.getStock() == 0.0) continue;
                newList.add((java.lang.Object)product);
            }
            if (file != null && !(filePath = file.getAbsolutePath()).toUpperCase().endsWith(".CSV")) {
                filePath = filePath + ".xml";
            }
            if (this.withoutZero.isSelected()) {
                Product.getReceivingReportToExcel((ScreensController)this.controller, (ObservableList)newList, (String)this.pathWithoutName, (String)file.getName());
            } else {
                Product.getReceivingReportToExcel((ScreensController)this.controller, (ObservableList)this.table.getItems(), (String)this.pathWithoutName, (String)file.getName());
            }
            this.controller.printFileFromPDF(file);
        }
    }

    private void populateTable(ObservableList<Product> list) {
        String filter = "";
        if (!this.aditionlFieldFilter.isEmpty()) {
            for (AditionalField str : this.aditionlFieldFilter) {
                filter = filter + str.getAditionalFieldID() + ",";
            }
        }
        try {
            final ObservableList aditionalFieldList = AditionalField.getListWithFilter((String)filter.substring(0, filter.length() - 1), (Connection)this.controller.getSettings().getConnection());
            for (int i = 0; i < aditionalFieldList.size(); ++i) {
                final int num = i;
                TableColumn column = new TableColumn(((AditionalField)aditionalFieldList.get(i)).getName());
                column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Product, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<Product, String> param) {
                        try {
                            return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)AditionalFieldDetails.getByProductID((long)((Product)param.getValue()).getProductID(), (long)((AditionalField)aditionalFieldList.get(num)).getAditionalFieldID(), (Connection)StockReportBaseTableController.this.controller.getSettings().getConnection())).name("Name").build();
                        }
                        catch (NoSuchMethodException | NullPointerException e) {
                            return null;
                        }
                    }
                });
                column.setResizable(true);
                column.setMinWidth(80.0);
                column.setPrefWidth(80.0);
                column.setMaxWidth(1000.0);
                column.setEditable(true);
                column.setSortable(true);
                column.setSortType(TableColumn.SortType.ASCENDING);
                this.columnList.add((java.lang.Object)column);
                this.table.getColumns().add((java.lang.Object)column);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.table.setItems(list);
        this.tfFilter.setText("");
        this.sumVrednostArtikala();
    }

    private void sumVrednostArtikala() {
        double vrednost = 0.0;
        double average = 0.0;
        for (Product product : this.table.getItems()) {
            vrednost += product.getPrice() * product.getStock();
            average += product.getNabavnaCena() * product.getStock();
        }
        this.lblFinansijskaVrednost.setText(Settings.getNumberFormat((int)2, (boolean)false).format(vrednost));
        this.lblAveragePurchaseValue.setText(Settings.getNumberFormat((int)2, (boolean)false).format(average));
        this.lblRazlika.setText(Settings.getNumberFormat((int)2, (boolean)false).format(vrednost - average));
    }

    private void createCheckBoxAditionalField() {
        final ObservableList aditionalFieldList = AditionalField.getList((Connection)this.controller.getSettings().getConnection());
        for (int i = 0; i < aditionalFieldList.size(); ++i) {
            final int index = i;
            if (!((AditionalField)aditionalFieldList.get(i)).isBackoffice()) continue;
            final CheckBox checkBox = new CheckBox(((AditionalField)aditionalFieldList.get(i)).getName());
            checkBox.setPrefWidth(150.0);
            this.hBoxAditionalField.getChildren().add((java.lang.Object)checkBox);
            checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    System.out.println(checkBox.getText());
                    AditionalField aField = AditionalField.getByName((String)checkBox.getText(), (Connection)StockReportBaseTableController.this.controller.getSettings().getConnection());
                    if (newValue.booleanValue()) {
                        StockReportBaseTableController.this.deselctAllCb(checkBox, StockReportBaseTableController.this.hBoxAditionalField);
                        StockReportBaseTableController.this.aditionlFieldFilter.add((java.lang.Object)aField);
                        TreeView treeView = new TreeView();
                        treeView.setId(aField.getName());
                        treeView.setCellFactory(p -> new CheckBoxTreeCell<AditionalFieldDetails>(){

                            public void updateItem(AditionalFieldDetails item, boolean empty) {
                                super.updateItem((java.lang.Object)item, empty);
                                if (item != null) {
                                    this.setText(item.getName());
                                }
                            }
                        });
                        CheckBoxTreeItem treeItem = new CheckBoxTreeItem();
                        AditionalFieldDetails afd = new AditionalFieldDetails();
                        afd.setName(aField.getName());
                        treeItem.setValue((java.lang.Object)afd);
                        for (AditionalFieldDetails aditionalFieldDetails : AditionalFieldDetails.getListByAditionalFieldID((long)((AditionalField)aditionalFieldList.get(index)).getAditionalFieldID(), (Connection)StockReportBaseTableController.this.controller.getSettings().getConnection())) {
                            CheckBoxTreeItem afdmenu = new CheckBoxTreeItem();
                            afdmenu.setValue((java.lang.Object)aditionalFieldDetails);
                            afdmenu.setIndependent(true);
                            treeItem.getChildren().add((java.lang.Object)afdmenu);
                            StockReportBaseTableController.this.listAditionalFieldDetailsCheckBox.add(afdmenu);
                        }
                        treeView.setPrefWidth(250.0);
                        treeView.setRoot((TreeItem)treeItem);
                        treeView.setShowRoot(false);
                        Label label = new Label(treeView.getId());
                        VBox vBox = new VBox();
                        vBox.setId(aField.getName());
                        vBox.setPadding(new Insets(0.0, 0.0, 40.0, 0.0));
                        vBox.getChildren().add((java.lang.Object)label);
                        vBox.getChildren().add((java.lang.Object)treeView);
                        StockReportBaseTableController.this.tilePane.setVisible(true);
                        StockReportBaseTableController.this.tilePane.getChildren().add((java.lang.Object)vBox);
                        StockReportBaseTableController.this.listTreeItem.add((java.lang.Object)vBox);
                    } else {
                        StockReportBaseTableController.this.aditionlFieldFilter.remove((java.lang.Object)aField);
                        if (!StockReportBaseTableController.this.listTreeItem.isEmpty()) {
                            for (VBox treeView : StockReportBaseTableController.this.listTreeItem) {
                                if (!treeView.getId().equals(aField.getName())) continue;
                                Iterator iterator = StockReportBaseTableController.this.listAditionalFieldDetailsCheckBox.iterator();
                                while (iterator.hasNext()) {
                                    if (!treeView.getChildren().contains(iterator.next())) continue;
                                    iterator.remove();
                                }
                                StockReportBaseTableController.this.tilePane.getChildren().remove((java.lang.Object)treeView);
                            }
                        }
                    }
                }
            });
            this.hBoxAditionalField.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        }
    }

    @FXML
    private void showTable() {
        this.aditionlFieldDetailsFilter = "";
        this.tilePane.setVisible(false);
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje artikala u toku.", this.rootPane.getScene().getWindow());
        for (CheckBoxTreeItem<AditionalFieldDetails> ti : this.listAditionalFieldDetailsCheckBox) {
            if (!ti.isSelected()) continue;
            this.aditionlFieldDetailsFilter = this.aditionlFieldDetailsFilter + ((AditionalFieldDetails)ti.getValue()).getAditionalFieldDetailsID() + ",";
        }
        Task<ObservableList<Product>> loadingCsvTask = new Task<ObservableList<Product>>(){

            protected ObservableList<Product> call() throws Exception {
                LocalDate currentDate = LocalDate.now();
                try {
                    StockReportBaseTableController.this.list = Product.getNewReceivingReport((String)StockReportBaseTableController.this.tfFilter.getText(), StockReportBaseTableController.this.aditionlFieldFilter, (String)StockReportBaseTableController.this.aditionlFieldDetailsFilter.substring(0, StockReportBaseTableController.this.aditionlFieldDetailsFilter.length() - 1), (ScreensController)StockReportBaseTableController.this.controller, (int)((Department)StockReportBaseTableController.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (LocalDate)((LocalDate)StockReportBaseTableController.this.dpTo.getValue()), (boolean)StockReportBaseTableController.this.rbKod.isSelected(), (boolean)StockReportBaseTableController.this.rbBarkod.isSelected(), (boolean)StockReportBaseTableController.this.rbArtikal.isSelected(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)StockReportBaseTableController.this.prodajnaCena.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaVrednost.isSelected());
                }
                catch (StringIndexOutOfBoundsException ex) {
                    StockReportBaseTableController.this.list = Product.getNewReceivingReport((String)StockReportBaseTableController.this.tfFilter.getText(), StockReportBaseTableController.this.aditionlFieldFilter, (String)StockReportBaseTableController.this.aditionlFieldDetailsFilter, (ScreensController)StockReportBaseTableController.this.controller, (int)((Department)StockReportBaseTableController.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (LocalDate)((LocalDate)StockReportBaseTableController.this.dpTo.getValue()), (boolean)StockReportBaseTableController.this.rbKod.isSelected(), (boolean)StockReportBaseTableController.this.rbBarkod.isSelected(), (boolean)StockReportBaseTableController.this.rbArtikal.isSelected(), (boolean)true, (boolean)StockReportBaseTableController.this.srednjaNvrednost.isSelected(), (boolean)true, (boolean)StockReportBaseTableController.this.prodajnaNvrednost.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaCena.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaVrednost.isSelected());
                }
                return StockReportBaseTableController.this.list;
            }
        };
        loadingCsvTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            if (!this.columnList.isEmpty()) {
                for (TableColumn column : this.columnList) {
                    this.table.getColumns().remove((java.lang.Object)column);
                }
            }
            this.populateTable(this.list);
            this.table.setVisible(true);
            this.filter();
        });
        loadingCsvTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)loadingCsvTask).start();
    }

    @FXML
    private void showTableFilter() {
        if (!this.tfFilter.getText().equals("")) {
            this.aditionlFieldDetailsFilter = "";
            this.tilePane.setVisible(false);
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje artikala u toku.", this.rootPane.getScene().getWindow());
            for (CheckBoxTreeItem<AditionalFieldDetails> ti : this.listAditionalFieldDetailsCheckBox) {
                if (!ti.isSelected()) continue;
                this.aditionlFieldDetailsFilter = this.aditionlFieldDetailsFilter + ((AditionalFieldDetails)ti.getValue()).getAditionalFieldDetailsID() + ",";
            }
            Task<ObservableList<Product>> loadingCsvTask = new Task<ObservableList<Product>>(){

                protected ObservableList<Product> call() throws Exception {
                    LocalDate currentDate = LocalDate.now();
                    try {
                        StockReportBaseTableController.this.list = Product.getNewReceivingReport((String)StockReportBaseTableController.this.tfFilter.getText(), StockReportBaseTableController.this.aditionlFieldFilter, (String)StockReportBaseTableController.this.aditionlFieldDetailsFilter.substring(0, StockReportBaseTableController.this.aditionlFieldDetailsFilter.length() - 1), (ScreensController)StockReportBaseTableController.this.controller, (int)((Department)StockReportBaseTableController.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (LocalDate)((LocalDate)StockReportBaseTableController.this.dpTo.getValue()), (boolean)StockReportBaseTableController.this.rbKod.isSelected(), (boolean)StockReportBaseTableController.this.rbBarkod.isSelected(), (boolean)StockReportBaseTableController.this.rbArtikal.isSelected(), (boolean)StockReportBaseTableController.this.srednjaNcena.isSelected(), (boolean)StockReportBaseTableController.this.srednjaNvrednost.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaNcena.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaNvrednost.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaCena.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaVrednost.isSelected());
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        StockReportBaseTableController.this.list = Product.getNewReceivingReport((String)StockReportBaseTableController.this.tfFilter.getText(), StockReportBaseTableController.this.aditionlFieldFilter, (String)StockReportBaseTableController.this.aditionlFieldDetailsFilter, (ScreensController)StockReportBaseTableController.this.controller, (int)((Department)StockReportBaseTableController.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (LocalDate)((LocalDate)StockReportBaseTableController.this.dpTo.getValue()), (boolean)StockReportBaseTableController.this.rbKod.isSelected(), (boolean)StockReportBaseTableController.this.rbBarkod.isSelected(), (boolean)StockReportBaseTableController.this.rbArtikal.isSelected(), (boolean)StockReportBaseTableController.this.srednjaNcena.isSelected(), (boolean)StockReportBaseTableController.this.srednjaNvrednost.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaNcena.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaNvrednost.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaCena.isSelected(), (boolean)StockReportBaseTableController.this.prodajnaVrednost.isSelected());
                    }
                    return StockReportBaseTableController.this.list;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                if (!this.columnList.isEmpty()) {
                    for (TableColumn column : this.columnList) {
                        this.table.getColumns().remove((java.lang.Object)column);
                    }
                }
                this.populateTable(this.list);
                this.table.setVisible(true);
                this.filter();
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        } else {
            this.controller.alert("Obavestenje", "Morate uneti podatak koji zelite da pretrazite, polje ne moze piti prazno", this.rootPane.getScene().getWindow());
        }
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.list, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            filteredData.setPredicate(product -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                try {
                    if (product.getName().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    if (product.getShortName().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    if (product.getCode().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    if (product.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return false;
            });
            this.sumVrednostArtikala();
        });
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }

    @FXML
    private void printAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/blagajna/LagerLista.jasper";
        ObservableList dataList = FXCollections.observableArrayList();
        for (Product product : this.table.getItems()) {
            if (product.getStock() == 0.0) continue;
            dataList.add((java.lang.Object)product);
        }
        JRBeanCollectionDataSource beanColDataSource = this.withoutZero.isSelected() ? new JRBeanCollectionDataSource((Collection)dataList) : new JRBeanCollectionDataSource((Collection)this.table.getItems());
        HashMap<String, String> hm = new HashMap<String, String>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (JRDataSource)beanColDataSource);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    public void deselctAllCb(CheckBox cb, HBox hb) {
        ObservableList list = hb.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            CheckBox child = (CheckBox)list.get(i);
            if (cb.getText().equals(child.getText())) continue;
            child.setSelected(false);
        }
    }
}

