/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.BeanPropertyUtils;
import rs.petcom.backoffice.gui.CustomPropertyEditorFactory;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class SpecificationInvoiceController
implements ControlledScreen {
    private ScreensController controller;
    private ToggleGroup group = new ToggleGroup();
    @FXML
    private BorderPane rootPane;
    @FXML
    private ChoiceBox<DocumentType> cbDocumentType;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private CheckComboBox<Person> clvPerson;
    @FXML
    private RadioButton rbPurchacePrice;
    @FXML
    private RadioButton rbSellPrice;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillPerson();
        this.fillDocumentType();
        this.dpDateFrom.setValue((Object)LocalDate.now());
        this.dpDateTo.setValue((Object)LocalDate.now());
        this.rbPurchacePrice.setToggleGroup(this.group);
        this.rbSellPrice.setToggleGroup(this.group);
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void display(ActionEvent event) {
        String dobavljaci = "";
        for (Person person : this.clvPerson.getCheckModel().getCheckedItems()) {
            dobavljaci = dobavljaci + person.getPersonID();
            dobavljaci = dobavljaci + ",";
        }
        final String reportFileName = this.rbPurchacePrice.isSelected() && !this.rbSellPrice.isSelected() ? "rs/petcom/backoffice/jasper/SpecificationInvoice.jasper" : "rs/petcom/backoffice/jasper/SpecificationInvoiceSellValue.jasper";
        final HashMap<String, Object> hm = new HashMap<String, Object>();
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (!images.getName().equals("memorandum")) continue;
                try {
                    hm.put("memorandum", ImageIO.read(images.getImage()));
                    hm.put("logo", null);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", "null");
        }
        hm.put("objekat", rs.petcom.master.dal.Object.get((Connection)this.controller.getSettings().getConnection()));
        hm.put("dobavljaci", dobavljaci.equals("") ? "-1" : (dobavljaci.contains(",") ? dobavljaci.substring(0, dobavljaci.length() - 1) : dobavljaci));
        hm.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())).getTime()));
        hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())).getTime()));
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje specifikacije u toku...", this.rootPane.getScene().getWindow());
        Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

            protected JasperPrint call() throws Exception {
                try {
                    JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                    hm.put("REPORT_VIRTUALIZER", virtualizer);
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)SpecificationInvoiceController.this.controller.getSettings().getConnection());
                    virtualizer.setReadOnly(true);
                    return jprint;
                }
                catch (JRException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        creatingReport.setOnSucceeded(arg_0 -> this.lambda$display$0(taskUpdateStage, (Task)creatingReport, arg_0));
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje specifikacije", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    private void fillPerson() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        propertySheet.getItems().setAll((Collection)BeanPropertyUtils.getProperties((Object)Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection())));
        for (Person person : Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection())) {
            this.clvPerson.getItems().add((Object)person);
        }
    }

    private void fillDocumentType() {
        this.cbDocumentType.setItems(DocumentType.getListByCodes((String)"PR,IP,OT", (Connection)this.controller.getSettings().getConnection()));
        if (!this.cbDocumentType.getItems().isEmpty()) {
            this.cbDocumentType.getSelectionModel().select(0);
        }
    }

    private /* synthetic */ void lambda$display$0(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
        HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
        hm2.put("report", printViewPane);
        this.controller.showModalDialog("Specifikacija", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
    }
}

