/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductGroup;
import rs.petcom.master.gui.TreeProductGroupCell;
import rs.petcom.master.gui.trgovina.TimeSpinner;
import rs.petcom.print.JRPrintPreviewPane;

public class SalesReportServiceController
implements ControlledScreen {
    ScreensController controller;
    TimeSpinner timeSpinnerFrom;
    TimeSpinner timeSpinnerTo;
    TreeItem<ProductGroup> treeRootGroups;
    TreeItem<AditionalFieldDetails> treeRootAF;
    String grupe = "";
    String grupeNazivi = "";
    StringBuilder sbDodatnaPolja = new StringBuilder();
    ArrayList<CheckBoxTreeItem<AditionalFieldDetails>> aditionalFildList = new ArrayList();
    ArrayList<CheckBoxTreeItem<AditionalFieldDetails>> aditionalFildDetailsList = new ArrayList();
    ObservableList<Product> list;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    StringConverter<LocalTime> converterTime = new StringConverter<LocalTime>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("hh:MM:ss");

        public String toString(LocalTime time) {
            if (time != null) {
                return this.dateFormatter.format(time);
            }
            return "";
        }

        public LocalTime fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalTime.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private BorderPane reportPane;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<User> cbOperator;
    @FXML
    private ComboBox<PriceList> cbPriceList;
    @FXML
    private TreeView<ProductGroup> treeGroup;
    @FXML
    private TreeView<AditionalFieldDetails> treeAditionalFieldDetails;
    @FXML
    private CheckBox cbIzborGrupa;
    @FXML
    private CheckBox cbIzborDodatnihPolja;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button btnSalesProducts;
    @FXML
    private Button btnSalesProductsByVat;
    @FXML
    private Button btnSalesAllOperators;
    @FXML
    private Button btnSalesOperator;
    @FXML
    private Button btnSalesProductsByBarCode;
    @FXML
    private Button btnSalesProductsByPriceList;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
        this.treeGroup.setCellFactory(g -> new TreeProductGroupCell());
        this.treeGroup.setShowRoot(false);
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                SalesReportServiceController.this.ucitajPOS();
            }
        });
    }

    public void setParameter(java.lang.Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getUser().hasRole("manager")) {
            this.cbOperator.setDisable(false);
        } else {
            this.cbOperator.setDisable(true);
        }
        for (User u : this.cbOperator.getItems()) {
            if (u.getUserID() != this.controller.getUser().getUserID()) continue;
            this.cbOperator.getSelectionModel().select((java.lang.Object)u);
        }
        this.timeSpinnerFrom = new TimeSpinner();
        this.gridPane.add((Node)this.timeSpinnerFrom, 2, 5);
        this.timeSpinnerTo = new TimeSpinner();
        this.gridPane.add((Node)this.timeSpinnerTo, 5, 5);
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        for (java.lang.Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add(o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.dateFrom.setConverter(this.converter);
        this.dateTo.setConverter(this.converter);
        this.dateFrom.setValue((java.lang.Object)LocalDate.now());
        this.dateTo.setValue((java.lang.Object)LocalDate.now());
        this.cbOperator.setItems(User.getUserList((Connection)this.controller.getSettings().getConnection()));
        if (this.cbOperator.getItems().size() > 0) {
            this.cbOperator.getSelectionModel().select(0);
        }
        this.cbPriceList.setItems(PriceList.getObeservableList((boolean)true, (Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection()));
        if (this.cbPriceList.getItems().size() > 0) {
            PriceList priceList = PriceList.getActive((LocalDateTime)Settings.LocalDateTimefromDate((java.util.Date)Settings.fromLocalDate((LocalDate)LocalDate.now())), (int)this.controller.getObject().getObjectID(), (Connection)this.controller.getSettings().getConnection());
            for (PriceList pList : this.cbPriceList.getItems()) {
                if (pList.getPriceListID() != priceList.getPriceListID()) continue;
                this.cbPriceList.getSelectionModel().select((java.lang.Object)pList);
            }
        }
        this.treeRootGroups = new CheckBoxTreeItem();
        this.treeRootGroups.setValue((java.lang.Object)new ProductGroup(-1, "Grupe", 1));
        for (ProductGroup g : ProductGroup.getList((int)1, (Connection)this.controller.getSettings().getConnection())) {
            TreeItem groupItem = new TreeItem();
            groupItem.setValue((java.lang.Object)g);
            this.treeRootGroups.getChildren().add((java.lang.Object)groupItem);
            groupItem.setExpanded(true);
        }
        this.treeRootGroups.setExpanded(true);
        this.treeGroup.setRoot(this.treeRootGroups);
        this.treeAditionalFieldDetails.setCellFactory(a -> new CheckBoxTreeCell<AditionalFieldDetails>(){

            public void updateItem(AditionalFieldDetails item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                }
            }
        });
        this.treeAditionalFieldDetails.setShowRoot(false);
        this.treeRootAF = new TreeItem();
        for (AditionalField af : AditionalField.getList((Connection)this.controller.getSettings().getConnection())) {
            CheckBoxTreeItem cbTreeItem = new CheckBoxTreeItem();
            cbTreeItem.setValue((java.lang.Object)new AditionalFieldDetails(af.getAditionalFieldID(), af.getName()));
            for (AditionalFieldDetails afd : AditionalFieldDetails.getListByAditionalFieldID((long)af.getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection())) {
                CheckBoxTreeItem cbTreeSubItem = new CheckBoxTreeItem((java.lang.Object)afd);
                cbTreeSubItem.setSelected(true);
                cbTreeItem.getChildren().add((java.lang.Object)cbTreeSubItem);
                this.aditionalFildDetailsList.add((CheckBoxTreeItem<AditionalFieldDetails>)cbTreeSubItem);
            }
            cbTreeItem.setSelected(true);
            cbTreeItem.setExpanded(true);
            this.treeRootAF.getChildren().add((java.lang.Object)cbTreeItem);
            this.aditionalFildList.add((CheckBoxTreeItem<AditionalFieldDetails>)cbTreeItem);
        }
        this.treeRootAF.setExpanded(false);
        this.treeAditionalFieldDetails.setRoot(this.treeRootAF);
    }

    @FXML
    private void showSales(ActionEvent event) {
        String reportFileName = "";
        if ((Button)event.getSource() == this.btnSalesProducts) {
            reportFileName = "rs/petcom/backoffice/jasper/pregled_prometa/SalesProductsAF.jasper";
            this.list = Product.getReceivingReportSalesProducts((ScreensController)this.controller, (PointOfSale)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()), (TimeSpinner)this.timeSpinnerFrom, (TimeSpinner)this.timeSpinnerTo, (DatePicker)this.dateFrom, (DatePicker)this.dateTo, (CheckBox)this.cbIzborGrupa, (String)this.grupe, (CheckBox)this.cbIzborDodatnihPolja, (StringBuilder)this.sbDodatnaPolja, (CheckBox)new CheckBox(), (StringBuilder)new StringBuilder(), (String)"", (boolean)false, (boolean)false);
        } else if ((Button)event.getSource() == this.btnSalesProductsByVat) {
            reportFileName = "rs/petcom/backoffice/jasper/pregled_prometa/SalesProductsByVat.jasper";
        } else if ((Button)event.getSource() == this.btnSalesAllOperators) {
            reportFileName = "rs/petcom/backoffice/jasper/pregled_prometa/SalesReportAllOperators.jasper";
        } else if ((Button)event.getSource() == this.btnSalesOperator) {
            reportFileName = "rs/petcom/backoffice/jasper/pregled_prometa/SalesReportOperator.jasper";
        } else if ((Button)event.getSource() == this.btnSalesProductsByBarCode) {
            reportFileName = "rs/petcom/backoffice/jasper/pregled_prometa/SalesReportByBarCode.jasper";
        } else if ((Button)event.getSource() == this.btnSalesProductsByPriceList) {
            reportFileName = "rs/petcom/backoffice/jasper/pregled_prometa/SalesReportByBarCode.jasper";
        }
        String uslovi = this.converter.toString(this.dateFrom.getValue()) + " - " + this.converter.toString(this.dateTo.getValue()) + "\n" + this.timeSpinnerFrom.getEditor().getText() + " - " + this.timeSpinnerTo.getEditor().getText();
        if (this.cbIzborGrupa.isSelected()) {
            uslovi = "Sve grupe \n" + this.converter.toString(this.dateFrom.getValue()) + " - " + this.converter.toString(this.dateTo.getValue()) + "\n" + this.timeSpinnerFrom.getEditor().getText() + " - " + this.timeSpinnerTo.getEditor().getText();
        } else {
            for (TreeItem g : this.treeRootGroups.getChildren()) {
                if (!((ProductGroup)g.getValue()).isSelected()) continue;
                if (!this.grupe.equals("")) {
                    this.grupe = this.grupe + ",";
                    this.grupeNazivi = this.grupeNazivi + ", ";
                }
                this.grupe = this.grupe + String.valueOf(((ProductGroup)g.getValue()).getProductGroupID());
                this.grupeNazivi = this.grupeNazivi + String.valueOf(((ProductGroup)g.getValue()).getName());
            }
            uslovi = this.grupeNazivi + "\n" + this.converter.toString(this.dateFrom.getValue()) + " - " + this.converter.toString(this.dateTo.getValue()) + "\n" + this.timeSpinnerFrom.getEditor().getText() + " - " + this.timeSpinnerTo.getEditor().getText();
        }
        if (!this.cbIzborDodatnihPolja.isSelected()) {
            for (int i = 0; i < this.aditionalFildDetailsList.size(); ++i) {
                if (!this.aditionalFildDetailsList.get(i).isSelected()) continue;
                this.sbDodatnaPolja.append(i < this.aditionalFildDetailsList.size() - 1 ? ((AditionalFieldDetails)this.aditionalFildDetailsList.get(i).getValue()).getAditionalFieldDetailsID() + "," : Long.valueOf(((AditionalFieldDetails)this.aditionalFildDetailsList.get(i).getValue()).getAditionalFieldDetailsID()));
            }
        }
        final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
        hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
        hm.put("vremeOd", Time.valueOf(this.timeSpinnerFrom.getEditor().getText()));
        hm.put("vremeDo", this.timeSpinnerTo.getEditor().getText().equals("00:00:00") ? Time.valueOf("23:59:59") : Time.valueOf(this.timeSpinnerTo.getEditor().getText()));
        hm.put("pos", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hm.put("objekat", ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hm.put("uslovi", uslovi);
        hm.put("izborGrupa", !this.cbIzborGrupa.isSelected());
        hm.put("izborDodatnihPolja", !this.cbIzborDodatnihPolja.isSelected());
        hm.put("dodatnaPolja", this.sbDodatnaPolja.toString());
        hm.put("grupe", this.grupe);
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        final String reportFileName2 = reportFileName;
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName2));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)SalesReportServiceController.this.controller.getSettings().getConnection());
                    JRPrintPreviewPane printViewPane = SalesReportServiceController.this.list != null ? new JRPrintPreviewPane(jprint, SalesReportServiceController.this.controller, SalesReportServiceController.this.list) : new JRPrintPreviewPane(jprint);
                    final HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
                    hm2.put("report", printViewPane);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                            SalesReportServiceController.this.controller.showModalDialog("Pregled prodaje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, SalesReportServiceController.this.rootPane.getScene().getWindow());
                        }
                    });
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    @FXML
    private void showReport2() {
        String reportFileName = "rs/petcom/backoffice/jasper/SumarySalesReport.jasper";
        String unutrasnjiFI = "rs/petcom/backoffice/jasper/unutrasnjiFI.jasper";
        String unutrasnjiNI = "rs/petcom/backoffice/jasper/unutrasnjiNI.jasper";
        String unutrasnjiRR = "rs/petcom/backoffice/jasper/unutrasnjiRucRacuni.jasper";
        String uslovi = this.controller.getBundle().getString("dateFrom") + this.converter.toString(this.dateFrom.getValue()) + " - " + this.controller.getBundle().getString("dateTo") + this.converter.toString(this.dateTo.getValue());
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
        hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
        hm.put("pos", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hm.put("objekat", ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hm.put("uslovi", uslovi);
        HashMap<String, java.lang.Object> hmFI = new HashMap<String, java.lang.Object>();
        hmFI.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
        hmFI.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
        hmFI.put("pos", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hmFI.put("objekat", ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hmFI.put("uslovi", uslovi);
        HashMap<String, java.lang.Object> hmNI = new HashMap<String, java.lang.Object>();
        hmNI.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
        hmNI.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
        hmNI.put("pos", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hmNI.put("objekat", ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hmNI.put("uslovi", uslovi);
        HashMap<String, java.lang.Object> hmRR = new HashMap<String, java.lang.Object>();
        hmRR.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
        hmRR.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
        hmRR.put("pos", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hmRR.put("objekat", ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hmRR.put("uslovi", uslovi);
        hm.put("params1", hmFI);
        hm.put("params2", hmNI);
        hm.put("params3", hmRR);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperReport subreport1 = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)unutrasnjiFI));
            JasperReport subreport2 = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)unutrasnjiNI));
            JasperReport subreport3 = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)unutrasnjiRR));
            hm.put("subreport1", subreport1);
            hm.put("subreport2", subreport2);
            hm.put("subreport3", subreport3);
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
            HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Pregeld prodaje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
            printViewPane = null;
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void izborGrupaAction() {
        this.treeGroup.setDisable(this.cbIzborGrupa.isSelected());
    }

    @FXML
    private void izborDodatnihAction() {
        this.treeAditionalFieldDetails.setDisable(this.cbIzborDodatnihPolja.isSelected());
    }

    private void ucitajPOS() {
        this.cbPos.getItems().clear();
        PointOfSale svaProdajnaMesta = new PointOfSale();
        svaProdajnaMesta.setPointOfSaleID(-1);
        svaProdajnaMesta.setName("Sva prodajna mesta");
        this.cbPos.getItems().add((java.lang.Object)svaProdajnaMesta);
        for (PointOfSale pos : PointOfSale.getPosList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbPos.getItems().add((java.lang.Object)pos);
        }
        this.cbPos.getSelectionModel().select((java.lang.Object)svaProdajnaMesta);
    }
}

