/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.backoffice.salesreportnew.reportmodels.JasperStarter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.RazlikaUCeni;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.summary.RazlikaUCenuSummary;

public class RazlikaUCeniController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<RazlikaUCeni> list = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDanOd;
    @FXML
    private DatePicker dpDanDo;
    @FXML
    private RadioButton rbPoslednjaNC;
    @FXML
    private RadioButton rbProsecnaNc;
    @FXML
    private TableView<RazlikaUCeni> tableRUC;
    @FXML
    private TableView<RazlikaUCenuSummary> tableRUCTot;
    @FXML
    private TableColumn<RazlikaUCeni, Product> columnProduct;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnQuantity;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnPurchacePrice;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnSellPrice;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnPurchaceValue;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnDifferencePrice;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnSellValue;
    @FXML
    private TableColumn<RazlikaUCeni, Double> columnDifferenceValue;
    @FXML
    private TableColumn<RazlikaUCenuSummary, String> columnProductTot;
    @FXML
    private TableColumn<RazlikaUCenuSummary, Double> columnPurchaceValueTot;
    @FXML
    private TableColumn<RazlikaUCenuSummary, Double> columnSellValueTot;
    @FXML
    private TableColumn<RazlikaUCenuSummary, Double> columnDifferenceValueTot;
    @FXML
    private TextField tfFilter;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void initialize() {
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpDanOd.setValue((Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpDanDo.setValue((Object)LocalDate.now());
        this.tableRUCTot.setFixedCellSize(30.0);
        this.tableRUCTot.prefHeightProperty().bind((ObservableValue)this.tableRUCTot.fixedCellSizeProperty().multiply((ObservableNumberValue)Bindings.size((ObservableList)this.tableRUCTot.getItems()).add(1.01)));
        this.tableRUCTot.minHeightProperty().bind((ObservableValue)this.tableRUCTot.prefHeightProperty());
        this.tableRUCTot.maxHeightProperty().bind((ObservableValue)this.tableRUCTot.prefHeightProperty());
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void showAction() {
        this.loadTable();
    }

    private void loadTable() {
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("product"));
        this.columnProduct.setCellFactory(column -> new TableCell<RazlikaUCeni, Product>(){

            protected void updateItem(Product item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getShortName());
                }
            }
        });
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.columnPurchacePrice.setCellValueFactory((Callback)new PropertyValueFactory("purchacePrice"));
        this.columnPurchaceValue.setCellValueFactory((Callback)new PropertyValueFactory("purchaceValue"));
        this.columnDifferencePrice.setCellValueFactory((Callback)new PropertyValueFactory("differencePrice"));
        this.columnSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellPrice"));
        this.columnSellValue.setCellValueFactory((Callback)new PropertyValueFactory("sellValue"));
        this.columnDifferenceValue.setCellValueFactory((Callback)new PropertyValueFactory("differenceValue"));
        this.columnProductTot.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.columnPurchaceValueTot.setCellValueFactory((Callback)new PropertyValueFactory("purchaceValueTotal"));
        this.columnSellValueTot.setCellValueFactory((Callback)new PropertyValueFactory("sellValueTotal"));
        this.columnDifferenceValueTot.setCellValueFactory((Callback)new PropertyValueFactory("differeneceValueTotal"));
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje u toku...", this.rootPane.getScene().getWindow());
        final RazlikaUCeni ruc = new RazlikaUCeni(this.controller);
        Task<ObservableList<RazlikaUCeni>> loadingCsvTask = new Task<ObservableList<RazlikaUCeni>>(){

            protected ObservableList<RazlikaUCeni> call() throws Exception {
                if (RazlikaUCeniController.this.rbPoslednjaNC.isSelected()) {
                    RazlikaUCeniController.this.list = ruc.getRazlikaUceniListByDateLAST((LocalDate)RazlikaUCeniController.this.dpDanOd.getValue(), (LocalDate)RazlikaUCeniController.this.dpDanDo.getValue());
                } else {
                    RazlikaUCeniController.this.list = ruc.getRazlikaUceniListByDateAVG((LocalDate)RazlikaUCeniController.this.dpDanOd.getValue(), (LocalDate)RazlikaUCeniController.this.dpDanDo.getValue());
                }
                return RazlikaUCeniController.this.list;
            }
        };
        loadingCsvTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.tableRUC.setItems(this.list);
            this.tableRUCTot.setItems(ruc.getRucSummaryList());
            this.filter();
        });
        loadingCsvTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)loadingCsvTask).start();
    }

    @FXML
    void printAction() {
        String path = "rs/petcom/backoffice/jasper/Ruc.jasper";
        Map<String, Object> reportParameters = ReportMapModel.getReportMap(this.controller);
        reportParameters.put("datas", this.tableRUC.getItems());
        reportParameters.put("dateFrom", this.dpDanOd.getValue());
        reportParameters.put("dateTo", this.dpDanDo.getValue());
        JasperStarter stater = new JasperStarter(reportParameters, path, this.rootPane);
        stater.createReportCollectionDataSource();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.list, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(razlikaUCeni -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            try {
                if (razlikaUCeni.getProduct().getShortName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return false;
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableRUC.comparatorProperty());
        this.tableRUC.setItems((ObservableList)sortedData);
    }
}

