/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.swing.filechooser.FileSystemView;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategoryEnum;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class LoyalityBillReportController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<Person> stalniList = FXCollections.observableArrayList();
    ObservableList<Person> list = FXCollections.observableArrayList();
    ObservableList<Document> listRacuna = FXCollections.observableArrayList();
    PersonCategoryEnum pce;
    HashMap<String, PersonCategoryEnum> mapa;
    Date from;
    Date to;
    String pathWithoutName = null;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    BorderPane rootPane;
    @FXML
    ComboBox<Object> cbObjekat;
    @FXML
    ComboBox<PaymentMethod> cbNacinPlacanja;
    @FXML
    DatePicker dpDanOd;
    @FXML
    DatePicker dpDanDo;
    @FXML
    Button btnPrint;
    @FXML
    TextField tfFilter;
    @FXML
    private TableView<Person> tvTable;
    @FXML
    private TableColumn<Person, String> tcCardNumber;
    @FXML
    private TableColumn<Person, String> tcFirstName;
    @FXML
    private TableColumn<Person, String> tcLastName;
    @FXML
    private TableColumn<Person, Double> tcBillAmount;
    @FXML
    private TableColumn<Person, Double> tcBillDiscount;
    @FXML
    private TableColumn<Person, Double> tcBillAmountWithDiscount;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpDanOd.setConverter(this.converter);
        this.dpDanDo.setConverter(this.converter);
        this.dpDanOd.setValue((java.lang.Object)Settings.fromDate((Date)WorkDay.getFirstStart((Connection)this.controller.getSettings().getConnection())));
        this.dpDanDo.setValue((java.lang.Object)LocalDate.now());
        Object sviObjekti = new Object();
        sviObjekti.setObjectID(-1);
        sviObjekti.setName("Svi objekti");
        this.cbObjekat.getItems().add((java.lang.Object)sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObjekat.getItems().add((java.lang.Object)o);
            if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
            this.cbObjekat.getSelectionModel().select((java.lang.Object)o);
            this.cbObjekat.setDisable(true);
            break;
        }
        this.popuniFilterNacinPlacanja();
    }

    private void popuniFilterNacinPlacanja() {
        this.cbNacinPlacanja.getItems().clear();
        PaymentMethod pm = new PaymentMethod();
        pm.setPaymentMethodID(-1);
        pm.setName("Sva placanja");
        this.cbNacinPlacanja.getItems().add((java.lang.Object)pm);
        for (PaymentMethod pmt : PaymentMethod.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbNacinPlacanja.getItems().add((java.lang.Object)pmt);
        }
        this.cbNacinPlacanja.getSelectionModel().select((java.lang.Object)pm);
    }

    public void setParameter(java.lang.Object parameter) {
        this.mapa = (HashMap)parameter;
        this.pce = this.mapa.get("personCategory");
        this.loadStalniList();
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.dpDanOd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityBillReportController.this.loadStalniList();
            }
        });
        this.dpDanDo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityBillReportController.this.loadStalniList();
            }
        });
        this.cbNacinPlacanja.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityBillReportController.this.loadStalniList();
            }
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                LoyalityBillReportController.this.loadStalniList();
            }
        });
        this.tfFilter.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    LoyalityBillReportController.this.tvTable.getSelectionModel().clearSelection();
                }
            }
        });
        this.tcCardNumber.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.tcFirstName.setCellValueFactory((Callback)new PropertyValueFactory("FirstName"));
        this.tcLastName.setCellValueFactory((Callback)new PropertyValueFactory("LastName"));
        this.tcBillAmount.setCellValueFactory((Callback)new PropertyValueFactory("sumByBill"));
        this.tcBillDiscount.setCellValueFactory((Callback)new PropertyValueFactory("discountByBill"));
        this.tcBillAmountWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("sumByBillWithDiscount"));
        this.tvTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Person>(){

            public void changed(ObservableValue<? extends Person> observable, Person oldValue, Person newValue) {
            }
        });
    }

    @FXML
    private void changeObjekat() {
    }

    @FXML
    private void commitPrint() {
        this.printAction();
    }

    private void loadStalniList() {
        this.from = WorkDay.start((LocalDate)((LocalDate)this.dpDanOd.getValue()), (Connection)this.controller.getSettings().getConnection());
        this.to = WorkDay.end((LocalDate)((LocalDate)this.dpDanDo.getValue()), (Connection)this.controller.getSettings().getConnection());
        this.stalniList = Person.getLoyalityBillList((Connection)this.controller.getSettings().getConnection(), (int)this.pce.getPersonCategoryId(), (Date)this.from, (Date)this.to, (String)this.tfFilter.getText().trim());
        this.tvTable.setItems(this.stalniList);
    }

    @FXML
    private void printAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/RacunStalniKupacSviNewBills.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("object", this.controller.getObject());
        hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        hm.put("period", new SimpleDateFormat("dd.MM.yyyy").format(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDanOd.getValue()))) + " do: " + new SimpleDateFormat("dd.MM.yyyy").format(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDanDo.getValue()))));
        hm.put("datumOd", new Timestamp(this.from.getTime()));
        try {
            hm.put("datumDo", new Timestamp(new Date().getTime()));
        }
        catch (NullPointerException e) {
            hm.put("datumDo", new Timestamp(this.to.getTime()));
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Svi racuni po kupcu", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void excelAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((java.lang.Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            String filePath;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            this.pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            if (file != null && !(filePath = file.getAbsolutePath()).toUpperCase().endsWith(".CSV")) {
                filePath = filePath + ".xml";
            }
            ObservableList list = FXCollections.observableArrayList();
            list = Document.getByPersonID((Connection)this.controller.getSettings().getConnection(), (int)this.pce.getPersonCategoryId(), (Date)this.from, (Date)this.to, (String)this.tfFilter.getText().trim());
            Document.getReceivingReportToExcel((ScreensController)this.controller, (ObservableList)list, (String)this.pathWithoutName, (String)file.getName());
            this.controller.printFileFromPDF(file);
        }
    }
}

