/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class EvidencijaZaNiController
implements ControlledScreen {
    private ScreensController controller;
    int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObjekat;
    @FXML
    private DatePicker dpOd;
    @FXML
    private DatePicker dpDo;
    HashMap<String, Object> parameter;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpOd.setConverter(this.converter);
        this.dpDo.setConverter(this.converter);
        this.dpOd.setValue((Object)LocalDate.ofYearDay(LocalDate.now().getYear(), 1));
        this.dpDo.setValue((Object)LocalDate.now());
        this.cbObjekat.setItems(rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbObjekat.getSelectionModel().select(0);
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return this.parameter;
    }

    @FXML
    public void printNIAction(ActionEvent e) {
        String reportFileName = "rs/petcom/backoffice/jasper/EvidencijaZaNi.jasper";
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("nazivFirme", ((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getName());
            hm.put("adresaFirme", "");
            hm.put("objekatId", ((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID());
            hm.put("objekat", this.cbObjekat.getSelectionModel().getSelectedItem());
            hm.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpOd.getValue())).getTime()));
            hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDo.getValue())).getTime()));
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            Connection con = this.controller.getSettings().getConnection();
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)con);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("NI lista", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
            printViewPane = null;
        }
        catch (JRException ex) {
            this.controller.alert("Gre\u0161ka", ex.getMessage(), this.rootPane.getScene().getWindow());
            ex.printStackTrace();
        }
    }

    @FXML
    public void export() {
    }
}

