/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DPUList;
import rs.petcom.master.dal.Settings;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class DPUListaController
implements ControlledScreen {
    private ScreensController controller;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObjekat;
    @FXML
    private DatePicker dpOd;
    @FXML
    private DatePicker dpDo;
    @FXML
    private ListView<DPUList> lvDPU;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpOd.setConverter(this.converter);
        this.dpDo.setConverter(this.converter);
        this.dpOd.setValue((Object)LocalDate.ofYearDay(LocalDate.now().getYear(), 1));
        this.dpDo.setValue((Object)LocalDate.now());
        this.cbObjekat.setItems(rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbObjekat.getSelectionModel().select(0);
    }

    public void setParameter(Object parameter) {
        this.refreshList();
        this.cbObjekat.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObjekat.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObjekat.getSelectionModel().select((Object)o);
                this.cbObjekat.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObjekat.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObjekat.getSelectionModel().select((Object)o);
                this.cbObjekat.setDisable(true);
                break;
            }
        }
        this.refreshList();
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    public void objectChange(ActionEvent event) {
        this.refreshList();
    }

    @FXML
    public void create(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("object", this.cbObjekat.getSelectionModel().getSelectedItem());
        this.controller.showModalDialog("DPU Lista - Detalji", ScreensController.DIALOG_DPU_LIST_DETAILES, hm, this.rootPane.getScene().getWindow());
        this.refreshList();
    }

    @FXML
    public void open(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("object", this.cbObjekat.getSelectionModel().getSelectedItem());
        hm.put("dpuList", this.lvDPU.getSelectionModel().getSelectedItem());
        this.controller.showModalDialog("DPU Lista - Detalji", ScreensController.DIALOG_DPU_LIST_DETAILES, hm, this.rootPane.getScene().getWindow());
    }

    @FXML
    public void delete(ActionEvent event) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("title", "Brisanje DPU liste.");
        hm.put("text", "\nDa li sigurni da \u017eelite da obri\u0161ete DPU listu? \n\n");
        int result = this.controller.showModalDialog("Brisanje DPU liste", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_YES) {
            ((DPUList)this.lvDPU.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.refreshList();
        }
    }

    @FXML
    public void refreshList() {
        this.lvDPU.setItems(DPUList.getList((int)((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpOd.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDo.getValue())), (Connection)this.controller.getSettings().getConnection()));
    }

    @FXML
    private void printDPUAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/DPUv2.jasper";
        if (this.lvDPU.getSelectionModel().getSelectedItem() != null) {
            try {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("datum", ((DPUList)this.lvDPU.getSelectionModel().getSelectedItem()).getDate());
                hm.put("dpuListId", ((DPUList)this.lvDPU.getSelectionModel().getSelectedItem()).getDPUListID());
                hm.put("nazivFirme", ((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getName());
                hm.put("adresaFirme", "");
                hm.put("objekatId", ((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID());
                hm.put("objekat", this.cbObjekat.getSelectionModel().getSelectedItem());
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
                hm2.put("report", printViewPane);
                this.controller.showModalDialog("DPU lista", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
                printViewPane = null;
            }
            catch (JRException e) {
                this.controller.alert("Gre\u0161ka", e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void export() {
        if (this.lvDPU.getSelectionModel().getSelectedItem() != null) {
            File file;
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            DPUList dpuLista = (DPUList)this.lvDPU.getSelectionModel().getSelectedItem();
            rs.petcom.master.dal.Object o = rs.petcom.master.dal.Object.getById((int)dpuLista.getObjectID(), (ScreensController)this.controller);
            String path = File.separator + File.separator + "Z:" + File.separator + "xml" + File.separator + o.getCode() + File.separator;
            File theDir = new File(path);
            boolean result = true;
            if (!theDir.exists()) {
                result = false;
                try {
                    theDir.mkdir();
                    result = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((file = new File(path + "DPU lista-" + o.getCode() + "-" + sdf.format(dpuLista.getDate()))) != null) {
                try {
                    if (file.getAbsolutePath().toUpperCase().endsWith(".XML")) {
                        dpuLista.exportToXml(file.getAbsolutePath(), this.controller);
                    } else {
                        dpuLista.exportToXml(file.getAbsolutePath() + ".xml", this.controller);
                    }
                }
                catch (SQLException e) {
                    this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje XML izve\u0161taja u folder: \n" + path, this.controller.getRoot().getScene().getWindow());
                    result = false;
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje XML izve\u0161taja u folder: \n" + path, this.controller.getRoot().getScene().getWindow());
                    result = false;
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje XML izve\u0161taja u folder: \n" + path, this.controller.getRoot().getScene().getWindow());
                    result = false;
                    e.printStackTrace();
                }
            }
            if (result) {
                this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali XML izve\u0161taj u folder: \n" + path, this.controller.getRoot().getScene().getWindow());
            }
        }
    }
}

