/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.products;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;

public class BarcodeNewInsertController
implements DialogController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private CheckBox cbIsWeight;
    @FXML
    private Button btnCancel;
    @FXML
    private TextField tfNewBarcode;
    @FXML
    private Label lblTittle;
    @FXML
    private Button btnConfirm;
    private Map<String, Object> parameters;
    private ScreensController controller;
    private ObservableList<Barcode> barCodeList;
    private boolean isEdit;
    private Barcode selBarcode;
    private int modalResult;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.barCodeList = (ObservableList)parameter.get("bcList");
        this.selBarcode = (Barcode)parameter.get("selectedBarcode");
        this.isEdit = false;
        if (this.selBarcode != null) {
            this.tfNewBarcode.setText(this.selBarcode.getBarCode());
            this.cbIsWeight.setSelected(this.selBarcode.getIsWeight().booleanValue());
            this.isEdit = true;
        }
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tfNewBarcode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (BarcodeNewInsertController.this.isWeightCheck(newValue)) {
                    BarcodeNewInsertController.this.cbIsWeight.setSelected(true);
                } else {
                    BarcodeNewInsertController.this.cbIsWeight.setSelected(false);
                }
            }
        });
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void cancelAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void confirmAction(ActionEvent event) {
        Barcode bc = new Barcode(-1L, this.tfNewBarcode.getText().trim());
        bc.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
        this.parameters.put("barcode", bc);
        if (this.isExsistingBarcode(this.isEdit)) {
            this.controller.alert("Obave\u0161tenje", "Barcode vec postoji na listi", this.rootPane.getScene().getWindow());
            return;
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private boolean isWeightCheck(String barcode) {
        return barcode.length() == 5 && this.isDigit(barcode);
    }

    private boolean isDigit(String barcode) {
        String pattern = "[0-9]+";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(barcode);
        return m.matches();
    }

    private boolean isExsistingBarcode(boolean edit) {
        int bcCount = 0;
        for (Barcode bcBarcode : this.barCodeList) {
            if (edit) {
                if (!bcBarcode.getBarCode().toLowerCase().trim().equals(this.tfNewBarcode.getText().toLowerCase().trim()) || this.selBarcode.getBarCode().toLowerCase().trim().equals(this.tfNewBarcode.getText().toLowerCase().trim())) continue;
                ++bcCount;
                continue;
            }
            if (!bcBarcode.getBarCode().toLowerCase().trim().equals(this.tfNewBarcode.getText().toLowerCase().trim())) continue;
            ++bcCount;
        }
        return bcCount > 0;
    }
}

