/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.pricelist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.OfferPriceDetailes;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.PriceListType;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.EditingCell;
import tornadofx.control.DateTimePicker;

public class PriceListNewDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private PriceListType priceListType;
    private OfferPrice selectedOfferPrice;
    private BuyerOfferPrice selectedBOP;
    private ToggleGroup rbGroup = new ToggleGroup();
    private ToggleGroup rbSecendGroup = new ToggleGroup();
    private ObservableList<Product> deleteProductList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfValue;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbFirstPrice;
    @FXML
    private CheckBox cbRoundActive;
    @FXML
    private DateTimePicker dpFrom;
    @FXML
    private DateTimePicker dpTo;
    @FXML
    private Label lblDatumDo;
    @FXML
    private Label lblDatumOd;
    @FXML
    private Label lblPriceListType;
    @FXML
    private RadioButton rbDiscount;
    @FXML
    private RadioButton rbPrice;
    @FXML
    private RadioButton rbOnlyNew;
    @FXML
    private RadioButton rbAllProducts;
    @FXML
    private TableView<Product> tablePriceListDetails;
    @FXML
    private TableColumn<Product, String> columnProduct;
    @FXML
    private TableColumn<Product, String> columnCode;
    @FXML
    private TableColumn<Product, String> columnBarCode;
    @FXML
    private TableColumn<Product, Double> columnQuantity;
    @FXML
    private TableColumn<Product, Double> columnDiscount;
    @FXML
    private TableColumn<Product, Double> columnPrice;
    @FXML
    private ComboBox<String> cbRoundDecimals;

    public void initialize() {
        this.tablePriceListDetails.setPlaceholder((Node)new Label("Sadr\u017eaj tabele je prazan"));
        Callback<TableColumn<Product, Double>, TableCell<Product, Double>> cellFactory = new Callback<TableColumn<Product, Double>, TableCell<Product, Double>>(){

            public TableCell<Product, Double> call(TableColumn<Product, Double> p) {
                return new EditingCell(PriceListNewDialogController.this.tablePriceListDetails);
            }
        };
        this.tablePriceListDetails.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    if (PriceListNewDialogController.this.columnQuantity.isVisible()) {
                        PriceListNewDialogController.this.tablePriceListDetails.getFocusModel().focus(PriceListNewDialogController.this.tablePriceListDetails.getSelectionModel().getSelectedIndex(), PriceListNewDialogController.this.columnQuantity);
                    } else if (PriceListNewDialogController.this.columnDiscount.isVisible()) {
                        PriceListNewDialogController.this.tablePriceListDetails.getFocusModel().focus(PriceListNewDialogController.this.tablePriceListDetails.getSelectionModel().getSelectedIndex(), PriceListNewDialogController.this.columnDiscount);
                    } else {
                        PriceListNewDialogController.this.tablePriceListDetails.getFocusModel().focus(PriceListNewDialogController.this.tablePriceListDetails.getSelectionModel().getSelectedIndex(), PriceListNewDialogController.this.columnPrice);
                    }
                }
            }
        });
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("stock"));
        this.columnQuantity.setCellFactory((Callback)cellFactory);
        this.columnQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Product, Double>>(){

            public void handle(TableColumn.CellEditEvent<Product, Double> t) {
                ((Product)t.getTableView().getItems().get(t.getTablePosition().getRow())).setStock(Settings.round((double)((Double)t.getNewValue()), (int)4));
                PriceListNewDialogController.this.tablePriceListDetails.getFocusModel().focusNext();
            }
        });
        this.columnDiscount.setCellValueFactory((Callback)new PropertyValueFactory("discount"));
        this.columnDiscount.setCellFactory((Callback)cellFactory);
        this.columnDiscount.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Product, Double>>(){

            public void handle(TableColumn.CellEditEvent<Product, Double> t) {
                ((Product)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDiscount(Settings.round((double)((Double)t.getNewValue()), (int)2));
                PriceListNewDialogController.this.tablePriceListDetails.getFocusModel().focusNext();
            }
        });
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.columnPrice.setCellFactory((Callback)cellFactory);
        this.columnPrice.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Product, Double>>(){

            public void handle(TableColumn.CellEditEvent<Product, Double> t) {
                ((Product)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrice(Settings.round((double)((Double)t.getNewValue()), (int)2));
                PriceListNewDialogController.this.tablePriceListDetails.getFocusModel().focusNext();
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.priceListType = (PriceListType)parameter.get("priceListType");
        this.selectedOfferPrice = (OfferPrice)parameter.get("selectedOfferPrice");
        this.selectedBOP = (BuyerOfferPrice)parameter.get("selectedBOP");
        this.lblPriceListType.setText(this.priceListType.getName());
        this.cbRoundDecimals.getItems().addAll((Object[])new String[]{"2 decimale", "1 decimala", "0 decimala"});
        this.cbRoundDecimals.getSelectionModel().selectFirst();
        this.tfQuantity.setText("1");
        this.tfValue.setText("0");
        if (this.priceListType.getName().equals("Akcija")) {
            this.cbFirstPrice.setVisible(true);
            this.cbRoundActive.setVisible(true);
            this.columnQuantity.setVisible(true);
            this.columnDiscount.setVisible(true);
            this.dpFrom.setVisible(true);
            this.dpTo.setVisible(true);
            this.lblDatumOd.setVisible(true);
            this.lblDatumOd.setVisible(true);
            this.loadOfferPriceList();
        } else {
            this.cbFirstPrice.setVisible(false);
            this.cbRoundActive.setVisible(false);
            this.columnQuantity.setVisible(false);
            this.columnDiscount.setVisible(false);
            this.dpFrom.setVisible(false);
            this.dpTo.setVisible(false);
            this.lblDatumOd.setVisible(false);
            this.lblDatumOd.setVisible(false);
            this.loadBuyerOfferPrice();
        }
        this.rbDiscount.setToggleGroup(this.rbGroup);
        this.rbPrice.setToggleGroup(this.rbGroup);
        this.rbAllProducts.setToggleGroup(this.rbSecendGroup);
        this.rbOnlyNew.setToggleGroup(this.rbSecendGroup);
        if (!this.deleteProductList.isEmpty()) {
            this.deleteProductList.clear();
        }
        this.fillTableDetails();
    }

    private void fillTableDetails() {
        block4: {
            block3: {
                if (!this.priceListType.getName().equals("Akcija")) break block3;
                if (this.selectedOfferPrice == null) break block4;
                for (OfferPriceDetailes offerPriceDetailes : OfferPriceDetailes.getByOfferPriceID((long)this.selectedOfferPrice.getOfferPriceID(), (ScreensController)this.controller)) {
                    offerPriceDetailes.getProduct().setPrice(offerPriceDetailes.getPrice());
                    offerPriceDetailes.getProduct().setPriceListDetailsId(offerPriceDetailes.getOfferPriceDetailsID());
                    offerPriceDetailes.getProduct().setBarcode(Barcode.getBarCode((long)offerPriceDetailes.getProduct().getProductID(), (Connection)this.controller.getSettings().getConnection()));
                    offerPriceDetailes.getProduct().setStock(offerPriceDetailes.getQuantity());
                    this.tablePriceListDetails.getItems().add((Object)offerPriceDetailes.getProduct());
                }
                break block4;
            }
            if (this.selectedBOP != null) {
                for (BuyerOfferPriceDetailes buyerOfferPriceDetailes : BuyerOfferPriceDetailes.getByOfferPriceID((long)this.selectedBOP.getBuyerOfferPriceID(), (ScreensController)this.controller)) {
                    buyerOfferPriceDetailes.getProduct().setPrice(buyerOfferPriceDetailes.getPrice());
                    buyerOfferPriceDetailes.getProduct().setPriceListDetailsId(buyerOfferPriceDetailes.getBuyerOfferPriceDetailsID());
                    buyerOfferPriceDetailes.getProduct().setBarcode(Barcode.getBarCode((long)buyerOfferPriceDetailes.getProduct().getProductID(), (Connection)this.controller.getSettings().getConnection()));
                    this.tablePriceListDetails.getItems().add((Object)buyerOfferPriceDetailes.getProduct());
                }
            }
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void addDetailsAction() {
        HashMap<String, ScreensController> hMap = new HashMap<String, ScreensController>();
        hMap.put("controller", this.controller);
        int mr = this.controller.showModalDialog("Izbor cenovnika", ScreensController.DIALOG_SELECT_PRODUCT, hMap, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            Product product = (Product)hMap.get("product");
            product.getCurrentPrice((long)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), this.controller.getSettings().getConnection());
            product.setStock(1.0);
            product.setBarcode(Barcode.getBarCode((long)product.getProductID(), (Connection)this.controller.getSettings().getConnection()));
            product.setPriceListDetailsId(-1L);
            this.tablePriceListDetails.getItems().add((Object)product);
            this.tablePriceListDetails.refresh();
            this.tablePriceListDetails.getSelectionModel().clearSelection();
        }
    }

    @FXML
    private void deleteDetailsAction() {
        if (this.tablePriceListDetails.getSelectionModel().getSelectedItem() != null) {
            this.deleteProductList.add(this.tablePriceListDetails.getSelectionModel().getSelectedItem());
            this.tablePriceListDetails.getItems().remove(this.tablePriceListDetails.getSelectionModel().getSelectedItem());
            this.tablePriceListDetails.refresh();
            this.tablePriceListDetails.getSelectionModel().clearSelection();
        }
    }

    @FXML
    private void importCsvAction() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int colPrice = -1;
                    int counterRow = 0;
                    PriceListNewDialogController.this.tablePriceListDetails.getItems().clear();
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)PriceListNewDialogController.this.controller, (long)1L)) {
                                        if (csvImport.getCsvName().equals("Bar Kod") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colBarcode = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Cena") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colPrice = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)PriceListNewDialogController.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    Double price = Double.parseDouble(colNames[colPrice]);
                                    p.setBarcode(colNames[colBarcode]);
                                    p.setPrice(price.doubleValue());
                                    System.out.println(p.getName() + " " + p.getBarcode() + " " + p.getPrice());
                                    PriceListNewDialogController.this.tablePriceListDetails.getItems().add((Object)p);
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    @FXML
    private void applyAction() {
    }

    @FXML
    public void commit(ActionEvent event) {
        if (this.priceListType.getName().equals("Akcija")) {
            if (this.selectedOfferPrice != null) {
                this.selectedOfferPrice.setObjectID(this.controller.getObject().getObjectID());
                this.selectedOfferPrice.setName(this.tfName.getText().trim());
                this.selectedOfferPrice.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
                this.selectedOfferPrice.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
                this.selectedOfferPrice.setActive(this.cbActive.isSelected());
                this.selectedOfferPrice.setFirstPrice(this.cbFirstPrice.isSelected());
                this.selectedOfferPrice.setRoundActive(this.cbRoundActive.isSelected());
                this.selectedOfferPrice.update(this.controller.getSettings().getConnection());
            } else {
                this.selectedOfferPrice = new OfferPrice();
                this.selectedOfferPrice.setObjectID(this.controller.getObject().getObjectID());
                this.selectedOfferPrice.setName(this.tfName.getText().trim());
                this.selectedOfferPrice.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
                this.selectedOfferPrice.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
                this.selectedOfferPrice.setActive(this.cbActive.isSelected());
                this.selectedOfferPrice.setFirstPrice(this.cbFirstPrice.isSelected());
                this.selectedOfferPrice.setRoundActive(this.cbRoundActive.isSelected());
                this.selectedOfferPrice.setOfferPriceID(Long.valueOf(this.selectedOfferPrice.insert(this.controller.getSettings().getConnection())));
            }
            for (Product product : this.tablePriceListDetails.getItems()) {
                OfferPriceDetailes offerPriceDetailes;
                if (product.getPriceListDetailsId() == -1L) {
                    offerPriceDetailes = new OfferPriceDetailes();
                    offerPriceDetailes.setOfferPriceID(this.selectedOfferPrice.getOfferPriceID().longValue());
                    offerPriceDetailes.setPrice(product.getPrice());
                    offerPriceDetailes.setProductID(product.getProductID());
                    offerPriceDetailes.setProduct(product);
                    offerPriceDetailes.setQuantity(product.getStock());
                    offerPriceDetailes.setDiscount(product.getDiscount());
                    offerPriceDetailes.insert(this.controller.getSettings().getConnection());
                    continue;
                }
                offerPriceDetailes = OfferPriceDetailes.getByOfferPriceDetailsId((long)product.getPriceListDetailsId(), (Connection)this.controller.getSettings().getConnection());
                offerPriceDetailes.setOfferPriceID(this.selectedOfferPrice.getOfferPriceID().longValue());
                offerPriceDetailes.setPrice(product.getPrice());
                offerPriceDetailes.setProductID(product.getProductID());
                offerPriceDetailes.setProduct(product);
                offerPriceDetailes.setQuantity(product.getStock());
                offerPriceDetailes.setDiscount(product.getDiscount());
                offerPriceDetailes.update(this.controller);
            }
            for (Product product : this.deleteProductList) {
                OfferPriceDetailes.delete((Product)product, (OfferPrice)this.selectedOfferPrice, (ScreensController)this.controller);
            }
        } else if (this.priceListType.getName().equals("Redovan")) {
            long id = 1L;
            for (Product product : this.tablePriceListDetails.getItems()) {
                PriceListDetailes pldDetailes = new PriceListDetailes();
                pldDetailes.setPriceListID(Long.valueOf(id));
                pldDetailes.setProductID(Long.valueOf(product.getProductID()));
                pldDetailes.setPrice(Double.valueOf(product.getPrice()));
                pldDetailes.setDiscount(Double.valueOf(0.0));
                pldDetailes.setDate(new Date());
                pldDetailes.insert(this.controller.getSettings().getConnection());
            }
        } else {
            if (this.selectedBOP != null) {
                this.selectedBOP.setName(this.tfName.getText().trim());
                this.selectedBOP.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
                this.selectedBOP.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
                this.selectedBOP.setActive(this.cbActive.isSelected());
                this.selectedBOP.update(this.controller.getSettings().getConnection());
            } else {
                this.selectedBOP = new BuyerOfferPrice();
                this.selectedBOP.setObjectID(this.controller.getObject().getObjectID());
                this.selectedBOP.setName(this.tfName.getText().trim());
                this.selectedBOP.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
                this.selectedBOP.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
                this.selectedBOP.setActive(this.cbActive.isSelected());
                this.selectedBOP.setBuyerOfferPriceID(Long.valueOf(this.selectedBOP.insert(this.controller.getSettings().getConnection())));
            }
            for (Product product : this.tablePriceListDetails.getItems()) {
                BuyerOfferPriceDetailes buyerOfferPriceDetailes;
                if (product.getPriceListDetailsId() == -1L) {
                    buyerOfferPriceDetailes = new BuyerOfferPriceDetailes();
                    buyerOfferPriceDetailes.setBuyerOfferPriceID(this.selectedBOP.getBuyerOfferPriceID().longValue());
                    buyerOfferPriceDetailes.setPrice(product.getPrice());
                    buyerOfferPriceDetailes.setProductID(product.getProductID());
                    buyerOfferPriceDetailes.setProduct(product);
                    buyerOfferPriceDetailes.insert(this.controller.getSettings().getConnection());
                    continue;
                }
                buyerOfferPriceDetailes = BuyerOfferPriceDetailes.getByBuyerOfferPriceDetailsID((long)product.getPriceListDetailsId(), (ScreensController)this.controller);
                buyerOfferPriceDetailes.setBuyerOfferPriceID(this.selectedBOP.getBuyerOfferPriceID().longValue());
                buyerOfferPriceDetailes.setPrice(product.getPrice());
                buyerOfferPriceDetailes.setProductID(product.getProductID());
                buyerOfferPriceDetailes.setProduct(product);
                buyerOfferPriceDetailes.update(this.controller);
            }
            for (Product product : this.deleteProductList) {
                BuyerOfferPriceDetailes.delete((Product)product, (BuyerOfferPrice)this.selectedBOP, (ScreensController)this.controller);
            }
        }
        this.deleteProductList.clear();
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.deleteProductList.clear();
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void loadBuyerOfferPrice() {
        if (this.selectedBOP != null) {
            this.tfName.setText(this.selectedBOP.getName());
            this.cbActive.setSelected(this.selectedBOP.isActive());
            this.dpFrom.setValue((Object)Settings.fromDate((Date)this.selectedBOP.getDateFrom()));
            this.dpTo.setValue((Object)Settings.fromDate((Date)this.selectedBOP.getDateTo()));
        } else {
            this.tfName.setText("");
            this.cbActive.setSelected(false);
            this.dpFrom.setDateTimeValue(LocalDateTime.now());
            this.dpTo.setDateTimeValue(LocalDateTime.now());
        }
    }

    private void loadOfferPriceList() {
        if (this.selectedOfferPrice != null) {
            this.cbFirstPrice.setSelected(this.selectedOfferPrice.isFirstPrice());
            this.cbRoundActive.setSelected(this.selectedOfferPrice.isRoundActive());
            this.tfName.setText(this.selectedOfferPrice.getName());
            this.cbActive.setSelected(this.selectedOfferPrice.isActive());
            this.dpFrom.setValue((Object)Settings.fromDate((Date)this.selectedOfferPrice.getDateFrom()));
            this.dpTo.setValue((Object)Settings.fromDate((Date)this.selectedOfferPrice.getDateTo()));
        } else {
            this.cbFirstPrice.setSelected(false);
            this.cbRoundActive.setSelected(false);
            this.tfName.setText("");
            this.cbActive.setSelected(false);
            this.dpFrom.setDateTimeValue(LocalDateTime.now());
            this.dpTo.setDateTimeValue(LocalDateTime.now());
        }
    }
}

