/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.izvestaji;

import java.util.Collection;
import java.util.HashMap;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.ProdatiArtikli;

public class ProdatiArtikliTabelaController
implements DialogController {
    private ScreensController controller;
    private Stage PRINT_DIALOG;
    private ObservableList<ProdatiArtikli> prodatiArtikliLista = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<ProdatiArtikli> tvProdatiArtikli;
    @FXML
    private TableColumn<ProdatiArtikli, String> columnCode;
    @FXML
    private TableColumn<ProdatiArtikli, String> columnBarCode;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.prodatiArtikliLista = (ObservableList)parameter.get("prodatiArtikliLista");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.columnBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barCode"));
        this.loadTable();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return 0;
    }

    public void setModalResult(int modalResult) {
    }

    @FXML
    private void closeAction() {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void printAction() {
        Screen screen = Screen.getPrimary();
        Rectangle2D rect = screen.getVisualBounds();
        SimpleBooleanProperty printingProperty = new SimpleBooleanProperty(false);
        printingProperty.set(true);
        if (this.PRINT_DIALOG == null) {
            this.PRINT_DIALOG = this.createPrintDialog((Stage)this.rootPane.getScene().getWindow(), true, new Canvas(rect.getWidth() / 2.0 + 50.0, rect.getHeight() / 2.0 + 300.0));
        }
        this.PRINT_DIALOG.sizeToScene();
        this.PRINT_DIALOG.show();
    }

    public void print(Node node, Printer printer) {
        boolean success;
        WritableImage wim = new WritableImage(300, 300);
        node.snapshot(null, wim);
        ImageView iv = new ImageView();
        iv.setImage((Image)wim);
        PrinterJob job = PrinterJob.createPrinterJob();
        job.setPrinter(printer);
        if (job != null && (success = job.printPage((Node)iv))) {
            job.endJob();
        }
    }

    private Stage createPrintDialog(Stage parent, boolean modal, Canvas node) {
        if (this.PRINT_DIALOG != null) {
            this.PRINT_DIALOG.close();
        }
        return new PrintDialog(parent, modal, "Printing Menu", (Node)this.tvProdatiArtikli);
    }

    private void loadTable() {
        this.tvProdatiArtikli.setItems(this.prodatiArtikliLista);
    }

    class PrintDialog
    extends Stage {
        public PrintDialog(Stage owner, boolean modality, String title, Node printNode) {
            this.initOwner((Window)owner);
            Modality m = modality ? Modality.APPLICATION_MODAL : Modality.NONE;
            this.initModality(m);
            this.setOpacity(0.9);
            this.setTitle(title);
            Group root = new Group();
            Scene scene = new Scene((Parent)root, 450.0, 150.0, (Paint)Color.WHITE);
            this.setScene(scene);
            GridPane gridpane = new GridPane();
            gridpane.setPadding(new Insets(5.0));
            gridpane.setHgap(5.0);
            gridpane.setVgap(5.0);
            Label printerLabel = new Label("Printer: ");
            gridpane.add((Node)printerLabel, 0, 1);
            Label layoutLabel = new Label("Layout: ");
            gridpane.add((Node)layoutLabel, 0, 2);
            Printer selectedPrinter = Printer.getDefaultPrinter();
            ChoiceBox printerChooser = new ChoiceBox(FXCollections.observableArrayList((Collection)Printer.getAllPrinters()));
            printerChooser.getSelectionModel().select((Object)selectedPrinter);
            gridpane.add((Node)printerChooser, 1, 1);
            ChoiceBox layoutChooser = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"Portait", "Landscape"}));
            layoutChooser.getSelectionModel().selectFirst();
            layoutChooser.getSelectionModel().selectedIndexProperty().addListener((ov, old, newval) -> {
                Number idx = (Number)newval;
                switch (idx.intValue()) {
                    case 0: {
                        selectedPrinter.createPageLayout(Paper.A0, PageOrientation.PORTRAIT, Printer.MarginType.EQUAL);
                        break;
                    }
                    case 1: {
                        selectedPrinter.createPageLayout(Paper.A0, PageOrientation.LANDSCAPE, Printer.MarginType.EQUAL);
                        break;
                    }
                    default: {
                        selectedPrinter.createPageLayout(Paper.A0, PageOrientation.PORTRAIT, Printer.MarginType.EQUAL);
                    }
                }
            });
            gridpane.add((Node)layoutChooser, 1, 2);
            Button printButton = new Button("Print");
            printButton.setOnAction(event -> ProdatiArtikliTabelaController.this.print(printNode, selectedPrinter));
            gridpane.add((Node)printButton, 0, 3);
            GridPane.setHalignment((Node)printButton, (HPos)HPos.RIGHT);
            root.getChildren().add((Object)gridpane);
        }
    }
}

