/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.izvestaji;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.backoffice.reports.models.ExciseTaxReportModel;
import rs.petcom.backoffice.salesreportnew.reportmodels.JasperStarter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;

public class ExciseTaxReportController
implements ControlledScreen {
    private ScreensController controller;
    private Connection connection;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private GridPane gridPane;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TableView<ExciseTaxReportModel> tvReportTable;
    @FXML
    private TableColumn<ExciseTaxReportModel, String> colDate;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colExcise;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colNoExciseTax;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colBasis;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colTotal;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colTax;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colCash;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colCard;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colCheck;
    @FXML
    private TableColumn<ExciseTaxReportModel, Double> colInvoice;

    public void initialize() {
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.connection = this.controller.getSettings().getConnection();
        this.fillData();
    }

    public void setParameter(Object parameter) {
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("revenueDate"));
        this.colExcise.setCellValueFactory((Callback)new PropertyValueFactory("excise"));
        this.colNoExciseTax.setCellValueFactory((Callback)new PropertyValueFactory("noExciseTax"));
        this.colBasis.setCellValueFactory((Callback)new PropertyValueFactory("basis"));
        this.colTax.setCellValueFactory((Callback)new PropertyValueFactory("tax"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colCash.setCellValueFactory((Callback)new PropertyValueFactory("cash"));
        this.colCard.setCellValueFactory((Callback)new PropertyValueFactory("card"));
        this.colCheck.setCellValueFactory((Callback)new PropertyValueFactory("check"));
        this.colInvoice.setCellValueFactory((Callback)new PropertyValueFactory("invoice"));
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void printReport() {
        String path = "rs/petcom/backoffice/jasper/salesreportnew/SalesReportVatExcises.jasper";
        LocalDate dateFrom = (LocalDate)this.dpFrom.getValue();
        LocalDate dateTo = (LocalDate)this.dpTo.getValue();
        Map<String, Object> reportResources = ReportMapModel.getReportMap(this.controller);
        reportResources.put("datas", this.tvReportTable.getItems());
        reportResources.put("controller", this.controller);
        reportResources.put("dateFrom", dateFrom);
        reportResources.put("dateTo", dateTo);
        JasperStarter starter = new JasperStarter(reportResources, path, this.rootPane);
        starter.createReportCollectionDataSource();
    }

    private void fillData() {
        final LocalDate lastWorkDay = Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom());
        this.dpFrom.setDayCellFactory(d -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                this.setDisable(item.isAfter(lastWorkDay));
            }
        });
        this.dpTo.setDayCellFactory(d -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                this.setDisable(item.isAfter(lastWorkDay));
            }
        });
        this.dpFrom.setValue((Object)lastWorkDay);
        this.dpTo.setValue((Object)lastWorkDay);
        this.dpFrom.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.dpTo.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.fillTheTable();
    }

    private void fillTheTable() {
        LocalDate dateFrom = (LocalDate)this.dpFrom.getValue();
        LocalDate dateTo = (LocalDate)this.dpTo.getValue();
        ObservableList<ExciseTaxReportModel> exciseTaxList = ExciseTaxReportModel.getExciseTaxRevenue(this.connection, dateFrom, dateTo);
        this.tvReportTable.setItems(exciseTaxList);
    }
}

