/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.financialdiscount;

import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.LoyaltyGroup;

public class LoyaltyGroupDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private LoyaltyGroup selectedLoyaltyGroup;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfDefaultDiscount;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedLoyaltyGroup = (LoyaltyGroup)parameter.get("selectedLoyaltyGroup");
        this.fillAditionalField();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionSave() {
        if (!this.tfName.getText().trim().equals("")) {
            if (this.selectedLoyaltyGroup == null) {
                this.selectedLoyaltyGroup = new LoyaltyGroup();
                this.selectedLoyaltyGroup.setName(this.tfName.getText().trim());
                this.selectedLoyaltyGroup.setDefaultDiscount(Double.parseDouble(this.tfDefaultDiscount.getText().trim()));
                this.selectedLoyaltyGroup.insert(this.controller);
            } else {
                this.selectedLoyaltyGroup.setName(this.tfName.getText().trim());
                this.selectedLoyaltyGroup.setDefaultDiscount(Double.parseDouble(this.tfDefaultDiscount.getText().trim()));
                this.selectedLoyaltyGroup.update(this.controller);
            }
        } else {
            this.controller.alert("Obavestenje", "Polje za naziv finansijskog popusta ne moze biti prazno", this.rootPane.getScene().getWindow());
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionClose() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillAditionalField() {
        if (this.selectedLoyaltyGroup != null) {
            this.tfName.setText(this.selectedLoyaltyGroup.getName().trim());
            this.tfDefaultDiscount.setText(String.valueOf(this.selectedLoyaltyGroup.getDefaultDiscount()));
        } else {
            this.tfName.setText("");
            this.tfDefaultDiscount.setText("0");
        }
    }
}

