/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.financialdiscount;

import java.awt.Toolkit;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.LoyaltyGroup;

public class LoyaltyGroupController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<LoyaltyGroup> tableLoyaltyGroup;
    @FXML
    private TableColumn<LoyaltyGroup, String> columnName;
    @FXML
    private TableColumn<LoyaltyGroup, Double> columnDefaultDiscount;
    @FXML
    private TextField tfFilter;
    @FXML
    private VBox vBoxRight;

    public void initialize() {
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnDefaultDiscount.setCellValueFactory((Callback)new PropertyValueFactory("defaultDiscount"));
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.rootPane.getScene() != null) {
            this.vBoxRight.setMinWidth(this.rootPane.getScene().getWidth() * 12.0 / 100.0);
        } else {
            this.vBoxRight.setMinWidth(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 12.0 / 100.0);
        }
        this.tableLoyaltyGroup.setItems(LoyaltyGroup.getLoyaltyGroupList((ScreensController)this.controller));
        this.filter();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedLoyaltyGroup", null);
        this.controller.showModalDialog("Loyaliti grupe - Detalji", ScreensController.SCREEN_BACKOFFICE_LOYALTY_GROUP_DIALOG, hm, this.rootPane.getScene().getWindow());
        this.tableLoyaltyGroup.setItems(LoyaltyGroup.getLoyaltyGroupList((ScreensController)this.controller));
        this.filter();
    }

    @FXML
    private void actionEdit(ActionEvent event) {
        if (this.tableLoyaltyGroup.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedLoyaltyGroup", this.tableLoyaltyGroup.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Loyaliti grupe - Detalji", ScreensController.SCREEN_BACKOFFICE_LOYALTY_GROUP_DIALOG, hm, this.rootPane.getScene().getWindow());
            this.tableLoyaltyGroup.setItems(LoyaltyGroup.getLoyaltyGroupList((ScreensController)this.controller));
            this.filter();
        } else {
            this.controller.alert("Obavestenje", "Odaberite loyaliti grupu iz tabele koju zelite da izmenite", this.rootPane.getScene().getWindow());
        }
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableLoyaltyGroup.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(loyaltyGroup -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return loyaltyGroup.getName() != null && loyaltyGroup.getName().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableLoyaltyGroup.comparatorProperty());
        this.tableLoyaltyGroup.setItems((ObservableList)sortedData);
    }
}

